/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;

public class InformixCollectionDatatype
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;
    private DataTypeAttribute DATATYPE;

    public InformixCollectionDatatype() {
        this.$init$();
    }

    public InformixCollectionDatatype(int n, String string) {
        super(n, string, string + "(<datatype> NOT NULL)", null);
        this.$init$();
        this.addAttribute(this.DATATYPE, 0);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        InformixCollectionDatatype informixCollectionDatatype = dBObject != null ? (InformixCollectionDatatype)dBObject : new InformixCollectionDatatype();
        this.copyToImpl(informixCollectionDatatype, bl);
        return informixCollectionDatatype;
    }

    protected void copyToImpl(InformixCollectionDatatype informixCollectionDatatype, boolean bl) {
        super.copyToImpl(informixCollectionDatatype, bl);
    }

    public boolean equals(Object object) {
        return object instanceof InformixCollectionDatatype && this.equalsImpl((InformixCollectionDatatype)object);
    }

    protected boolean equalsImpl(InformixCollectionDatatype informixCollectionDatatype) {
        return super.equalsImpl(informixCollectionDatatype);
    }

    static {
        $assertionsDisabled = InformixCollectionDatatype.class.desiredAssertionStatus() ^ true;
    }

    public DataTypeUsage createUsage(Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        return super.createUsage(map);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dBObject);
        PredefinedDataTypeUsage predefinedDataTypeUsage = (PredefinedDataTypeUsage)dataTypeUsage;
        String string = ((String)predefinedDataTypeUsage.getAttributeValue("datatype")).toUpperCase();
        String[] stringArray = InformixCollectionDatatype.tokenize(string, "( )");
        if (this.isNestedCollection(stringArray[0])) {
            this.validateNestedCollection(stringArray, 0, dBObject);
        } else {
            this.validateDatatype(stringArray[0], dBObject);
        }
    }

    private boolean isNestedCollection(String string) {
        return string.equals("SET") || string.equals("LIST") || string.equals("MULTISET");
    }

    private int validateNestedCollection(String[] stringArray, int n, DBObject dBObject) throws DataTypeValidationException {
        String string = stringArray[n];
        int n2 = stringArray.length - 1;
        if (n == n2 || stringArray[++n].charAt(0) != '(') {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(130, string, stringArray[n]));
        }
        if (n < n2) {
            if (this.isNestedCollection(stringArray[++n])) {
                n = this.validateNestedCollection(stringArray, n, dBObject);
            } else {
                this.validateDatatype(stringArray[n], dBObject);
            }
        }
        while (++n < stringArray.length && !stringArray[n].equals("NOT")) {
        }
        if (n > n2 || !stringArray[n].equals("NOT") || ++n > n2 || !stringArray[n].equals("NULL") || ++n > n2 || stringArray[n].charAt(0) != ')') {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(130, string, stringArray[n > n2 ? n2 : n]));
        }
        return n;
    }

    private void validateDatatype(String string, DBObject dBObject) throws DataTypeValidationException {
        if (string.equals("TEXT") || string.equals("BYTE") || string.equals("SERIAL") || string.equals("SERIAL8")) {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(120, string, this.getDataTypeAttribute("datatype").getLabel().replaceAll("&", "")));
        }
    }

    void $init$() {
        this.DATATYPE = new DataTypeAttribute("datatype", 113, new String[]{"INT8", "INTEGER", "SMALLINT", "DECIMAL", "MONEY", "FLOAT", "DOUBLE PRECISION", "SMALLFLOAT", "DATE", "DATETIME", "INTERVAL", "CHAR", "NCHAR", "VARCHAR", "NVARCHAR", "LVARCHAR", "BOOLEAN", "BLOB", "CLOB"}, null, true, true);
    }
}

