/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

public class InformixConstraintValidator
extends ConstraintValidator {
    private static HashMap compatibleTypesMap;

    public InformixConstraintValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean incompatibleDataTypes(DataType dataType, DataType dataType2) {
        boolean bl = ModelUtil.areDifferent((Object)dataType, (Object)dataType2);
        if (bl) {
            ArrayList arrayList;
            if (compatibleTypesMap == null) {
                InformixConstraintValidator.initialiseCompatibleTypesMap();
            }
            if ((arrayList = (ArrayList)compatibleTypesMap.get(dataType.getName())) != null && arrayList.contains(dataType2.getName())) {
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isValidConstraintDatatype(String string, DataTypeUsage dataTypeUsage) {
        return (string.equals("BYTE") || string.equals("TEXT")) ^ true;
    }

    private static void initialiseCompatibleTypesMap() {
        compatibleTypesMap = new HashMap();
        String[] stringArray = new String[]{"INTEGER", "SERIAL"};
        String[] stringArray2 = new String[]{"INT", "SERIAL"};
        String[] stringArray3 = new String[]{"INT", "INTEGER"};
        String[] stringArray4 = new String[]{"SERIAL8"};
        String[] stringArray5 = new String[]{"INT8"};
        compatibleTypesMap.put("INT", new ArrayList<String>(Arrays.asList(stringArray)));
        compatibleTypesMap.put("INTEGER", new ArrayList<String>(Arrays.asList(stringArray2)));
        compatibleTypesMap.put("SERIAL", new ArrayList<String>(Arrays.asList(stringArray3)));
        compatibleTypesMap.put("INT8", new ArrayList<String>(Arrays.asList(stringArray4)));
        compatibleTypesMap.put("SERIAL8", new ArrayList<String>(Arrays.asList(stringArray5)));
    }
}

