/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDecimalDatatype;
import oracle.javatools.db.informix.InformixTimeDatatype;
import oracle.javatools.db.informix.InformixVarcharDatatype;

public abstract class InformixDatabaseImpl
extends JdbcDatabase
implements InformixDatabase {
    static final Long LONG_0 = new Long(0L);
    static final Long LONG_1 = new Long(1L);
    static final Long LONG_2 = new Long(2);
    static final Long LONG_16 = new Long(16);

    public InformixDatabaseImpl(String string, Connection connection) {
        super(string, connection);
    }

    public DataType getDataType(String string) {
        return super.getDataType(string.trim().toUpperCase());
    }

    protected String normaliseDataTypeName(String string) {
        String string2 = string.trim().replaceAll("\\s", " ");
        return string2.compareToIgnoreCase("INT") == 0 ? "INTEGER" : string2;
    }

    protected String normaliseDefaultValue(DataType dataType, String string) {
        if (dataType instanceof CharacterDataType) {
            string = string.replaceAll("'", "''");
            string = "'" + string + "'";
        }
        return string;
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            DataTypeAttribute dataTypeAttribute = new DataTypeAttribute("blobspace", 112, new String[]{"TABLE"}, null, true, false);
            DataTypeAttribute dataTypeAttribute2 = new DataTypeAttribute("size", 1L, Integer.MAX_VALUE);
            DataTypeAttribute dataTypeAttribute3 = new DataTypeAttribute("start", 114, 1L, new Long(Integer.MAX_VALUE), LONG_1, false);
            DataTypeAttribute dataTypeAttribute4 = new DataTypeAttribute("start", 114, 1L, new Long(Long.MAX_VALUE), LONG_1, false);
            NumericDataType.MinMaxValue minMaxValue = new NumericDataType.MinMaxValue("-9223372036854775807", "9223372036854775807", 0);
            NumericDataType.MinMaxValue minMaxValue2 = new NumericDataType.MinMaxValue("-2147483647", "2147483647", 0);
            NumericDataType.MinMaxValue minMaxValue3 = new NumericDataType.MinMaxValue("-32767", "32767", 0);
            NumericDataType.MinMaxValue minMaxValue4 = new NumericDataType.MinMaxValue("1", "2147483647", 1);
            NumericDataType.MinMaxValue minMaxValue5 = new NumericDataType.MinMaxValue("1", "9223372036854775807", 1);
            NumericDataType numericDataType = new NumericDataType(65535, "INT8", minMaxValue);
            NumericDataType numericDataType2 = new NumericDataType(65535, "INTEGER", minMaxValue2);
            NumericDataType numericDataType3 = new NumericDataType(65535, "SMALLINT", minMaxValue3);
            NumericDataType numericDataType4 = new NumericDataType(65535, "SERIAL", "SERIAL[(<start>)]", new DataTypeAttribute[]{dataTypeAttribute3}, minMaxValue4);
            NumericDataType numericDataType5 = new NumericDataType(65535, "SERIAL8", "SERIAL8[(<start>)]", new DataTypeAttribute[]{dataTypeAttribute4}, minMaxValue5);
            InformixDecimalDatatype informixDecimalDatatype = new InformixDecimalDatatype(65535);
            NumericDataType numericDataType6 = new NumericDataType(65535, "MONEY", "MONEY[(<precision>[, <scale>])]", 1L, 32, LONG_16, false, 0L, null, LONG_2, false, null, null);
            NumericDataType numericDataType7 = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, 14, null, false, null, null);
            NumericDataType numericDataType8 = new NumericDataType(65535, "DOUBLE PRECISION", null);
            NumericDataType numericDataType9 = new NumericDataType(65535, "SMALLFLOAT", null);
            PredefinedDataType predefinedDataType = new PredefinedDataType(65535, "DATE");
            InformixTimeDatatype informixTimeDatatype = new InformixTimeDatatype(65535, "DATETIME");
            InformixTimeDatatype informixTimeDatatype2 = new InformixTimeDatatype(65535, "INTERVAL");
            CharacterDataType characterDataType = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 32767L, 1L, false, null);
            CharacterDataType characterDataType2 = new CharacterDataType(65535, "NCHAR", "NCHAR[(<size>)]", 1L, 32767L, 1L, false, null);
            InformixVarcharDatatype informixVarcharDatatype = new InformixVarcharDatatype(65533, "VARCHAR");
            InformixVarcharDatatype informixVarcharDatatype2 = new InformixVarcharDatatype(65533, "NVARCHAR");
            CharacterDataType characterDataType3 = new CharacterDataType(65535, "TEXT", "TEXT[ IN <blobspace>]", new DataTypeAttribute[]{dataTypeAttribute, dataTypeAttribute2});
            BinaryDataType binaryDataType = new BinaryDataType(65535, "BYTE", "BYTE[ IN <blobspace>]", new DataTypeAttribute[]{dataTypeAttribute, dataTypeAttribute2});
            dataTypeRegistry.registerDataType(numericDataType, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dataTypeRegistry.registerDataType(numericDataType2, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dataTypeRegistry.registerDataType(numericDataType3, InformixDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType4, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dataTypeRegistry.registerDataType(numericDataType5, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dataTypeRegistry.registerDataType(informixDecimalDatatype, InformixDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType6, InformixDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType7, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(numericDataType9, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(numericDataType8, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(predefinedDataType, InformixDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dataTypeRegistry.registerDataType(informixTimeDatatype, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INTERVAL);
            dataTypeRegistry.registerDataType(informixTimeDatatype2, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INTERVAL);
            dataTypeRegistry.registerDataType(characterDataType, InformixDatabaseImpl.class, JdbcDatabase.ANSI_CHAR);
            dataTypeRegistry.registerDataType(characterDataType2, InformixDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR);
            dataTypeRegistry.registerDataType(informixVarcharDatatype, InformixDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dataTypeRegistry.registerDataType(informixVarcharDatatype2, InformixDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR_VARYING);
            dataTypeRegistry.registerDataType(characterDataType3, InformixDatabaseImpl.class, JdbcDatabase.ANSI_CLOB);
            dataTypeRegistry.registerDataType(binaryDataType, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BLOB);
            dataTypeRegistry.registerSynonym("CHARACTER", (DataType)characterDataType, InformixDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHARACTER VARYING", (DataType)informixVarcharDatatype, InformixDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("DEC", (DataType)informixDecimalDatatype, InformixDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("INT", (DataType)numericDataType2, InformixDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NUMERIC", (DataType)informixDecimalDatatype, InformixDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("REAL", (DataType)numericDataType9, InformixDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

