/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;

public class InformixDecimalDatatype
extends NumericDataType {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT;
    static final Long LONG_0;
    static final Long LONG_16;
    static final Long LONG_255;

    public InformixDecimalDatatype() {
    }

    public InformixDecimalDatatype(int n) {
        super(n, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 1L, 32, LONG_16, false, 0L, null, LONG_0, false, null, MIN_MAX_FLOAT);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        InformixDecimalDatatype informixDecimalDatatype = dBObject != null ? (InformixDecimalDatatype)dBObject : new InformixDecimalDatatype();
        this.copyToImpl(informixDecimalDatatype, bl);
        return informixDecimalDatatype;
    }

    protected void copyToImpl(InformixDecimalDatatype informixDecimalDatatype, boolean bl) {
        super.copyToImpl(informixDecimalDatatype, bl);
    }

    public boolean equals(Object object) {
        return object instanceof InformixDecimalDatatype && this.equalsImpl((InformixDecimalDatatype)object);
    }

    protected boolean equalsImpl(InformixDecimalDatatype informixDecimalDatatype) {
        return super.equalsImpl(informixDecimalDatatype);
    }

    static {
        $assertionsDisabled = InformixDecimalDatatype.class.desiredAssertionStatus() ^ true;
        MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "1.0e+124", 2);
        LONG_0 = new Long(0L);
        LONG_16 = new Long(16);
        LONG_255 = new Long(255L);
    }

    public DataTypeUsage createUsage(Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        Long l = (Long)map.get("scale");
        if (l.equals(LONG_255)) {
            map.remove("scale");
        }
        return super.createUsage(map);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        if (dataTypeUsage != null) {
            Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
            if (l == null) {
                InformixDecimalDatatype informixDecimalDatatype = (InformixDecimalDatatype)this.copyTo(null);
                DataTypeAttribute dataTypeAttribute = informixDecimalDatatype.getDataTypeAttribute("scale");
                informixDecimalDatatype.removeAttribute(dataTypeAttribute);
                informixDecimalDatatype.validateUsageAsFloatingPoint(dataTypeUsage, dBObject);
            } else {
                super.validateUsage(dataTypeUsage, dBObject);
            }
        }
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        if (dataTypeUsage != null && object != null) {
            Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
            if (l == null) {
                InformixDecimalDatatype informixDecimalDatatype = (InformixDecimalDatatype)this.copyTo(null);
                DataTypeAttribute dataTypeAttribute = informixDecimalDatatype.getDataTypeAttribute("scale");
                informixDecimalDatatype.removeAttribute(dataTypeAttribute);
                informixDecimalDatatype.validateDefaultValueAsFloatingPoint(object, dataTypeUsage, dBObject);
            } else {
                super.validateDefaultValue(object, dataTypeUsage, dBObject);
            }
        }
    }

    private void validateUsageAsFloatingPoint(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dBObject);
    }

    private void validateDefaultValueAsFloatingPoint(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        super.validateDefaultValue(object, dataTypeUsage, dBObject);
    }
}

