/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;

public class InformixDynamicServerDescriptor
extends DatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 128;
    private static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACCESS", "ACCESS_METHOD", "ACTIVE", "ADD", "AFTER", "AGGREGATE", "ALIGNMENT", "ALL", "ALL_ROWS", "ALLOCATE", "ALTER", "AND", "ANSI", "ANY", "APPEND", "AS", "ASC", "AT", "ATTACH", "ATTACH", "AUDIT", "AUTHORIZATION", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BOOLEAN", "BOTH", "BUFFERED", "BUILTIN", "BY", "BYTE", "CACHE", "CALL", "CANNOTHASH", "CARDINALITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLASS", "CLIENT", "CLOSE", "CLUSTER", "CLUSTERSIZE", "COARSE", "COBOL", "CODESET", "COLLATION", "COLLECTION", "COLUMN", "COMMIT", "COMMITTED", "COMMUTATOR", "CONCURRENT", "CONNECT", "CONNECTION", "CONST", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "COPY", "COSTFUNC", "COUNT", "CRCOLS", "CREATE", "CROSS", "CURRENT", "CURSOR", "CYCLE", "DATABASE", "DATAFILES", "DATASKIP", "DATASOURCE", "DATE", "DATETIME", "DAY", "DBA", "DBDATE", "DBMONEY", "DBPASSWORD", "DEALLOCATE", "DEBUG", "DEC", "DEC_T", "DECIMAL", "DECLARE", "DECODE", "DEFAULT", "DEFERRED", "DEFERRED_PREPARE", "DEFINE", "DELAY", "DELETE", "DELIMITER", "DELUXE", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETACH", "DIAGNOSTICS", "DIRECTIVES", "DIRTY", "DISABLED", "DISCONNECT", "DISTINCT", "DISTRIBUTEBINARY", "DISTRIBUTESREFERENCES", "DISTRIBUTIONS", "DOCUMENT", "DOMAIN", "DONOTDISTRIBUTE", "DORMANT", "DOUBLE", "DROP", "DTIME_T", "EACH", "ELIF", "ELSE", "ENABLED", "ENCRYPTION", "END", "ENUM", "ENVIRONMENT", "ERROR", "ESCAPE", "EXCEPTION", "EXCLUSIVE", "EXEC", "EXECUTE", "EXECUTEANYWHERE", "EXISTS", "EXIT", "EXPLAIN", "EXPLICIT", "EXPRESS", "EXPRESSION", "EXTEND", "EXTENT", "EXTERNAL", "FALSE", "FAR", "FETCH", "FILE", "FILLFACTOR", "FILTERING", "FIRST", "FIRST_ROWS", "FIXCHAR", "FIXED", "FLOAT", "FLUSH", "FOR", "FOREACH", "FOREIGN", "FORMAT", "FORTRAN", "FOUND", "FRACTION", "FRAGMENT", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GK", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLESNULLS ", "HASH", "HAVING", "HIGH", "HINT", "HOLD", "HOUR", "HYBRID", "IF", "IFX_INT8_T", "IFX_LO_CREATE_SPEC_T", "IFX_LO_STAT_T", "IMMEDIATE", "IMPLICIT", "IN", "INACTIVE", "INCREMENT", "INDEX", "INDEXES", "INDICATOR", "INFORMIX", "INIT", "INLINE", "INNER", "INOUT", "INSERT", "INSTEAD", "INT", "INT8", "INTEG", "INTEGER", "INTERNAL", "INTERNALLENGTH", "INTERVAL", "INTO", "INTRVL_T", "IS", "ISCANONICAL", "ISOLATION", "ITEM", "ITERATOR", "JOIN", "KEEP", "KEY", "LABELEQ", "LABELGE", "LABELGLB", "LABELGT", "LABELLE", "LABELLT", "LABELLUB", "LABELTOSTRING", "LANGUAGE", "LAST", "LEADING", "LEFT", "LET", "LEVEL", "LIKE", "LIST", "LISTING", "LOAD", "LOC_T", "LOCAL", "LOCATOR", "LOCK", "LOCKS", "LOG", "LONG", "LOW", "LOWER", "LVARCHAR", "MATCHES", "MAX", "MAXERRORS", "MAXLEN", "MAXVALUE", "MDY", "MEDIAN", "MEDIUM", "MEMORY_RESIDENT", "MIDDLE", "MIN", "MINUTE", "MINVALUE", "MODE", "MODERATE", "MODIFY", "MODULE", "MONEY", "MONTH", "MOUNTING", "MULTISET", "NAME", "NCHAR", "NEGATOR", "NEW", "NEXT", "NO", "NOCACHE", "NOCYCLE", "NOMAXVALUE", "NOMIGRATE", "NOMINVALUE", "NON_RESIDENT", "NONE", "NOORDER", "NORMAL", "NOT", "NOTEMPLATEARG", "NULL", "NUMERIC", "NVARCHAR", "NVL", "OCTET_LENGTH", "OF", "OFF", "OLD", "ON", "ONLINE", "ONLY", "OPAQUE", "OPCLASS", "OPEN", "OPERATIONAL", "OPTCOMPIND", "OPTICAL", "OPTIMIZATION", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OUTER", "PAGE", "PARALLELIZABLE", "PARAMETER", "PARTITION", "PASCAL", "PASSEDBYVALUE", "PASSWORD", "PDQPRIORITY", "PERCALL_COST", "PLI", "PLOAD", "PRECISION", "PREPARE", "PREVIOUS", "PRIMARY", "PRIOR", "PRIVATE", "PRIVILEGES", "PROCEDURE", "PUBLIC", "PUT", "RAISE", "RANGE", "RAW", "READ", "REAL", "RECORDEND", "REF", "REFERENCES", "REFERENCING", "REGISTER", "REJECTFILE", "RELATIVE", "RELEASE", "REMAINDER", "RENAME", "REOPTIMIZATION", "REPEATABLE", "REPLICATION", "RESERVE", "RESOLUTION", "RESOURCE", "RESTART", "RESTRICT", "RESUME", "RETAIN", "RETURN", "RETURNING", "RETURNS", "REUSE", "REVOKE", "RIGHT", "ROBIN", "ROLE", "ROLLBACK", "ROLLFORWARD", "ROUND", "ROUTINE", "ROW", "ROWID", "ROWIDS", "ROWS", "SAMEAS", "SAMPLES", "SAVE", "SCHEDULE", "SCHEMA", "SCRATCH", "SCROLL", "SECOND", "SECONDARY", "SECTION", "SELCONST", "SELECT", "SELFUNC", "SEQUENCE", "SERIAL", "SERIAL8", "SERIALIZABLE", "SERVERUUID", "SESSION", "SET", "SHARE", "SHORT", "SIGNED", "SIZE", "SKALL", "SKINHIBIT", "SKSHOW", "SMALLFLOAT", "SMALLINT", "SOME", "SPECIFIC", "SQL", "SQLCODE", "SQLCONTEXT", "SQLERROR", "SQLSTATE", "SQLWARNING", "STABILITY", "STACK", "STANDARD", "START", "STATIC", "STATISTICS", "STDEV", "STEP", "STOP", "STORAGE", "STRATEGIES", "STRING", "STRINGTOLABEL", "STRUCT", "STYLE", "SUBSTR", "SUBSTRING", "SUM", "SUPPORT", "SYNC", "SYNONYM", "SYSTEM", "TABLE", "TEMP", "TEMPLATE", "TEST", "TEXT", "THEN", "TIME", "TIMEOUT", "TO", "TODAY", "TRACE", "TRAILING", "TRANSACTION", "TRIGGER", "TRIGGERS", "TRIM", "TRUE", "TRUNCATE", "TYPE", "TYPEDEF", "TYPEID", "TYPENAME", "TYPEOF", "UNCOMMITTED", "UNDER", "UNION", "UNIQUE", "UNITS", "UNKNOWN", "UNLOAD", "UNLOCK", "UNSIGNED", "UPDATE", "UPPER", "USAGE", "USE_SUBQF", "USER", "USING", "VALUE", "VALUES", "VAR", "VARCHAR", "VARIABLE", "VARIANCE", "VARIANT", "VARYING", "VIEW", "VIOLATIONS", "VOID", "VOLATILE", "WAIT", "WARNING", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "XADATASOURCE", "XID", "XLOAD", "XUNLOAD", "YEAR"));

    public int getCasePolicy() {
        return 0;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        this.checkInformixDatabaseIdentifier(string2, "_$", RESERVED_WORDS);
    }

    private void checkInformixDatabaseIdentifier(String string, String string2, Set set) throws InvalidNameException {
        InformixDynamicServerDescriptor.validateIdentifier(string, '\"', 128, string2, false, set, this.getCasePolicy());
        char c = string.charAt(0);
        if (c != '\"' && !Character.isLetter(c) && c != '_') {
            throw new InvalidNameException(null, DBArb.getString(4));
        }
    }
}

