/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.db.informix.InformixDynamicServerDescriptor;
import oracle.javatools.db.informix.InformixDynamicServerImpl;

public class InformixDynamicServerFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_descriptor;

    public InformixDynamicServerFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new InformixDatabaseImpl.Registerer(), InformixDatabaseImpl.class);
        dataTypeRegistry.registerProvider(new InformixDynamicServerImpl.Registerer(), InformixDynamicServerImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        if (this.isInformixConnection(connection)) {
            return new InformixDynamicServerImpl(string, connection);
        }
        return null;
    }

    protected boolean isInformixConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                if (string.indexOf("Informix") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (InformixDatabase.class.isAssignableFrom(clazz) && this.m_descriptor == null) {
            this.m_descriptor = new InformixDynamicServerDescriptor();
        }
        return null;
    }
}

