/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class InformixTimeDatatype
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Long LONG_3;
    private static final Long LONG_4;
    private static final Long LONG_5;
    private static final Long LONG_9;
    private static final String[] m_timeUnits;

    public InformixTimeDatatype() {
    }

    public InformixTimeDatatype(int n, String string) {
        super(n, string, string.equals("DATETIME") ? "DATETIME[ <from> TO <to>[(<scale>)]]" : "INTERVAL[ <from>[(<precision>)] TO <to>[(<scale>)]]", null);
        int n2 = 0;
        this.addAttribute(new DataTypeAttribute("from", 110, m_timeUnits, null, false, false), n2++);
        if (string.equals("INTERVAL")) {
            this.addAttribute(new DataTypeAttribute("precision", 93, 1L, LONG_9, LONG_4, false), n2++);
        }
        this.addAttribute(new DataTypeAttribute("to", 111, m_timeUnits, null, false, false), n2++);
        this.addAttribute(new DataTypeAttribute("scale", 96, 1L, LONG_5, LONG_3, false), n2++);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        InformixTimeDatatype informixTimeDatatype = dBObject != null ? (InformixTimeDatatype)dBObject : new InformixTimeDatatype();
        this.copyToImpl(informixTimeDatatype, bl);
        return informixTimeDatatype;
    }

    protected void copyToImpl(InformixTimeDatatype informixTimeDatatype, boolean bl) {
        super.copyToImpl(informixTimeDatatype, bl);
    }

    public boolean equals(Object object) {
        return object instanceof InformixTimeDatatype && this.equalsImpl((InformixTimeDatatype)object);
    }

    protected boolean equalsImpl(InformixTimeDatatype informixTimeDatatype) {
        return super.equalsImpl(informixTimeDatatype);
    }

    static {
        $assertionsDisabled = InformixTimeDatatype.class.desiredAssertionStatus() ^ true;
        LONG_3 = new Long(3);
        LONG_4 = new Long(4);
        LONG_5 = new Long(5);
        LONG_9 = new Long(9);
        m_timeUnits = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "FRACTION"};
    }

    public DataTypeUsage createUsage(Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        String string = (String)map.get("name");
        Long l = DataTypeHelper.toLong(map.get("size"));
        if (string != null && l != null) {
            int n = l.intValue() / 256;
            int n2 = (l.intValue() - n * 256) / 16;
            int n3 = l.intValue() - n * 256 - n2 * 16;
            map.put("from", this.getTypeName(n2));
            map.put("to", this.getTypeName(n3));
            map.put("precision", new Long(n));
            if (n3 > 10) {
                map.put("scale", new Long(n3 - 10));
            } else {
                map.remove("scale");
            }
        }
        return super.createUsage(map);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dBObject);
        String string = (String)dataTypeUsage.getAttributeValue("from");
        String string2 = (String)dataTypeUsage.getAttributeValue("to");
        Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
        if (string != null && string2 == null || string == null && string2 != null) {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.getString(126));
        }
        if (l != null && string2 != null && string2.compareToIgnoreCase("FRACTION") != 0) {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.getString(127));
        }
        if (string != null) {
            string2 = string2.toUpperCase();
            string = string.toUpperCase();
            if (this.indexOf(string2) < this.indexOf(string)) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.getString(128));
            }
            if (this.getName().equals("INTERVAL")) {
                if ((string.equals("YEAR") || string.equals("MONTH")) && !string2.equals("YEAR") && !string2.equals("MONTH")) {
                    throw new DataTypeValidationException(dBObject, this.getName(), DBArb.getString(129));
                }
                Long l2 = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
                if (string.equals("FRACTION") && l2 != null && l2.compareTo(LONG_5) > 0) {
                    throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(122, DBArb.getString(93).replaceAll("&", ""), LONG_5));
                }
            }
        }
    }

    private int indexOf(String string) {
        int n = 0;
        while (!m_timeUnits[n].equals(string)) {
            ++n;
        }
        return n;
    }

    private String getTypeName(int n) {
        return n > 10 ? m_timeUnits[6] : m_timeUnits[n / 2];
    }
}

