/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class InformixVarcharDatatype
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;

    public InformixVarcharDatatype() {
    }

    public InformixVarcharDatatype(int n, String string) {
        super(n, string, n == 2 ? string + "[(<size>[, <reserve>])]" : string + "(<size>[, <reserve>])", null);
        this.addAttribute(new DataTypeAttribute("size", 108, 1L, new Long(255L), new Long(1L), n == 2 ^ true), 0);
        this.addAttribute(new DataTypeAttribute("reserve", 109, 0L, null, new Long(0L), false), 1);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        InformixVarcharDatatype informixVarcharDatatype = dBObject != null ? (InformixVarcharDatatype)dBObject : new InformixVarcharDatatype();
        this.copyToImpl(informixVarcharDatatype, bl);
        return informixVarcharDatatype;
    }

    protected void copyToImpl(InformixVarcharDatatype informixVarcharDatatype, boolean bl) {
        super.copyToImpl(informixVarcharDatatype, bl);
    }

    public boolean equals(Object object) {
        return object instanceof InformixVarcharDatatype && this.equalsImpl((InformixVarcharDatatype)object);
    }

    protected boolean equalsImpl(InformixVarcharDatatype informixVarcharDatatype) {
        return super.equalsImpl(informixVarcharDatatype);
    }

    static {
        $assertionsDisabled = InformixVarcharDatatype.class.desiredAssertionStatus() ^ true;
    }

    public DataTypeUsage createUsage(Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        String string = (String)map.get("name");
        Long l = DataTypeHelper.toLong(map.get("size"));
        if (string != null && l != null) {
            long l2 = l < 0L ? l + 65536L : l;
            long l3 = l2 / 256L;
            map.put("size", new Long(l2 - l3 * 256L));
            map.put("reserve", new Long(l3));
        }
        return super.createUsage(map);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dBObject);
        Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "size");
        Long l2 = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "reserve");
        if (l2 != null && l != null && l2.compareTo(l) > 0) {
            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(122, DBArb.getString(109).replaceAll("&", ""), l));
        }
    }
}

