/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;

public class MySQLDatabaseFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_descriptor;

    public MySQLDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new MySQLDatabaseImpl.Registerer(), MySQLDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        if (this.isMySQLConnection(connection)) {
            return new MySQLDatabaseImpl(string, connection);
        }
        return null;
    }

    protected boolean isMySQLConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (string.startsWith("MySQL")) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (MySQLDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new MySQLDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

