/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;

public class MySQLFloatDatatype
extends NumericDataType {
    private static final DataTypeAttribute FLOAT_DISPLAY_WIDTH = new DataTypeAttribute("size", 107, 0L, new Long(255L), new Long(12), false);
    private static final DataTypeAttribute SCALE = new DataTypeAttribute("scale", 94, 0L, null, new Long(0L), false);
    private static final DataTypeAttribute FLOAT_PRECISION = new DataTypeAttribute("size", 107, 0L, new Long(53), null, false);
    private static final NumericDataType ANSI_FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT(<size>)[ <unsigned>]", new DataTypeAttribute[]{FLOAT_PRECISION, NumericDataType.UNSIGNED}, new NumericDataType.MinMaxValue("2.2250738585072014E-308", "1.7976931348623157E+308", 2));

    public MySQLFloatDatatype() {
    }

    public MySQLFloatDatatype(int n) {
        super(n, "FLOAT", "FLOAT[(<size>[, <scale>])][ <unsigned>]", new DataTypeAttribute[]{FLOAT_DISPLAY_WIDTH, SCALE, NumericDataType.UNSIGNED}, new NumericDataType.MinMaxValue("1.175494351E-38", "3.402823466E+38", 2));
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        MySQLFloatDatatype mySQLFloatDatatype = dBObject != null ? (MySQLFloatDatatype)dBObject : new MySQLFloatDatatype();
        this.copyToImpl(mySQLFloatDatatype, bl);
        return mySQLFloatDatatype;
    }

    protected void copyToImpl(MySQLFloatDatatype mySQLFloatDatatype, boolean bl) {
        super.copyToImpl(mySQLFloatDatatype, bl);
    }

    public boolean equals(Object object) {
        return object instanceof MySQLFloatDatatype && this.equalsImpl((MySQLFloatDatatype)object);
    }

    protected boolean equalsImpl(MySQLFloatDatatype mySQLFloatDatatype) {
        return super.equalsImpl(mySQLFloatDatatype);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        if (dataTypeUsage != null) {
            Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
            if (l == null) {
                Long l2 = (Long)dataTypeUsage.getAttributeValue("size");
                if (l2 != null) {
                    if (l2.compareTo(FLOAT_PRECISION.getMinValue()) < 0) {
                        throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(121, DataTypeHelper.getNameFromLabel(FLOAT_PRECISION.getLabel()), FLOAT_PRECISION.getMinValue()));
                    }
                    if (l2.compareTo(FLOAT_PRECISION.getMaxValue()) > 0) {
                        throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(131, DataTypeHelper.getNameFromLabel(FLOAT_PRECISION.getLabel()), FLOAT_PRECISION.getMaxValue()));
                    }
                }
            } else {
                super.validateUsage(dataTypeUsage, dBObject);
            }
        }
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        if (dataTypeUsage != null && object != null) {
            Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
            if (l == null) {
                ANSI_FLOAT.validateDefaultValue(object, dataTypeUsage, dBObject);
            } else {
                super.validateDefaultValue(object, dataTypeUsage, dBObject);
            }
        }
    }
}

