/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.OracleColumnValidator;
import oracle.javatools.db.ora.OracleConstraintValidator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexValidator;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.OracleSequenceBuilder;
import oracle.javatools.db.ora.OracleSynonymBuilder;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTableValidator;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.db.validators.ViewValidator;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.util.ModelUtil;

public abstract class BaseOracleDatabase
extends AbstractDatabase
implements OracleDatabase {
    private static int QUERY_OBJECT_STATUS = 0;
    private static int QUERY_INDIVIDUAL_OBJECT_NAMESPACE = 1;
    private static int VALIDATE_INDEX_NAMESPACE = 2;
    private static int VALIDATE_TRIGGER_NAMESPACE = 3;
    private static int ALL_OBJECTS_TIMESTAMP = 4;
    private static final String QUERY_CONSTRAINT_NAMESPACE = "SELECT CONSTRAINT_NAME FROM   SYS.ALL_CONSTRAINTS WHERE  OWNER = ? AND    CONSTRAINT_NAME LIKE ?";
    private static final String VALIDATE_CONSTRAINT_NAMESPACE = "SELECT T.TABLE_NAME, 'TABLE' FROM   SYS.ALL_CONSTRAINTS C, SYS.ALL_TABLES T WHERE  C.OWNER = T.OWNER AND    C.TABLE_NAME = T.TABLE_NAME AND    C.OWNER = ? AND    C.CONSTRAINT_NAME = ? UNION SELECT V.VIEW_NAME, 'VIEW' FROM   SYS.ALL_CONSTRAINTS C, SYS.ALL_VIEWS V WHERE  C.OWNER = V.OWNER AND    C.TABLE_NAME = V.VIEW_NAME AND    C.OWNER = ? AND    C.CONSTRAINT_NAME = ?";
    private static final String PUBLIC_NAME = "PUBLIC";
    private static final String QUERY_TABLESPACES = "SELECT TABLESPACE_NAME FROM SYS.USER_TABLESPACES WHERE CONTENTS = 'PERMANENT'";
    private static final String USERS_QUERY = "SELECT USERNAME FROM SYS.ALL_USERS WHERE USERNAME != USER";
    private static final String VISIBLE_USERS_QUERY = "SELECT DISTINCT(OWNER) FROM SYS.ALL_OBJECTS";
    private static final String CURR_USER_QUERY = "SELECT USERNAME, DEFAULT_TABLESPACE, TEMPORARY_TABLESPACE FROM SYS.USER_USERS";
    private Schema _public;
    private Schema _currSchema;
    private Map<String, Schema> _schemas;
    private boolean _schemasLoaded;
    private static final ArrayList s_supportedObjectTypes = new ArrayList<String>(Arrays.asList("SEQUENCE", "SYNONYM", "TABLE", "VIEW", "MATERIALIZED VIEW", "MATERIALIZED VIEW LOG", "TRIGGER", "PACKAGE", "FUNCTION", "PROCEDURE", "TYPE", "DATABASE LINK", "INDEX", "DIRECTORY"));
    static final Long LONG_0 = new Long(0L);
    static final Long LONG_1 = new Long(1L);
    static final Long LONG_2 = new Long(2);
    static final Long LONG_6 = new Long(6);
    static final Long LONG_9 = new Long(9);
    static final Long LONG_4000 = new Long(4000L);
    static final Long LONG_2000 = new Long(2000L);

    void $init$() {
        this._public = new Schema(PUBLIC_NAME);
        this._schemas = new TreeMap<String, Schema>();
    }

    BaseOracleDatabase(String string, Connection connection) {
        super(string, connection);
        this.$init$();
        this._currSchema = this.createSchema(connection);
        this._schemas.put(this._currSchema.getName(), this._currSchema);
    }

    protected final Schema getCurrentSchema() {
        return this._currSchema;
    }

    protected final Schema getPublicSchema() {
        return this._public;
    }

    protected abstract DBObjectID createID(Schema var1, String var2, String var3, int var4);

    protected void registerBuilders() {
        this.registerBuilder("SYNONYM", new OracleSynonymBuilder(this));
        this.registerBuilder("SEQUENCE", new OracleSequenceBuilder(this));
        this.registerBuilder("TABLE", new OracleTableBuilder(this));
        this.registerBuilder("INDEX", new OracleIndexBuilder(this));
        this.registerBuilder("VIEW", new OracleViewBuilder(this));
    }

    protected void registerValidators() {
        super.registerValidators();
        this.registerValidator("COLUMN", new OracleColumnValidator(this));
        this.registerValidator("TABLE", new OracleTableValidator(this));
        this.registerValidator("INDEX", new OracleIndexValidator(this));
        this.registerValidator("CONSTRAINT", new OracleConstraintValidator(this));
        this.registerValidator("VIEW", new ViewValidator(this));
    }

    public String getUserName() {
        return this._currSchema != null ? this._currSchema.getName() : null;
    }

    public abstract String getDatabaseType();

    public final Long getTimestamp(String string, Schema schema, String string2) throws DBException {
        Long l = null;
        SchemaObject schemaObject = this.findObject(string, schema, string2);
        if (schemaObject != null) {
            l = (Long)schemaObject.getProperty("Timestamp");
        }
        return l;
    }

    public final Long getTimestamp(DBObjectID dBObjectID) throws DBException {
        SchemaObject schemaObject = this.findObject(dBObjectID);
        return schemaObject != null ? (Long)schemaObject.getProperty("Timestamp") : null;
    }

    protected Long getExternalTimestamp(SchemaObject schemaObject) throws DBException {
        Long l;
        String string;
        Long l2;
        DBObjectID dBObjectID = schemaObject.getID();
        Long l3 = l2 = dBObjectID != null ? this.getExternalTimestampByID(dBObjectID) : this.getExternalTimestampByName(schemaObject.getType(), schemaObject.getSchema(), schemaObject.getName());
        if (l2 != null && ("PACKAGE".equals(string = schemaObject.getType()) || "TYPE".equals(string)) && (l = this.getExternalTimestampByName(string + " BODY", schemaObject.getSchema(), schemaObject.getName())) != null && l.compareTo(l2) > 0) {
            l2 = l;
        }
        return l2;
    }

    protected abstract Long getExternalTimestampByID(DBObjectID var1) throws DBException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getExternalTimestampByName(String string, Schema schema, String string2) {
        Long l = null;
        if ("TABLE".equals(string) || "VIEW".equals(string) || "PACKAGE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TYPE".equals(string) || "TRIGGER".equals(string) || "MATERIALIZED VIEW".equals(string) || "JAVA SOURCE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE BODY".equals(string)) {
            Connection connection;
            Connection connection2 = connection = this.getConnection();
            synchronized (connection2) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    try {
                        Timestamp timestamp;
                        String string3 = BaseOracleDatabase.convertObject(schema);
                        statement = this.getStatement(connection, ALL_OBJECTS_TIMESTAMP, string3, string2, string);
                        resultSet = statement.executeQuery();
                        if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)) != null) {
                            l = new Long(timestamp.getTime());
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return l;
    }

    public boolean supportsDebugging() {
        return false;
    }

    protected DBObjectBuilder getBuilderForType(String string) {
        return super.getBuilderForType(string);
    }

    protected final SchemaObject findObject(String string, Schema schema, String string2) {
        return super.findObject(string, schema, string2);
    }

    protected void cacheObject(SchemaObject schemaObject) {
        super.cacheObject(schemaObject);
    }

    protected DBObject findByID(DBObjectID dBObjectID) throws DBException {
        return super.findByID(dBObjectID);
    }

    public boolean hasPriviledge(String string, Schema schema, String string2) {
        return !ModelUtil.areEqual((Object)"CREATE", (Object)string2) && super.hasPriviledge(string, schema, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateUniqueName(String string, DBObject dBObject, String string2) throws NameInUseException {
        if (ModelUtil.hasLength((String)string2)) {
            Connection connection;
            string = this.normaliseType(string);
            Connection connection2 = connection = this.getConnection();
            synchronized (connection2) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    try {
                        if (this.isMainObjectType(string)) {
                            statement = this.getValidateMainNamespaceStatement(connection, BaseOracleDatabase.convertObject(dBObject), string2);
                        } else if (string.equals("INDEX")) {
                            statement = this.getStatement(connection, VALIDATE_INDEX_NAMESPACE, BaseOracleDatabase.convertObject(dBObject), string2);
                        }
                        if (string.equals("TRIGGER")) {
                            statement = this.getStatement(connection, VALIDATE_TRIGGER_NAMESPACE, BaseOracleDatabase.convertObject(dBObject), string2);
                        } else if (string.equals("CONSTRAINT")) {
                            statement = this.getValidateConstraintNamespaceStatement(connection, BaseOracleDatabase.convertObject(DBUtil.getSchema(dBObject)), string2);
                        }
                        if (statement != null && (resultSet = statement.executeQuery()).next()) {
                            throw new NameInUseException(string2, resultSet.getString(1), resultSet.getString(2));
                        }
                    }
                    catch (SQLException sQLException) {
                        DBUtil.getLog().trace(sQLException.getMessage());
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueName(String string, DBObject dBObject, String string2) {
        Connection connection;
        HashSet<String> hashSet = new HashSet<String>();
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string + 1;
        }
        String string3 = string2.replaceAll("\\d*$", "") + '%';
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    if (this.isMainObjectType(string)) {
                        statement = this.getQueryMainNamespaceStatement(connection, BaseOracleDatabase.convertObject(dBObject), string3);
                    } else if ("INDEX".equals(string) || "TRIGGER".equals(string)) {
                        statement = this.getStatement(connection, QUERY_INDIVIDUAL_OBJECT_NAMESPACE, BaseOracleDatabase.convertObject(dBObject), string3, string);
                    } else if ("CONSTRAINT".equals(string)) {
                        String string4 = BaseOracleDatabase.convertObject(DBUtil.getSchema(dBObject));
                        statement = connection.prepareStatement(QUERY_CONSTRAINT_NAMESPACE);
                        statement.setString(1, string4);
                        statement.setString(2, string3);
                        this.sqlTrace(QUERY_CONSTRAINT_NAMESPACE, new Object[]{string4, string3});
                    }
                    if (statement != null) {
                        resultSet = statement.executeQuery();
                        while (resultSet.next()) {
                            hashSet.add(resultSet.getString(1));
                        }
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.getLog().trace(sQLException.getMessage());
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return DBUtil.getUniqueName(hashSet, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectValid(String string, String string2, String string3) {
        Connection connection;
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            try {
                try {
                    preparedStatement = this.getStatement(connection, QUERY_OBJECT_STATUS, string2, string3, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        bl = "VALID".equalsIgnoreCase(string4);
                    }
                }
                catch (SQLException sQLException) {}
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string, String string2, String string3) {
        Connection connection;
        boolean bl = false;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = this.getQueryExistsStatement(connection, string2, string3, string);
                    resultSet = preparedStatement.executeQuery();
                    bl = resultSet.next();
                }
                catch (SQLException sQLException) {}
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return bl;
    }

    public DataType getDataType(String string) {
        if ((string = string.trim()).startsWith("TIMESTAMP")) {
            string = "TIMESTAMP";
        } else if (string.startsWith("INTERVAL YEAR")) {
            string = "INTERVAL YEAR";
        } else if (string.startsWith("INTERVAL DAY")) {
            string = "INTERVAL DAY";
        }
        return super.getDataType(string.toUpperCase().trim());
    }

    public Schema[] listSchemas() throws DBException {
        this.loadAllSchemas();
        Collection<Schema> collection = this._schemas.values();
        return collection.toArray(new Schema[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema[] listSchemas(boolean bl) throws DBException {
        Connection connection;
        if (!bl) {
            return this.listSchemas();
        }
        ArrayList<Schema> arrayList = new ArrayList<Schema>();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(VISIBLE_USERS_QUERY);
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (!ModelUtil.areDifferent((Object)PUBLIC_NAME, (Object)string)) continue;
                        Schema schema = this._schemas.get(string);
                        if (schema == null) {
                            schema = this.createSchema(string);
                            this._schemas.put(string, schema);
                        }
                        arrayList.add(schema);
                    }
                    if (!arrayList.contains(this._currSchema)) {
                        arrayList.add(this._currSchema);
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return arrayList.toArray(new Schema[arrayList.size()]);
    }

    public boolean canRestrictSchemaList() {
        return true;
    }

    public Schema getSchema(String string) throws DBException {
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        if (PUBLIC_NAME.equals(string)) {
            return this._public;
        }
        if (ModelUtil.areEqual((Object)this._currSchema.getName(), (Object)string)) {
            return this._currSchema;
        }
        this.loadAllSchemas();
        return this._schemas.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listTablespaces() {
        Connection connection;
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    this.sqlTrace(QUERY_TABLESPACES);
                    resultSet = statement.executeQuery(QUERY_TABLESPACES);
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {}
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean canCreate(SchemaObject schemaObject, boolean bl) {
        if (!bl && this.exists(schemaObject)) {
            return false;
        }
        return s_supportedObjectTypes.contains(schemaObject.getType());
    }

    public void createObjects(SchemaObject[] schemaObjectArray, boolean bl) throws DBException {
        SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length];
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        int n = 0;
        while (n < schemaObjectArray.length) {
            String string = schemaObjectArray[n].getType();
            if (!s_supportedObjectTypes.contains(string)) {
                DBUtil.getLog().trace(string + " not supported");
                throw new DBException(new UnsupportedOperationException());
            }
            ArrayList arrayList = null;
            if (hashMap.containsKey(string)) {
                arrayList = (ArrayList)hashMap.get(string);
            } else {
                arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            arrayList.add(schemaObjectArray[n]);
            if (bl) {
                schemaObjectArray2[n] = this.getObject(string, schemaObjectArray[n].getSchema(), schemaObjectArray[n].getName());
            }
            ++n;
        }
        ListIterator listIterator = s_supportedObjectTypes.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (!hashMap.containsKey(string)) continue;
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            SchemaObject[] schemaObjectArray3 = arrayList.toArray(new SchemaObject[0]);
            this.createObjects(schemaObjectArray3, string, bl);
        }
        this.finishCreate(schemaObjectArray, null);
    }

    public void createObject(SchemaObject schemaObject, boolean bl) throws DBException {
        SchemaObject schemaObject2;
        if (schemaObject == null) {
            throw new DBException(null, "NULL object in createObject()");
        }
        String string = schemaObject.getType();
        SchemaObject schemaObject3 = schemaObject2 = bl ? this.getObject(string, schemaObject.getSchema(), schemaObject.getName()) : null;
        if (!s_supportedObjectTypes.contains(schemaObject.getType())) {
            throw new DBException(new UnsupportedOperationException());
        }
        this.createObject(schemaObject, schemaObject.getType(), bl);
        this.finishCreate(new SchemaObject[]{schemaObject}, new SchemaObject[]{schemaObject2});
    }

    public boolean canDelete(SchemaObject schemaObject, boolean bl) {
        if (!this.exists(schemaObject)) {
            return false;
        }
        Ddl ddl = this.getDeleteDDL(new SchemaObject[]{schemaObject}, bl);
        return ddl != null;
    }

    public void undeleteObject(SchemaObject schemaObject) throws DBException {
        this.undeleteObjects(new SchemaObject[]{schemaObject});
    }

    public void undeleteObjects(SchemaObject[] schemaObjectArray) throws DBException {
        throw new UnsupportedOperationException("undrop/flashback only for >= oracle 10g");
    }

    public void deleteObject(SchemaObject schemaObject, boolean bl) throws DBException {
        this.deleteObjects(new SchemaObject[]{schemaObject}, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjects(SchemaObject[] schemaObjectArray, boolean bl) throws DBException {
        Connection connection;
        Ddl ddl = this.getDeleteDDL(schemaObjectArray, bl);
        if (ddl == null) {
            throw new DBException(new UnsupportedOperationException());
        }
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    String[] stringArray = ddl.getArray("DROPCON");
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            block20: {
                                this.sqlTrace(stringArray[n]);
                                try {
                                    statement.execute(stringArray[n]);
                                }
                                catch (SQLException sQLException) {
                                    int n2 = sQLException.getErrorCode();
                                    if (n2 == 2441 || n2 == 2442 || n2 == 2443) break block20;
                                    throw sQLException;
                                }
                            }
                            ++n;
                        }
                    }
                    if ((stringArray = ddl.getArray("DROP")) != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            this.sqlTrace(stringArray[n]);
                            statement.execute(stringArray[n]);
                            ++n;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.finishDelete(schemaObjectArray[0].getSchema(), schemaObjectArray);
    }

    private Ddl getDeleteDDL(SchemaObject[] schemaObjectArray, boolean bl) {
        Ddl ddl = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            ddl = dDLGenerator.getDeleteDDL(schemaObjectArray, bl);
        }
        return ddl;
    }

    public void updateObject(SchemaObject schemaObject, SchemaObject schemaObject2) throws DBException {
        this.updateObjects(new SchemaObject[]{schemaObject}, new SchemaObject[]{schemaObject2});
    }

    public void updateObjects(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) throws DBException {
        if (schemaObjectArray == null || schemaObjectArray2 == null) {
            throw new DBException(new IllegalArgumentException("NULL objects in updateObject()"));
        }
        if (schemaObjectArray.length != schemaObjectArray2.length) {
            throw new DBException(new IllegalArgumentException("Number of old and new objects don't match"));
        }
        if (schemaObjectArray.length < 1) {
            throw new DBException(new IllegalArgumentException("No objects to update"));
        }
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject schemaObject = schemaObjectArray[n];
            SchemaObject schemaObject2 = schemaObjectArray2[n];
            if (schemaObject2 == null) {
                throw new DBException(new IllegalArgumentException("NULL object in updateObject()"));
            }
            String string = schemaObject.getType();
            if (ModelUtil.areDifferent((Object)string, (Object)schemaObject2.getType())) {
                throw new DBException(new IllegalArgumentException("New and old objects don't match"));
            }
            if (!("TABLE".equals(string) || "VIEW".equals(string) || "SEQUENCE".equals(string) || "SYNONYM".equals(string) || "MATERIALIZED VIEW".equals(string) || "MATERIALIZED VIEW LOG".equals(string))) {
                throw new DBException(new UnsupportedOperationException("Update of " + string + " not supported"));
            }
            ++n;
        }
        Ddl[] ddlArray = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            ddlArray = dDLGenerator.getUpdateDDL(schemaObjectArray, schemaObjectArray2);
        }
        if (ddlArray == null) {
            throw new DBException((DBObject)schemaObjectArray2[0], "Error getting DDL for updating object");
        }
        this.updateObjects(schemaObjectArray, schemaObjectArray2, ddlArray);
    }

    public void updateObjects(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2, Ddl[] ddlArray) throws DBException {
        if (ddlArray.length > 0) {
            DBException dBException = null;
            try {
                try {
                    this.executeDdl(ddlArray, Ddl.s_ddlOrder);
                }
                catch (DBException dBException2) {
                    dBException = dBException2;
                }
            }
            finally {
                try {
                    this.finishCreate(schemaObjectArray2, schemaObjectArray);
                }
                catch (DBException dBException3) {
                    if (dBException == null) {
                        dBException = dBException3;
                    }
                    dBException.setNextException(dBException3);
                }
                if (dBException != null) {
                    throw dBException;
                }
            }
        }
    }

    public void createObjects(SchemaObject[] schemaObjectArray, Ddl[] ddlArray, boolean bl) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        int n = 0;
        while (n < schemaObjectArray.length) {
            if (schemaObjectArray[n] != null) {
                arrayList.add(schemaObjectArray[n]);
            }
            ++n;
        }
        schemaObjectArray = arrayList.toArray(new SchemaObject[arrayList.size()]);
        SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length];
        if (bl) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < schemaObjectArray.length) {
                SchemaObject schemaObject;
                String string = schemaObjectArray[n3].getType();
                schemaObjectArray2[n3] = schemaObject = this.getObject(string, schemaObjectArray[n3].getSchema(), schemaObjectArray[n3].getName());
                if (schemaObject != null) {
                    ++n2;
                    if (schemaObject == schemaObjectArray[n3]) {
                        throw new DBException(new IllegalStateException("new " + string + " == old " + string));
                    }
                    if (!this.canDelete(schemaObject, false)) {
                        throw new DBException((DBObject)schemaObject, "Cannot drop existing " + string);
                    }
                }
                ++n3;
            }
            if (n2 > 0) {
                if (n2 < schemaObjectArray2.length) {
                    SchemaObject[] schemaObjectArray3 = new SchemaObject[n2];
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < schemaObjectArray2.length) {
                        if (schemaObjectArray2[n5] != null) {
                            schemaObjectArray3[n4++] = schemaObjectArray2[n5];
                        }
                        ++n5;
                    }
                    this.deleteObjects(schemaObjectArray3, false);
                } else {
                    this.deleteObjects(schemaObjectArray2, false);
                }
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(Ddl.s_ddlOrder));
        arrayList2.remove("DROPCON");
        arrayList2.remove("DROP");
        this.executeDdl(ddlArray, arrayList2.toArray(new String[0]));
        this.finishCreate(schemaObjectArray, null);
    }

    public boolean canCreate(Schema schema, boolean bl) {
        if (!bl) {
            try {
                if (this.getSchema(schema.getName()) != null) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            catch (DBException dBException) {
                boolean bl3 = false;
                return bl3;
            }
        }
        return this.hasPriviledge("SCHEMA", null, "CREATE");
    }

    public void createSchema(Schema schema, boolean bl) throws DBException {
        Schema schema2;
        if (schema == null) {
            throw new IllegalArgumentException("null Schema in createSchema");
        }
        Ddl ddl = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            ddl = dDLGenerator.getCreateDDL(schema);
        }
        if (bl && (schema2 = this.getSchema(schema.getName())) != null) {
            if (schema2 == schema) {
                throw new IllegalArgumentException("Cannot replace schema with itself");
            }
            if (!this.canDelete(schema2, true)) {
                throw new DBException((DBObject)schema, "Cannot drop existing schema " + schema2.getName());
            }
            this.deleteSchema(schema2, true);
        }
        this.executeDdl(new Ddl[]{ddl}, new String[]{"SCHEMA", "GRANT"});
        this.loadAllSchemas();
        String string = schema.getName();
        Schema schema3 = this.createSchema(string);
        this._schemas.put(string, schema3);
        this.fireSchemaAdded(schema3);
    }

    public boolean canDelete(Schema schema, boolean bl) {
        try {
            if (this.getSchema(schema.getName()) == null) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (DBException dBException) {
            boolean bl3 = false;
            return bl3;
        }
        return this.hasPriviledge("SCHEMA", schema, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Schema schema, boolean bl) throws DBException {
        Connection connection;
        Ddl ddl = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            ddl = dDLGenerator.getDeleteDDL(schema, bl);
        }
        if (ddl == null) {
            throw new DBException(new UnsupportedOperationException());
        }
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    String[] stringArray = ddl.getArray("DROP");
                    int n = 0;
                    while (n < stringArray.length) {
                        this.sqlTrace(stringArray[n]);
                        statement.execute(stringArray[n]);
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.loadAllSchemas();
        if (this._schemas.remove(schema.getName()) != null) {
            this.fireSchemaRemoved(schema);
        }
    }

    public void updateSchema(Schema schema, Schema schema2) throws DBException {
        throw new DBException(new UnsupportedOperationException("Schema Update"));
    }

    public String getDatabaseSource(String string, Schema schema, String string2, String string3) throws DBException {
        String string4 = null;
        SchemaObject schemaObject = this.getObject(string, schema, string2);
        if (schemaObject instanceof Trigger) {
            string4 = this.getTriggerSource((Trigger)schemaObject);
        } else if (schemaObject instanceof SpecPlSql) {
            if ("Spec".equals(string3)) {
                string4 = ((SpecPlSql)schemaObject).getSource();
            } else if ("Body".equals(string3)) {
                string4 = ((SpecPlSql)schemaObject).getBodySource();
            }
        } else if (schemaObject instanceof SourceObject) {
            string4 = ((SourceObject)schemaObject).getSource();
        }
        return "CREATE OR REPLACE\n" + string4;
    }

    public String getDatabaseSource(String string, Schema schema, String string2) throws DBException {
        return this.getDatabaseSource(string, schema, string2, null);
    }

    protected String getTriggerSource(Trigger trigger) {
        String string = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        Ddl ddl = dDLGenerator.getCreateDDL(trigger, false, false);
        if (ddl != null && ModelUtil.hasLength((String)(string = ddl.get("TRG")))) {
            Lexer lexer = PlsqlParser.createSqlLexer();
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            lexer.setTextBuffer(readTextBuffer);
            LexerToken lexerToken = lexer.createLexerToken();
            int n = 0;
            block4: while (true) {
                int n2 = lexer.lex(lexerToken);
                switch (n2) {
                    case 0: {
                        break block4;
                    }
                    case 1112: {
                        n = lexerToken.getStartOffset();
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
            string = readTextBuffer.getString(n, readTextBuffer.getLength() - n);
        }
        return string;
    }

    protected SchemaObject getCreatedObject(String string, Schema schema, String string2) throws DBException {
        SchemaObject[] schemaObjectArray;
        SchemaObject schemaObject = super.getCreatedObject(string, schema, string2);
        if (schemaObject == null && string.equals("DATABASE LINK") && (schemaObjectArray = this.listObjectsImpl(new String[]{"DATABASE LINK"}, schema, string2 + "%")) != null & schemaObjectArray.length == 1) {
            schemaObject = schemaObjectArray[0];
        }
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SchemaObject[] listObjectsImpl(String[] stringArray, Schema schema, String string) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        String string2 = this.getListQuery(stringArray, schema, string);
        if (string2 != null) {
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = this.getConnection();
            long l = System.currentTimeMillis();
            int n = Integer.MAX_VALUE;
            try {
                Integer n2 = Integer.getInteger("oracle.db.MaxFetchCount");
                if (n2 != null) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = Integer.MAX_VALUE;
            }
            int n3 = 0;
            Connection connection2 = connection;
            synchronized (connection2) {
                try {
                    try {
                        statement = connection.createStatement();
                        statement.setFetchSize(500);
                        this.sqlTrace(string2);
                        resultSet = statement.executeQuery(string2);
                        while (resultSet.next()) {
                            if (Thread.currentThread().isInterrupted()) {
                            } else {
                                String string3 = resultSet.getString(1);
                                String string4 = resultSet.getString(2).trim();
                                int n4 = resultSet.getInt(3);
                                DBObjectID dBObjectID = this.createID(schema, string3, string4, n4);
                                SchemaObject schemaObject = this.findObject(string4, schema, string3);
                                if (schemaObject == null || ModelUtil.areDifferent((Object)schemaObject.getID(), (Object)dBObjectID)) {
                                    schemaObject = this.createObjectFromDB(schema, string3, string4, dBObjectID);
                                }
                                if (schemaObject != null) {
                                    arrayList.add(schemaObject);
                                }
                                if (++n3 < n) continue;
                            }
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            l = System.currentTimeMillis() - l;
            DBUtil.getLog().trace("BaseOracleDatabase list objects for schema {0} took {1}ms", new Object[]{BaseOracleDatabase.convertObject(schema), Long.toString(l)});
        }
        return arrayList.toArray(new SchemaObject[arrayList.size()]);
    }

    protected final String getListQuery(String[] stringArray, Schema schema, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            if (this.isCustomQuery(stringArray[n], schema)) {
                arrayList2.add(this.getCustomQuery(stringArray[n]));
            } else if (this.isSupportedType(stringArray[n])) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList.size() > 0) {
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            string2 = this.convertArrayToList(stringArray2);
            stringBuffer.append(this.getStandardQuery(stringArray2));
        }
        if (arrayList2.size() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" UNION ");
            }
            stringBuffer.append(arrayList2.get(0));
            int n2 = 1;
            while (n2 < arrayList2.size()) {
                stringBuffer.append(" UNION ");
                stringBuffer.append(arrayList2.get(n2));
                ++n2;
            }
        }
        string = !ModelUtil.hasLength((String)string) ? "%" : string.replaceAll("\\'", "\\'\\'");
        return MessageFormat.format(stringBuffer.toString(), BaseOracleDatabase.convertObject(schema), string, string2);
    }

    protected boolean isSupportedType(String string) {
        return this.getBuilderForType(string) != null;
    }

    protected abstract String getStandardQuery(String[] var1);

    protected abstract String getCustomQuery(String var1);

    protected boolean isCustomQuery(String string, Schema schema) {
        return false;
    }

    private String convertArrayToList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 32);
        if (stringArray.length > 0) {
            stringBuffer.append('\'').append(stringArray[0]).append('\'');
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(',').append('\'').append(stringArray[n]).append('\'');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected SchemaObject createObjectFromDB(Schema schema, String string, String string2, DBObjectID dBObjectID) {
        AbstractSchemaObject abstractSchemaObject = null;
        DBObjectBuilder dBObjectBuilder = this.getBuilderForType(string2);
        if (dBObjectBuilder != null) {
            abstractSchemaObject = (AbstractSchemaObject)dBObjectBuilder.createObject(string, schema, dBObjectID);
            this.markForLazyInit(abstractSchemaObject);
            this.cacheObject(abstractSchemaObject);
        }
        return abstractSchemaObject;
    }

    private void createObject(SchemaObject schemaObject, String string, boolean bl) throws DBException {
        this.createObjects(new SchemaObject[]{schemaObject}, string, bl);
    }

    private void createObjects(SchemaObject[] schemaObjectArray, String string, boolean bl) throws DBException {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Ddl[] ddlArray = new Ddl[schemaObjectArray.length];
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator != null) {
            int n = 0;
            while (n < schemaObjectArray.length) {
                ddlArray[n] = dDLGenerator.getCreateDDL(schemaObjectArray[n], false, false);
                if (ddlArray[n] == null) {
                    throw new DBException(new UnsupportedOperationException());
                }
                if ("INDEX".equals(schemaObjectArray[n].getType())) {
                    arrayList.add(((Index)schemaObjectArray[n]).getTable());
                }
                ++n;
            }
        }
        if (bl) {
            SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < schemaObjectArray.length) {
                SchemaObject schemaObject = this.getObject(string, schemaObjectArray[n2].getSchema(), schemaObjectArray[n2].getName());
                if (schemaObject != null) {
                    if (schemaObject == schemaObjectArray[n2]) {
                        throw new DBException(new IllegalStateException("new " + string + " == old " + string));
                    }
                    if (!this.canDelete(schemaObject, false)) {
                        throw new DBException((DBObject)schemaObject, "Cannot drop existing " + string);
                    }
                    schemaObjectArray2[n++] = schemaObject;
                }
                ++n2;
            }
            if (n > 0) {
                if (n < schemaObjectArray2.length) {
                    SchemaObject[] schemaObjectArray3 = schemaObjectArray2;
                    schemaObjectArray2 = new SchemaObject[n];
                    System.arraycopy(schemaObjectArray3, 0, schemaObjectArray2, 0, n);
                }
                this.deleteObjects(schemaObjectArray2, false);
            }
        }
        this.executeDdl(ddlArray, Ddl.s_ddlOrder);
        for (Table table : arrayList) {
            this.getObject("TABLE", table.getSchema(), table.getName());
        }
    }

    protected Schema createSchema(Connection connection) {
        Schema schema = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                this.sqlTrace(CURR_USER_QUERY);
                resultSet = statement.executeQuery(CURR_USER_QUERY);
                if (resultSet.next()) {
                    schema = this.createSchema(resultSet.getString(1));
                    OracleSchemaProperties oracleSchemaProperties = new OracleSchemaProperties();
                    oracleSchemaProperties.setDefaultTablespace(resultSet.getString(2));
                    oracleSchemaProperties.setTemporaryTablespace(resultSet.getString(3));
                    schema.setProperty("OracleSchemaProperties", oracleSchemaProperties);
                }
            }
            catch (SQLException sQLException) {
                try {
                    schema = this.createSchema(connection.getMetaData().getUserName());
                }
                catch (SQLException sQLException2) {}
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return schema;
    }

    private void executeDdl(Ddl[] ddlArray, String[] stringArray) throws DBException {
        this.executeDdl(ddlArray, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDdl(Ddl[] ddlArray, String[] stringArray, boolean bl) throws DBException {
        Connection connection;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                try {
                    int n = 0;
                    while (n < stringArray.length) {
                        int n2 = 0;
                        while (n2 < ddlArray.length) {
                            String[] stringArray2;
                            if (ddlArray[n2] != null && (stringArray2 = ddlArray[n2].getArrayTrimSlash(stringArray[n])) != null) {
                                int n3 = 0;
                                while (n3 < stringArray2.length) {
                                    if (statement == null) {
                                        statement = connection.createStatement();
                                    }
                                    this.sqlTrace(stringArray2[n3]);
                                    try {
                                        statement.execute(stringArray2[n3]);
                                    }
                                    catch (SQLException sQLException) {
                                        if (bl) {
                                            DBUtil.getLog().trace("BaseOracleDatabase SQL execution failed, but ignored:");
                                            DBUtil.logStackTrace(sQLException);
                                        }
                                        throw new DBException(sQLException);
                                    }
                                    ++n3;
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadAllSchemas() throws DBException {
        if (!this._schemasLoaded) {
            Connection connection;
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection2 = connection = this.getConnection();
            synchronized (connection2) {
                try {
                    try {
                        statement = connection.createStatement();
                        statement.setFetchSize(500);
                        this.sqlTrace(USERS_QUERY);
                        resultSet = statement.executeQuery(USERS_QUERY);
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            if (this._schemas.containsKey(string)) continue;
                            this._schemas.put(string, this.createSchema(string));
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this._schemasLoaded = true;
        }
    }

    private boolean isMainObjectType(String string) {
        return "TABLE".equals(string) || "VIEW".equals(string) || "SEQUENCE".equals(string) || "SYNONYM".equals(string) || "PACKAGE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TYPE".equals(string);
    }

    protected PreparedStatement getStatement(Connection connection, String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        this.sqlTrace(string, new Object[]{string2, string3});
        return preparedStatement;
    }

    protected abstract PreparedStatement getStatement(Connection var1, int var2, String var3, String var4) throws SQLException;

    protected abstract PreparedStatement getStatement(Connection var1, int var2, String var3, String var4, String var5) throws SQLException;

    protected abstract PreparedStatement getQueryExistsStatement(Connection var1, String var2, String var3, String var4) throws SQLException;

    protected abstract PreparedStatement getQueryMainNamespaceStatement(Connection var1, String var2, String var3) throws SQLException;

    protected abstract PreparedStatement getValidateMainNamespaceStatement(Connection var1, String var2, String var3) throws SQLException;

    private PreparedStatement getValidateConstraintNamespaceStatement(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(VALIDATE_CONSTRAINT_NAMESPACE);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string2);
        this.sqlTrace(VALIDATE_CONSTRAINT_NAMESPACE, new Object[]{string, string2, string, string2});
        return preparedStatement;
    }
}

