/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

abstract class DBSourceBuilder
extends OracleDBObjectBuilder {
    protected static final int WHERE_OBJECT_TYPE = 1;
    protected static final int WHERE_OBJECT_OWNER = 2;
    protected static final int WHERE_OBJECT_NAME = 3;

    DBSourceBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    protected abstract String getQuery();

    protected final String getSource(SourceObject sourceObject) throws DBException {
        return this._getSourceImpl(sourceObject, false);
    }

    protected final String getBodySource(SpecPlSql specPlSql) throws DBException {
        return this._getSourceImpl(specPlSql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String _getSourceImpl(SourceObject sourceObject, boolean bl) throws DBException {
        Connection connection;
        if (bl && !(sourceObject instanceof SpecPlSql)) {
            throw new IllegalArgumentException("Cannot query for the body of an object that has no body");
        }
        String string = null;
        Schema schema = sourceObject.getSchema();
        String string2 = sourceObject.getName();
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    String string3 = AbstractDBObjectProvider.convertObject(schema);
                    StringBuffer stringBuffer = new StringBuffer();
                    String string4 = this.getObjectType() + (bl ? " BODY" : "");
                    String string5 = this.getQuery();
                    statement = connection.prepareStatement(string5);
                    statement.setString(1, string4);
                    statement.setString(2, string3);
                    statement.setString(3, string2);
                    this.sqlTrace(string5, new Object[]{string4, string3, string2});
                    resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        String string6 = resultSet.getString(1);
                        if (string6 != null) {
                            stringBuffer.append(string6);
                            if (string6.endsWith("\n")) continue;
                            stringBuffer.append('\n');
                            continue;
                        }
                        stringBuffer.append('\n');
                    }
                    if (stringBuffer.length() > 0) {
                        string = stringBuffer.toString();
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string;
    }
}

