/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.util.ModelUtil;

class DatabaseLinkBuilder
extends OracleDBObjectBuilder {
    DatabaseLinkBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "DATABASE LINK");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        DatabaseLink databaseLink = new DatabaseLink(string, schema, dBObjectID);
        databaseLink.setPublic(ModelUtil.areEqual((Object)this.getDatabase().getPublicSchema(), (Object)schema));
        return databaseLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Connection connection;
        DatabaseLink databaseLink = (DatabaseLink)schemaObject;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    String string = this.getQuery();
                    String string2 = AbstractDBObjectProvider.convertObject(schemaObject.getSchema());
                    String string3 = AbstractDBObjectProvider.convertObject(schemaObject);
                    statement = connection.prepareStatement(string);
                    statement.setString(1, string2);
                    statement.setString(2, string3);
                    this.sqlTrace(string, new Object[]{string3});
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        databaseLink.setUsername(string4);
                        String string5 = resultSet.getString(2);
                        databaseLink.setHost(string5);
                        String string6 = resultSet.getString(3);
                        databaseLink.setCreated(string6);
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private String getQuery() {
        return "SELECT USERNAME, HOST, CREATED   FROM SYS.ALL_DB_LINKS  WHERE OWNER = ? AND DB_LINK = ? ";
    }
}

