/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class DirectoryBuilder
extends OracleDBObjectBuilder {
    DirectoryBuilder(Oracle8 oracle8) {
        super(oracle8, "DIRECTORY");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Directory directory = new Directory(string, schema);
        directory.setID(dBObjectID);
        return directory;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        this.fillInPath((Directory)schemaObject);
    }

    private void fillInPath(Directory directory) throws DBException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(this, "SELECT DIRECTORY_PATH FROM ALL_DIRECTORIES WHERE OWNER = ? AND DIRECTORY_NAME = ? ", directory.getSchema(), directory);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    directory.setPath(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException((DBObject)directory, (Throwable)sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }
}

