/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.validators.AbstractValidator;

class DirectoryValidator
extends AbstractValidator {
    DirectoryValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        super.validateObject(dBObject, dBObject2);
        this.validateDirectory((Directory)dBObject2);
    }

    private void validateDirectory(Directory directory) throws ValidationException {
        String string = directory.getPath();
        if (!ModelUtil.hasLength((String)string)) {
            throw new ValidationException((DBObject)directory, "Directory must have a valid path.");
        }
        Schema schema = directory.getSchema();
        if (schema != null && ModelUtil.areDifferent((Object)schema.getName(), (Object)"SYS")) {
            throw new ValidationException((DBObject)directory, "Directory must be in SYS schema.");
        }
    }
}

