/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.DataInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JavaClass;
import oracle.javatools.db.JavaResource;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.BLOB;

final class JavaBinaryBuilder
extends OracleDBObjectBuilder {
    private static final String CLASS_QUERY = "declare   v_shortname varchar2(30);   lob BLOB; begin   v_shortname := dbms_java.shortname( ? );   dbms_lob.createtemporary(lob, true, dbms_lob.SESSION);   dbms_java.export_class(v_shortname, ?, lob);   ? := lob; end; ";
    private static final String RESOURCE_QUERY = "declare   v_shortname varchar2(30);   lob BLOB; begin   v_shortname := dbms_java.shortname( ? );   dbms_lob.createtemporary(lob, true, dbms_lob.SESSION);   dbms_java.export_resource(v_shortname, ?, lob);   ? := lob; end; ";
    private static final String FREE_BLOB = "call dbms_lob.freetemporary(?)";

    JavaBinaryBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        BinaryObject binaryObject = "JAVA CLASS".equals(this.getObjectType()) ? (BinaryObject)new JavaClass(string, schema) : (BinaryObject)new JavaResource(string, schema);
        binaryObject.setID(dBObjectID);
        return binaryObject;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        BinaryObject binaryObject = (BinaryObject)schemaObject;
        Schema schema = binaryObject.getSchema();
        String string = binaryObject.getName();
        Connection connection = this.getConnection();
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                String string2 = AbstractDBObjectProvider.convertObject(schema);
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(this._getSQL());
                oracleCallableStatement.setString(1, string);
                oracleCallableStatement.setString(2, string2);
                oracleCallableStatement.registerOutParameter(3, 2004);
                oracleCallableStatement.execute();
                BLOB bLOB = oracleCallableStatement.getBLOB(3);
                DataInputStream dataInputStream = new DataInputStream(bLOB.getBinaryStream());
                byte[] byArray = new byte[(int)bLOB.length()];
                byArray = bLOB.getBytes(1L, byArray.length);
                binaryObject.setBytes(byArray);
                oracleCallableStatement.close();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(FREE_BLOB);
                oracleCallableStatement.setBLOB(1, bLOB);
                oracleCallableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String _getSQL() {
        return "JAVA CLASS".equals(this.getObjectType()) ? CLASS_QUERY : RESOURCE_QUERY;
    }
}

