/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JavaSource;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DBSourceBuilder;

final class JavaSourceBuilder
extends DBSourceBuilder {
    private static final String JAVA_SOURCE_QUERY = "SELECT TEXT FROM SYS.ALL_SOURCE, JAVASNM WHERE TYPE = ? AND OWNER = ? AND NAME = SHORT(+) AND NVL(LONGNAME,NAME) = ? ORDER BY LINE";

    JavaSourceBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "JAVA SOURCE");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        JavaSource javaSource = new JavaSource(string, schema);
        javaSource.setID(dBObjectID);
        return javaSource;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        JavaSource javaSource = (JavaSource)schemaObject;
        javaSource.setSource(this.getSource(javaSource));
    }

    protected String getQuery() {
        return JAVA_SOURCE_QUERY;
    }
}

