/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.ide.util.Copyable;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.util.ModelUtil;

public class LOBDescriptor
implements Copyable {
    public static final String LOB_PARAMETER_CACHE = "CACHE";
    public static final String LOB_PARAMETER_NOCACHE = "NOCACHE";
    public static final String LOB_PARAMETER_CACHEREADS = "CACHE READS";
    private String _lobSegName;
    private ArrayList<DBObjectID> _lobColumns;
    private Integer _chunk;
    private Integer _pctVersion;
    private Integer _freepools;
    private boolean _storageEnabledInRow;
    private boolean _retention;
    private String _cache;
    private OracleStorageProperties _storage;

    public LOBDescriptor() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        LOBDescriptor lOBDescriptor = object != null ? (LOBDescriptor)object : new LOBDescriptor();
        this.copyToImpl(lOBDescriptor);
        return lOBDescriptor;
    }

    public boolean equals(Object object) {
        return object instanceof LOBDescriptor && this.equalsImpl((LOBDescriptor)object);
    }

    public void setLOBSegName(String string) {
        this._lobSegName = string;
    }

    public String getLOBSegName() {
        return this._lobSegName;
    }

    public void setColumns(DBObjectID[] dBObjectIDArray) {
        this._lobColumns.removeAll(this._lobColumns);
        if (dBObjectIDArray != null) {
            int n = 0;
            while (n < dBObjectIDArray.length) {
                this.addColumn(dBObjectIDArray[n]);
                ++n;
            }
        }
    }

    public DBObjectID[] getColumns() {
        return this._lobColumns.toArray(new DBObjectID[this._lobColumns.size()]);
    }

    public void addColumn(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this._lobColumns.add(dBObjectID);
        }
    }

    public void removeColumn(DBObjectID dBObjectID) {
        this._lobColumns.remove(dBObjectID);
    }

    public void setChunk(Integer n) {
        this._chunk = n;
    }

    public Integer getChunk() {
        return this._chunk;
    }

    public void setPctVersion(Integer n) {
        this._pctVersion = n;
    }

    public Integer getPctVersion() {
        return this._pctVersion;
    }

    public void setFreepools(Integer n) {
        this._freepools = n;
    }

    public Integer getFreepools() {
        return this._freepools;
    }

    public void setStorage(OracleStorageProperties oracleStorageProperties) {
        this._storage = oracleStorageProperties;
    }

    public OracleStorageProperties getStorage() {
        return this._storage;
    }

    public void setRetention(boolean bl) {
        this._retention = bl;
    }

    public boolean isRetention() {
        return this._retention;
    }

    public void setStorageEnabledInRow(boolean bl) {
        this._storageEnabledInRow = bl;
    }

    public boolean isStorageEnabledInRow() {
        return this._storageEnabledInRow;
    }

    public void setCache(String string) {
        this._cache = string;
    }

    public String getCache() {
        return this._cache;
    }

    public void validate(Table table, OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) throws ValidationException {
        this.validateColumns(table);
        this.validateChunk(table);
        this.validateCache(table);
        this.validateFreepools(table);
        this.validatePctVersion(table);
        this.validateStorage(table);
    }

    public void validateCache(Table table) throws ValidationException {
        if (!(this._cache == null || this._cache.equalsIgnoreCase(LOB_PARAMETER_CACHE) || this._cache.equalsIgnoreCase(LOB_PARAMETER_NOCACHE) || this._cache.equalsIgnoreCase(LOB_PARAMETER_CACHEREADS))) {
            throw new ValidationException((DBObject)table, DBArb.format(211, this._cache));
        }
    }

    public void validateChunk(Table table) throws ValidationException {
        if (this._chunk != null) {
            if (this._chunk < 1 || this._chunk > 32768) {
                throw new ValidationException((DBObject)table, DBArb.getString(214));
            }
            if (this._storage != null && this._storage.getNextExtent() != null && this._chunk > this._storage.getNextExtent()) {
                throw new ValidationException((DBObject)table, DBArb.format(215, this._storage.getNextExtent()));
            }
        }
    }

    public void validateFreepools(Table table) throws ValidationException {
        if (this._freepools != null) {
            if (this._freepools < 0) {
                throw new ValidationException((DBObject)table, DBArb.getString(216));
            }
            if (this._storage != null && this._storage.getFreelistGroups() != null) {
                throw new ValidationException((DBObject)table, DBArb.getString(217));
            }
        }
    }

    public void validatePctVersion(Table table) throws ValidationException {
        this.validateRetention(table);
        if (this._pctVersion != null && (this._pctVersion < 0 || this._pctVersion > 100)) {
            throw new ValidationException((DBObject)table, DBArb.getString(213));
        }
    }

    public void validateRetention(Table table) throws ValidationException {
        if (this._retention && this._pctVersion != null) {
            throw new ValidationException((DBObject)table, DBArb.getString(212));
        }
    }

    public void validateStorage(Table table) throws ValidationException {
        if (this._storage != null) {
            this._storage.validate(table);
        }
    }

    public void validateColumns(Table table) throws ValidationException {
        if (this._lobColumns.size() < 1) {
            throw new ValidationException((DBObject)table, DBArb.getString(209));
        }
        if (this._lobSegName != null && this._lobColumns.size() > 1) {
            throw new ValidationException((DBObject)table, DBArb.getString(210));
        }
        int n = 0;
        while (n < this._lobColumns.size()) {
            DBObjectID dBObjectID = this._lobColumns.get(n);
            try {
                Column column = (Column)dBObjectID.resolveID();
                boolean bl = LOBDescriptor.isVARRAYColumn(dBObjectID);
                if (!LOBDescriptor.isLOBColumn(dBObjectID) && !bl || bl && n > 0) {
                    throw new ValidationException((DBObject)table, DBArb.getString(209));
                }
                if (bl && this._lobSegName == null) {
                    throw new ValidationException((DBObject)table, DBArb.getString(207));
                }
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
            ++n;
        }
    }

    public static boolean isLOBColumn(DBObjectID dBObjectID) {
        Column column = null;
        DBObject dBObject = null;
        try {
            column = (Column)dBObjectID.resolveID();
            if (column != null) {
                dBObject = DataTypeHelper.getDataType(column.getDataTypeUsage());
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dBObject != null) {
            String string = dBObject.getName();
            return "BLOB".equalsIgnoreCase(string) || "CLOB".equalsIgnoreCase(string) || "NCLOB".equalsIgnoreCase(string) || "BFILE".equalsIgnoreCase(string);
        }
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID dBObjectID) {
        return LOBDescriptor.isLOBColumn(dBObjectID) ^ true;
    }

    protected void copyToImpl(LOBDescriptor lOBDescriptor) {
        lOBDescriptor._lobSegName = this._lobSegName;
        lOBDescriptor._storageEnabledInRow = this._storageEnabledInRow;
        lOBDescriptor._chunk = this._chunk;
        lOBDescriptor._pctVersion = this._pctVersion;
        lOBDescriptor._retention = this._retention;
        lOBDescriptor._freepools = this._freepools;
        lOBDescriptor._cache = this._cache;
        lOBDescriptor._storage = this._storage == null ? null : (OracleStorageProperties)this._storage.copyTo(null);
        lOBDescriptor._lobColumns.clear();
        lOBDescriptor._lobColumns.addAll(this._lobColumns);
    }

    protected boolean equalsImpl(LOBDescriptor lOBDescriptor) {
        return ModelUtil.areEqual((Object)this._lobSegName, (Object)lOBDescriptor._lobSegName) && ModelUtil.areEqual(this._lobColumns, lOBDescriptor._lobColumns) && ModelUtil.areEqual((Object)lOBDescriptor._storageEnabledInRow, (Object)this._storageEnabledInRow) && ModelUtil.areEqual((Object)lOBDescriptor._chunk, (Object)this._chunk) && ModelUtil.areEqual((Object)lOBDescriptor._pctVersion, (Object)this._pctVersion) && ModelUtil.areEqual((Object)lOBDescriptor._retention, (Object)this._retention) && ModelUtil.areEqual((Object)lOBDescriptor._freepools, (Object)this._freepools) && ModelUtil.areEqual((Object)lOBDescriptor._cache, (Object)this._cache) && ModelUtil.areEqual((Object)lOBDescriptor._storage, (Object)this._storage);
    }

    void $init$() {
        this._lobColumns = new ArrayList();
        this._storageEnabledInRow = true;
        this._retention = false;
    }
}

