/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

public class MaterializedView
extends Relation
implements SQLQueryOwner {
    public static final String TYPE = "MATERIALIZED VIEW";
    public static final int REWRITE_TYPE_NONE = 0;
    public static final int REWRITE_TYPE_TEXTMATCH = 1;
    public static final int REWRITE_TYPE_GENERAL = 2;
    public static final int REFRESH_MODE_ON_DEMAND = 0;
    public static final int REFRESH_MODE_ON_COMMIT = 1;
    public static final int REFRESH_MODE_SPECIFY = 2;
    public static final int REFRESH_MODE_NEVER = 3;
    public static final int REFRESH_METHOD_COMPLETE = 0;
    public static final int REFRESH_METHOD_FORCE = 1;
    public static final int REFRESH_METHOD_FAST = 2;
    public static final int REFRESH_METHOD_NEVER = 3;
    public static final int FAST_REFRESH_MODE_NO = 0;
    public static final int FAST_REFRESH_MODE_DIRLOAD = 1;
    public static final int FAST_REFRESH_MODE_DML = 2;
    public static final int FAST_REFRESH_MODE_DIRLOAD_DML = 3;
    public static final int FAST_REFRESH_MODE_DIRLOAD_LIMITEDDML = 4;
    public static final int STALENESS_FRESH = 0;
    public static final int STALENESS_STALE = 1;
    public static final int STALENESS_UNUSABLE = 2;
    public static final int STALENESS_UNKNOWN = 3;
    public static final int STALENESS_UNDEFINED = 4;
    public static final int PREBUILT_NONE = 0;
    public static final int PREBUILT_UNSPECIFIED_PRECISION = 1;
    public static final int PREBUILT_WITH_REDUCED_PRECISION = 2;
    public static final int PREBUILD_WITHOUT_REDUCED_PRECISION = 3;
    public static final int BUILD_TYPE_IMMEDIATE = 0;
    public static final int BUILD_TYPE_DEFERRED = 1;
    public static final int WITH_ID_UNSPECIFIED = 0;
    public static final int WITH_PRIMARY_KEY = 1;
    public static final int WITH_KEY_ROWID = 2;
    public static final int RS_NONE = 0;
    public static final int RS_LOCAL = 1;
    public static final int RS_MASTER = 2;
    private boolean _updatable;
    private boolean _rewrite;
    private int _rewriteType;
    private int _refreshMode;
    private int _refreshMethod;
    private int _fastRefresh;
    private int _lastRefreshType;
    private Date _lastRefreshDate;
    private int _staleness;
    private int _buildType;
    private int _prebuilt;
    private boolean _useNoIndex;
    private int _indexPctFree;
    private int _indexInitTrans;
    private int _maxTrans;
    private int _minTrans;
    private int _initExtent;
    private int _nextExtent;
    private int _indexMinExtent;
    private int _indexMaxExtent;
    private String _start;
    private String _interval;
    private int _keyType;
    private Boolean _trustedConstraint;
    private int _rsType;
    private String _rsName;
    private boolean _cache;
    private String _tablespace;
    private int _parallel;
    private List _masters;
    private SQLQuery _query;

    void $init$() {
        this._masters = new ArrayList();
    }

    public MaterializedView() {
        this.$init$();
    }

    public MaterializedView(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        MaterializedView materializedView = dBObject instanceof MaterializedView ? (MaterializedView)dBObject : new MaterializedView();
        this.copyToImpl(materializedView, bl);
        return materializedView;
    }

    public boolean equals(Object object) {
        return object instanceof MaterializedView && this.equalsImpl((MaterializedView)object);
    }

    protected void copyToImpl(MaterializedView materializedView, boolean bl) {
        super.copyToImpl(materializedView, bl);
        materializedView._updatable = this._updatable;
        materializedView._rewrite = this._rewrite;
        materializedView._rewriteType = this._rewriteType;
        materializedView._refreshMode = this._refreshMode;
        materializedView._refreshMethod = this._refreshMethod;
        materializedView._fastRefresh = this._fastRefresh;
        materializedView._lastRefreshType = this._lastRefreshType;
        materializedView._lastRefreshDate = this._lastRefreshDate == null ? null : (Date)this._lastRefreshDate.clone();
        materializedView._indexMinExtent = this._indexMinExtent;
        materializedView._indexMaxExtent = this._indexMaxExtent;
        materializedView._indexPctFree = this._indexPctFree;
        materializedView._indexInitTrans = this._indexInitTrans;
        materializedView._maxTrans = this._maxTrans;
        materializedView._minTrans = this._minTrans;
        materializedView._initExtent = this._initExtent;
        materializedView._nextExtent = this._nextExtent;
        materializedView._staleness = this._staleness;
        materializedView._buildType = this._buildType;
        materializedView._prebuilt = this._prebuilt;
        materializedView._useNoIndex = this._useNoIndex;
        materializedView._rsType = this._rsType;
        materializedView._rsName = this._rsName;
        materializedView._tablespace = this._tablespace;
        materializedView._start = this._start;
        materializedView._interval = this._interval;
        materializedView._cache = this._cache;
        materializedView._parallel = this._parallel;
        materializedView._keyType = this._keyType;
        materializedView._trustedConstraint = this._trustedConstraint;
        materializedView._masters = new ArrayList(this._masters);
        materializedView._query = this._query == null ? null : (SQLQuery)this._query.copyTo(null, bl);
    }

    protected boolean equalsImpl(MaterializedView materializedView) {
        return super.equalsImpl(materializedView) && materializedView._updatable == this._updatable && materializedView._rewrite == this._rewrite && materializedView._rewriteType == this._rewriteType && materializedView._refreshMode == this._refreshMode && materializedView._refreshMethod == this._refreshMethod && materializedView._fastRefresh == this._fastRefresh && materializedView._lastRefreshType == this._lastRefreshType && materializedView._lastRefreshDate == this._lastRefreshDate && materializedView._indexMinExtent == this._indexMinExtent && materializedView._indexMaxExtent == this._indexMaxExtent && materializedView._indexPctFree == this._indexPctFree && materializedView._indexInitTrans == this._indexInitTrans && materializedView._maxTrans == this._maxTrans && materializedView._minTrans == this._minTrans && materializedView._initExtent == this._initExtent && materializedView._nextExtent == this._nextExtent && materializedView._staleness == this._staleness && materializedView._buildType == this._buildType && materializedView._prebuilt == this._prebuilt && materializedView._useNoIndex == this._useNoIndex && materializedView._rsType == this._rsType && materializedView._rsName == this._rsName && materializedView._tablespace == this._tablespace && materializedView._start == this._start && materializedView._interval == this._interval && materializedView._keyType == this._keyType && materializedView._trustedConstraint == this._trustedConstraint && materializedView._cache == this._cache && materializedView._parallel == this._parallel && ModelUtil.areEqual((Object)materializedView._masters, (Object)this._masters) && ModelUtil.areEqual((Object)materializedView._query, (Object)this._query);
    }

    public String getType() {
        return TYPE;
    }

    public SQLQuery getSQLQuery() {
        this.checkInit();
        return this._query;
    }

    public void setSQLQuery(SQLQuery sQLQuery) {
        this.checkInit();
        this._query = sQLQuery;
    }

    public String getViewText() throws TransientMarker {
        this.checkInit();
        return this._query == null ? null : this._query.getSQLText().trim();
    }

    public void setUpdatable(boolean bl) {
        this.checkInit();
        this._updatable = bl;
    }

    public boolean isUpdatable() {
        this.checkInit();
        return this._updatable;
    }

    public void setRewrite(boolean bl) {
        this.checkInit();
        this._rewrite = bl;
    }

    public boolean isRewrite() {
        this.checkInit();
        return this._rewrite;
    }

    public void setRewriteType(int n) {
        this.checkInit();
        this._rewriteType = n;
    }

    public int getRewriteType() {
        this.checkInit();
        return this._rewriteType;
    }

    public void setRefreshMode(int n) {
        this.checkInit();
        this._refreshMode = n;
    }

    public int getRefreshMode() {
        this.checkInit();
        return this._refreshMode;
    }

    public void setRefreshMethod(int n) {
        this.checkInit();
        this._refreshMethod = n;
    }

    public int getRefreshMethod() {
        this.checkInit();
        return this._refreshMethod;
    }

    public void setFastRefresh(int n) {
        this.checkInit();
        this._fastRefresh = n;
    }

    public int getFastRefresh() {
        this.checkInit();
        return this._fastRefresh;
    }

    public void setLastRefreshType(int n) {
        this.checkInit();
        this._lastRefreshType = n;
    }

    public int getLastRefreshType() {
        this.checkInit();
        return this._lastRefreshType;
    }

    public void setLastRefreshDate(Date date) {
        this.checkInit();
        this._lastRefreshDate = date;
    }

    public Date getLastRefreshDate() {
        this.checkInit();
        return this._lastRefreshDate;
    }

    public String getNextRefresh() {
        return this._start;
    }

    public void setNextRefresh(String string) {
        this._start = string;
    }

    public String getInterval() {
        return this._interval;
    }

    public void setInterval(String string) {
        this._interval = string;
    }

    public void setStaleness(int n) {
        this.checkInit();
        this._staleness = n;
    }

    public int getStaleness() {
        this.checkInit();
        return this._staleness;
    }

    public void setBuildType(int n) {
        this.checkInit();
        this._buildType = n;
    }

    public int getBuildType() {
        this.checkInit();
        return this._buildType;
    }

    public void setPrebuilt(boolean bl) {
    }

    public boolean isPrebuilt() {
        return false;
    }

    public void setOnPrebuilt(int n) {
        this.checkInit();
        this._prebuilt = n;
    }

    public int getOnPrebuilt() {
        this.checkInit();
        return this._prebuilt;
    }

    public void setUseNoIndex(boolean bl) {
        this.checkInit();
        this._useNoIndex = bl;
    }

    public boolean isUseNoIndex() {
        this.checkInit();
        return this._useNoIndex;
    }

    public void setIndexPercentFree(int n) {
        this.checkInit();
        this._indexPctFree = n;
    }

    public int getIndexPercentFree() {
        this.checkInit();
        return this._indexPctFree;
    }

    public void setIndexPercentUsed(int n) {
    }

    public int getIndexPercentUsed() {
        return 0;
    }

    public void setIndexInitTrans(int n) {
        this.checkInit();
        this._indexInitTrans = n;
    }

    public int getIndexInitTrans() {
        this.checkInit();
        return this._indexInitTrans;
    }

    public void setMaxTrans(int n) {
        this.checkInit();
        this._maxTrans = n;
    }

    public int getMaxTrans() {
        this.checkInit();
        return this._maxTrans;
    }

    public void setMinTrans(int n) {
        this.checkInit();
        this._minTrans = n;
    }

    public int getMinTrans() {
        this.checkInit();
        return this._minTrans;
    }

    public void setInitExtent(int n) {
        this.checkInit();
        this._initExtent = n;
    }

    public int getInitExtent() {
        this.checkInit();
        return this._initExtent;
    }

    public void setNextExtent(int n) {
        this.checkInit();
        this._nextExtent = n;
    }

    public int getNextExtent() {
        this.checkInit();
        return this._nextExtent;
    }

    public void setIndexMinExtent(int n) {
        this.checkInit();
        this._indexMinExtent = n;
    }

    public int getIndexMinExtent() {
        this.checkInit();
        return this._indexMinExtent;
    }

    public void setIndexMaxExtent(int n) {
        this.checkInit();
        this._indexMaxExtent = n;
    }

    public int getIndexMaxExtent() {
        this.checkInit();
        return this._indexMaxExtent;
    }

    public String getTablespace() {
        return this._tablespace;
    }

    public void setTablespace(String string) {
        this._tablespace = string;
    }

    public void setCache(boolean bl) {
        this.checkInit();
        this._cache = bl;
    }

    public boolean isCache() {
        this.checkInit();
        return this._cache;
    }

    public void setParallel(int n) {
        this._parallel = n;
    }

    public int getParallel() {
        return this._parallel;
    }

    public void setMasters(String[] stringArray) {
        this.checkInit();
        this._masters.clear();
        this._masters.addAll(Arrays.asList(stringArray));
    }

    public String[] getMasters() {
        this.checkInit();
        return this._masters.toArray(new String[this._masters.size()]);
    }

    public int getKeyType() {
        this.checkInit();
        return this._keyType;
    }

    public void setKeyType(int n) {
        this.checkInit();
        this._keyType = n;
    }

    public Boolean isUsingTrustedConstraints() {
        this.checkInit();
        return this._trustedConstraint;
    }

    public void setUsingTrustedConstraints(Boolean bl) {
        this.checkInit();
        this._trustedConstraint = bl;
    }

    public int getRollbackSegmentType() {
        return this._rsType;
    }

    public void setRollbackSegmentType(int n) {
        this._rsType = n;
    }

    public String getRollbackSegmentName() {
        return this._rsName;
    }

    public void setRollbackSegmentName(String string) {
        this._rsName = string;
    }
}

