/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

class MaterializedViewBuilder
extends OracleRelationBuilder {
    private static final String MVIEW_QUERY = "SELECT A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, C.DEGREE, C.INITIAL_EXTENT, C.NEXT_EXTENT, C.CACHE, D.NEXT_DATE, D.INTERVAL, A.QUERY, B.DETAILOBJ_OWNER, B.DETAILOBJ_NAME FROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, SYS.ALL_TABLES C, SYS.ALL_REFRESH D WHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) AND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER AND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) AND A.OWNER = ? AND A.MVIEW_NAME = ?";
    private static String TENG_REPLACE_COL = "A.UNKNOWN_TRUSTED_FD";
    private static String NON_TENG_REPLACE_COL = "'NULL'";
    private static final String MVIEW_INDEX_QUERY = "SELECT E.PCT_FREE, E.INI_TRANS, E.MIN_EXTENTS, E.MAX_EXTENTS, E.TABLESPACE_NAME FROM SYS.ALL_MVIEWS A, SYS.ALL_INDEXES E WHERE A.MVIEW_NAME = E.TABLE_NAME(+) AND E.INDEX_NAME = CONCAT('I_SNAP$_', A.MVIEW_NAME) AND A.OWNER = ? AND A.MVIEW_NAME = ?";

    MaterializedViewBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "MATERIALIZED VIEW");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        MaterializedView materializedView = new MaterializedView(string, schema);
        materializedView.setID(dBObjectID);
        return materializedView;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        MaterializedView materializedView = (MaterializedView)schemaObject;
        this.fillInProperties(materializedView);
        this.fillInColumns(materializedView);
    }

    private void fillInProperties(MaterializedView materializedView) throws DBException {
        this.fillInNonIndexProperties(materializedView);
        this.fillInIndexProperties(materializedView);
    }

    private void fillInNonIndexProperties(MaterializedView materializedView) throws DBException {
        Schema schema = materializedView.getSchema();
        String string = materializedView.getName();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string2 = AbstractDBObjectProvider.convertObject(schema);
                String string3 = MaterializedViewBuilder.getQuery(this.getDatabase().getOracleDatabaseType());
                statement = this.getConnection().prepareStatement(string3);
                statement.setString(1, string2);
                statement.setString(2, string);
                this.sqlTrace(string3, new Object[]{string2, string});
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    int n = 1;
                    materializedView.setUpdatable(MaterializedViewBuilder._parseYNBoolean(resultSet.getString(n++)));
                    materializedView.setRewrite(MaterializedViewBuilder._parseYNBoolean(resultSet.getString(n++)));
                    materializedView.setRewriteType(MaterializedViewBuilder._parseRewriteCapability(resultSet.getString(n++)));
                    materializedView.setRefreshMode(MaterializedViewBuilder._parseRefreshMode(resultSet.getString(n++)));
                    materializedView.setRefreshMethod(MaterializedViewBuilder._parseRefreshMethod(resultSet.getString(n++)));
                    materializedView.setFastRefresh(MaterializedViewBuilder._parseFastRefreshable(resultSet.getString(n++)));
                    materializedView.setLastRefreshType(MaterializedViewBuilder._parseLastRefreshType(resultSet.getString(n++)));
                    materializedView.setLastRefreshDate(resultSet.getTimestamp(n++));
                    materializedView.setStaleness(MaterializedViewBuilder._parseStaleness(resultSet.getString(n++)));
                    materializedView.setBuildType(MaterializedViewBuilder._parseBuildType(resultSet.getString(n++)));
                    materializedView.setOnPrebuilt(MaterializedViewBuilder._parsePrebuilt(resultSet.getString(n++)));
                    materializedView.setUseNoIndex(MaterializedViewBuilder._parseYNBoolean(resultSet.getString(n++)));
                    materializedView.setUsingTrustedConstraints(MaterializedViewBuilder._parseYNNullBoolean(resultSet.getString(n++)));
                    materializedView.setParallel(MaterializedViewBuilder._parseParallel(resultSet.getString(n++)));
                    materializedView.setInitExtent(resultSet.getInt(n++));
                    materializedView.setNextExtent(resultSet.getInt(n++));
                    materializedView.setCache(MaterializedViewBuilder._parseYNBoolean(resultSet.getString(n++)));
                    materializedView.setNextRefresh(resultSet.getString(n++));
                    materializedView.setInterval(resultSet.getString(n++));
                    SQLQuery sQLQuery = OracleViewBuilder.buildQuery(this.getDatabase(), materializedView.getSchema(), resultSet.getString(n++));
                    materializedView.setSQLQuery(sQLQuery);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string4 = MaterializedViewBuilder._parseMasterName(resultSet.getString(n), resultSet.getString(n + 1));
                    while (string4 != null) {
                        if (string4.length() > 0) {
                            arrayList.add(string4);
                        }
                        String string5 = string4 = resultSet.next() ? MaterializedViewBuilder._parseMasterName(resultSet.getString(n), resultSet.getString(n + 1)) : null;
                    }
                    materializedView.setMasters(arrayList.toArray(new String[arrayList.size()]));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void fillInIndexProperties(MaterializedView materializedView) throws DBException {
        Schema schema = materializedView.getSchema();
        String string = materializedView.getName();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string2 = AbstractDBObjectProvider.convertObject(schema);
                preparedStatement = this.getConnection().prepareStatement(MVIEW_INDEX_QUERY);
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                this.sqlTrace(MVIEW_INDEX_QUERY, new Object[]{string2, string});
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int n = 1;
                    materializedView.setIndexPercentFree(resultSet.getInt(n++));
                    materializedView.setIndexInitTrans(resultSet.getInt(n++));
                    materializedView.setIndexMinExtent(resultSet.getInt(n++));
                    materializedView.setIndexMaxExtent(resultSet.getInt(n++));
                    materializedView.setTablespace(resultSet.getString(n++));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String getQuery(int n) {
        String string = null;
        string = n >= 5 ? String.format(MVIEW_QUERY, TENG_REPLACE_COL) : String.format(MVIEW_QUERY, NON_TENG_REPLACE_COL);
        return string;
    }

    private static boolean _parseYNBoolean(String string) {
        return "Y".equals(string.trim());
    }

    private static Boolean _parseYNNullBoolean(String string) {
        String string2 = string.trim();
        if ("Y".equals(string2) || "YES".equals(string2)) {
            return Boolean.TRUE;
        }
        if ("N".equals(string2) || "NO".equals(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static int _parseParallel(String string) {
        int n = 1;
        try {
            Integer n2 = new Integer(string.trim());
            n = n2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private static int _parseRewriteCapability(String string) {
        int n = 0;
        if ("TEXTMATCH".equals(string)) {
            n = 1;
        } else if ("GENERAL".equals(string)) {
            n = 2;
        }
        return n;
    }

    private static int _parseRefreshMode(String string) {
        int n = 3;
        if ("DEMAND".equals(string)) {
            n = 0;
        } else if ("COMMIT".equals(string)) {
            n = 1;
        }
        return n;
    }

    private static int _parseRefreshMethod(String string) {
        int n = 3;
        if ("COMPLETE".equals(string)) {
            n = 0;
        } else if ("FORCE".equals(string)) {
            n = 1;
        } else if ("FAST".equals(string)) {
            n = 2;
        }
        return n;
    }

    private static int _parseFastRefreshable(String string) {
        int n = 0;
        if ("DIRLOAD".equals(string)) {
            n = 1;
        } else if ("DML".equals(string)) {
            n = 2;
        } else if ("DIRLOAD_DML".equals(string)) {
            n = 3;
        } else if ("DIRLOAD_LIMITEDDML".equals(string)) {
            n = 4;
        }
        return n;
    }

    private static int _parseLastRefreshType(String string) {
        int n = 3;
        if ("COMPLETE".equals(string)) {
            n = 0;
        } else if ("FAST".equals(string)) {
            n = 2;
        }
        return n;
    }

    private static int _parsePrebuilt(String string) {
        int n = 0;
        if ("Y".equals(string)) {
            n = 1;
        }
        return n;
    }

    private static int _parseStaleness(String string) {
        int n = 3;
        if ("FRESH".equals(string)) {
            n = 0;
        } else if ("STALE".equals(string)) {
            n = 1;
        } else if ("UNUSABLE".equals(string)) {
            n = 2;
        } else if ("UNDEFINED".equals(string)) {
            n = 4;
        }
        return n;
    }

    private static int _parseBuildType(String string) {
        int n = 0;
        if ("DEFERRED".equals(string)) {
            n = 1;
        }
        return n;
    }

    private static String _parseMasterName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (ModelUtil.hasLength((String)string)) {
            stringBuffer.append(string);
        }
        if (ModelUtil.hasLength((String)string2)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

