/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class MaterializedViewLogBuilder
extends OracleDBObjectBuilder {
    MaterializedViewLogBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "MATERIALIZED VIEW LOG");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        MaterializedViewLog materializedViewLog = new MaterializedViewLog(string, schema);
        materializedViewLog.setID(dBObjectID);
        return materializedViewLog;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        MaterializedViewLog materializedViewLog = (MaterializedViewLog)schemaObject;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = MessageFormat.format("SELECT L.MASTER, L.LOG_TABLE, L.ROWIDS, L.PRIMARY_KEY,        L.OBJECT_ID, L.SEQUENCE, L.INCLUDE_NEW_VALUES, L.FILTER_COLUMNS,        T.LOGGING, T.CACHE, T.DEGREE, T.TABLESPACE_NAME FROM SYS.ALL_SNAPSHOT_LOGS L,      SYS.ALL_TABLES T WHERE T.TABLE_NAME = L.LOG_TABLE AND       L.LOG_OWNER = ''{0}'' AND L.MASTER = ''{1}''", AbstractDBObjectProvider.convertObject(materializedViewLog.getSchema()), materializedViewLog.getName());
                statement = this.getConnection().prepareStatement(string);
                this.sqlTrace(string, null);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    int n = 1;
                    materializedViewLog.setMaster(resultSet.getString(n++));
                    materializedViewLog.setLogTable(resultSet.getString(n++));
                    materializedViewLog.setRowidLogged(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setPrimaryKeyLogged(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setObjectIdLogged(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setSequenceLogged(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setNewValues(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setColumnsFiltered(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setLogging(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setCache(MaterializedViewLogBuilder._parseBoolean(resultSet.getString(n++)));
                    materializedViewLog.setParallel(resultSet.getInt(n++));
                    materializedViewLog.setTablespace(resultSet.getString(n++));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean _parseBoolean(String string) {
        return "Y".equals(string.trim()) || "YES".equals(string.trim());
    }
}

