/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public final class NameBasedRefID
extends AbstractDBObjectID {
    private String m_refName;
    private String m_refSchema;
    private String m_refDatabaseLink;
    private transient String _label;
    private transient DBObjectProvider m_pro;

    public NameBasedRefID() {
    }

    public NameBasedRefID(String string, String string2) {
        this(string, string2, (String)null);
    }

    public NameBasedRefID(String string, String string2, String string3) {
        this.m_refName = string2;
        this.m_refSchema = string;
        this.m_refDatabaseLink = string3;
    }

    public NameBasedRefID(Schema schema, String string) {
        this(schema, string, null);
    }

    public NameBasedRefID(Schema schema, String string, String string2) {
        this.m_refName = string;
        this.m_refSchema = schema == null ? null : schema.getName();
        this.m_refDatabaseLink = string2;
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        return dBObjectID instanceof NameBasedRefID && this.equalsImpl((NameBasedRefID)dBObjectID);
    }

    public String getSchemaName() {
        return this.m_refSchema;
    }

    public void setSchemaName(String string) {
        this.m_refSchema = string;
    }

    public String getName() {
        return this.m_refName;
    }

    public void setName(String string) {
        this.m_refName = string;
    }

    public String getDatabaseLink() {
        return this.m_refDatabaseLink;
    }

    public void setDatabaseLink(String string) {
        this.m_refDatabaseLink = string;
    }

    public DBObject resolveID() throws DBException {
        Schema schema;
        SchemaObject schemaObject = null;
        if (this.m_pro != null && ModelUtil.hasLength((String)this.m_refSchema) && ModelUtil.hasLength((String)this.m_refName) && (schema = this.m_pro.getSchema(this.m_refSchema)) != null && (schemaObject = this.m_pro.getObject("TABLE", schema, this.m_refName)) == null) {
            String[] stringArray = this.m_pro.listObjectTypes();
            int n = 0;
            while (n < stringArray.length && schemaObject == null) {
                if (!stringArray[n].equals("TABLE")) {
                    schemaObject = this.m_pro.getObject(stringArray[n], schema, this.m_refName);
                }
                ++n;
            }
        }
        return schemaObject;
    }

    public synchronized String toString() {
        if (this._label == null) {
            String string = this.m_refSchema == null ? "" : this.m_refSchema;
            String string2 = this.m_refName == null ? "" : this.m_refName;
            String string3 = this.m_refDatabaseLink == null ? "" : this.m_refDatabaseLink;
            this._label = "(" + string + ", " + string2 + ", " + string3 + ")";
        }
        return this._label;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean equalsImpl(NameBasedRefID nameBasedRefID) {
        return ModelUtil.areEqual((Object)nameBasedRefID.m_refSchema, (Object)this.m_refSchema) && ModelUtil.areEqual((Object)nameBasedRefID.m_refName, (Object)this.m_refName) && ModelUtil.areEqual((Object)nameBasedRefID.m_refDatabaseLink, (Object)this.m_refDatabaseLink);
    }
}

