/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.ora.Oracle10gDDLGenerator;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.RecycledObjectBuilder;

public class Oracle10g
extends Oracle9iR2 {
    private static final String TIMESTAMP_BY_ID_10g = "SELECT TO_DATE(TIMESTAMP, 'YYYY-MM-DD:HH24:MI:SS') FROM SYS.ALL_OBJECTS WHERE OBJECT_ID = ? AND OBJECT_ID NOT IN ( SELECT PURGE_OBJECT FROM RECYCLEBIN )";

    Oracle10g(Connection connection) {
        this(null, connection);
    }

    Oracle10g(String string, Connection connection) {
        super(string, connection);
    }

    public int getOracleDatabaseType() {
        return 5;
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("RECYCLEBIN", new RecycledObjectBuilder(this));
    }

    protected DDLGenerator createDDLGenerator() {
        return new Oracle10gDDLGenerator(this);
    }

    protected String getTimestampQuery() {
        return TIMESTAMP_BY_ID_10g;
    }

    protected String getStandardQuery(String[] stringArray) {
        return "SELECT OBJECT_NAME, OBJECT_TYPE, OBJECT_ID FROM SYS.ALL_OBJECTS WHERE OWNER = ''{0}'' AND   OBJECT_NAME LIKE ''{1}'' AND   OBJECT_TYPE IN ({2}) AND   SUBOBJECT_NAME IS NULL AND   OBJECT_ID NOT IN ( SELECT PURGE_OBJECT FROM RECYCLEBIN ) ";
    }

    protected boolean isCustomQuery(String string, Schema schema) {
        return string.equals("RECYCLEBIN") || super.isCustomQuery(string, schema);
    }

    public String getCustomQuery(String string) {
        if (string.equals("TABLE")) {
            return "SELECT O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID FROM SYS.ALL_OBJECTS O WHERE O.OWNER = ''{0}'' AND   O.OBJECT_TYPE = ''TABLE'' AND   O.OBJECT_NAME LIKE ''{1}'' AND   O.GENERATED = ''N'' AND NOT EXISTS (SELECT 1 FROM SYS.ALL_MVIEWS WHERE MVIEW_NAME = O.OBJECT_NAME AND OWNER = O.OWNER)  AND O.OBJECT_NAME NOT LIKE ''BIN$%'' ";
        }
        if (string.equals("RECYCLEBIN")) {
            if (this.hasPrivilege("SYSDBA")) {
                return OracleDictionaryQueries.DBA_RECYCLEBIN_QUERY;
            }
            String string2 = OracleDictionaryQueries.RECYCLEBIN_QUERY;
            return string2.replace("<SCHEMA>", this.getCurrentSchema().getName());
        }
        return super.getCustomQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeleteObjects(SchemaObject[] schemaObjectArray) throws DBException {
        Connection connection;
        Ddl ddl = this.getUndeleteDDL(schemaObjectArray);
        if (ddl == null) {
            throw new DBException(new UnsupportedOperationException());
        }
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    String[] stringArray = ddl.getArray("FLASHBACK");
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            this.sqlTrace(stringArray[n]);
                            statement.execute(stringArray[n]);
                            ++n;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.finishDelete(schemaObjectArray[0].getSchema(), schemaObjectArray);
    }

    private Ddl getUndeleteDDL(SchemaObject[] schemaObjectArray) {
        Ddl ddl = null;
        DDLGenerator dDLGenerator = this.getDDLGenerator();
        if (dDLGenerator instanceof Oracle10gDDLGenerator) {
            ddl = ((Oracle10gDDLGenerator)dDLGenerator).getUndeleteDDL(schemaObjectArray);
        }
        return ddl;
    }

    protected void finishDelete(Schema schema, SchemaObject[] schemaObjectArray) {
        super.finishDelete(schema, schemaObjectArray);
        if (schemaObjectArray.length > 0 && "RECYCLEBIN".equals(schemaObjectArray[0].getType())) {
            ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
            int n = 0;
            while (n < schemaObjectArray.length) {
                try {
                    String string = ((RecycledObject)schemaObjectArray[n]).getOriginalName();
                    String string2 = ((RecycledObject)schemaObjectArray[n]).getOriginalType();
                    SchemaObject schemaObject = this.getObject(string2, schema, string);
                    if (schemaObject != null) {
                        arrayList.add(schemaObject);
                    }
                }
                catch (DBException dBException) {
                    DBUtil.logStackTrace(dBException);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                this.fireObjectsAdded(schema, arrayList.toArray(new SchemaObject[arrayList.size()]));
            }
        }
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        protected void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            dataTypeRegistry.registerDataType(new NumericDataType(1, "BINARY_DOUBLE", new NumericDataType.MinMaxValue("2.3e-308", "1.79e+308", 2)), Oracle10g.class);
            dataTypeRegistry.registerDataType(new NumericDataType(1, "BINARY_FLOAT", new NumericDataType.MinMaxValue("1.2e-38", "3.4e+38", 2)), Oracle10g.class);
        }

        protected void registerComplexTypes(DataTypeRegistry dataTypeRegistry) {
            long l = System.currentTimeMillis();
            Schema schema = Oracle8i.getBuiltInSchema("ORDSYS");
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(34), OracleTypesArb.getString(35));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(36), OracleTypesArb.getString(37));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(38), OracleTypesArb.getString(39));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(40), OracleTypesArb.getString(41));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(42), OracleTypesArb.getString(43));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(44), OracleTypesArb.getString(45));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle10g.class, schema, OracleTypesArb.getString(46), OracleTypesArb.getString(47));
            l = System.currentTimeMillis() - l;
            DBUtil.getLog().trace("Registering Oracle10g built in complex types {0}ms", new Object[]{Long.toString(l)});
        }

        Registerer() {
        }
    }
}

