/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.Oracle10gDDLAlterTable;
import oracle.javatools.db.ora.Oracle9iR2DDLGenerator;
import oracle.javatools.db.ora.OracleDDLAlterTable;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.util.ModelUtil;

public class Oracle10gDDLGenerator
extends Oracle9iR2DDLGenerator {
    public static final String PURGE = "PURGE";

    public Oracle10gDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Ddl getPurgeDDL(RecycledObject recycledObject) {
        Ddl ddl = new Ddl();
        if (recycledObject == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PURGE).append(" ");
            stringBuffer.append("RECYCLEBIN");
            ddl.put("DROP", stringBuffer.toString());
        } else {
            String string = recycledObject.getOriginalType();
            if (ModelUtil.hasLength((String)string)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(PURGE).append(" ");
                if (string.equals("TABLE")) {
                    stringBuffer.append("TABLE").append(" ");
                } else if (string.equals("INDEX")) {
                    stringBuffer.append("INDEX").append(" ");
                }
                stringBuffer.append(this.m_prov.getExternalName(recycledObject.getName()));
                ddl.put("DROP", stringBuffer.toString());
            }
        }
        return ddl;
    }

    public Ddl getUndeleteDDL(SchemaObject[] schemaObjectArray) {
        Ddl ddl = new Ddl();
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject schemaObject = schemaObjectArray[n];
            String string = schemaObject.getType();
            if ("RECYCLEBIN".equals(string)) {
                ddl.append(this.getUndropDDL((RecycledObject)schemaObject));
            }
            ++n;
        }
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public Ddl getUndropDDL(RecycledObject recycledObject) {
        String string = recycledObject.getName();
        String string2 = recycledObject.getOriginalName();
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, "FLASHBACK", "RECYCLE", string2);
        stringBuffer.append("FLASHBACK").append(" ");
        if ("TABLE".equals(recycledObject.getOriginalType())) {
            stringBuffer.append("TABLE").append(" ");
        } else if ("INDEX".equals(recycledObject.getOriginalType())) {
            stringBuffer.append("INDEX").append(" ");
        }
        stringBuffer.append("\"").append(string).append("\"").append(" ");
        stringBuffer.append("TO BEFORE DROP");
        Ddl ddl = new Ddl();
        ddl.put("FLASHBACK", stringBuffer.toString());
        return ddl;
    }

    public Ddl getDeleteDDL(SchemaObject schemaObject, boolean bl) {
        if (schemaObject instanceof RecycledObject) {
            return this.getPurgeDDL((RecycledObject)schemaObject);
        }
        return super.getDeleteDDL(schemaObject, bl);
    }

    protected OracleDDLAlterTable createOracleDDLAlterTable(ResultSet resultSet) {
        return new Oracle10gDDLAlterTable(this.m_prov, resultSet);
    }
}

