/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.DatabaseLinkBuilder;
import oracle.javatools.db.ora.DatabaseLinkValidator;
import oracle.javatools.db.ora.JavaBinaryBuilder;
import oracle.javatools.db.ora.JavaSourceBuilder;
import oracle.javatools.db.ora.MaterializedViewBuilder;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.MaterializedViewLogValidator;
import oracle.javatools.db.ora.MaterializedViewValidator;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8iTriggerBuilder;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;

public class Oracle8i
extends Oracle8 {
    public static final String BUILT_IN_SCHEMA = "OfflineDBConstants.BUILT_IN_SCHEMA";
    private static final String CREATE_PRIV = "CREATE {0}";
    private static final String CREATE_ANY_PRIV = "CREATE ANY {0}";
    private static final String ALTER_ANY_PRIV = "ALTER ANY {0}";
    private static final String DROP_ANY_PRIV = "DROP ANY {0}";
    private static final HashMap s_buitInSchemas = new HashMap();
    protected static final String SYS = "SYS";
    protected static final String MDSYS = "MDSYS";
    protected static final String ORDSYS = "ORDSYS";

    static {
        Schema schema = new Schema(SYS);
        Schema schema2 = new Schema(MDSYS);
        Schema schema3 = new Schema(ORDSYS);
        schema.setProperty(BUILT_IN_SCHEMA, Boolean.TRUE);
        schema2.setProperty(BUILT_IN_SCHEMA, Boolean.TRUE);
        schema3.setProperty(BUILT_IN_SCHEMA, Boolean.TRUE);
        s_buitInSchemas.put(SYS, schema);
        s_buitInSchemas.put(MDSYS, schema2);
        s_buitInSchemas.put(ORDSYS, schema3);
    }

    Oracle8i(Connection connection) {
        this(null, connection);
    }

    Oracle8i(String string, Connection connection) {
        super(string, connection);
        if (connection instanceof OracleConnection) {
            Oracle8i.initOC((OracleConnection)connection);
        }
    }

    public int getOracleDatabaseType() {
        return 2;
    }

    protected void registerBuilders() {
        super.registerBuilders();
        if (this.supportsJava()) {
            this.registerBuilder("JAVA SOURCE", new JavaSourceBuilder(this));
            this.registerBuilder("JAVA CLASS", new JavaBinaryBuilder(this, "JAVA CLASS"));
            this.registerBuilder("JAVA RESOURCE", new JavaBinaryBuilder(this, "JAVA RESOURCE"));
        }
        this.registerBuilder("MATERIALIZED VIEW", new MaterializedViewBuilder(this));
        this.registerBuilder("MATERIALIZED VIEW LOG", new MaterializedViewLogBuilder(this));
        this.registerBuilder("TRIGGER", new Oracle8iTriggerBuilder(this));
        this.registerBuilder("DATABASE LINK", new DatabaseLinkBuilder(this));
    }

    protected void registerValidators() {
        super.registerValidators();
        this.registerValidator("DATABASE LINK", new DatabaseLinkValidator(this));
        this.registerValidator("MATERIALIZED VIEW", new MaterializedViewValidator(this));
        this.registerValidator("MATERIALIZED VIEW LOG", new MaterializedViewLogValidator(this));
    }

    public boolean supportsJava() {
        return true;
    }

    public boolean hasPriviledge(String string, Schema schema, String string2) {
        if (ModelUtil.areEqual((Object)"CREATE", (Object)string2)) {
            if ("INDEX".equals(string) && (schema == null || ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema))) {
                return true;
            }
            String[] stringArray = "SCHEMA".equals(string) ? new String[]{"USER"} : ("PACKAGE".equals(string) || "FUNCTION".equals(string) ? new String[]{"PROCEDURE"} : ("MATERIALIZED VIEW".equals(string) ? new String[]{string, "SNAPSHOT"} : new String[]{string}));
            boolean bl = false;
            String[] stringArray2 = stringArray;
            int n = 0;
            while (n < stringArray2.length) {
                String string3 = stringArray2[n];
                boolean bl2 = bl = this.hasPrivilege(MessageFormat.format(CREATE_ANY_PRIV, string3)) || (schema == null || ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema)) && this.hasPrivilege(MessageFormat.format(CREATE_PRIV, string3));
                if (bl) break;
                ++n;
            }
            return bl;
        }
        if (ModelUtil.areEqual((Object)"MODIFY", (Object)string2)) {
            String string4 = null;
            if ("PACKAGE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string)) {
                string4 = "PROCEDURE";
            } else if ("TYPE".equals(string)) {
                string4 = "TYPE";
            } else if ("TRIGGER".equals(string)) {
                string4 = "TRIGGER";
            }
            if (string4 != null) {
                return ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema) || this.hasPrivilege(MessageFormat.format(ALTER_ANY_PRIV, string4));
            }
        } else if (ModelUtil.areEqual((Object)"DELETE", (Object)string2)) {
            String string5 = string;
            if ("SCHEMA".equals(string)) {
                return ModelUtil.areDifferent((Object)schema, (Object)this.getCurrentSchema()) && ModelUtil.areDifferent((Object)schema, (Object)this.getPublicSchema()) && this.hasPrivilege("DROP USER");
            }
            if ("PACKAGE".equals(string) || "FUNCTION".equals(string)) {
                string5 = "PROCEDURE";
            }
            Object[] objectArray = new Object[]{string5};
            return ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema) || this.hasPrivilege(MessageFormat.format(DROP_ANY_PRIV, objectArray));
        }
        return super.hasPriviledge(string, schema, string2);
    }

    public void deleteObject(SchemaObject schemaObject, boolean bl) throws DBException {
        super.deleteObject(schemaObject, bl);
    }

    static void initOC(OracleConnection oracleConnection) {
        if (oracleConnection.getSessionTimeZone() == null) {
            boolean bl = false;
            TimeZone timeZone = TimeZone.getDefault();
            String string = timeZone != null ? timeZone.getID() : "America/Los_Angeles";
            try {
                oracleConnection.setSessionTimeZone(string);
                bl = true;
            }
            catch (SQLException sQLException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (!bl) {
                Calendar calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
                int n = calendar.get(16) + calendar.get(15);
                int n2 = n / 60000;
                String string2 = MessageFormat.format("{0,number,00}:{1,number,00}", new Integer(n2 / 60), new Integer(n2 % 60));
                try {
                    oracleConnection.setSessionTimeZone(string2);
                }
                catch (SQLException sQLException) {
                    DBUtil.getLog().trace("Error setting Session TimeZone to either " + string + " or " + string2);
                    DBUtil.getLog().trace("  " + sQLException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    protected String getCustomQuery(String string) {
        String string2 = "MATERIALIZED VIEW LOG".equals(string) ? OracleDictionaryQueries.ORACLE_MVIEW_LOG_QUERY : ("MATERIALIZED VIEW".equals(string) ? "SELECT MV.MVIEW_NAME, ''MATERIALIZED VIEW'', O.OBJECT_ID FROM  SYS.ALL_MVIEWS MV, SYS.ALL_OBJECTS O WHERE MV.OWNER = ''{0}'' AND   MV.MVIEW_NAME LIKE ''{1}'' AND   MV.OWNER = O.OWNER AND   MV.MVIEW_NAME = O.OBJECT_NAME AND   O.OBJECT_TYPE = ''UNDEFINED''" : ("JAVA SOURCE".equals(string) || "JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) ? MessageFormat.format("SELECT NVL(LONGNAME,OBJECT_NAME), OBJECT_TYPE, OBJECT_ID FROM SYS.ALL_OBJECTS, JAVASNM WHERE OWNER = ''{0}'' AND NVL(LONGNAME,OBJECT_NAME) LIKE ''{1}'' AND OBJECT_TYPE = ''{2}'' AND OBJECT_NAME = SHORT(+)", "'{0}'", "'{1}'", "'" + string + "'") : ("DATABASE LINK".equals(string) ? OracleDictionaryQueries.DATABASE_LINK_QUERY : super.getCustomQuery(string))));
        return string2;
    }

    protected boolean isCustomQuery(String string, Schema schema) {
        return "MATERIALIZED VIEW LOG".equals(string) || "MATERIALIZED VIEW".equals(string) || "JAVA SOURCE".equals(string) || "JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) || "DATABASE LINK".equals(string) || super.isCustomQuery(string, schema);
    }

    protected String getIDQuery(String string) {
        return "JAVA SOURCE".equals(string) || "JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) ? "SELECT OWNER, NVL(LONGNAME,OBJECT_NAME), NULL, NULL, NULL, -1 FROM SYS.ALL_OBJECTS, JAVASNM WHERE OBJECT_ID = ?" : super.getIDQuery(string);
    }

    protected static final void registerComplexType(DataTypeRegistry dataTypeRegistry, Class clazz, Schema schema, String string, String string2) {
        ObjectType objectType = new ObjectType(string, schema);
        objectType.setSource(string2);
        dataTypeRegistry.registerComplexType(objectType, clazz);
    }

    protected static final Schema getBuiltInSchema(String string) {
        return (Schema)s_buitInSchemas.get(string);
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            dataTypeRegistry.registerDataType(new PredefinedDataType(1, "UROWID", "UROWID[(<size>)]", 1L, 4000L, 4000L, false, null), Oracle8i.class, JdbcDatabase.ANSI_SMALLINT);
        }

        public void registerComplexTypes(DataTypeRegistry dataTypeRegistry) {
            long l = System.currentTimeMillis();
            Schema schema = Oracle8i.getBuiltInSchema(Oracle8i.MDSYS);
            Schema schema2 = Oracle8i.getBuiltInSchema(Oracle8i.ORDSYS);
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle8i.class, schema, OracleTypesArb.getString(16), OracleTypesArb.getString(17));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle8i.class, schema2, OracleTypesArb.getString(22), OracleTypesArb.getString(23));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle8i.class, schema2, OracleTypesArb.getString(26), OracleTypesArb.getString(27));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle8i.class, schema2, OracleTypesArb.getString(30), OracleTypesArb.getString(31));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle8i.class, schema2, OracleTypesArb.getString(32), OracleTypesArb.getString(33));
            l = System.currentTimeMillis() - l;
            DBUtil.getLog().trace("Registering Oracle8i built in complex types {0}ms", new Object[]{Long.toString(l)});
        }

        Registerer() {
        }
    }
}

