/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.TimeStampTZDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.OracleTypesArb;

public class Oracle9i
extends Oracle8i {
    public static final String ORA_DATATYPE_ATTRIBUTE_TIME_ZONE = "time_zone";
    public static final String ORA_DATATYPE_ATTRIBUTE_VALUE_TIME_ZONE = "TIME ZONE";
    protected static final DataTypeAttribute fractionalPrecision = new DataTypeAttribute("scale", 96, 0L, BaseOracleDatabase.LONG_9, BaseOracleDatabase.LONG_6, false);

    Oracle9i(Connection connection) {
        this(null, connection);
    }

    Oracle9i(String string, Connection connection) {
        super(string, connection);
    }

    public int getOracleDatabaseType() {
        return 3;
    }

    protected boolean isCustomQuery(String string, Schema schema) {
        return string.equals("MATERIALIZED VIEW") ? false : super.isCustomQuery(string, schema);
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        protected void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            DataTypeAttribute dataTypeAttribute = new DataTypeAttribute("unit", 99, new String[]{"BYTE", "CHAR"}, null, false, false);
            DataTypeAttribute dataTypeAttribute2 = new DataTypeAttribute(Oracle9i.ORA_DATATYPE_ATTRIBUTE_TIME_ZONE, 95, new String[]{Oracle9i.ORA_DATATYPE_ATTRIBUTE_VALUE_TIME_ZONE, "LOCAL TIME ZONE"}, null, false, false);
            dataTypeRegistry.registerDataType(new TimeStampTZDataType(1, "TIMESTAMP", "TIMESTAMP[(<scale>)][ WITH <time_zone>]", new DataTypeAttribute[]{fractionalPrecision, dataTypeAttribute2}), Oracle9i.class);
            dataTypeRegistry.registerDataType(new CharacterDataType(1, "CHAR", "CHAR[(<size>[ <unit>])]", 1L, 2000L, 1L, false, new DataTypeAttribute[]{dataTypeAttribute}), Oracle9i.class);
            dataTypeRegistry.registerDataType(new CharacterDataType(1, "VARCHAR2", "VARCHAR2(<size>[ <unit>])", 1L, 4000L, 4000L, true, new DataTypeAttribute[]{dataTypeAttribute}), Oracle9i.class);
        }

        protected static void registerSysTypes(DataTypeRegistry dataTypeRegistry, Class clazz) {
            Schema schema = Oracle8i.getBuiltInSchema("SYS");
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(8), OracleTypesArb.getString(9));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(12), OracleTypesArb.getString(13));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(6), OracleTypesArb.getString(7));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(14), OracleTypesArb.getString(15));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(0), OracleTypesArb.getString(1));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(48), OracleTypesArb.getString(49));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(50), OracleTypesArb.getString(51));
            Oracle8i.registerComplexType(dataTypeRegistry, clazz, schema, OracleTypesArb.getString(52), OracleTypesArb.getString(53));
        }

        protected void registerComplexTypes(DataTypeRegistry dataTypeRegistry) {
            long l = System.currentTimeMillis();
            Schema schema = Oracle8i.getBuiltInSchema("MDSYS");
            Schema schema2 = Oracle8i.getBuiltInSchema("ORDSYS");
            Registerer.registerSysTypes(dataTypeRegistry, Oracle9i.class);
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle9i.class, schema, OracleTypesArb.getString(18), OracleTypesArb.getString(19));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle9i.class, schema2, OracleTypesArb.getString(24), OracleTypesArb.getString(25));
            Oracle8i.registerComplexType(dataTypeRegistry, Oracle9i.class, schema2, OracleTypesArb.getString(28), OracleTypesArb.getString(29));
            l = System.currentTimeMillis() - l;
            DBUtil.getLog().trace("Registering Oracle9i built in complex types {0}ms", new Object[]{Long.toString(l)});
        }

        Registerer() {
        }
    }
}

