/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.validators.ColumnValidator;

public class OracleColumnValidator
extends ColumnValidator {
    public OracleColumnValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void validateName(DBObject dBObject) throws InvalidNameException {
        super.validateName(dBObject);
        String string = dBObject.getName();
        if (string.equals("ROWID")) {
            throw new InvalidNameException(dBObject, DBArb.format(51, string, DBArb.getString(5)));
        }
    }

    protected void validateColumnDefinition(Column column) throws ValidationException {
        super.validateColumnDefinition(column);
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType(column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dataType.getName().startsWith("LONG")) {
            Column[] columnArray = column.getRelation().getColumns();
            int n = 0;
            while (n < columnArray.length) {
                DBObject dBObject = null;
                try {
                    dBObject = DataTypeHelper.getDataType(columnArray[n].getDataTypeUsage());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dBObject.getName().startsWith("LONG") && !column.getName().equals(columnArray[n].getName())) {
                    throw new ValidationException((DBObject)column, DBArb.format(146, columnArray[n].getName()));
                }
                ++n;
            }
        }
    }
}

