/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;

public class OracleConstraintValidator
extends ConstraintValidator {
    private static final HashSet INVALID_CONSTRAINT_DATATYPES = new HashSet<String>(Arrays.asList("BFILE", "BLOB", "CLOB", "LONG", "LONG RAW", "NCLOB", "LOB", "VARRAY", "NESTED TABLE", "OBJECT", "REF"));

    public OracleConstraintValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        super.validateNameInUse(dBObject);
        if (dBObject instanceof UniqueConstraint) {
            Table table = (Table)dBObject.getParent();
            Index[] indexArray = table.getIndexes();
            int n = 0;
            while (n < indexArray.length) {
                if (dBObject.getName().equals(indexArray[n].getName())) {
                    throw new NameInUseException(dBObject.getName(), table.getName(), table.getType());
                }
                ++n;
            }
            this.getProvider().validateUniqueName("INDEX", table.getSchema(), dBObject.getName());
        }
    }

    protected boolean isValidConstraintDatatype(String string, DataTypeUsage dataTypeUsage) {
        String string2;
        boolean bl = INVALID_CONSTRAINT_DATATYPES.contains(string) ^ true;
        if (dataTypeUsage != null && string.equals("TIMESTAMP") && (string2 = (String)dataTypeUsage.getAttributeValue("time_zone")) != null && string2.equals("TIME ZONE")) {
            bl = false;
        }
        return bl;
    }
}

