/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;

abstract class OracleDBObjectBuilder
extends AbstractDBObjectBuilder {
    private BaseOracleDatabase _db;
    private boolean _supportsTimestamp;

    protected OracleDBObjectBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
        this._db = baseOracleDatabase;
        this._supportsTimestamp = baseOracleDatabase.getOracleDatabaseType() != 8;
    }

    protected final Connection getConnection() {
        return this._db.getConnection();
    }

    protected BaseOracleDatabase getDatabase() {
        return this._db;
    }

    protected void registerObject(SchemaObject schemaObject) throws DBException {
        this.updateTimestamp(schemaObject);
        super.registerObject(schemaObject);
    }

    private void updateTimestamp(SchemaObject schemaObject) throws DBException {
        if (this._supportsTimestamp && schemaObject.getProperty("Timestamp") == null) {
            schemaObject.setProperty("Timestamp", this._db.getExternalTimestamp(schemaObject));
        }
    }

    protected abstract void fillInObject(SchemaObject var1) throws DBException;

    protected void fillInObjects(SchemaObject[] schemaObjectArray) throws DBException {
    }

    static void mav$sqlTrace(OracleDBObjectBuilder oracleDBObjectBuilder, String string, Object[] objectArray) {
        oracleDBObjectBuilder.sqlTrace(string, objectArray);
    }

    protected class QueryWrapper {
        private PreparedStatement _stmt;
        private ResultSet _rs;
        private String _query;
        private Object[] _params;

        public QueryWrapper(String string, Object ... objectArray) {
            this._query = string;
            this._params = objectArray;
        }

        public QueryWrapper(String string) {
            this(string, null);
        }

        public ResultSet executeQuery() throws SQLException {
            Connection connection = OracleDBObjectBuilder.this.getConnection();
            this._stmt = connection.prepareStatement(this._query);
            Object[] objectArray = null;
            if (this._params != null) {
                objectArray = new Object[this._params.length];
                int n = 0;
                while (n < this._params.length) {
                    objectArray[n] = this.convertParam(this._params[n]);
                    if (objectArray[n] instanceof String) {
                        this._stmt.setString(n + 1, (String)objectArray[n]);
                    } else if (objectArray[n] instanceof Date) {
                        this._stmt.setDate(n + 1, (Date)objectArray[n]);
                    } else if (objectArray[n] instanceof Integer) {
                        this._stmt.setInt(n + 1, (Integer)objectArray[n]);
                    } else {
                        this._stmt.setObject(n + 1, objectArray[n]);
                    }
                    ++n;
                }
            }
            OracleDBObjectBuilder.mav$sqlTrace(OracleDBObjectBuilder.this, this._query, objectArray);
            this._rs = this._stmt.executeQuery();
            return this._rs;
        }

        private Object convertParam(Object object) {
            if (object instanceof DBObject) {
                return AbstractDBObjectProvider.convertObject((DBObject)object);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(this.convertParam(objectArray[n]));
                    if (n < objectArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            return object;
        }

        public void close() {
            if (this._rs != null) {
                try {
                    this._rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

