/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

public class OracleDDLAlterTable
extends OracleDDLGenerator {
    private ResultSet m_diffs;
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String DATATYPEUSAGE = "dataTypeUsage";
    public static final String ISNOTNULL = "notNull";
    public static final String DEFAULT_DIFF = "default";
    public static final String ISENABLED = "enabled";
    public static final String COLUMNS = "columns";
    public static final String CONSTRAINTS = "constraints";
    public static final String PROPERTYNAME_INDEXES = "indexes";
    public static final String PROPERTYNAME_INCREMENTBY = "incrementBy";
    public static final String PROPERTYNAME_MAXVALUE = "maxValue";
    public static final String PROPERTYNAME_MINVALUE = "minValue";
    public static final String PROPERTYNAME_CYCLEFLAG = "cycleFlag";
    public static final String PROPERTYNAME_CACHESIZE = "cacheSize";
    public static final String PROPERTYNAME_ORDERFLAG = "orderFlag";
    public static final String PROPERTYNAME_CHECKCONDITION = "checkCondition";
    public static final String PROPERTYNAME_DELETEMODE = "deleteMode";
    public static final String PROPERTYNAME_ORACLEEXTERNALTABLEPROPERTIES = "OracleExternalTableProperties";
    public static final String PROPERTYNAME_REJECTLIMIT = "rejectLimit";
    public static final String PROPERTYNAME_ACCESSPARAMETERS = "accessParameters";
    public static final String PROPERTYNAME_LOCATIONSPECIFIERS = "locationSpecifiers";
    public static final String PROPERTYNAME_DEFAULT_DIRECTORY = "defaultDirectory";
    public static final String PROPERTYNAME_DIRECTORY = "directory";
    public static final String PROPERTYNAME_SPECIFIER = "specifier";
    public static final String PROPERTYNAME_ORACLEIOTPROPERTIES = "OracleIndexOrganizedTableProperties";
    public static final String PROPERTYNAME_PCT_THRESHOLD = "pctThreshold";
    public static final String PROPERTYNAME_KEY_COMPRESSION = "keyCompression";
    public static final String PROPERTYNAME_MAPPED = "mapped";
    public static final String PROPERTYNAME_INCLUDE_COLUMN = "includeColumn";
    public static final String PROPERTYNAME_OVERFLOWABLE = "overflowable";
    public static final String PROPERTYNAME_OVERFLOW_PROPERTIES = "overflowProperties";
    public static final String PROPERTYNAME_BUFFER_MODE = "bufferMode";
    public static final String PROPERTYNAME_FREELISTS = "freelists";
    public static final String PROPERTYNAME_FREELIST_GROUPS = "freelistGroups";
    public static final String PROPERTYNAME_INI_EXTENT = "initialExtent";
    public static final String PROPERTYNAME_INITRANS = "initrans";
    public static final String PROPERTYNAME_LOGGING = "logging";
    public static final String PROPERTYNAME_MAXEXTENTS = "maxExtent";
    public static final String PROPERTYNAME_MAXTRANS = "maxtrans";
    public static final String PROPERTYNAME_MINEXTENTS = "minExtent";
    public static final String PROPERTYNAME_NEXT_EXTENT = "nextExtent";
    public static final String PROPERTYNAME_PCTFREE = "percentFree";
    public static final String PROPERTYNAME_PCTINCREASE = "percentIncrease";
    public static final String PROPERTYNAME_PCTUSED = "percentUsed";
    public static final String PROPERTYNAME_TABLESPACE = "tablespace";
    public static final String PROPERTYNAME_ORACLETABLEPARTITIONS = "OracleTablePartitions";
    public static final String PROPERTYNAME_PARTITION_COLUMNS = "partitionColumns";
    public static final String PROPERTYNAME_PARTITIONS = "partitions";
    public static final String PROPERTYNAME_PARTITION_HASH_QUANTITY = "hashQuantity";
    public static final String PROPERTYNAME_PARTITION_HASH_QUANTITY_TABLESPACES = "hashQuantityTablespaces";
    public static final String PROPERTYNAME_PARTITION_SUBPARTITION_MODEL = "subpartitionModel";
    public static final String PROPERTYNAME_TABLEPARTITION = "TablePartition";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_COMPRESSION = "compression";
    public static final String PROPERTYNAME_VALUES = "values";
    public static final String PROPERTYNAME_SEGMENT_ATTRIBUTES = "segmentAttributes";
    public static final String PROPERTYNAME_PARTITION_LEVEL_SUBPARTITIONS = "partitionLevelSubpartitions";
    public static final String PROPERTYNAME_LOB_DESCRIPTORS = "LOBDescriptors";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_CACHE = "cache";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_CHUNK = "chunk";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_FREEPOOLS = "freepools";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_LOB_SEGNAME = "lOBSegName";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_PCTVERSION = "pctVersion";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_RETENTION = "retention";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_STORAGE = "storage";
    public static final String PROPERTYNAME_LOB_DESCRIPTOR_STORAGE_ENABLED_IN_ROW = "storageEnabledInRow";
    public static final String PROPERTYNAME_CACHE = "cache";
    public static final String PROPERTYNAME_PARALLEL = "parallel";
    public static final String PROPERTYNAME_ISUSENOINDEX = "isUseNoIndex";
    public static final String PROPERTYNAME_INDEXTABLESPACE = "tablespace";
    public static final String PROPERTYNAME_INDEXPCTFREE = "indexPercentFree";
    public static final String PROPERTYNAME_INDEXPCTUSED = "indexPercentUsed";
    public static final String PROPERTYNAME_INITTRANS = "indexInitTrans";
    public static final String PROPERTYNAME_MINEXTENT = "indexMinExtent";
    public static final String PROPERTYNAME_MAXEXTENT = "indexMaxExtent";
    public static final String PROPERTYNAME_REFRESHMODE = "refreshMode";
    public static final String PROPERTYNAME_NEXTREFRESH = "nextRefresh";
    public static final String PROPERTYNAME_INTERVAL = "interval";
    public static final String PROPERTYNAME_METHOD = "refreshMethod";
    public static final String PROPERTYNAME_KEYTYPE = "keyType";
    public static final String PROPERTYNAME_RSTYPE = "rollbackSegmentType";
    public static final String PROPERTYNAME_RSNAME = "rollbackSegmentName";
    public static final String PROPERTYNAME_TRUSTEDCONSTRAINTS = "usingTrustedConstraints";
    private static HashMap s_seqAttrMap;
    private static HashMap s_seqNoAttrMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final String DEFAULT_PCT_THRESHOLD = "50";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String NL = " \n";

    static {
        $assertionsDisabled = OracleDDLAlterTable.class.desiredAssertionStatus() ^ true;
        s_seqAttrMap = new HashMap();
        s_seqNoAttrMap = new HashMap();
    }

    public OracleDDLAlterTable(DBObjectProvider dBObjectProvider, ResultSet resultSet) {
        super(dBObjectProvider);
        this.$init$();
        this.m_diffs = resultSet;
        if (this.m_diagnosticPrint) {
            resultSet.print();
        }
    }

    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet resultSet) {
        Ddl ddl = null;
        if (schemaObject instanceof Table) {
            ddl = this.getAlterTable((Table)schemaObject, resultSet);
        } else if (schemaObject instanceof Sequence) {
            ddl = this.getAlterSequence((Sequence)schemaObject, resultSet);
        } else if (schemaObject instanceof MaterializedView) {
            ddl = this.getAlterMView((MaterializedView)schemaObject, resultSet);
        }
        return ddl;
    }

    void $init$() {
        s_seqAttrMap.put(PROPERTYNAME_INCREMENTBY, "INCREMENT BY");
        s_seqAttrMap.put(PROPERTYNAME_MAXVALUE, "MAXVALUE");
        s_seqAttrMap.put(PROPERTYNAME_MINVALUE, "MINVALUE");
        s_seqAttrMap.put(PROPERTYNAME_CYCLEFLAG, "CYCLE");
        s_seqAttrMap.put(PROPERTYNAME_CACHESIZE, "CACHE");
        s_seqAttrMap.put(PROPERTYNAME_ORDERFLAG, "ORDER");
        s_seqNoAttrMap.put(PROPERTYNAME_INCREMENTBY, "INCREMENT BY 1");
        s_seqNoAttrMap.put(PROPERTYNAME_MAXVALUE, "NOMAXVALUE");
        s_seqNoAttrMap.put(PROPERTYNAME_MINVALUE, "NOMINVALUE");
        s_seqNoAttrMap.put(PROPERTYNAME_CYCLEFLAG, "NOCYCLE");
        s_seqNoAttrMap.put(PROPERTYNAME_CACHESIZE, "NOCACHE");
        s_seqNoAttrMap.put(PROPERTYNAME_ORDERFLAG, "NOORDER");
    }

    private Ddl getAlterMView(MaterializedView materializedView, ResultSet resultSet) {
        Ddl ddl = new Ddl();
        MaterializedView materializedView2 = (MaterializedView)resultSet.b();
        OracleDDLGenerator.MaterializedViewDDLHelper materializedViewDDLHelper = new OracleDDLGenerator.MaterializedViewDDLHelper(this, materializedView2);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        HashMap hashMap = this.getAttributes(resultSet, false);
        for (String string : hashMap.keySet()) {
            if ("cache".equals(string)) {
                stringBuffer.append(materializedViewDDLHelper.getCacheDDL());
            }
            if (PROPERTYNAME_PARALLEL.equals(string)) {
                stringBuffer.append(materializedViewDDLHelper.getParallelDDL());
            }
            if (PROPERTYNAME_INITTRANS.equals(string)) {
                stringBuffer.append(materializedViewDDLHelper.getUsingIndexDDL(true));
            }
            if (!PROPERTYNAME_REFRESHMODE.equals(string) && !PROPERTYNAME_NEXTREFRESH.equals(string) && !PROPERTYNAME_INTERVAL.equals(string) && !PROPERTYNAME_METHOD.equals(string) && !PROPERTYNAME_KEYTYPE.equals(string) && !PROPERTYNAME_RSTYPE.equals(string) && !PROPERTYNAME_RSNAME.equals(string) && !PROPERTYNAME_TRUSTEDCONSTRAINTS.equals(string) || bl) continue;
            bl = true;
            stringBuffer.append(materializedViewDDLHelper.getRefreshDDL());
        }
        if (stringBuffer.toString().trim().length() > 1) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("ALTER").append(" ").append("MATERIALIZED VIEW").append(" ");
            stringBuffer2.append(this.getSchemaDotName(materializedView));
            stringBuffer2.append(NL);
            stringBuffer2.append(stringBuffer);
            ddl.put("MVW", stringBuffer2.toString());
        }
        return ddl;
    }

    private Ddl getAlterSequence(Sequence sequence, ResultSet resultSet) {
        Ddl ddl = new Ddl();
        boolean bl = false;
        HashMap hashMap = this.getAttributes(resultSet, false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(" ").append("SEQUENCE").append(" ");
        stringBuffer.append(this.getSchemaDotName(sequence));
        stringBuffer.append(NL);
        for (String string : hashMap.keySet()) {
            if (!s_seqAttrMap.containsKey(string)) continue;
            bl = true;
            String string2 = (String)hashMap.get(string);
            if (string2 == null || string2.length() == 0) {
                String string3 = (String)s_seqNoAttrMap.get(string);
                stringBuffer.append(string3);
            } else {
                String string4 = (String)s_seqAttrMap.get(string);
                if ("true".equals(string2)) {
                    stringBuffer.append(string4);
                } else if ("false".equals(string2)) {
                    String string5 = (String)s_seqNoAttrMap.get(string);
                    stringBuffer.append(string5);
                } else {
                    stringBuffer.append(string4).append(" ").append(string2);
                }
            }
            stringBuffer.append(NL);
        }
        if (bl) {
            ddl.put("SEQ", stringBuffer.toString());
        }
        return ddl;
    }

    protected String renameColumn(ResultSet resultSet) {
        return null;
    }

    protected String renameConstraint(ResultSet resultSet) {
        return null;
    }

    private Ddl getAlterTable(Table table, ResultSet resultSet) {
        String string;
        Ddl ddl = new Ddl();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashMap hashMap = this.getAttributes(resultSet, false);
        if (hashMap.containsKey(PROPERTYNAME_NAME)) {
            String string2 = (String)hashMap.get(PROPERTYNAME_NAME);
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(" ").append("RENAME").append(" ").append("TO").append(" ");
            stringBuffer.append(this.m_prov.getExternalName(string2));
            ddl.put("RENTAB", stringBuffer.toString());
        }
        if (this.isCommentDifferent(resultSet) && ModelUtil.hasLength((String)(string = this.createCommentOn("TABLE", this.getSchemaDotName(table), (String)hashMap.get("Comment"))))) {
            arrayList3.add(string);
        }
        List list = this.getChanged(resultSet, COLUMNS);
        List list2 = this.getDropped(resultSet, COLUMNS);
        List list3 = this.getNew(resultSet, COLUMNS);
        for (ResultSet resultSet2 : list) {
            String string3 = null;
            boolean bl = false;
            if (resultSet2.getModifiedObjectMap().containsKey(PROPERTYNAME_NAME)) {
                bl = true;
                string3 = this.renameColumn(resultSet2);
            }
            if (bl && string3 == null) {
                list2.add(resultSet2);
                list3.add(resultSet2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(NL);
            if (bl) {
                stringBuffer.append(string3).append(" ");
            }
            HashMap hashMap2 = this.getAttributes(resultSet2, true);
            if (!bl || resultSet2.getModifiedObjectMap().size() > 1) {
                stringBuffer.append(this.modifyColumn(resultSet2, hashMap2));
            }
            arrayList.add(stringBuffer.toString());
        }
        for (Object e : list3) {
            ResultSet resultSet3 = (ResultSet)e;
            HashMap hashMap3 = this.getAttributes(resultSet3, true);
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(NL);
            stringBuffer.append(this.addColumn(resultSet3, hashMap3));
            arrayList.add(stringBuffer.toString());
        }
        for (Object e : list2) {
            ResultSet resultSet4 = (ResultSet)e;
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(NL);
            stringBuffer.append(this.dropColumn(resultSet4));
            arrayList.add(stringBuffer.toString());
        }
        if (this.hasColumnComments(resultSet)) {
            List list4 = this.getColumns(resultSet);
            for (ResultSet resultSet5 : list4) {
                if (!this.isCommentDifferent(resultSet5) || this.isDropped(resultSet5)) continue;
                HashMap hashMap4 = this.getAttributes(resultSet5, true);
                arrayList2.add(this.createCommentOn("COLUMN", this.getSchemaDotName(table) + "." + this.getQuotedName(resultSet5), (String)hashMap4.get("Comment")));
            }
        }
        ddl.put("ACO", arrayList);
        ddl.put("CMC", arrayList2);
        ddl.put("CMT", arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        List list5 = this.getNew(resultSet, CONSTRAINTS);
        List list6 = this.getChanged(resultSet, CONSTRAINTS);
        List list7 = this.getDropped(resultSet, CONSTRAINTS);
        for (ResultSet resultSet6 : list6) {
            String string4 = null;
            if (resultSet6.getModifiedObjectMap().containsKey(PROPERTYNAME_NAME)) {
                string4 = this.renameConstraint(resultSet6);
            }
            if (string4 != null && resultSet6.getModifiedObjectMap().size() == 1) {
                StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
                stringBuffer.append(this.getSchemaDotName(table));
                stringBuffer.append(NL);
                stringBuffer.append(string4);
                String string5 = this.getConstraintType(resultSet6);
                if (string5.equals("FKConstraint")) {
                    arrayList5.add(stringBuffer.toString());
                    continue;
                }
                if (string5.equals("CheckConstraint")) {
                    arrayList6.add(stringBuffer.toString());
                    continue;
                }
                arrayList4.add(stringBuffer.toString());
                continue;
            }
            list7.add(resultSet6);
            list5.add(resultSet6);
        }
        for (ResultSet resultSet7 : list7) {
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(NL);
            stringBuffer.append(this.dropConstraint(resultSet7));
            String string6 = this.getConstraintType(resultSet7);
            if (string6.equals("FKConstraint")) {
                arrayList5.add(stringBuffer.toString());
                continue;
            }
            if (string6.equals("CheckConstraint")) {
                arrayList6.add(stringBuffer.toString());
                continue;
            }
            arrayList4.add(stringBuffer.toString());
        }
        for (ResultSet resultSet8 : list5) {
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
            stringBuffer.append(this.getSchemaDotName(table));
            stringBuffer.append(NL);
            stringBuffer.append(this.addConstraint(table, resultSet8));
            String string7 = this.getConstraintType(resultSet8);
            if (string7.equals("FKConstraint")) {
                arrayList5.add(stringBuffer.toString());
                continue;
            }
            if (string7.equals("CheckConstraint")) {
                arrayList6.add(stringBuffer.toString());
                continue;
            }
            arrayList4.add(stringBuffer.toString());
        }
        ddl.put("CONUK", arrayList4);
        ddl.put("CONFK", arrayList5);
        ddl.put("CONCC", arrayList6);
        List list8 = this.getChanged(resultSet, PROPERTYNAME_INDEXES);
        List list9 = this.getDropped(resultSet, PROPERTYNAME_INDEXES);
        list9.addAll(list8);
        List list10 = this.getNew(resultSet, PROPERTYNAME_INDEXES);
        list10.addAll(list8);
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (ResultSet resultSet9 : list9) {
            Index index = (Index)resultSet9.a();
            StringBuffer stringBuffer = new StringBuffer("DROP INDEX ");
            stringBuffer.append(this.getSchemaDotName(index));
            arrayList7.add(stringBuffer.toString());
        }
        ArrayList<String> arrayList8 = new ArrayList<String>();
        for (ResultSet resultSet10 : list10) {
            Index index = (Index)resultSet10.b();
            Ddl ddl2 = this.createIndex(index);
            arrayList8.add(ddl2.get("IND"));
        }
        ddl.put("DROP", arrayList7);
        ddl.put("IND", arrayList8);
        this.alterExternalTableProperties(ddl, table, resultSet);
        if (table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
            this.alterIndexOrganizedTableProperties(ddl, table, resultSet);
        }
        this.alterOracleTablePartitions(ddl, table, resultSet);
        return ddl;
    }

    private void alterOracleTablePartitions(Ddl ddl, Table table, ResultSet resultSet) {
        boolean bl = table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(PROPERTYNAME_ORACLETABLEPARTITIONS);
        if (resultSet2 != null) {
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE).append(this.getSchemaDotName(table)).append(" ");
            ArrayList arrayList = new ArrayList();
            this.alterOracleTablePartitions(stringBuffer, arrayList, resultSet2, null, bl);
            if (arrayList.size() > 0) {
                ddl.put("TP", arrayList);
            }
        }
    }

    private void alterOracleTablePartitions(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, String string, boolean bl) {
        Map map = resultSet.getModifiedObjectMap();
        ResultSet resultSet2 = (ResultSet)map.get(PROPERTYNAME_PARTITION_SUBPARTITION_MODEL);
        if (resultSet2 != null) {
            this.setSubpartitionModel(stringBuffer, arrayList, resultSet2);
        }
        if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_PARTITIONS)) != null) {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)resultSet.a();
            this.modifyTablePartitions(stringBuffer, arrayList, resultSet2, bl, oracleTablePartitions.getSubpartitionModel() != null);
            this.addTablePartitions(stringBuffer, arrayList, resultSet2, string);
            this.dropTablePartitions(stringBuffer, arrayList, resultSet2);
        }
    }

    private void setSubpartitionModel(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet) {
        Map map = resultSet.getModifiedObjectMap();
        if (map.containsKey(PROPERTYNAME_PARTITION_HASH_QUANTITY)) {
            ResultSet resultSet2 = (ResultSet)map.get(PROPERTYNAME_PARTITION_HASH_QUANTITY);
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            stringBuffer2.append("SET").append(" ").append("SUBPARTITION").append(" ").append("TEMPLATE").append(" ").append(resultSet2.getBVal());
            arrayList.add(stringBuffer2.toString());
        } else if (map.containsKey(PROPERTYNAME_PARTITIONS)) {
            ResultSet resultSet3 = (ResultSet)map.get(PROPERTYNAME_PARTITIONS);
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
            stringBuffer3.append("SET").append(" ").append("SUBPARTITION").append(" ").append("TEMPLATE");
            List list = (List)resultSet3.b();
            if (list.size() > 0) {
                TablePartition[] tablePartitionArray = list.toArray(new TablePartition[0]);
                stringBuffer3.append(this.createTableSubpartitions(tablePartitionArray, "  "));
            } else {
                stringBuffer3.append("(").append(")");
            }
            arrayList.add(stringBuffer3.toString());
        }
    }

    private void modifyTablePartitions(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, boolean bl, boolean bl2) {
        for (Object e : resultSet.getModifiedObjectList()) {
            TablePartition tablePartition = (TablePartition)((ResultSet)e).a();
            if (tablePartition != null) {
                boolean bl3 = false;
                String string = this.m_prov.getExternalName(tablePartition.getName());
                String string2 = tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
                Map map = ((ResultSet)e).getModifiedObjectMap();
                ResultSet resultSet2 = (ResultSet)map.get(PROPERTYNAME_PARTITION_LEVEL_SUBPARTITIONS);
                if (resultSet2 != null) {
                    this.alterOracleTablePartitions(stringBuffer, arrayList, resultSet2, string, bl);
                }
                if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_VALUES)) != null && tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.LIST) {
                    this.addListValues(stringBuffer, arrayList, resultSet2, string, string2);
                    this.dropListValues(stringBuffer, arrayList, resultSet2, string, string2);
                    bl3 = true;
                }
                if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_LOB_DESCRIPTORS)) != null && this.modifyTablePartitionLOBs(stringBuffer, arrayList, resultSet2, tablePartition)) {
                    bl3 = true;
                }
                if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_COMPRESSION)) != null && !bl && tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION) {
                    String string3;
                    String string4 = "COMPRESS".equalsIgnoreCase(resultSet2.getBVal()) ? "COMPRESS" : (string3 = "NOCOMPRESS".equalsIgnoreCase(resultSet2.getBVal()) ? "NOCOMPRESS" : null);
                    if (string3 != null) {
                        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
                        stringBuffer2.append("MODIFY").append(" ").append("PARTITION").append(" ").append(string).append(" ").append(string3);
                        arrayList.add(stringBuffer2.toString());
                        bl3 = true;
                    }
                }
                if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_SEGMENT_ATTRIBUTES)) != null) {
                    if (tablePartition.getObjectType() != OracleTablePartitions.ObjectType.PARTITION || tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        if (!bl) {
                            Map map2 = resultSet2.getModifiedObjectMap();
                            if (!$assertionsDisabled && map2 == null) {
                                throw new AssertionError();
                            }
                            ResultSet resultSet3 = (ResultSet)map2.get("tablespace");
                            if (resultSet3 != null) {
                                StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
                                stringBuffer3.append("MOVE").append(" ").append(string2).append(" ").append(string).append(" ").append("TABLESPACE").append(" ").append(resultSet3.getBVal()).append(" ").append("UPDATE").append(" ").append("INDEXES");
                                arrayList.add(stringBuffer3.toString());
                            }
                        }
                    } else if (this.modifyTablePartitionSegmentAttributes(stringBuffer, arrayList, resultSet2, string, bl)) {
                        bl3 = true;
                    }
                }
                if (bl3 && !bl2) {
                    StringBuffer stringBuffer4 = new StringBuffer(stringBuffer);
                    stringBuffer4.append("MODIFY").append(" ").append(string2).append(" ").append(string).append(" ").append("REBUILD").append(" ").append("UNUSABLE").append(" ").append(" ").append("LOCAL").append(" ").append("INDEXES");
                    arrayList.add(stringBuffer4.toString());
                }
                if ((resultSet2 = (ResultSet)map.get(PROPERTYNAME_NAME)) == null) continue;
                string = resultSet2.getBVal();
                StringBuffer stringBuffer5 = new StringBuffer(stringBuffer);
                stringBuffer5.append("RENAME").append(" ").append(string2).append(" ").append(this.m_prov.getExternalName(resultSet2.getAVal())).append(" ").append("TO").append(" ").append(this.m_prov.getExternalName(resultSet2.getBVal()));
                arrayList.add(stringBuffer5.toString());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private boolean modifyTablePartitionLOBs(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, TablePartition tablePartition) {
        boolean bl = false;
        boolean bl2 = tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.HASH;
        String string = this.m_prov.getExternalName(tablePartition.getName());
        String string2 = tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
        for (Object e : resultSet.getModifiedObjectList()) {
            LOBDescriptor lOBDescriptor = (LOBDescriptor)((ResultSet)e).a();
            if (lOBDescriptor == null) continue;
            Map map = ((ResultSet)e).getModifiedObjectMap();
            String string3 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_LOB_SEGNAME);
            String string4 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_PCTVERSION);
            String string5 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_FREEPOOLS);
            String string6 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_STORAGE_ENABLED_IN_ROW);
            String string7 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_RETENTION);
            String string8 = this.getBVal(map, "cache");
            String string9 = this.getBVal(map, PROPERTYNAME_LOB_DESCRIPTOR_CHUNK);
            String string10 = this.getLOBStorageVal(map, "tablespace");
            String string11 = this.getLOBStorageVal(map, PROPERTYNAME_BUFFER_MODE);
            String string12 = this.getLOBStorageVal(map, PROPERTYNAME_INI_EXTENT);
            String string13 = this.getLOBStorageVal(map, PROPERTYNAME_LOGGING);
            DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
            if (!bl2 && (ModelUtil.hasLength((String)string7) || ModelUtil.hasLength((String)string4) || ModelUtil.hasLength((String)string11) || ModelUtil.hasLength((String)string8))) {
                DBObjectID[] dBObjectIDArray2 = dBObjectIDArray;
                int n = 0;
                while (n < dBObjectIDArray2.length) {
                    DBObjectID dBObjectID = dBObjectIDArray2[n];
                    String string14 = this.getColumnName(dBObjectID);
                    if (ModelUtil.hasLength((String)string14)) {
                        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
                        stringBuffer2.append("MODIFY").append(" ").append(string2).append(" ").append(string).append(" ").append("LOB").append("(").append(string14).append(")").append("(");
                        if (ModelUtil.hasLength((String)string4)) {
                            stringBuffer2.append(" ").append("PCTVERSION").append(" ").append(string4);
                        } else if (ModelUtil.hasLength((String)string7) && string7.equals("true")) {
                            stringBuffer2.append(" ").append("RETENTION");
                        }
                        if (ModelUtil.hasLength((String)string11)) {
                            stringBuffer2.append(this.getBufferPool(string11));
                        }
                        if (ModelUtil.hasLength((String)string8)) {
                            stringBuffer2.append(" ").append("CACHE").append(" ").append(string8);
                            if (ModelUtil.hasLength((String)string13) && !string8.equals("CACHE")) {
                                stringBuffer2.append(" ").append(string13.equals("true") ? "LOGGING" : "NOLOGGING");
                            }
                        }
                        arrayList.add(stringBuffer2.toString());
                    }
                    ++n;
                }
            }
            if (!ModelUtil.hasLength((String)string6) && !ModelUtil.hasLength((String)string3) && !ModelUtil.hasLength((String)string10) && !ModelUtil.hasLength((String)string5) && !ModelUtil.hasLength((String)string9) && !ModelUtil.hasLength((String)string12)) continue;
            DBObjectID[] dBObjectIDArray3 = dBObjectIDArray;
            int n = 0;
            while (n < dBObjectIDArray3.length) {
                DBObjectID dBObjectID = dBObjectIDArray3[n];
                String string15 = this.getColumnName(dBObjectID);
                if (ModelUtil.hasLength((String)string15)) {
                    StringBuffer stringBuffer3 = new StringBuffer(stringBuffer);
                    stringBuffer3.append("MOVE").append(" ").append(string2).append(" ").append(string).append(" ");
                    if (LOBDescriptor.isLOBColumn(dBObjectID)) {
                        stringBuffer3.append("LOB").append("(").append(string15).append(")").append(" ").append("STORE").append(" ").append("AS");
                    } else {
                        stringBuffer3.append("VARRAY").append(" ").append(this.getColumnName(dBObjectIDArray[0])).append(" ").append("STORE").append(" ").append("AS").append(" ").append("LOB");
                    }
                    if (ModelUtil.hasLength((String)string3)) {
                        stringBuffer3.append(" ").append(string3);
                    }
                    boolean bl3 = false;
                    if (ModelUtil.hasLength((String)string10) && (tablePartition.getPartitionType() != OracleTablePartitions.PartitionType.HASH || !LOBDescriptor.isVARRAYColumn(dBObjectID))) {
                        stringBuffer3.append(" ").append("(").append("TABLESPACE").append(" ").append(string10);
                        bl3 = true;
                    }
                    if (tablePartition.getPartitionType() != OracleTablePartitions.PartitionType.HASH) {
                        if (ModelUtil.hasLength((String)string9)) {
                            if (!bl3) {
                                stringBuffer3.append(" ").append("(");
                                bl3 = true;
                            }
                            stringBuffer3.append("CHUNK").append(" ").append(string9);
                        }
                        if (ModelUtil.hasLength((String)string5)) {
                            if (!bl3) {
                                stringBuffer3.append(" ").append("(");
                                bl3 = true;
                            }
                            stringBuffer3.append("FREEPOOLS").append(" ").append(string5);
                        }
                        if (ModelUtil.hasLength((String)string12)) {
                            if (!bl3) {
                                stringBuffer3.append(" ").append("(");
                                bl3 = true;
                            }
                            stringBuffer3.append("STORAGE").append("(").append("INITIAL").append(" ").append(string12).append(")");
                        }
                        if (ModelUtil.hasLength((String)string6)) {
                            if (!bl3) {
                                stringBuffer3.append(" ").append("(");
                                bl3 = true;
                            }
                            stringBuffer3.append(string6.equals("true") ? "ENABLE" : "DISABLE").append(" ").append("STORAGE").append(" ").append("IN").append(" ").append("ROW");
                        }
                    }
                    if (bl3) {
                        stringBuffer3.append(")");
                    }
                    arrayList.add(stringBuffer3.toString());
                }
                ++n;
            }
        }
        return bl;
    }

    private String getBVal(Map map, String string) {
        ResultSet resultSet = (ResultSet)map.get(string);
        if (resultSet != null) {
            return resultSet.getBVal();
        }
        return null;
    }

    private String getLOBStorageVal(Map map, String string) {
        ResultSet resultSet = (ResultSet)map.get(PROPERTYNAME_LOB_DESCRIPTOR_STORAGE);
        if (resultSet != null) {
            Map map2 = resultSet.getModifiedObjectMap();
            if (!$assertionsDisabled && map2 == null) {
                throw new AssertionError();
            }
            ResultSet resultSet2 = (ResultSet)map2.get(string);
            if (resultSet2 != null) {
                return resultSet2.getBVal();
            }
        }
        return null;
    }

    public String getColumnName(DBObjectID dBObjectID) {
        Column column = null;
        DBObject dBObject = null;
        try {
            column = (Column)dBObjectID.resolveID();
            if (column != null) {
                dBObject = DataTypeHelper.getDataType(column.getDataTypeUsage());
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return dBObject != null ? this.m_prov.getExternalName(dBObject.getName()) : "";
    }

    private void addListValues(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, String string, String string2) {
        List list = resultSet.getBonlyList();
        if (list.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            stringBuffer2.append("MODIFY").append(" ").append(string2).append(" ").append(string).append(" ").append("ADD").append(" ").append("VALUES").append("(");
            boolean bl = true;
            for (Object e : list) {
                if (!bl) {
                    stringBuffer2.append(",").append(" ");
                }
                bl = false;
                stringBuffer2.append(((ResultSet)e).b().toString());
            }
            stringBuffer2.append(")");
            arrayList.add(stringBuffer2.toString());
        }
    }

    private void dropListValues(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, String string, String string2) {
        List list = resultSet.getAonlyList();
        if (list.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            stringBuffer2.append("MODIFY").append(" ").append(string2).append(" ").append(string).append(" ").append("DROP").append(" ").append("VALUES").append("(");
            boolean bl = true;
            for (Object e : list) {
                if (!bl) {
                    stringBuffer2.append(",").append(" ");
                }
                bl = false;
                stringBuffer2.append(((ResultSet)e).a().toString());
            }
            stringBuffer2.append(")");
            arrayList.add(stringBuffer2.toString());
        }
    }

    private void addTablePartitions(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, String string) {
        for (Object e : resultSet.getBonlyList()) {
            TablePartition tablePartition = (TablePartition)((ResultSet)e).b();
            if (!$assertionsDisabled && tablePartition == null) {
                throw new AssertionError();
            }
            if (tablePartition == null) continue;
            OracleTablePartitions.ObjectType objectType = tablePartition.getObjectType();
            if (!$assertionsDisabled && objectType == null) {
                throw new AssertionError();
            }
            if (objectType == null) continue;
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            if (objectType == OracleTablePartitions.ObjectType.PARTITION) {
                stringBuffer2.append(this.getAddPartition(tablePartition));
            } else if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                stringBuffer2.append(this.getAddPartitionLevelSubpartition(tablePartition, string));
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (stringBuffer2.length() <= stringBuffer.length()) continue;
            arrayList.add(stringBuffer2.toString());
        }
    }

    private void dropTablePartitions(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet) {
        for (Object e : resultSet.getAonlyList()) {
            TablePartition tablePartition = (TablePartition)((ResultSet)e).a();
            if (!$assertionsDisabled && tablePartition == null) {
                throw new AssertionError();
            }
            if (tablePartition == null) continue;
            OracleTablePartitions.ObjectType objectType = tablePartition.getObjectType();
            if (objectType != null && (objectType == OracleTablePartitions.ObjectType.PARTITION || objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION)) {
                String string = objectType == OracleTablePartitions.ObjectType.PARTITION ? "PARTITION" : "SUBPARTITION";
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
                stringBuffer2.append("DROP").append(" ").append(string).append(" ").append(this.m_prov.getExternalName(tablePartition.getName())).append(" ").append("UPDATE").append(" ").append("INDEXES");
                arrayList.add(stringBuffer2.toString());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private boolean modifyTablePartitionSegmentAttributes(StringBuffer stringBuffer, ArrayList arrayList, ResultSet resultSet, String string, boolean bl) {
        boolean bl2 = false;
        Map map = resultSet.getModifiedObjectMap();
        if (map != null && map.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
            stringBuffer2.append("MODIFY").append(" ").append("PARTITION").append(" ").append(string);
            int n = stringBuffer2.length();
            for (ResultSet resultSet2 : map.values()) {
                if (!bl && PROPERTYNAME_PCTFREE.equals(resultSet2.getName()) && ModelUtil.hasLength((String)resultSet2.getBVal())) {
                    stringBuffer2.append(" ").append("PCTFREE").append(" ").append(resultSet2.getBVal());
                    continue;
                }
                if (PROPERTYNAME_INITRANS.equals(resultSet2.getName()) && ModelUtil.hasLength((String)resultSet2.getBVal())) {
                    stringBuffer2.append(" ").append("INITRANS").append(" ").append(resultSet2.getBVal());
                    continue;
                }
                if (PROPERTYNAME_LOGGING.equals(resultSet2.getName())) {
                    if ("false".equals(resultSet2.getBVal())) {
                        stringBuffer2.append(" ").append("NOLOGGING");
                        continue;
                    }
                    stringBuffer2.append(" ").append("LOGGING");
                    continue;
                }
                if (!PROPERTYNAME_BUFFER_MODE.equals(resultSet2.getName())) continue;
                stringBuffer2.append(this.getBufferPool(resultSet2.getBVal()));
            }
            if (stringBuffer2.length() > n) {
                arrayList.add(stringBuffer2.toString());
                bl2 = true;
            }
            if (!bl) {
                stringBuffer2 = new StringBuffer(stringBuffer);
                stringBuffer2.append("MOVE").append(" ").append("PARTITION").append(" ").append(string);
                n = stringBuffer2.length();
                for (ResultSet resultSet3 : map.values()) {
                    if ("tablespace".equals(resultSet3.getName()) && ModelUtil.hasLength((String)resultSet3.getBVal())) {
                        stringBuffer2.append(" ").append("TABLESPACE").append(" ").append(resultSet3.getBVal());
                        continue;
                    }
                    if (!PROPERTYNAME_INI_EXTENT.equals(resultSet3.getName()) || !ModelUtil.hasLength((String)resultSet3.getBVal())) continue;
                    stringBuffer2.append(" ").append("STORAGE").append("(").append("INITIAL").append(" ").append(resultSet3.getBVal()).append(")");
                }
                if (stringBuffer2.length() > n) {
                    stringBuffer2.append(" ").append("UPDATE").append(" ").append("INDEXES");
                    arrayList.add(stringBuffer2.toString());
                }
            }
        }
        return bl2;
    }

    private StringBuffer getAddPartition(TablePartition tablePartition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ADD").append(" ").append("PARTITION").append(" ");
        if (ModelUtil.hasLength((String)tablePartition.getName())) {
            stringBuffer.append(this.m_prov.getExternalName(tablePartition.getName()));
        }
        if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            stringBuffer.append(NL).append(this.createPartitioningStorageClause(tablePartition, "  "));
        } else if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.LIST) {
            stringBuffer.append(" ").append(this.createTableListPartition(tablePartition));
        } else if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE) {
            stringBuffer.append(" ").append(this.createTableRangePartition(tablePartition));
        }
        return stringBuffer.append("UPDATE").append(" ").append("INDEXES");
    }

    private StringBuffer getAddPartitionLevelSubpartition(TablePartition tablePartition, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MODIFY").append(" ").append("PARTITION").append(" ").append(this.m_prov.getExternalName(string)).append(" ").append("ADD").append(" ").append("SUBPARTITION").append(" ");
        if (ModelUtil.hasLength((String)tablePartition.getName())) {
            stringBuffer.append(this.m_prov.getExternalName(tablePartition.getName()));
        }
        if (tablePartition.getValues() != null) {
            stringBuffer.append(" ").append(this.createTablePartitionValues("VALUES", tablePartition.getValues()));
        }
        stringBuffer.append(NL).append(this.createPartitioningStorageClause(tablePartition, "  "));
        return stringBuffer.append("UPDATE").append(" ").append("INDEXES");
    }

    private void alterIndexOrganizedTableProperties(Ddl ddl, Table table, ResultSet resultSet) {
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(PROPERTYNAME_ORACLEIOTPROPERTIES);
        if (resultSet2 != null) {
            ResultSet resultSet3;
            ResultSet resultSet4;
            StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE).append(this.getSchemaDotName(table));
            Map map = resultSet2.getModifiedObjectMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (map.containsKey(PROPERTYNAME_OVERFLOWABLE) && "true".equals((resultSet4 = (ResultSet)map.get(PROPERTYNAME_OVERFLOWABLE)).getBVal())) {
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer).append(" ").append("ADD").append(" ").append("OVERFLOW");
                arrayList.add(stringBuffer2.toString());
            }
            String string = null;
            if (map.containsKey(PROPERTYNAME_OVERFLOW_PROPERTIES) && (resultSet3 = (ResultSet)map.get(PROPERTYNAME_OVERFLOW_PROPERTIES)) != null) {
                StringBuffer stringBuffer3 = new StringBuffer(stringBuffer).append(" ").append("OVERFLOW");
                int n = stringBuffer3.length();
                Map map2 = resultSet3.getModifiedObjectMap();
                if (map2 != null && map2.size() > 0) {
                    for (ResultSet resultSet5 : map2.values()) {
                        if ("tablespace".equals(resultSet5.getName())) {
                            string = resultSet5.getBVal();
                            continue;
                        }
                        if (PROPERTYNAME_PCTFREE.equals(resultSet5.getName())) {
                            stringBuffer3.append(" ").append("PCTFREE").append(" ").append(resultSet5.getBVal());
                            continue;
                        }
                        if (PROPERTYNAME_INITRANS.equals(resultSet5.getName())) {
                            stringBuffer3.append(" ").append("INITRANS").append(" ").append(resultSet5.getBVal());
                            continue;
                        }
                        if (PROPERTYNAME_LOGGING.equals(resultSet5.getName())) {
                            if ("false".equals(resultSet5.getBVal())) {
                                stringBuffer3.append(" ").append("NO").append("LOGGING");
                                continue;
                            }
                            stringBuffer3.append(" ").append("LOGGING");
                            continue;
                        }
                        if (!PROPERTYNAME_BUFFER_MODE.equals(resultSet5.getName())) continue;
                        stringBuffer3.append(this.getBufferPool(resultSet5.getBVal()));
                    }
                } else {
                    OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)resultSet3.a();
                    OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties2 = (OracleIndexOrganizedTableProperties)resultSet3.b();
                    if (oracleIndexOrganizedTableProperties != null && oracleIndexOrganizedTableProperties2 != null && oracleIndexOrganizedTableProperties.getOverflowProperties() == null && oracleIndexOrganizedTableProperties2.getOverflowProperties() != null) {
                        OracleStorageProperties oracleStorageProperties = oracleIndexOrganizedTableProperties2.getOverflowProperties();
                        string = oracleStorageProperties.getTablespace();
                        if (oracleStorageProperties.getPercentFree() != null) {
                            stringBuffer3.append(" ").append("PCTFREE").append(" ").append(oracleStorageProperties.getPercentFree());
                        }
                        if (oracleStorageProperties.getInitrans() != null) {
                            stringBuffer3.append(" ").append("INITRANS").append(" ").append(oracleStorageProperties.getInitrans());
                        }
                        if (oracleStorageProperties.getLogging() != null) {
                            if (!oracleStorageProperties.getLogging().booleanValue()) {
                                stringBuffer3.append(" ").append("NO").append("LOGGING");
                            } else {
                                stringBuffer3.append(" ").append("LOGGING");
                            }
                        }
                        stringBuffer3.append(this.getBufferPool(String.valueOf(oracleStorageProperties.getBufferMode())));
                    }
                }
                if (stringBuffer3.length() != n) {
                    arrayList.add(stringBuffer3.toString());
                }
            }
            if (map.containsKey(PROPERTYNAME_PCT_THRESHOLD) || map.containsKey(PROPERTYNAME_INCLUDE_COLUMN)) {
                StringBuffer stringBuffer4;
                block39: {
                    stringBuffer4 = new StringBuffer(stringBuffer);
                    ResultSet resultSet6 = (ResultSet)map.get(PROPERTYNAME_PCT_THRESHOLD);
                    if (resultSet6 != null) {
                        String string2 = ModelUtil.hasLength((String)resultSet6.getBVal()) ? resultSet6.getBVal() : DEFAULT_PCT_THRESHOLD;
                        stringBuffer4.append(" ").append("PCTTHRESHOLD").append(" ").append(string2);
                    }
                    try {
                        resultSet6 = (ResultSet)map.get(PROPERTYNAME_INCLUDE_COLUMN);
                        if (resultSet6 != null) {
                            String string3;
                            OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)resultSet6.b();
                            if (!$assertionsDisabled && oracleIndexOrganizedTableProperties == null) {
                                throw new AssertionError();
                            }
                            DBObjectID dBObjectID = oracleIndexOrganizedTableProperties != null ? oracleIndexOrganizedTableProperties.getIncludeColumn() : null;
                            DBObject dBObject = dBObjectID != null ? dBObjectID.resolveID() : null;
                            String string4 = string3 = dBObject != null ? dBObject.getName() : null;
                            if (ModelUtil.hasLength((String)string3)) {
                                stringBuffer4.append(" ").append("INCLUDING").append(" ").append(string3);
                            }
                        }
                    }
                    catch (DBException dBException) {
                        if ($assertionsDisabled) break block39;
                        throw new AssertionError();
                    }
                }
                if (stringBuffer4.length() != stringBuffer.length()) {
                    arrayList.add(stringBuffer4.toString());
                }
            }
            if (ModelUtil.hasLength(string) || map.containsKey(PROPERTYNAME_MAPPED) || map.containsKey(PROPERTYNAME_KEY_COMPRESSION)) {
                StringBuffer stringBuffer5 = new StringBuffer(stringBuffer).append(" ").append("MOVE");
                int n = stringBuffer5.length();
                ResultSet resultSet7 = (ResultSet)map.get(PROPERTYNAME_MAPPED);
                if (resultSet7 != null) {
                    if ("false".equals(resultSet7.getBVal())) {
                        stringBuffer5.append(" ").append("NO").append("MAPPING");
                    } else {
                        stringBuffer5.append(" ").append("MAPPING").append(" ").append("TABLE");
                    }
                }
                if ((resultSet7 = (ResultSet)map.get(PROPERTYNAME_KEY_COMPRESSION)) != null) {
                    if (ModelUtil.hasLength((String)resultSet7.getBVal())) {
                        Integer n2 = null;
                        try {
                            n2 = new Integer(resultSet7.getBVal());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        stringBuffer5.append(" ").append("COMPRESS");
                        if (n2 != null && n2 > 0) {
                            stringBuffer5.append(" ").append(resultSet7.getBVal());
                        }
                    } else {
                        stringBuffer5.append(" ").append("NO").append("COMPRESS");
                    }
                }
                if (ModelUtil.hasLength(string)) {
                    stringBuffer5.append(" ").append("OVERFLOW").append(" ").append("TABLESPACE").append(" ").append(string);
                }
                if (stringBuffer5.length() != n) {
                    arrayList.add(stringBuffer5.toString());
                }
            }
            if (arrayList.size() > 0) {
                ddl.put("IOT", arrayList);
            }
        }
    }

    private StringBuffer getBufferPool(String string) {
        String string2;
        Integer n;
        StringBuffer stringBuffer = new StringBuffer();
        Integer n2 = n = string != null ? new Integer(string) : null;
        String string3 = n == null || n == 0 ? "DEFAULT" : (n == 1 ? "KEEP" : (string2 = n == 2 ? "RECYCLE" : null));
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (string2 != null) {
            stringBuffer.append(" ").append("STORAGE").append("(").append("BUFFER_POOL").append(" ").append(string2).append(")");
        }
        return stringBuffer;
    }

    private void alterExternalTableProperties(Ddl ddl, Table table, ResultSet resultSet) {
        block28: {
            try {
                ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(PROPERTYNAME_ORACLEEXTERNALTABLEPROPERTIES);
                if (resultSet2 != null) {
                    StringBuffer stringBuffer = new StringBuffer(ALTER_TABLE);
                    stringBuffer.append(this.getSchemaDotName(table)).append(NL);
                    Iterator iterator = resultSet2.getModifiedObjectMap().values().iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        boolean bl2 = true;
                        ResultSet resultSet3 = (ResultSet)iterator.next();
                        if (PROPERTYNAME_REJECTLIMIT.equals(resultSet3.getName())) {
                            String string = resultSet3.getBVal();
                            stringBuffer.append("REJECT LIMIT").append(" ").append(string);
                            stringBuffer.append(NL);
                        } else if (PROPERTYNAME_ACCESSPARAMETERS.equals(resultSet3.getName())) {
                            String string = resultSet3.getBVal();
                            stringBuffer.append("ACCESS PARAMETERS");
                            stringBuffer.append(NL);
                            stringBuffer.append(string);
                            stringBuffer.append(NL);
                        } else if (PROPERTYNAME_DEFAULT_DIRECTORY.equals(resultSet3.getName())) {
                            OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)resultSet3.b();
                            if (!$assertionsDisabled && oracleExternalTableProperties == null) {
                                throw new AssertionError();
                            }
                            if (oracleExternalTableProperties != null) {
                                String string;
                                DBObject dBObject;
                                DBObjectID dBObjectID = oracleExternalTableProperties.getDefaultDirectory();
                                if (!$assertionsDisabled && dBObjectID == null) {
                                    throw new AssertionError();
                                }
                                DBObject dBObject2 = dBObject = dBObjectID == null ? null : dBObjectID.resolveID();
                                if (!$assertionsDisabled && dBObject == null) {
                                    throw new AssertionError();
                                }
                                String string2 = string = dBObject == null ? null : dBObject.getName();
                                if (!$assertionsDisabled && string == null) {
                                    throw new AssertionError();
                                }
                                if (string != null) {
                                    stringBuffer.append("DEFAULT").append(" ").append("DIRECTORY").append(" ").append(string).append(NL);
                                }
                            }
                        } else if (PROPERTYNAME_LOCATIONSPECIFIERS.equals(resultSet3.getName())) {
                            boolean bl3 = true;
                            StringBuffer stringBuffer2 = new StringBuffer("LOCATION(");
                            for (ResultSet resultSet4 : resultSet3.getBonlyList()) {
                                String string;
                                DBObject dBObject;
                                Map map = resultSet4.getBonlyMap();
                                ResultSet resultSet5 = (ResultSet)map.get(PROPERTYNAME_DIRECTORY);
                                OracleExternalTableProperties.LocationSpecifier locationSpecifier = (OracleExternalTableProperties.LocationSpecifier)resultSet5.b();
                                if (!$assertionsDisabled && locationSpecifier == null) {
                                    throw new AssertionError();
                                }
                                if (locationSpecifier == null) continue;
                                DBObjectID dBObjectID = locationSpecifier.getDirectory();
                                if (!$assertionsDisabled && dBObjectID == null) {
                                    throw new AssertionError();
                                }
                                DBObject dBObject3 = dBObject = dBObjectID == null ? null : dBObjectID.resolveID();
                                if (!$assertionsDisabled && dBObject == null) {
                                    throw new AssertionError();
                                }
                                String string3 = string = dBObject == null ? null : dBObject.getName();
                                if (!$assertionsDisabled && string == null) {
                                    throw new AssertionError();
                                }
                                String string4 = locationSpecifier.getSpecifier();
                                if (!$assertionsDisabled && !ModelUtil.hasLength((String)string4)) {
                                    throw new AssertionError();
                                }
                                if (bl3) {
                                    bl3 = false;
                                } else {
                                    stringBuffer2.append(",");
                                }
                                stringBuffer2.append(" ");
                                if (ModelUtil.hasLength((String)string)) {
                                    stringBuffer2.append(string).append(":");
                                }
                                stringBuffer2.append("'").append(string4).append("'");
                            }
                            stringBuffer2.append(")").append(NL);
                            stringBuffer.append(stringBuffer2);
                        } else {
                            bl2 = false;
                        }
                        bl |= bl2;
                    }
                    if (bl) {
                        ddl.put("OET", stringBuffer.toString());
                    }
                }
            }
            catch (DBException dBException) {
                if ($assertionsDisabled) break block28;
                throw new AssertionError();
            }
        }
    }

    private HashMap getAttributes(ResultSet resultSet, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = resultSet.getAllObjectsMap();
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ResultSet resultSet2 = (ResultSet)map.get(iterator.next());
            if (!bl && resultSet2.isSame()) continue;
            hashMap.put(resultSet2.getName(), resultSet2.getBVal());
        }
        return hashMap;
    }

    private String getDataTypeDDL(HashMap hashMap) {
        return (String)hashMap.get(DATATYPEUSAGE);
    }

    private String addColumn(ResultSet resultSet, HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ADD (");
        stringBuffer.append("\"" + resultSet.getName() + "\"" + " ");
        stringBuffer.append(this.getDataTypeDDL(hashMap));
        if (hashMap.containsKey(DEFAULT_DIFF)) {
            stringBuffer.append(this.getDefault(resultSet, (String)hashMap.get(DEFAULT_DIFF)));
        }
        if (hashMap.containsKey(ISNOTNULL) && hashMap.get(ISNOTNULL).equals("true")) {
            stringBuffer.append(" NOT NULL");
        }
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }

    private String getQuotedName(ResultSet resultSet) {
        return "\"" + resultSet.getName() + "\"";
    }

    protected String getQuotedOnlineName(ResultSet resultSet) {
        Map map = resultSet.getAllObjectsMap();
        ResultSet resultSet2 = (ResultSet)map.get(PROPERTYNAME_NAME);
        String string = resultSet2.getAVal();
        return "\"" + string + "\"";
    }

    private String modifyColumn(ResultSet resultSet, HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        if (resultSet.isModified()) {
            Map map = resultSet.getModifiedObjectMap();
            stringBuffer.append("MODIFY").append(" ").append("(");
            stringBuffer.append(this.getQuotedName(resultSet));
            if (map.containsKey(DATATYPEUSAGE)) {
                stringBuffer.append(" ");
                stringBuffer.append(this.getDataTypeDDL(hashMap));
            }
            if (map.containsKey(DEFAULT_DIFF)) {
                stringBuffer.append(this.getDefault(resultSet, (String)hashMap.get(DEFAULT_DIFF)));
            }
            if (map.containsKey(ISNOTNULL) && hashMap.containsKey(ISNOTNULL)) {
                if (Boolean.toString(true).equals(hashMap.get(ISNOTNULL))) {
                    stringBuffer.append(" ").append("NOT");
                }
                stringBuffer.append(" ").append("NULL");
            }
            stringBuffer.append(")").append("\n");
        }
        return stringBuffer.toString();
    }

    private String getDefault(ResultSet resultSet, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(DEFAULT_DIFF);
        if (ModelUtil.hasLength((String)string)) {
            ResultSet resultSet3 = (ResultSet)resultSet.getAllObjectsMap().get(DATATYPEUSAGE);
            stringBuffer.append(" ").append("DEFAULT").append(" ").append(string);
        } else if (ModelUtil.hasLength((String)resultSet2.getAVal())) {
            stringBuffer.append(" ").append("DEFAULT").append(" ").append("NULL");
        }
        return stringBuffer.toString();
    }

    private String dropColumn(ResultSet resultSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP COLUMN ");
        stringBuffer.append(this.getQuotedOnlineName(resultSet));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String addConstraint(Relation relation, ResultSet resultSet) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap = this.getAttributes(resultSet, true);
        stringBuffer.append("ADD ");
        this.appendConstraintName(stringBuffer, resultSet.getName());
        stringBuffer.append(this.getConsTypeText(resultSet) + " ");
        String string = this.getConstraintType(resultSet);
        if (string.equals("CheckConstraint")) {
            stringBuffer.append("\n").append("(").append("\n");
            String string2 = (String)hashMap.get(PROPERTYNAME_CHECKCONDITION);
            string2 = string2.trim().replace('\n', ' ');
            stringBuffer.append(string2);
            stringBuffer.append("\n").append(")");
        } else {
            stringBuffer.append(this.getColumnList(resultSet, COLUMNS));
            if (string.equals("FKConstraint")) {
                int n;
                String string3 = (String)hashMap.get("ReferencedSchema");
                String string4 = (String)hashMap.get("ReferencedRelation");
                if (string4 != null && string4.length() > 0) {
                    stringBuffer.append(" REFERENCES ");
                    if (string3 != null && string3.length() > 0 && !string3.equals(relation.getSchema().getName())) {
                        stringBuffer.append(string3 + ".");
                    }
                    stringBuffer.append(string4 + " ");
                    stringBuffer.append(this.getColumnList(resultSet, "ReferencedColumn"));
                }
                if ((n = Integer.parseInt((String)hashMap.get(PROPERTYNAME_DELETEMODE))) == 1) {
                    stringBuffer.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("CASCADE");
                } else if (n == 2) {
                    stringBuffer.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("SET").append(" ").append("NULL");
                }
            }
        }
        if (hashMap.containsKey(ISENABLED)) {
            boolean bl = "true".equals(hashMap.get(ISENABLED));
            stringBuffer.append(" ");
            stringBuffer.append(bl ? "ENABLE" : "DISABLE");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String dropConstraint(ResultSet resultSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP CONSTRAINT ");
        stringBuffer.append(this.getQuotedOnlineName(resultSet));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getColumnList(ResultSet resultSet, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n(\n");
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = resultSet2.getBList().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ResultSet resultSet3 = (ResultSet)iterator.next();
            String string2 = resultSet3.getName();
            hashMap.put(String.valueOf(n), string2);
            ++n;
        }
        int n2 = 0;
        while (hashMap.containsKey(String.valueOf(n2))) {
            if (n2 > 0) {
                stringBuffer.append(",").append("\n");
            }
            stringBuffer.append("\"").append((String)hashMap.get(String.valueOf(n2))).append("\"");
            ++n2;
        }
        stringBuffer.append("\n").append(")");
        return stringBuffer.toString();
    }

    private String getConsTypeText(ResultSet resultSet) {
        String string;
        String string2 = null;
        Constraint constraint = (Constraint)resultSet.a();
        if (constraint == null) {
            constraint = (Constraint)resultSet.b();
        }
        if ((string = constraint.getConstraintType()).equals("CheckConstraint")) {
            string2 = "CHECK";
        } else if (string.equals("FKConstraint")) {
            string2 = "FOREIGN KEY";
        } else if (string.equals("PKConstraint")) {
            string2 = "PRIMARY KEY";
        } else if (string.equals("UniqueConstraint")) {
            string2 = "UNIQUE";
        }
        return string2;
    }

    private List getDropped(ResultSet resultSet, String string) {
        Map map;
        ResultSet resultSet2;
        List list = new ArrayList();
        if (this.getNodeType(resultSet).equals("TABLE") && (resultSet2 = (ResultSet)(map = resultSet.getAllObjectsMap()).get(string)) != null) {
            list = resultSet2.getAonlyList();
        }
        return list;
    }

    private boolean isDropped(ResultSet resultSet) {
        return resultSet.inAbutNotB();
    }

    private boolean hasDroppedColumns(ResultSet resultSet) {
        boolean bl = this.getDropped(resultSet, COLUMNS).size() > 0;
        return bl;
    }

    private boolean hasDroppedConstraints(ResultSet resultSet) {
        boolean bl = this.getDropped(resultSet, CONSTRAINTS).size() > 0;
        return bl;
    }

    private List getNew(ResultSet resultSet, String string) {
        Map map;
        ResultSet resultSet2;
        List list = new ArrayList();
        if (resultSet.a() instanceof Table && (resultSet2 = (ResultSet)(map = resultSet.getAllObjectsMap()).get(string)) != null) {
            list = resultSet2.getBonlyList();
        }
        return list;
    }

    private boolean hasAdditionalX(ResultSet resultSet, String string) {
        boolean bl = this.getNew(resultSet, string).size() > 0;
        return bl;
    }

    private boolean hasAdditionalColumns(ResultSet resultSet) {
        return this.hasAdditionalX(resultSet, COLUMNS);
    }

    private boolean hasAdditionalConstraints(ResultSet resultSet) {
        return this.hasAdditionalX(resultSet, CONSTRAINTS);
    }

    private boolean hasColumnComments(ResultSet resultSet) {
        ResultSet resultSet2;
        boolean bl = false;
        if (resultSet.a() instanceof Table && (resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(COLUMNS)) != null) {
            for (ResultSet resultSet3 : resultSet2.getAllObjectsList()) {
                if (!this.isCommentDifferent(resultSet3)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private List getChanged(ResultSet resultSet, String string) {
        ResultSet resultSet2;
        List list = new ArrayList();
        if (resultSet.a() instanceof Table && (resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(string)) != null) {
            list = resultSet2.getModifiedObjectList();
        }
        return list;
    }

    private boolean hasChangedColumn(ResultSet resultSet) {
        boolean bl = this.getChanged(resultSet, COLUMNS).size() > 0;
        return bl;
    }

    private boolean isCommentDifferent(ResultSet resultSet) {
        boolean bl = false;
        Map map = resultSet.getNotSameObjectMap();
        if (map.containsKey("Comment")) {
            bl = true;
        }
        return bl;
    }

    private List getConstraints(ResultSet resultSet) {
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(CONSTRAINTS);
        return resultSet2.getAllObjectsList();
    }

    private List getColumns(ResultSet resultSet) {
        ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(COLUMNS);
        return resultSet2.getAllObjectsList();
    }

    private String getConstraintType(ResultSet resultSet) {
        Constraint constraint = null;
        if (resultSet.a() != null && resultSet.a() instanceof Constraint) {
            constraint = (Constraint)resultSet.a();
        } else if (resultSet.b() != null && resultSet.b() instanceof Constraint) {
            constraint = (Constraint)resultSet.b();
        }
        if (!$assertionsDisabled && constraint == null) {
            throw new AssertionError();
        }
        return constraint.getConstraintType();
    }

    private String getNodeType(ResultSet resultSet) {
        int n;
        Object object = resultSet.a();
        if (object == null) {
            object = resultSet.b();
        }
        String string = null;
        if (object instanceof DBObject) {
            string = ((DBObject)object).getType();
        }
        if ((n = string.lastIndexOf(".")) > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

