/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDDLGenerator;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.ora.OracleDDLAlterTable;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleIndexProperties;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public class OracleDDLGenerator
extends AbstractDDLGenerator
implements DDLGenerator {
    protected boolean m_diagnosticPrint;
    private boolean m_createPrompts;
    private String m_createSpoolingCommands;
    private boolean m_manualReconcile;
    private boolean m_prefixSchemaName;
    protected DBObjectProvider m_prov;
    public static final int UPDATE_UNKNOWN = 0;
    public static final int UPDATE_ALTER = 1;
    public static final int UPDATE_REPLACE = 2;
    private static HashMap s_updateTypeMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String SP = " ";
    protected static final String SP2 = "  ";
    protected static final String SP4 = "    ";
    protected static final String SP6 = "      ";
    protected static final String SP8 = "        ";
    protected static final String DOT = ".";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    protected static final String SLASH = "/";
    protected static final String SINGLEQUOTE = "'";
    protected static final String DQ = "\"";
    protected static final String SQ = "'";
    protected static final String NEWLINE = "\n";
    protected static final String ACCESS_PARAMETERS = "ACCESS PARAMETERS";
    protected static final String ADD = "ADD";
    protected static final String AS = "AS";
    protected static final String AFTER = "AFTER";
    protected static final String ALTER = "ALTER";
    protected static final String AUTHENTICATED = "AUTHENTICATED";
    protected static final String BEFORE = "BEFORE";
    protected static final String BEGIN = "BEGIN";
    protected static final String BITMAP = "BITMAP";
    protected static final String BODY = "BODY";
    protected static final String BY = "BY";
    protected static final String BUFFER_POOL = "BUFFER_POOL";
    protected static final String BUILD = "BUILD";
    protected static final String CACHE = "CACHE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CHECK = "CHECK";
    protected static final String CHUNK = "CHUNK";
    protected static final String CLOB = "CLOB";
    protected static final String COLUMN = "COLUMN";
    protected static final String COMMENT = "COMMENT";
    protected static final String COMMIT = "COMMIT";
    protected static final String COMPLETE = "COMPLETE";
    protected static final String COMPRESS = "COMPRESS";
    protected static final String CONNECT = "CONNECT";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String CONSTRAINTS = "CONSTRAINTS";
    protected static final String CONTEXT = "CONTEXT";
    protected static final String CREATE = "CREATE";
    protected static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    protected static final String CTXSYS = "CTXSYS";
    protected static final String CYCLE = "CYCLE";
    protected static final String CURRENT_USER = "CURRENT_USER";
    protected static final String DATABASE = "DATABASE";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String DELETE = "DELETE";
    protected static final String DEMAND = "DEMAND";
    protected static final String DIRECTORY = "DIRECTORY";
    protected static final String DISABLE = "DISABLE";
    protected static final String DROP = "DROP";
    protected static final String EACH = "EACH";
    protected static final String ENABLE = "ENABLE";
    protected static final String END = "END";
    protected static final String ENFORCED = "ENFORCED";
    protected static final String ENABLE_STORAGE_IN_ROW = "ENABLE STORAGE IN ROW";
    protected static final String EXCLUDING = "EXCLUDING";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String FAST = "FAST";
    protected static final String FOR = "FOR";
    protected static final String FOR_UPDATE = "FOR_UPDATE";
    protected static final String FORCE = "FORCE";
    protected static final String FOREIGN = "FOREIGN";
    protected static final String FLASHBACK = "FLASHBACK";
    protected static final String FREELIST = "FREELIST";
    protected static final String FREELISTS = "FREELISTS";
    protected static final String FREEPOOLS = "FREEPOOLS";
    protected static final String GLOBAL = "GLOBAL";
    protected static final String GRANT = "GRANT";
    protected static final String GROUPS = "GROUPS";
    protected static final String ID = "ID";
    protected static final String IDENTIFIED = "IDENTIFIED";
    protected static final String INCREMENT = "INCREMENT";
    protected static final String IMMEDIATE = "IMMEDIATE";
    protected static final String IN = "IN";
    protected static final String INCLUDING = "INCLUDING";
    protected static final String INDEX = "INDEX";
    protected static final String INDEXES = "INDEXES";
    protected static final String INDEXTYPE = "INDEXTYPE";
    protected static final String INITIAL = "INITIAL";
    protected static final String INITRANS = "INITRANS";
    protected static final String INSERT = "INSERT";
    protected static final String INSTEAD = "INSTEAD";
    protected static final String IS = "IS";
    protected static final String KEEP = "KEEP";
    protected static final String KEY = "KEY";
    protected static final String LINK = "LINK";
    protected static final String LOB = "LOB";
    protected static final String LOCAL = "LOCAL";
    protected static final String LOCATION = "LOCATION";
    protected static final String LOGGING = "LOGGING";
    protected static final String MAPPING = "MAPPING";
    protected static final String MASTER = "MASTER";
    protected static final String MAXEXTENTS = "MAXEXTENTS";
    protected static final String MAXTRANS = "MAXTRANS";
    protected static final String MAXVALUE = "MAXVALUE";
    protected static final String MINEXTENTS = "MINEXTENTS";
    protected static final String MINVALUE = "MINVALUE";
    protected static final String MODIFY = "MODIFY";
    protected static final String MOVE = "MOVE";
    protected static final String MVIEW = "MATERIALIZED VIEW";
    protected static final String MVIEWLOG = "MATERIALIZED VIEW LOG";
    protected static final String NEXT = "NEXT";
    protected static final String NEVER_REFRESH = "NEVER REFRESH";
    protected static final String NEW = "NEW";
    protected static final String NO = "NO";
    protected static final String NOCACHE = "NOCACHE";
    protected static final String NOCYCLE = "NOCYCLE";
    protected static final String NOLOGGING = "NOLOGGING";
    protected static final String NOORDER = "NOORDER";
    protected static final String NOPARALLEL = "NOPARALLEL";
    protected static final String NOT = "NOT";
    protected static final String NULL = "NULL";
    protected static final String OBJECT = "OBJECT";
    protected static final String OF = "OF";
    protected static final String OFF = "OFF";
    protected static final String OLD = "OLD";
    protected static final String ON = "ON";
    protected static final String OR = "OR";
    protected static final String ORDER = "ORDER";
    protected static final String ORGANIZATION = "ORGANIZATION";
    protected static final String OVERFLOW = "OVERFLOW";
    protected static final String PARALLEL = "PARALLEL";
    protected static final String PARTITION = "PARTITION";
    protected static final String PARTITIONS = "PARTITIONS";
    protected static final String PCTFREE = "PCTFREE";
    protected static final String PCTINCREASE = "PCTINCREASE";
    protected static final String PCTTHRESHOLD = "PCTTHRESHOLD";
    protected static final String PCTUSED = "PCTUSED";
    protected static final String PCTVERSION = "PCTVERSION";
    protected static final String PREBUILT = "PREBUILT";
    protected static final String PRESERVE = "PRESERVE";
    protected static final String PRIMARY = "PRIMARY";
    protected static final String PROMPT = "PROMPT";
    protected static final String PUBLIC = "PUBLIC";
    protected static final String PURGE = "PURGE";
    protected static final String QUERY_REWRITE = "QUERY REWRITE";
    protected static final String REBUILD = "REBUILD";
    protected static final String RECYCLE = "RECYCLE";
    protected static final String REDUCED_PRECISION = "REDUCED PRECISION";
    protected static final String RENAME = "RENAME";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String REFRESH = "REFRESH";
    protected static final String REJECT_LIMIT = "REJECT LIMIT";
    protected static final String RETENTION = "RETENTION";
    protected static final String RETURN = "RETURN";
    protected static final String ROLLBACK_SEGMENT = "ROLLBACK SEGMENT";
    protected static final String ROW = "ROW";
    protected static final String ROWID = "ROWID";
    protected static final String ROWS = "ROWS";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String SEQUENCE = "SEQUENCE";
    protected static final String SET = "SET";
    protected static final String SHARED = "SHARED";
    protected static final String SPEC = "SPEC";
    protected static final String SPOOL = "SPOOL";
    protected static final String SQLBLANKLINES = "SQLBLANKLINES";
    protected static final String START = "START";
    protected static final String STORAGE = "STORAGE";
    protected static final String STORE = "STORE";
    protected static final String SUBPARTITION = "SUBPARTITION";
    protected static final String SUBPARTITIONS = "SUBPARTITIONS";
    protected static final String SUBSTITUTABLE_AT_ALL_LEVELS = "SUBSTITUTABLE_AT_ALL_LEVELS";
    protected static final String SYNONYM = "SYNONYM";
    protected static final String TABLE = "TABLE";
    protected static final String TABLESPACE = "TABLESPACE";
    protected static final String TEMPLATE = "TEMPLATE";
    protected static final String TEMPORARY = "TEMPORARY";
    protected static final String TO = "TO";
    protected static final String TO_BEFORE_DROP = "TO BEFORE DROP";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TRUSTED = "TRUSTED";
    protected static final String TYPE = "TYPE";
    protected static final String UPDATE = "UPDATE";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String UNLIMITED = "UNLIMITED";
    protected static final String UNUSABLE = "UNUSABLE";
    protected static final String USER = "USER";
    protected static final String USING = "USING";
    protected static final String VALUES = "VALUES";
    protected static final String VALUES_LESS_THAN = "VALUES LESS THAN";
    protected static final String VARRAY = "VARRAY";
    protected static final String VIEW = "VIEW";
    protected static final String WHEN = "WHEN";
    protected static final String WITH = "WITH";
    protected static final String WITHOUT = "WITHOUT";
    protected static final String YES = "YES";

    void $init$() {
        this.m_diagnosticPrint = false;
        this.m_createPrompts = false;
    }

    public OracleDDLGenerator(DBObjectProvider dBObjectProvider) {
        this.$init$();
        this.m_prov = dBObjectProvider;
    }

    public Ddl getCreateDDL(SchemaObject schemaObject, boolean bl, boolean bl2) {
        return this.getCreateDDL(new SchemaObject[]{schemaObject}, bl, bl2);
    }

    public Ddl getCreateDDL(SchemaObject[] schemaObjectArray, boolean bl, boolean bl2) {
        Ddl ddl = new Ddl();
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject schemaObject = schemaObjectArray[n];
            if (schemaObject != null) {
                String string = schemaObject.getType();
                if (bl) {
                    try {
                        SchemaObject schemaObject2 = this.m_prov.getObject(string, schemaObject.getSchema(), schemaObject.getName());
                        if (schemaObject2 != null && VIEW != string && SYNONYM != string && !(schemaObject instanceof SourceObject)) {
                            ddl.append(this.getDeleteDDL(schemaObject2, bl2));
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                if (INDEX.equals(string)) {
                    ddl.append(this.createIndex((Index)schemaObject));
                } else if (SEQUENCE.equals(string)) {
                    ddl.append(this.createSequence((Sequence)schemaObject));
                } else if (SYNONYM.equals(string)) {
                    ddl.append(this.createSynonym((Synonym)schemaObject, bl));
                } else if (TABLE.equals(string)) {
                    ddl.append(this.createTable((Table)schemaObject));
                } else if (TRIGGER.equals(string)) {
                    ddl.append(this.createTrigger((Trigger)schemaObject));
                } else if (VIEW.equals(string)) {
                    ddl.append(this.createView((View)schemaObject, bl));
                } else if (MVIEW.equals(string)) {
                    ddl.append(this.createMaterializedView((MaterializedView)schemaObject, bl));
                } else if (MVIEWLOG.equals(string)) {
                    ddl.append(this.createMaterializedViewLog((MaterializedViewLog)schemaObject, bl));
                } else if ("DATABASE LINK".equals(string)) {
                    ddl.append(this.createDatabaseLink((DatabaseLink)schemaObject));
                } else if (schemaObject instanceof SourceObject) {
                    if (!(!(schemaObject instanceof SpecPlSql) || schemaObject instanceof ComplexType && "COLLECTION".equals(((ComplexType)schemaObject).getTypeCode()))) {
                        ddl.append(this.createSpecAndBody((SpecPlSql)schemaObject, bl));
                    } else {
                        ddl.append(this.createSourceObject((SourceObject)schemaObject, bl));
                    }
                }
            }
            ++n;
        }
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public Ddl getDeleteDDL(SchemaObject schemaObject, boolean bl) {
        return this.getDeleteDDL(new SchemaObject[]{schemaObject}, bl);
    }

    public Ddl getDeleteDDL(SchemaObject[] schemaObjectArray, boolean bl) {
        Ddl ddl = new Ddl();
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject schemaObject = schemaObjectArray[n];
            String string = schemaObject.getType();
            if (MVIEWLOG.equals(string)) {
                ddl.append(this.dropMViewLog((MaterializedViewLog)schemaObject));
            } else if (TYPE.equals(string)) {
                ddl.append(this.dropType((ObjectType)schemaObject, bl));
            } else if (SYNONYM.equals(string)) {
                ddl.append(this.dropSynonym((Synonym)schemaObject));
            } else if ("DATABASE LINK".equals(string)) {
                ddl.append(this.dropDatabaseLink((DatabaseLink)schemaObject));
            } else if (TABLE.equals(string) || VIEW.equals(string)) {
                ddl.append(this.dropRelation((Relation)schemaObject, bl));
            } else if ("RECYCLEBIN".equals(string)) {
                ddl.append(this.purgeRecycledObject((RecycledObject)schemaObject));
            } else if ("FUNCTION".equals(string) || MVIEW.equals(string) || "PACKAGE".equals(string) || "PROCEDURE".equals(string) || SEQUENCE.equals(string) || TRIGGER.equals(string) || INDEX.equals(string)) {
                ddl.append(this.dropBasicObject(schemaObject));
            }
            ++n;
        }
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public Ddl[] getUpdateDDL(SchemaObject schemaObject, SchemaObject schemaObject2) {
        return this.getUpdateDDL(new SchemaObject[]{schemaObject}, new SchemaObject[]{schemaObject2});
    }

    public Ddl[] getUpdateDDL(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) {
        DiffEngine diffEngine;
        DiffContext diffContext;
        ResultSet resultSet;
        ArrayList<Ddl> arrayList = new ArrayList<Ddl>();
        ArrayList<SchemaObject> arrayList2 = new ArrayList<SchemaObject>();
        ArrayList<SchemaObject> arrayList3 = new ArrayList<SchemaObject>();
        int n = 0;
        while (n < schemaObjectArray.length) {
            if (schemaObjectArray2[n] instanceof View) {
                arrayList.add(this.createView((View)schemaObjectArray2[n], true));
            } else if (schemaObjectArray2[n] instanceof MaterializedViewLog) {
                arrayList.add(this.createMaterializedViewLog((MaterializedViewLog)schemaObjectArray2[n], true));
            } else if (schemaObjectArray2[n] instanceof Synonym) {
                arrayList.add(this.createSynonym((Synonym)schemaObjectArray2[n], true));
            } else if (schemaObjectArray2[n] instanceof SpecPlSql) {
                arrayList.add(this.createSpecAndBody((SpecPlSql)schemaObjectArray2[n], true));
            } else if (schemaObjectArray2[n] instanceof SourceObject) {
                arrayList.add(this.createSourceObject((SourceObject)schemaObjectArray2[n], true));
            } else if (schemaObjectArray2[n] != null) {
                arrayList2.add(schemaObjectArray[n]);
                arrayList3.add(schemaObjectArray2[n]);
            }
            ++n;
        }
        if (arrayList2.size() > 0 && !(resultSet = (diffContext = (diffEngine = ReconcileHelper.getDiffEngine()).diff(arrayList2.toArray(), arrayList3.toArray())).getResult()).isSame()) {
            Ddl[] ddlArray = this.getUpdateDDL(resultSet);
            arrayList.addAll(Arrays.asList(ddlArray));
        }
        Ddl[] ddlArray = new Ddl[]{};
        return arrayList.toArray(ddlArray);
    }

    static {
        $assertionsDisabled = OracleDDLGenerator.class.desiredAssertionStatus() ^ true;
        s_updateTypeMap = null;
    }

    private int getUpdateAction(Class clazz) {
        if (s_updateTypeMap == null) {
            s_updateTypeMap = new HashMap();
            s_updateTypeMap.put(Sequence.class, new Integer(1));
            s_updateTypeMap.put(Table.class, new Integer(1));
            s_updateTypeMap.put(MaterializedView.class, new Integer(1));
        }
        int n = 2;
        if (s_updateTypeMap.containsKey(clazz)) {
            n = (Integer)s_updateTypeMap.get(clazz);
        }
        return n;
    }

    public Ddl[] getUpdateDDL(ResultSet resultSet) {
        ArrayList<Ddl> arrayList = new ArrayList<Ddl>();
        if (!resultSet.isSame()) {
            ArrayList<ResultSet> arrayList2 = null;
            if ("LIST".equals(resultSet.getType())) {
                arrayList2 = resultSet.getAllObjectsList();
            } else {
                if (!$assertionsDisabled && !"MAP".equals(resultSet.getType())) {
                    throw new AssertionError();
                }
                arrayList2 = new ArrayList<ResultSet>();
                arrayList2.add(resultSet);
            }
            OracleDDLAlterTable oracleDDLAlterTable = this.createOracleDDLAlterTable(resultSet);
            for (ResultSet resultSet2 : arrayList2) {
                if (resultSet2.isSame()) continue;
                int n = this.getUpdateAction(resultSet2.getResultSetClass());
                if (resultSet2.a() == null || 2 == n) {
                    arrayList.add(this.getCreateDDL((SchemaObject)resultSet2.b(), 2 == n, false));
                    continue;
                }
                if (resultSet2.b() == null) {
                    arrayList.add(this.getDeleteDDL((SchemaObject)resultSet2.a(), false));
                    continue;
                }
                if (1 != n) continue;
                arrayList.add(oracleDDLAlterTable.getAlterStatement((SchemaObject)resultSet2.a(), resultSet2));
            }
        }
        arrayList.add(this.generateSpoolCommands());
        Ddl[] ddlArray = new Ddl[]{};
        return arrayList.toArray(ddlArray);
    }

    protected OracleDDLAlterTable createOracleDDLAlterTable(ResultSet resultSet) {
        return new OracleDDLAlterTable(this.m_prov, resultSet);
    }

    public Ddl getCreateDDL(Schema schema) {
        Iterator iterator;
        String string = new StringBuffer().append(this.m_prov.getExternalName(schema.getName())).toString();
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE, USER, string);
        stringBuffer.append(CREATE).append(SP).append(USER).append(SP);
        stringBuffer.append(string);
        stringBuffer.append(SP).append(IDENTIFIED).append(SP).append(BY).append(SP);
        stringBuffer.append(schema.getProperty("PASSWORD"));
        OracleSchemaProperties oracleSchemaProperties = (OracleSchemaProperties)schema.getProperty("OracleSchemaProperties");
        if (oracleSchemaProperties != null) {
            String string2 = oracleSchemaProperties.getDefaultTablespace();
            if (ModelUtil.hasLength((String)string2)) {
                stringBuffer.append(SP).append(DEFAULT).append(SP).append(TABLESPACE).append(SP);
                stringBuffer.append(string2);
            }
            if (ModelUtil.hasLength((String)(string2 = oracleSchemaProperties.getTemporaryTablespace()))) {
                stringBuffer.append(SP).append(TEMPORARY).append(SP).append(TABLESPACE).append(SP);
                stringBuffer.append(string2);
            }
        }
        Ddl ddl = new Ddl();
        ddl.put(SCHEMA, stringBuffer.toString());
        Set set = (Set)schema.getProperty("USER PRIVS");
        if (set != null && (iterator = set.iterator()).hasNext()) {
            stringBuffer.setLength(0);
            stringBuffer.append(GRANT).append(SP);
            stringBuffer.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(COMMA).append(SP).append(iterator.next());
            }
            stringBuffer.append(SP).append(TO).append(SP).append(string);
            ddl.put(GRANT, stringBuffer.toString());
        }
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public Ddl getDeleteDDL(Schema schema, boolean bl) {
        String string = new StringBuffer().append(this.m_prov.getExternalName(schema.getName())).toString();
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, USER, string);
        stringBuffer.append(DROP).append(SP).append(USER).append(SP);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(SP).append(CASCADE);
        }
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        ddl.append(this.generateSpoolCommands());
        return ddl;
    }

    public void setCreatePrompts(boolean bl) {
        this.m_createPrompts = bl;
    }

    public void setSpooling(String string) {
        this.m_createSpoolingCommands = string;
    }

    public void setPrefixSchemaName(boolean bl) {
        this.m_prefixSchemaName = bl;
    }

    public boolean hasCreatePrompts() {
        return this.m_createPrompts;
    }

    protected String getSchemaDotName(DBObject dBObject) {
        return this.getSchemaDotName(DBUtil.getSchema(dBObject), dBObject.getName());
    }

    protected String getSchemaDotName(Schema schema, String string) {
        return this.getSchemaDotName(AbstractDBObjectProvider.convertObject(schema), string);
    }

    private String getSchemaDotName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Schema schema = null;
        if (this.m_prov instanceof OracleDatabaseImpl) {
            try {
                schema = this.m_prov.getDefaultSchema();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.getSchemaDotName(string, string2, schema);
    }

    private String getSchemaDotName(String string, String string2, Schema schema) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_prefixSchemaName || schema != null && ModelUtil.hasLength((String)string) && ModelUtil.areDifferent((Object)schema.getName(), (Object)string)) {
            stringBuffer.append(this.m_prov.getExternalName(string)).append(DOT);
        }
        stringBuffer.append(this.m_prov.getExternalName(string2));
        return stringBuffer.toString();
    }

    private String integerAsKorM(Integer n) {
        int n2 = n;
        String string = new String("");
        if (n2 >= 1024 && n2 % 1024 == 0) {
            string = "K";
            if ((n2 /= 1024) % 1024 == 0) {
                n2 /= 1024;
                string = "M";
            }
        }
        return Integer.toString(n2) + string;
    }

    private String createOracleStorageClause(OracleStorageProperties oracleStorageProperties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (oracleStorageProperties != null) {
            int n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Integer n6;
            Integer n7;
            StringBuffer stringBuffer2 = new StringBuffer();
            String string2 = string + SP2;
            Integer n8 = oracleStorageProperties.getInitialExtent();
            if (n8 != null) {
                stringBuffer2.append(string2).append(INITIAL).append(SP).append(this.integerAsKorM(n8)).append(NEWLINE);
            }
            if ((n7 = oracleStorageProperties.getNextExtent()) != null) {
                stringBuffer2.append(string2).append(NEXT).append(SP).append(this.integerAsKorM(n7)).append(NEWLINE);
            }
            if ((n6 = oracleStorageProperties.getMinExtent()) != null) {
                stringBuffer2.append(string2).append(MINEXTENTS).append(SP).append(n6.toString()).append(NEWLINE);
            }
            if ((n5 = oracleStorageProperties.getMaxExtent()) != null) {
                stringBuffer2.append(string2).append(MAXEXTENTS).append(SP + (n5 == Integer.MAX_VALUE ? UNLIMITED : n5.toString())).append(NEWLINE);
            }
            if ((n4 = oracleStorageProperties.getPercentIncrease()) != null) {
                stringBuffer2.append(string2).append(PCTINCREASE).append(SP).append(n4.toString()).append(NEWLINE);
            }
            if ((n3 = oracleStorageProperties.getFreelists()) != null) {
                stringBuffer2.append(string2).append(FREELISTS).append(SP).append(n3.toString()).append(NEWLINE);
            }
            if ((n2 = oracleStorageProperties.getFreelistGroups()) != null) {
                stringBuffer2.append(string2).append(FREELIST).append(SP).append(GROUPS).append(SP).append(n2.toString()).append(NEWLINE);
            }
            if ((n = oracleStorageProperties.getBufferMode()) != 0) {
                stringBuffer2.append(string2).append(BUFFER_POOL).append(SP);
                if (n == 1) {
                    stringBuffer2.append(KEEP);
                } else if (n == 2) {
                    stringBuffer2.append(RECYCLE);
                }
                stringBuffer2.append(NEWLINE);
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(string).append(STORAGE).append(NEWLINE).append(string).append(LPAREN).append(NEWLINE).append(stringBuffer2).append(string).append(RPAREN).append(NEWLINE);
            }
        }
        return stringBuffer.toString();
    }

    private String createOracleTableProperties(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = table.getProperty("TableType");
        if (Table.TableType.TRANSACTION_TEMP == object) {
            stringBuffer.append(ON).append(SP).append(COMMIT).append(SP).append(DELETE).append(SP).append(ROWS).append(NEWLINE);
        } else if (Table.TableType.SESSION_TEMP == object) {
            stringBuffer.append(ON).append(SP).append(COMMIT).append(SP).append(PRESERVE).append(SP).append(ROWS).append(NEWLINE);
        } else if (Table.TableType.INDEX_ORGANIZED == object) {
            stringBuffer.append(this.createIotProperties(table));
        } else if (Table.TableType.EXTERNAL == object) {
            stringBuffer.append(this.createExternalTableProperties(table));
        } else {
            OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
            if (oracleStorageProperties != null) {
                stringBuffer.append(this.createOracleStorageProperties(oracleStorageProperties, SP2));
            }
        }
        return stringBuffer.toString();
    }

    private StringBuffer createOracleTablePartitions(OracleTablePartitions oracleTablePartitions) {
        StringBuffer stringBuffer = new StringBuffer();
        if (oracleTablePartitions != null) {
            DBObjectID[] dBObjectIDArray = oracleTablePartitions.getPartitionColumns();
            TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
            OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
            if (oracleTablePartitions.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && dBObjectIDArray.length > 0 && partitionType != null) {
                stringBuffer.append(PARTITION).append(SP).append(BY).append(SP).append((Object)partitionType).append(this.createColumnNameList(dBObjectIDArray)).append(NEWLINE);
                OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
                if (oracleTablePartitions2 != null) {
                    stringBuffer.append(this.createOracleTableSubpartitions(oracleTablePartitions2));
                }
                if (partitionType == OracleTablePartitions.PartitionType.HASH && oracleTablePartitions.getHashQuantity() != null) {
                    stringBuffer.append(this.createTableHashPartitionsByQuantity(oracleTablePartitions));
                } else {
                    boolean bl = true;
                    TablePartition[] tablePartitionArray2 = tablePartitionArray;
                    int n = 0;
                    while (n < tablePartitionArray2.length) {
                        TablePartition tablePartition = tablePartitionArray2[n];
                        if (!$assertionsDisabled && tablePartition == null) {
                            throw new AssertionError();
                        }
                        if (tablePartition != null) {
                            if (bl) {
                                stringBuffer.append(LPAREN).append(NEWLINE).append(SP2);
                                bl = false;
                            } else {
                                stringBuffer.append(COMMA).append(SP);
                            }
                            stringBuffer.append(PARTITION).append(SP);
                            if (ModelUtil.hasLength((String)tablePartition.getName())) {
                                stringBuffer.append(this.m_prov.getExternalName(tablePartition.getName())).append(SP);
                            }
                            if (partitionType == OracleTablePartitions.PartitionType.HASH) {
                                stringBuffer.append(NEWLINE).append(this.createPartitioningStorageClause(tablePartition, SP4));
                            } else if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                                stringBuffer.append(this.createTableListPartition(tablePartition));
                            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
                                stringBuffer.append(this.createTableRangePartition(tablePartition));
                            }
                        }
                        ++n;
                    }
                    if (!bl) {
                        stringBuffer.append(RPAREN).append(NEWLINE);
                    }
                }
            } else {
                stringBuffer.append(PARTITION).append(SP).append(BY).append(SP).append((Object)partitionType).append(this.createColumnNameList(dBObjectIDArray)).append(NEWLINE);
            }
        }
        return stringBuffer;
    }

    protected StringBuffer createPartitioningStorageClause(TablePartition tablePartition, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tablePartition != null) {
            OracleStorageProperties oracleStorageProperties = tablePartition.getSegmentAttributes();
            if (oracleStorageProperties != null && ModelUtil.hasLength((String)oracleStorageProperties.getTablespace())) {
                stringBuffer.append(string).append(TABLESPACE).append(SP).append(this.m_prov.getExternalName(oracleStorageProperties.getTablespace())).append(NEWLINE);
            }
            LOBDescriptor[] lOBDescriptorArray = tablePartition.getLOBDescriptors();
            int n = 0;
            while (n < lOBDescriptorArray.length) {
                String string2;
                DBObjectID[] dBObjectIDArray = lOBDescriptorArray[n].getColumns();
                String string3 = lOBDescriptorArray[n].getLOBSegName();
                OracleStorageProperties oracleStorageProperties2 = lOBDescriptorArray[n].getStorage();
                String string4 = string2 = oracleStorageProperties2 != null ? oracleStorageProperties2.getTablespace() : null;
                if (dBObjectIDArray.length > 0 && dBObjectIDArray[0] != null) {
                    if (LOBDescriptor.isLOBColumn(dBObjectIDArray[0])) {
                        if (ModelUtil.hasLength((String)string3) || ModelUtil.hasLength((String)string2)) {
                            stringBuffer.append(string).append(LOB).append(this.createColumnNameList(dBObjectIDArray)).append(SP).append(STORE).append(SP).append(AS).append(SP);
                            if (ModelUtil.hasLength((String)string3)) {
                                stringBuffer.append(string3);
                            }
                            if (ModelUtil.hasLength((String)string2)) {
                                stringBuffer.append(LPAREN).append(TABLESPACE).append(SP).append(this.m_prov.getExternalName(string2)).append(RPAREN);
                            }
                        } else if (!($assertionsDisabled || ModelUtil.hasLength((String)string3) || ModelUtil.hasLength((String)string2))) {
                            throw new AssertionError();
                        }
                    } else if (ModelUtil.hasLength((String)string3)) {
                        try {
                            stringBuffer.append(string).append(VARRAY).append(SP).append(this.m_prov.getExternalName(dBObjectIDArray[0].resolveID().getName())).append(SP).append(STORE).append(SP).append(AS).append(SP).append(LOB).append(SP).append(string3);
                        }
                        catch (DBException dBException) {
                            DBUtil.logStackTrace(dBException);
                        }
                    } else if (!$assertionsDisabled && !ModelUtil.hasLength((String)string3)) {
                        throw new AssertionError();
                    }
                } else if (!($assertionsDisabled || dBObjectIDArray.length > 0 && dBObjectIDArray[0] != null)) {
                    throw new AssertionError();
                }
                stringBuffer.append(NEWLINE);
                ++n;
            }
        }
        return stringBuffer;
    }

    protected StringBuffer createTableRangePartition(TablePartition tablePartition) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = tablePartition.getValues();
        if (!$assertionsDisabled && objectArray.length <= 0) {
            throw new AssertionError();
        }
        if (objectArray.length > 0) {
            stringBuffer.append(this.createTablePartitionValues(VALUES_LESS_THAN, tablePartition.getValues())).append(NEWLINE).append(this.createTablePartitionDescription(tablePartition));
            if (tablePartition.getPartitionLevelSubpartitions() != null) {
                stringBuffer.append(this.createOracleTableSubpartitions(tablePartition.getPartitionLevelSubpartitions()));
            }
        }
        return stringBuffer;
    }

    protected StringBuffer createTableListPartition(TablePartition tablePartition) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = tablePartition.getValues();
        if (!$assertionsDisabled && objectArray.length <= 0) {
            throw new AssertionError();
        }
        if (objectArray.length > 0) {
            stringBuffer.append(this.createTablePartitionValues(VALUES, objectArray)).append(NEWLINE).append(this.createTablePartitionDescription(tablePartition));
        }
        return stringBuffer;
    }

    public StringBuffer createTablePartitionValues(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(string).append(LPAREN);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    if (n > 0) {
                        stringBuffer.append(COMMA).append(SP);
                    }
                    stringBuffer.append(objectArray[n].toString());
                }
                ++n;
            }
            stringBuffer.append(RPAREN);
        }
        return stringBuffer;
    }

    private StringBuffer createTableHashPartitionsByQuantity(OracleTablePartitions oracleTablePartitions) {
        StringBuffer stringBuffer = new StringBuffer();
        if (oracleTablePartitions.getHashQuantity() != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            stringBuffer.append(SP2).append(PARTITIONS).append(SP).append(oracleTablePartitions.getHashQuantity());
            String[] stringArray = oracleTablePartitions.getHashQuantityTablespaces();
            if (stringArray.length > 0) {
                stringBuffer.append(SP).append(STORE).append(SP).append(IN).append(this.createTablespaceNameList(stringArray));
            }
        }
        return stringBuffer;
    }

    private StringBuffer createTablePartitionDescription(TablePartition tablePartition) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tablePartition.getSegmentAttributes() != null) {
            stringBuffer.append(this.createOracleStorageProperties(tablePartition.getSegmentAttributes(), SP4));
        }
        if (tablePartition.getCompression() != null) {
            stringBuffer.append(SP4).append(tablePartition.getCompression()).append(NEWLINE);
        }
        LOBDescriptor[] lOBDescriptorArray = tablePartition.getLOBDescriptors();
        int n = 0;
        while (n < lOBDescriptorArray.length) {
            stringBuffer.append(this.createLOBDescriptor(lOBDescriptorArray[n]));
            ++n;
        }
        return stringBuffer;
    }

    private StringBuffer createLOBDescriptor(LOBDescriptor lOBDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        DBObjectID[] dBObjectIDArray = lOBDescriptor.getColumns();
        if (dBObjectIDArray.length > 0 && dBObjectIDArray[0] != null) {
            stringBuffer.append(LOBDescriptor.isLOBColumn(dBObjectIDArray[0]) ? this.createLOB(lOBDescriptor) : this.createVARRAY(lOBDescriptor));
        }
        return stringBuffer;
    }

    private StringBuffer createLOB(LOBDescriptor lOBDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SP4).append(LOB).append(this.createColumnNameList(lOBDescriptor.getColumns())).append(SP).append(STORE).append(SP).append(AS).append(SP);
        if (lOBDescriptor.getLOBSegName() != null) {
            stringBuffer.append(lOBDescriptor.getLOBSegName());
        }
        stringBuffer.append(this.createLOBParameters(lOBDescriptor)).append(NEWLINE);
        return stringBuffer;
    }

    private StringBuffer createVARRAY(LOBDescriptor lOBDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Column column = (Column)lOBDescriptor.getColumns()[0].resolveID();
            stringBuffer.append(SP4).append(VARRAY).append(SP).append(this.m_prov.getExternalName(column.getName()));
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        String string = lOBDescriptor.getLOBSegName();
        StringBuffer stringBuffer2 = this.createLOBParameters(lOBDescriptor);
        if (string != null || stringBuffer2.length() > 0) {
            stringBuffer.append(SP).append(STORE).append(SP).append(AS).append(SP).append(LOB);
            if (string != null) {
                stringBuffer.append(SP).append(string);
            }
            stringBuffer.append(this.createLOBParameters(lOBDescriptor)).append(NEWLINE);
        }
        return stringBuffer;
    }

    private StringBuffer createLOBParameters(LOBDescriptor lOBDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        if (lOBDescriptor.isStorageEnabledInRow()) {
            stringBuffer.append(SP6).append(ENABLE_STORAGE_IN_ROW).append(NEWLINE);
        }
        if (lOBDescriptor.getChunk() != null) {
            stringBuffer.append(SP6).append(CHUNK).append(SP).append(lOBDescriptor.getChunk()).append(NEWLINE);
        }
        if (lOBDescriptor.getFreepools() != null) {
            stringBuffer.append(SP6).append(FREEPOOLS).append(SP).append(lOBDescriptor.getFreepools()).append(NEWLINE);
        }
        if (lOBDescriptor.getPctVersion() != null) {
            stringBuffer.append(SP6).append(PCTVERSION).append(SP).append(lOBDescriptor.getPctVersion()).append(NEWLINE);
        }
        if (lOBDescriptor.isRetention()) {
            stringBuffer.append(SP6).append(RETENTION).append(NEWLINE);
        }
        OracleStorageProperties oracleStorageProperties = lOBDescriptor.getStorage();
        String string = lOBDescriptor.getCache();
        if (string != null) {
            stringBuffer.append(SP6).append(string);
            if (oracleStorageProperties != null && oracleStorageProperties.getLogging() != null && (string.equalsIgnoreCase(NOCACHE) || string.equalsIgnoreCase("CACHE READS"))) {
                stringBuffer.append(SP).append(oracleStorageProperties.getLogging().equals(Boolean.TRUE) ? LOGGING : NOLOGGING);
            }
            stringBuffer.append(NEWLINE);
        }
        if (oracleStorageProperties != null) {
            if (oracleStorageProperties.getTablespace() != null) {
                stringBuffer.append(SP6).append(TABLESPACE).append(SP).append(DBUtil.quoteName(oracleStorageProperties.getTablespace(), DQ)).append(NEWLINE);
            }
            stringBuffer.append(this.createOracleStorageClause(oracleStorageProperties, SP6));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer.length() > 0) {
            stringBuffer2.append(NEWLINE).append(SP4).append(LPAREN).append(NEWLINE).append(stringBuffer).append(SP4).append(RPAREN);
        }
        return stringBuffer2;
    }

    private StringBuffer createOracleTableSubpartitions(OracleTablePartitions oracleTablePartitions) {
        StringBuffer stringBuffer = new StringBuffer();
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        OracleTablePartitions.ObjectType objectType = oracleTablePartitions.getObjectType();
        if (partitionType != null && (partitionType == OracleTablePartitions.PartitionType.HASH || partitionType == OracleTablePartitions.PartitionType.LIST) && objectType != null && objectType != OracleTablePartitions.ObjectType.PARTITION) {
            if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                stringBuffer.append(this.createPartitionLevelSubpartitions(oracleTablePartitions));
            } else {
                stringBuffer.append(SUBPARTITION).append(SP).append(BY).append(SP).append((Object)partitionType).append(this.createColumnNameList(oracleTablePartitions.getPartitionColumns()));
                if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                    stringBuffer.append(SP).append(SUBPARTITION).append(SP).append(TEMPLATE);
                    if (partitionType == OracleTablePartitions.PartitionType.HASH && oracleTablePartitions.getHashQuantity() != null) {
                        stringBuffer.append(SP).append(oracleTablePartitions.getHashQuantity());
                    } else {
                        stringBuffer.append(NEWLINE).append(this.createTableSubpartitions(oracleTablePartitions.getPartitions(), SP2));
                    }
                } else {
                    StringBuffer stringBuffer2 = this.createTableHashSubpartitionsByQuantity(oracleTablePartitions);
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append(SP).append(stringBuffer2);
                    }
                }
            }
            stringBuffer.append(NEWLINE);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return stringBuffer;
    }

    private StringBuffer createTableHashSubpartitionsByQuantity(OracleTablePartitions oracleTablePartitions) {
        StringBuffer stringBuffer = new StringBuffer();
        if (oracleTablePartitions.getHashQuantity() != null && oracleTablePartitions.getPartitionType() != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            stringBuffer.append(SUBPARTITIONS).append(SP).append(oracleTablePartitions.getHashQuantity());
            String[] stringArray = oracleTablePartitions.getHashQuantityTablespaces();
            if (stringArray.length > 0) {
                stringBuffer.append(SP).append(STORE).append(SP).append(IN).append(this.createTablespaceNameList(stringArray));
            }
        }
        return stringBuffer;
    }

    private StringBuffer createPartitionLevelSubpartitions(OracleTablePartitions oracleTablePartitions) {
        StringBuffer stringBuffer = this.createTableHashSubpartitionsByQuantity(oracleTablePartitions);
        if (stringBuffer.length() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(SP4);
            return stringBuffer2.append(stringBuffer);
        }
        return this.createTableSubpartitions(oracleTablePartitions.getPartitions(), SP4);
    }

    protected StringBuffer createTableSubpartitions(TablePartition[] tablePartitionArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tablePartitionArray.length > 0) {
            String string2 = string + SP2;
            stringBuffer.append(string).append(LPAREN).append(NEWLINE);
            int n = 0;
            while (n < tablePartitionArray.length) {
                if (n == 0) {
                    stringBuffer.append(string2).append(SUBPARTITION);
                } else {
                    stringBuffer.append(string).append(COMMA).append(SP).append(SUBPARTITION);
                }
                if (ModelUtil.hasLength((String)tablePartitionArray[n].getName())) {
                    stringBuffer.append(SP).append(this.m_prov.getExternalName(tablePartitionArray[n].getName()));
                }
                if (tablePartitionArray[n].getValues() != null) {
                    stringBuffer.append(SP).append(this.createTablePartitionValues(VALUES, tablePartitionArray[n].getValues()));
                }
                stringBuffer.append(NEWLINE).append(this.createPartitioningStorageClause(tablePartitionArray[n], string2 + SP2));
                ++n;
            }
            stringBuffer.append(string).append(RPAREN);
        }
        return stringBuffer;
    }

    protected StringBuffer createColumnNameList(DBObjectID[] dBObjectIDArray) {
        StringBuffer stringBuffer = new StringBuffer(LPAREN);
        int n = 0;
        while (n < dBObjectIDArray.length) {
            try {
                Column column = (Column)dBObjectIDArray[n].resolveID();
                if (column != null) {
                    if (n > 0) {
                        stringBuffer.append(COMMA).append(SP);
                    }
                    stringBuffer.append(this.m_prov.getExternalName(column.getName()));
                }
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
            ++n;
        }
        stringBuffer.append(RPAREN);
        return stringBuffer;
    }

    private StringBuffer createTablespaceNameList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(LPAREN);
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(COMMA).append(SP);
            }
            stringBuffer.append(this.m_prov.getExternalName(stringArray[n]));
            ++n;
        }
        stringBuffer.append(RPAREN);
        return stringBuffer;
    }

    private String createExternalTableProperties(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
        if (oracleExternalTableProperties != null) {
            DBObjectID dBObjectID = oracleExternalTableProperties.getDefaultDirectory();
            Directory directory = null;
            try {
                directory = dBObjectID == null ? null : (Directory)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
            OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray = oracleExternalTableProperties.getLocationSpecifiers();
            if (directory != null && locationSpecifierArray.length > 0) {
                stringBuffer.append(ORGANIZATION).append(SP).append(EXTERNAL).append(NEWLINE).append(LPAREN).append(NEWLINE);
                String string = oracleExternalTableProperties.getAccessDriverType();
                if (string != null) {
                    stringBuffer.append(SP2).append(TYPE).append(SP).append(string).append(NEWLINE);
                }
                stringBuffer.append(SP2).append(DEFAULT).append(SP).append(DIRECTORY).append(SP).append(this.m_prov.getExternalName(directory.getName())).append(NEWLINE);
                Object object = oracleExternalTableProperties.getAccessParameters();
                if (object != null) {
                    stringBuffer.append(SP2).append(ACCESS_PARAMETERS).append(NEWLINE);
                    if (oracleExternalTableProperties.getAccessParameterType() == OracleExternalTableProperties.AccessType.CLOB) {
                        stringBuffer.append(SP4).append(USING).append(SP).append(CLOB).append(LPAREN);
                        if (object instanceof SQLQuery) {
                            SQLQuery sQLQuery = (SQLQuery)object;
                            stringBuffer.append(sQLQuery.getSQLText());
                        } else {
                            stringBuffer.append(object.toString());
                        }
                    } else {
                        stringBuffer.append(SP2).append(LPAREN);
                        if (object instanceof OpaqueFormatSpec) {
                            OpaqueFormatSpec opaqueFormatSpec = (OpaqueFormatSpec)object;
                            stringBuffer.append(opaqueFormatSpec.getSpec());
                        } else {
                            stringBuffer.append(object.toString());
                        }
                    }
                    stringBuffer.append(RPAREN).append(NEWLINE);
                }
                stringBuffer.append(SP2).append(LOCATION).append(NEWLINE).append(SP2).append(LPAREN);
                int n = 0;
                while (n < locationSpecifierArray.length) {
                    if (n > 0) {
                        stringBuffer.append(COMMA);
                    }
                    stringBuffer.append(NEWLINE).append(SP4);
                    Directory directory2 = null;
                    DBObjectID dBObjectID2 = locationSpecifierArray[n].getDirectory();
                    try {
                        directory2 = dBObjectID2 == null ? null : (Directory)dBObjectID2.resolveID();
                    }
                    catch (DBException dBException) {
                        DBUtil.logStackTrace(dBException);
                    }
                    if (directory2 != null) {
                        stringBuffer.append(this.m_prov.getExternalName(directory2.getName())).append(COLON).append(SP);
                    }
                    stringBuffer.append("'").append(locationSpecifierArray[n].getSpecifier()).append("'");
                    ++n;
                }
                stringBuffer.append(NEWLINE).append(SP2).append(RPAREN).append(NEWLINE).append(RPAREN).append(NEWLINE);
                String string2 = oracleExternalTableProperties.getRejectLimit();
                if (string2 != null) {
                    stringBuffer.append(REJECT_LIMIT).append(SP).append(string2).append(NEWLINE);
                }
            }
        } else {
            stringBuffer.append(ORGANIZATION).append(SP).append(EXTERNAL).append(LPAREN).append(RPAREN).append(NEWLINE);
        }
        return stringBuffer.toString();
    }

    private String createIotProperties(Table table) {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ORGANIZATION).append(SP).append(INDEX).append(NEWLINE);
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        if (oracleStorageProperties != null) {
            stringBuffer.append(this.createOracleStorageProperties(oracleStorageProperties, SP2));
        }
        if ((oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null) {
            Integer n;
            Integer n2 = oracleIndexOrganizedTableProperties.getKeyCompression();
            if (n2 != null) {
                stringBuffer.append(COMPRESS);
                if (n2 > 0) {
                    stringBuffer.append(SP).append(n2);
                }
                stringBuffer.append(NEWLINE);
            }
            if ((n = oracleIndexOrganizedTableProperties.getPctThreshold()) != null) {
                stringBuffer.append(PCTTHRESHOLD).append(SP).append(n).append(NEWLINE);
            }
            DBObjectID dBObjectID = oracleIndexOrganizedTableProperties.getIncludeColumn();
            Column column = null;
            try {
                column = dBObjectID == null ? null : (Column)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
            if (column != null) {
                stringBuffer.append(INCLUDING).append(SP).append(this.m_prov.getExternalName(column.getName())).append(NEWLINE);
            }
            if (oracleIndexOrganizedTableProperties.isMapped()) {
                stringBuffer.append(MAPPING).append(SP).append(TABLE).append(NEWLINE);
            }
            if (oracleIndexOrganizedTableProperties.isOverflowable()) {
                stringBuffer.append(OVERFLOW);
                OracleStorageProperties oracleStorageProperties2 = oracleIndexOrganizedTableProperties.getOverflowProperties();
                if (oracleStorageProperties2 != null) {
                    stringBuffer.append(SP).append(this.createOracleStorageProperties(oracleStorageProperties2, SP2));
                }
            }
        }
        return stringBuffer.toString();
    }

    private String createOracleStorageProperties(OracleStorageProperties oracleStorageProperties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (oracleStorageProperties != null) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Boolean bl;
            String string2 = oracleStorageProperties.getTablespace();
            if (string2 != null) {
                stringBuffer.append(string).append(TABLESPACE).append(SP).append(DBUtil.quoteName(string2, DQ)).append(NEWLINE);
            }
            if ((bl = oracleStorageProperties.getLogging()) != null) {
                stringBuffer.append(string).append(bl != false ? LOGGING : NOLOGGING).append(SP).append(NEWLINE);
            }
            if ((n4 = oracleStorageProperties.getPercentFree()) != null) {
                stringBuffer.append(string).append(PCTFREE).append(SP).append(n4.toString()).append(NEWLINE);
            }
            if ((n3 = oracleStorageProperties.getPercentUsed()) != null) {
                stringBuffer.append(string).append(PCTUSED).append(SP).append(n3.toString()).append(NEWLINE);
            }
            if ((n2 = oracleStorageProperties.getInitrans()) != null && n2 > 0 && n2 <= 255) {
                stringBuffer.append(string).append(INITRANS).append(SP).append(n2.toString()).append(NEWLINE);
            }
            if ((n = oracleStorageProperties.getMaxtrans()) != null && n > 0 && n <= 255) {
                stringBuffer.append(string).append(MAXTRANS).append(SP).append(n.toString()).append(NEWLINE);
            }
            stringBuffer.append(this.createOracleStorageClause(oracleStorageProperties, string));
        }
        return stringBuffer.toString();
    }

    private Ddl createTable(Table table) {
        OracleTablePartitions oracleTablePartitions;
        Ddl ddl = this.createRelationalObject(table);
        String string = this.getSchemaDotName(table);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE, TABLE, string);
        stringBuffer.append(CREATE);
        Object object = table.getProperty("TableType");
        if (Table.TableType.SESSION_TEMP == object || Table.TableType.TRANSACTION_TEMP == object) {
            stringBuffer.append(SP).append(GLOBAL).append(SP).append(TEMPORARY);
        }
        stringBuffer.append(SP).append(TABLE).append(SP).append(string).append(NEWLINE).append(LPAREN).append(NEWLINE).append(ddl.get("TAB")).append(this.createPrimaryKey(table)).append(RPAREN).append(NEWLINE);
        String string2 = this.createOracleTableProperties(table);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if ((oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions")) != null && Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"))) {
            stringBuffer.append(this.createOracleTablePartitions(oracleTablePartitions));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Index[] indexArray = table.getIndexes();
        int n = 0;
        while (n < indexArray.length) {
            arrayList.add(this.createIndex(indexArray[n]).get("IND"));
            ++n;
        }
        Ddl ddl2 = new Ddl();
        ddl2.put("TAB", stringBuffer.toString());
        if (ddl.containsKey("CONUK")) {
            ddl2.put("CONUK", ddl.getArray("CONUK"));
        }
        if (ddl.containsKey("CONFK")) {
            ddl2.put("CONFK", ddl.getArray("CONFK"));
        }
        if (ddl.containsKey("CONCC")) {
            ddl2.put("CONCC", ddl.getArray("CONCC"));
        }
        if (ddl.containsKey("CMT")) {
            ddl2.put("CMT", ddl.get("CMT"));
        }
        if (ddl.containsKey("CMC")) {
            ddl2.put("CMC", ddl.getArray("CMC"));
        }
        if (arrayList.size() > 0) {
            ddl2.put("IND", arrayList);
        }
        return ddl2;
    }

    private String createPrimaryKey(Table table) {
        Constraint[] constraintArray = table.getConstraints();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraintArray[n] instanceof PKConstraint) {
                PKConstraint pKConstraint = (PKConstraint)constraintArray[n];
                stringBuffer.append(", ");
                this.appendConstraintName(stringBuffer, pKConstraint.getName());
                stringBuffer.append("PRIMARY KEY\n").append(this.getColumnList(pKConstraint.getColumns(), true));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private Ddl createRelationalObject(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Column[] columnArray = relation.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            if (n > 0) {
                stringBuffer.append(COMMA).append(NEWLINE);
            }
            Ddl ddl = this.createColumnDDL(columnArray[n]);
            stringBuffer.append(ddl.get("ACO"));
            if (ddl.containsKey("CMC")) {
                arrayList.add(ddl.get("CMC"));
            }
            ++n;
        }
        stringBuffer.append(NEWLINE);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Constraint[] constraintArray = relation.getConstraints();
        int n2 = 0;
        while (n2 < constraintArray.length) {
            if ("UniqueConstraint".equals(constraintArray[n2].getConstraintType())) {
                arrayList2.add(this.createConstraint(constraintArray[n2]));
            }
            ++n2;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n3 = 0;
        while (n3 < constraintArray.length) {
            if (constraintArray[n3] instanceof FKConstraint) {
                arrayList3.add(this.createConstraint(constraintArray[n3]));
            }
            ++n3;
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        int n4 = 0;
        while (n4 < constraintArray.length) {
            if (constraintArray[n4] instanceof CheckConstraint) {
                arrayList4.add(this.createConstraint(constraintArray[n4]));
            }
            ++n4;
        }
        Ddl ddl = new Ddl();
        ddl.put("TAB", stringBuffer.toString());
        ddl.put("CONUK", arrayList2);
        ddl.put("CONFK", arrayList3);
        ddl.put("CONCC", arrayList4);
        String string = this.createCommentOnRelation(relation);
        if (string != null && string.length() > 0) {
            ddl.put("CMT", string);
        }
        ddl.put("CMC", arrayList);
        return ddl;
    }

    private String createConstraint(Constraint constraint) {
        String string = this.getSchemaDotName(constraint.getRelation());
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(ALTER).append(SP).append(TABLE).append(SP);
        stringBuffer2.append(string);
        stringBuffer2.append(NEWLINE);
        if (constraint instanceof CheckConstraint) {
            this.addPrompt(stringBuffer, CREATE, "CHECK CONSTRAINT", null, ON, string);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addCheckConstraint((CheckConstraint)constraint));
        } else if (constraint instanceof PKConstraint) {
            this.addPrompt(stringBuffer, CREATE, "PRIMARY KEY CONSTRAINT", null, ON, string);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        } else if (constraint instanceof UniqueConstraint) {
            this.addPrompt(stringBuffer, CREATE, "UNIQUE KEY CONSTRAINT", null, ON, string);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addUniqueConstraint((UniqueConstraint)constraint));
        } else if (constraint instanceof FKConstraint) {
            this.addPrompt(stringBuffer, CREATE, "FOREIGN KEY CONSTRAINT", null, ON, string);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(this.addFKConstraint((FKConstraint)constraint));
        }
        stringBuffer.append(SP);
        if (constraint.isEnabled()) {
            stringBuffer.append(ENABLE);
        } else {
            stringBuffer.append(DISABLE);
        }
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    private Ddl createColumnDDL(Column column) {
        StringBuffer stringBuffer = new StringBuffer(SP2);
        stringBuffer.append(this.m_prov.getExternalName(column.getName()));
        stringBuffer.append(SP);
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType(column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dataType != null) {
            stringBuffer.append(dataType.getDDL(column.getDataTypeUsage()));
            if (column.getDefault() != null) {
                stringBuffer.append(SP);
                stringBuffer.append(DEFAULT);
                stringBuffer.append(SP);
                String string = column.getDefault().toString();
                stringBuffer.append(string);
            }
        }
        if (column.isNotNull()) {
            stringBuffer.append(SP).append(NOT).append(SP).append(NULL);
        }
        Ddl ddl = new Ddl();
        ddl.put("ACO", stringBuffer.toString());
        String string = this.createCommentOnColumn(column);
        if (string != null && string.length() > 0) {
            ddl.put("CMC", string);
        }
        return ddl;
    }

    private String addCheckConstraint(CheckConstraint checkConstraint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ADD).append(SP);
        this.appendConstraintName(stringBuffer, checkConstraint.getName());
        stringBuffer.append(CHECK).append(NEWLINE).append(LPAREN);
        String string = checkConstraint.getCheckCondition();
        if (string != null) {
            string = string.trim().replace('\n', ' ');
        }
        stringBuffer.append(string);
        stringBuffer.append(RPAREN).append(NEWLINE);
        return stringBuffer.toString();
    }

    private String getColumnList(Column[] columnArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(SP2);
        }
        stringBuffer.append(LPAREN).append(NEWLINE);
        int n = 0;
        while (n < columnArray.length) {
            if (n > 0) {
                stringBuffer.append(COMMA).append(NEWLINE);
            }
            if (bl) {
                stringBuffer.append(SP2);
            }
            stringBuffer.append(SP2 + this.m_prov.getExternalName(columnArray[n].getName()));
            ++n;
        }
        stringBuffer.append(NEWLINE);
        if (bl) {
            stringBuffer.append(SP2);
        }
        stringBuffer.append(RPAREN).append(NEWLINE);
        return stringBuffer.toString();
    }

    private String addUniqueConstraint(UniqueConstraint uniqueConstraint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ADD).append(SP);
        this.appendConstraintName(stringBuffer, uniqueConstraint.getName());
        if (uniqueConstraint instanceof PKConstraint) {
            stringBuffer.append(PRIMARY).append(SP).append(KEY);
        } else {
            stringBuffer.append(UNIQUE);
        }
        stringBuffer.append(NEWLINE);
        stringBuffer.append(this.getColumnList(uniqueConstraint.getColumns(), false));
        return stringBuffer.toString();
    }

    protected String schemaDot(FKConstraint fKConstraint) {
        Schema schema;
        StringBuffer stringBuffer = new StringBuffer("");
        Schema schema2 = fKConstraint.getRelation().getSchema();
        Relation relation = this.getFKReference(fKConstraint);
        Schema schema3 = schema = relation != null ? relation.getSchema() : null;
        if (schema != null && (this.m_prefixSchemaName || schema2 == null || !schema2.equals(schema))) {
            stringBuffer.append(this.m_prov.getExternalName(schema.getName())).append(DOT);
        }
        return stringBuffer.toString();
    }

    private String addFKConstraint(FKConstraint fKConstraint) {
        StringBuffer stringBuffer = new StringBuffer();
        DBObject dBObject = null;
        try {
            dBObject = fKConstraint.getReferenceID().resolveID();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dBObject instanceof UniqueConstraint) {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObject;
            stringBuffer.append(ADD).append(SP);
            this.appendConstraintName(stringBuffer, fKConstraint.getName());
            stringBuffer.append(FOREIGN).append(SP).append(KEY).append(NEWLINE);
            stringBuffer.append(this.getColumnList(fKConstraint.getColumns(), false));
            stringBuffer.append(REFERENCES);
            stringBuffer.append(SP);
            stringBuffer.append(this.schemaDot(fKConstraint));
            stringBuffer.append(this.m_prov.getExternalName(AbstractDBObjectProvider.convertObject(this.getFKReference(fKConstraint))));
            stringBuffer.append(NEWLINE);
            stringBuffer.append(LPAREN).append(NEWLINE);
            Column[] columnArray = uniqueConstraint.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                if (n != 0) {
                    stringBuffer.append(COMMA).append(NEWLINE);
                }
                stringBuffer.append(this.m_prov.getExternalName(columnArray[n].getName()));
                ++n;
            }
            stringBuffer.append(NEWLINE).append(RPAREN);
            if (fKConstraint.getDeleteMode() == 1) {
                stringBuffer.append(NEWLINE).append(ON).append(SP).append(DELETE).append(SP).append(CASCADE);
            }
            if (fKConstraint.getDeleteMode() == 2) {
                stringBuffer.append(NEWLINE).append(ON).append(SP).append(DELETE).append(SP).append(SET).append(SP).append(NULL);
            }
        }
        return stringBuffer.toString();
    }

    protected void addPrompt(StringBuffer stringBuffer, String string, String string2, String string3, String string4, String string5) {
        if (this.m_createPrompts) {
            stringBuffer.append(PROMPT).append(SP);
            stringBuffer.append(string.toLowerCase()).append(SP);
            if (string2 != null) {
                stringBuffer.append(string2.toLowerCase());
            }
            if (string3 != null) {
                stringBuffer.append(SP).append("'").append(string3).append("'");
            }
            if (string4 != null) {
                stringBuffer.append(SP).append(string4.toLowerCase()).append(SP);
            }
            if (string5 != null) {
                stringBuffer.append("'").append(string5).append("'");
            }
            stringBuffer.append(NEWLINE);
        }
    }

    protected void addPrompt(StringBuffer stringBuffer, String string, String string2, String string3) {
        this.addPrompt(stringBuffer, string, string2, string3, null, null);
    }

    private Ddl createView(View view, boolean bl) {
        String string = this.getSchemaDotName(view);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.addPrompt(stringBuffer, CREATE_OR_REPLACE, VIEW, string);
            stringBuffer.append(CREATE_OR_REPLACE).append(SP);
        } else {
            this.addPrompt(stringBuffer, CREATE, VIEW, string);
            stringBuffer.append(CREATE).append(SP);
        }
        if (view.isForceOnCreate()) {
            stringBuffer.append(FORCE).append(SP);
        }
        stringBuffer.append(VIEW).append(SP);
        stringBuffer.append(string);
        stringBuffer.append(SP).append(AS).append(SP);
        stringBuffer.append(view.getViewText());
        Ddl ddl = new Ddl();
        ddl.put("VW", stringBuffer.toString());
        String string2 = this.createCommentOnRelation(view);
        if (string2 != null && string2.length() > 0) {
            ddl.put("CMT", string2);
        }
        return ddl;
    }

    private Ddl createMaterializedView(MaterializedView materializedView, boolean bl) {
        String string = this.getSchemaDotName(materializedView);
        StringBuffer stringBuffer = new StringBuffer();
        MaterializedViewDDLHelper materializedViewDDLHelper = new MaterializedViewDDLHelper(materializedView);
        if (bl) {
            this.addPrompt(stringBuffer, CREATE_OR_REPLACE, MVIEW, string);
            stringBuffer.append(CREATE_OR_REPLACE).append(SP);
        } else {
            this.addPrompt(stringBuffer, CREATE, MVIEW, string);
            stringBuffer.append(CREATE).append(SP);
        }
        stringBuffer.append(MVIEW).append(SP);
        stringBuffer.append(string).append(NEWLINE);
        int n = materializedView.getOnPrebuilt();
        if (n != 0) {
            stringBuffer.append(ON).append(SP).append(PREBUILT).append(SP);
            stringBuffer.append(TABLE).append(SP);
            if (n != 1) {
                if (n == 2) {
                    stringBuffer.append(WITH).append(SP);
                } else {
                    stringBuffer.append(WITHOUT).append(SP);
                }
                stringBuffer.append(REDUCED_PRECISION).append(SP);
            }
        } else {
            stringBuffer.append(materializedViewDDLHelper.getCacheDDL());
            stringBuffer.append(materializedViewDDLHelper.getParallelDDL());
            if (materializedView.getBuildType() == 1) {
                stringBuffer.append(BUILD).append(SP).append(DEFERRED).append(NEWLINE);
            } else if (materializedView.getBuildType() == 0) {
                stringBuffer.append(BUILD).append(SP).append(IMMEDIATE).append(NEWLINE);
            }
        }
        stringBuffer.append(materializedViewDDLHelper.getUsingIndexDDL(false));
        stringBuffer.append(materializedViewDDLHelper.getRefreshDDL());
        if (materializedView.isUpdatable()) {
            stringBuffer.append(NEWLINE).append(FOR_UPDATE).append(SP);
        }
        if (materializedView.isRewrite()) {
            stringBuffer.append(NEWLINE).append(ENABLE).append(SP);
        } else {
            stringBuffer.append(NEWLINE).append(DISABLE).append(SP);
        }
        stringBuffer.append(NEWLINE).append(QUERY_REWRITE).append(SP);
        stringBuffer.append(SP).append(AS).append(SP);
        stringBuffer.append(materializedView.getViewText());
        Ddl ddl = new Ddl();
        ddl.put("MVW", stringBuffer.toString());
        String string2 = this.createCommentOnRelation(materializedView);
        if (string2 != null && string2.length() > 0) {
            ddl.put("CMT", string2);
        }
        return ddl;
    }

    private Ddl createMaterializedViewLog(MaterializedViewLog materializedViewLog, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = materializedViewLog.getMaster();
        if (bl) {
            this.addPrompt(stringBuffer, CREATE_OR_REPLACE, MVIEWLOG, string);
            stringBuffer.append(CREATE_OR_REPLACE).append(SP);
        } else {
            this.addPrompt(stringBuffer, CREATE, MVIEWLOG, string);
            stringBuffer.append(CREATE).append(SP);
        }
        stringBuffer.append(MVIEWLOG).append(SP).append(ON).append(SP);
        stringBuffer.append(string).append(SP);
        if (ModelUtil.hasLength((String)materializedViewLog.getTablespace())) {
            stringBuffer.append(TABLESPACE).append(SP);
            stringBuffer.append(materializedViewLog.getTablespace()).append(SP);
        }
        stringBuffer.append(materializedViewLog.isCache() ? CACHE : NOCACHE).append(SP);
        stringBuffer.append(materializedViewLog.isLogging() ? LOGGING : NOLOGGING).append(SP);
        if (materializedViewLog.getParallel() > 0) {
            stringBuffer.append(PARALLEL).append(SP);
            stringBuffer.append(materializedViewLog.getParallel()).append(SP);
        } else {
            stringBuffer.append(NOPARALLEL).append(SP);
        }
        if (materializedViewLog.isPrimaryKeyLogged() || materializedViewLog.isRowidLogged() || materializedViewLog.isObjectIdLogged() || materializedViewLog.isSequenceLogged()) {
            stringBuffer.append(NEWLINE).append(WITH).append(SP);
            if (materializedViewLog.isPrimaryKeyLogged()) {
                stringBuffer.append(PRIMARY).append(SP).append(KEY).append(SP);
            }
            if (materializedViewLog.isRowidLogged()) {
                stringBuffer.append(ROWID).append(SP);
            }
            if (materializedViewLog.isObjectIdLogged()) {
                stringBuffer.append(OBJECT).append(SP).append(ID).append(SP);
            }
            if (materializedViewLog.isSequenceLogged()) {
                stringBuffer.append(SEQUENCE).append(SP);
            }
            if (materializedViewLog.isNewValues()) {
                stringBuffer.append(INCLUDING).append(SP);
            } else {
                stringBuffer.append(EXCLUDING).append(SP);
            }
            stringBuffer.append(NEW).append(SP).append(VALUES).append(SP);
        }
        Ddl ddl = new Ddl();
        ddl.put("MVL", stringBuffer.toString());
        return ddl;
    }

    private Ddl createSequence(Sequence sequence) {
        String string = this.getSchemaDotName(sequence);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE, SEQUENCE, string);
        stringBuffer.append(CREATE).append(SP);
        stringBuffer.append(SEQUENCE).append(SP);
        stringBuffer.append(string).append(SP);
        if (sequence.getIncrementBy() != null) {
            stringBuffer.append(INCREMENT).append(SP).append(BY).append(SP);
            stringBuffer.append(sequence.getIncrementBy().toString()).append(SP);
        }
        if (sequence.getStartWith() != null) {
            stringBuffer.append(START).append(SP).append(WITH).append(SP);
            stringBuffer.append(sequence.getStartWith().toString()).append(SP);
        }
        if (sequence.getMaxValue() != null) {
            stringBuffer.append(MAXVALUE).append(SP);
            stringBuffer.append(sequence.getMaxValue().toString()).append(SP);
        }
        if (sequence.getMinValue() != null) {
            stringBuffer.append(MINVALUE).append(SP);
            stringBuffer.append(sequence.getMinValue().toString()).append(SP);
        }
        if (sequence.getCycleFlag() != null && sequence.getCycleFlag().equals(Boolean.TRUE)) {
            stringBuffer.append(CYCLE).append(SP);
        }
        if (sequence.getCacheFlag() != null) {
            if (sequence.getCacheFlag().booleanValue()) {
                if (sequence.getCacheSize() != null && sequence.getCacheSize().intValue() > 1) {
                    stringBuffer.append(CACHE).append(SP).append(sequence.getCacheSize().toString()).append(SP);
                }
            } else {
                stringBuffer.append(NOCACHE).append(SP);
            }
        }
        if (sequence.getOrderFlag() != null && sequence.getOrderFlag().equals(Boolean.TRUE)) {
            stringBuffer.append(ORDER).append(SP);
        }
        Ddl ddl = new Ddl();
        ddl.put("SEQ", stringBuffer.toString());
        return ddl;
    }

    private Ddl createSynonym(Synonym synonym, boolean bl) {
        String string = synonym.getSchema().getName();
        String string2 = this.getSchemaDotName(synonym);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE, SYNONYM, string2);
        if (bl) {
            stringBuffer.append(CREATE_OR_REPLACE).append(SP);
        } else {
            stringBuffer.append(CREATE).append(SP);
        }
        if (synonym.isPublic()) {
            stringBuffer.append(PUBLIC).append(SP);
            string2 = synonym.getName();
        }
        stringBuffer.append(SYNONYM).append(SP);
        stringBuffer.append(string2);
        stringBuffer.append(SP).append(FOR).append(SP);
        DBObjectID dBObjectID = synonym.getReference();
        String string3 = "";
        String string4 = "";
        try {
            SchemaObject schemaObject = (SchemaObject)dBObjectID.resolveID();
            if (schemaObject != null) {
                Schema schema = schemaObject.getSchema();
                if (schema != null) {
                    string3 = schema.getName();
                }
                string4 = schemaObject.getName();
            } else if (dBObjectID instanceof NameBasedRefID) {
                string3 = ((NameBasedRefID)dBObjectID).getSchemaName();
                string4 = ((NameBasedRefID)dBObjectID).getName();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (ModelUtil.hasLength((String)string3) && (this.m_prefixSchemaName || !string3.equals(string))) {
            stringBuffer.append(string3).append(DOT);
        }
        stringBuffer.append(string4);
        Ddl ddl = new Ddl();
        ddl.put("SYN", stringBuffer.toString());
        return ddl;
    }

    protected Ddl createIndex(Index index) {
        OracleIndexProperties oracleIndexProperties;
        String string = this.getSchemaDotName(index);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE, INDEX, string);
        stringBuffer.append(CREATE).append(SP);
        if (3 == index.getIndexType()) {
            stringBuffer.append(BITMAP).append(SP);
        } else if (2 == index.getIndexType()) {
            stringBuffer.append(UNIQUE).append(SP);
        }
        stringBuffer.append(INDEX).append(SP);
        stringBuffer.append(string);
        stringBuffer.append(SP).append(ON).append(SP);
        String string2 = this.getSchemaDotName(index.getTable());
        stringBuffer.append(string2);
        stringBuffer.append(SP).append(LPAREN);
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        int n = 0;
        while (n < indexObjectArray.length) {
            if (n > 0) {
                stringBuffer.append(COMMA).append(SP);
            }
            stringBuffer.append(indexObjectArray[n].getExpression().getSQLText());
            String string3 = indexObjectArray[n].getOrder();
            if (ModelUtil.hasLength((String)string3)) {
                stringBuffer.append(SP).append(string3);
            }
            ++n;
        }
        stringBuffer.append(RPAREN);
        if (index.getIndexType() == 4 && (oracleIndexProperties = (OracleIndexProperties)index.getProperty("OracleIndexProperties")) != null && 1 == oracleIndexProperties.getIndexDomainType()) {
            stringBuffer.append(SP).append(INDEXTYPE).append(SP).append(IS);
            stringBuffer.append(SP).append(CTXSYS).append(DOT).append(CONTEXT);
        }
        Ddl ddl = new Ddl();
        ddl.put("IND", stringBuffer.toString());
        return ddl;
    }

    protected void appendConstraintName(StringBuffer stringBuffer, String string) {
        if (ModelUtil.hasLength((String)string)) {
            boolean bl;
            boolean bl2 = bl = string.length() == 12 || string.length() == 11;
            if (!bl || !"SYS_C".equals(string.substring(0, 5))) {
                stringBuffer.append(CONSTRAINT).append(SP);
                stringBuffer.append(this.m_prov.getExternalName(string)).append(SP);
            }
        }
    }

    private Ddl createTrigger(Trigger trigger) {
        String string = this.getSchemaDotName(trigger);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, CREATE_OR_REPLACE, TRIGGER, string);
        stringBuffer.append(CREATE_OR_REPLACE).append(SP).append(TRIGGER).append(SP);
        stringBuffer.append(string);
        stringBuffer.append(SP);
        if (1 == trigger.getBaseType()) {
            stringBuffer.append(INSTEAD).append(SP).append(OF).append(SP);
        } else if (trigger.getTiming() == 0) {
            stringBuffer.append(BEFORE).append(SP);
        } else {
            stringBuffer.append(AFTER).append(SP);
        }
        if (trigger.getBaseType() == 0 || 1 == trigger.getBaseType()) {
            List list = trigger.getEvents();
            int n = 0;
            while (n < list.size()) {
                String string2;
                if (n > 0) {
                    stringBuffer.append(OR).append(SP);
                }
                if (INSERT.equals(string2 = (String)list.get(n)) || DELETE.equals(string2) || UPDATE.equals(string2)) {
                    if (INSERT.equals(string2)) {
                        stringBuffer.append(INSERT).append(SP);
                    } else if (DELETE.equals(string2)) {
                        stringBuffer.append(DELETE).append(SP);
                    } else {
                        stringBuffer.append(UPDATE).append(SP);
                        List list2 = trigger.getColumns();
                        if (UPDATE.equals(string2) && trigger.getBaseType() == 0 && list2.size() > 0) {
                            stringBuffer.append(OF).append(SP);
                            int n2 = 0;
                            while (n2 < list2.size()) {
                                if (n2 > 0) {
                                    stringBuffer.append(COMMA);
                                }
                                stringBuffer.append(this.m_prov.getExternalName((String)list2.get(n2)));
                                ++n2;
                            }
                            stringBuffer.append(SP);
                        }
                    }
                }
                ++n;
            }
            stringBuffer.append(ON).append(SP);
            stringBuffer.append(this.getSchemaDotName(trigger.getTableOwner(), trigger.getTableName()));
            stringBuffer.append(SP).append(NEWLINE);
            String[] stringArray = trigger.getReferenceNames();
            boolean bl = false;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (ModelUtil.hasLength((String)stringArray[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                stringBuffer.append(REFERENCING).append(SP);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (ModelUtil.hasLength((String)stringArray[n4])) {
                        stringBuffer.append(n4 == 0 ? OLD : NEW);
                        stringBuffer.append(SP).append(AS).append(SP);
                        stringBuffer.append(stringArray[n4]).append(SP);
                    }
                    ++n4;
                }
                stringBuffer.append(NEWLINE);
            }
            if (!trigger.isStatementLevel()) {
                stringBuffer.append(FOR).append(SP).append(EACH).append(SP).append(ROW).append(SP).append(NEWLINE);
            }
            if (trigger.getBaseType() == 0 && ModelUtil.hasLength((String)trigger.getWhenClause())) {
                stringBuffer.append(WHEN).append(SP).append(LPAREN);
                stringBuffer.append(trigger.getWhenClause());
                stringBuffer.append(RPAREN).append(SP).append(NEWLINE);
            }
        } else {
            List list = trigger.getEvents();
            int n = 0;
            while (n < list.size()) {
                if (n > 0) {
                    stringBuffer.append(OR).append(SP);
                }
                String string3 = (String)list.get(n);
                stringBuffer.append(string3).append(SP);
                ++n;
            }
            stringBuffer.append(ON).append(SP);
            if (trigger.getTableOwner() != null && ModelUtil.hasLength((String)trigger.getTableOwner().getName())) {
                stringBuffer.append(DBUtil.quoteName(trigger.getTableOwner().getName(), DQ));
                stringBuffer.append(DOT).append(SCHEMA).append(SP);
            } else {
                stringBuffer.append(DATABASE).append(SP);
            }
            stringBuffer.append(NEWLINE);
        }
        if (ModelUtil.hasLength((String)trigger.getCode())) {
            stringBuffer.append(trigger.getCode());
        } else {
            stringBuffer.append(BEGIN).append(NEWLINE);
            stringBuffer.append(SP).append(SP).append(NULL).append(SEMICOLON).append(NEWLINE);
            stringBuffer.append(END).append(SEMICOLON);
        }
        Ddl ddl = new Ddl();
        ddl.put("TRG", stringBuffer.toString());
        return ddl;
    }

    private Ddl dropBasicObject(SchemaObject schemaObject) {
        String string = this.getSchemaDotName(schemaObject);
        String string2 = schemaObject.getType();
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, string2, string);
        stringBuffer.append(DROP).append(SP).append(string2).append(SP);
        stringBuffer.append(string);
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl purgeRecycledObject(RecycledObject recycledObject) {
        String string = recycledObject.getName();
        String string2 = recycledObject.getOriginalName();
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, PURGE, RECYCLE, string2);
        stringBuffer.append(PURGE).append(SP);
        if (TABLE.equals(recycledObject.getOriginalType())) {
            stringBuffer.append(TABLE).append(SP);
        } else if (INDEX.equals(recycledObject.getOriginalType())) {
            stringBuffer.append(INDEX).append(SP);
        }
        stringBuffer.append(DQ).append(string).append(DQ);
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl dropSynonym(Synonym synonym) {
        String string = null;
        string = synonym.isPublic() ? synonym.getName() : this.getSchemaDotName(synonym);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, SYNONYM, string);
        stringBuffer.append(DROP).append(SP);
        if (synonym.isPublic()) {
            stringBuffer.append(PUBLIC).append(SP);
        }
        stringBuffer.append(SYNONYM).append(SP);
        stringBuffer.append(string);
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl dropRelation(Relation relation, boolean bl) {
        String string = this.getSchemaDotName(relation);
        String string2 = relation.getType();
        ArrayList<String> arrayList = new ArrayList<String>();
        Constraint[] constraintArray = relation.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraintArray[n] instanceof FKConstraint) {
                StringBuffer stringBuffer = new StringBuffer();
                FKConstraint fKConstraint = (FKConstraint)constraintArray[n];
                stringBuffer.append("ALTER " + string2 + SP + string + SP);
                stringBuffer.append("DROP CONSTRAINT ");
                stringBuffer.append(DQ + fKConstraint.getName() + DQ);
                stringBuffer.append(NEWLINE);
                arrayList.add(stringBuffer.toString());
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, string2, string);
        stringBuffer.append(DROP).append(SP).append(string2).append(SP);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(SP).append(CASCADE).append(SP).append(CONSTRAINTS);
        }
        Ddl ddl = new Ddl();
        ddl.put("DROPCON", arrayList);
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl dropMViewLog(MaterializedViewLog materializedViewLog) {
        String string = this.getSchemaDotName(materializedViewLog.getSchema(), materializedViewLog.getMaster());
        String string2 = MVIEWLOG;
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, string2, string);
        stringBuffer.append(DROP).append(SP).append(string2).append(SP);
        stringBuffer.append(ON).append(SP);
        stringBuffer.append(string);
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl dropType(ObjectType objectType, boolean bl) {
        String string = this.getSchemaDotName(objectType);
        StringBuffer stringBuffer = new StringBuffer();
        this.addPrompt(stringBuffer, DROP, TYPE, string);
        stringBuffer.append(DROP).append(SP).append(TYPE).append(SP);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(SP).append(FORCE).append(SP);
        }
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private Ddl dropDatabaseLink(DatabaseLink databaseLink) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DROP).append(SP);
        if (databaseLink.isPublic()) {
            stringBuffer.append(PUBLIC).append(SP);
        }
        stringBuffer.append(DATABASE).append(SP).append(LINK).append(SP).append(databaseLink.getName());
        Ddl ddl = new Ddl();
        ddl.put(DROP, stringBuffer.toString());
        return ddl;
    }

    private String createCommentOn(String string, String string2, Map map) {
        String string3 = map == null ? null : (String)map.get("Comment");
        return this.createCommentOn(string, string2, string3);
    }

    protected String createCommentOn(String string, String string2, String string3) {
        String string4 = null;
        if (string3 != null) {
            string3 = string3.replace('\n', ' ').replace('\r', ' ').replaceAll("'", "''");
            StringBuffer stringBuffer = new StringBuffer(COMMENT).append(SP).append(ON).append(SP);
            stringBuffer.append(string);
            stringBuffer.append(SP);
            stringBuffer.append(string2);
            stringBuffer.append(SP).append(IS).append(SP).append("'");
            stringBuffer.append(string3);
            stringBuffer.append("'");
            stringBuffer.append(NEWLINE);
            string4 = stringBuffer.toString();
        }
        return string4;
    }

    private String createCommentOnColumn(Column column) {
        String string = this.getSchemaDotName(column.getRelation()) + DOT + column.getName();
        Map map = column.getProperties();
        return this.createCommentOn(COLUMN, string, map);
    }

    private String createCommentOnRelation(Relation relation) {
        String string = this.getSchemaDotName(relation);
        Map map = relation.getProperties();
        return this.createCommentOn(TABLE, string, map);
    }

    private Relation getFKReference(FKConstraint fKConstraint) {
        Relation relation = null;
        try {
            DBObject dBObject = fKConstraint.getReferenceID().resolveID();
            if (dBObject instanceof UniqueConstraint) {
                relation = ((UniqueConstraint)dBObject).getRelation();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return relation;
    }

    protected Ddl generateSpoolCommands() {
        Ddl ddl = new Ddl();
        if (this.m_createPrompts && this.m_createSpoolingCommands != null) {
            String string = "SPOOL " + this.m_createSpoolingCommands;
            String string2 = "SPOOL OFF";
            ddl.putOne("SPOOLON", string);
            ddl.putOne("SPOOLOFF", string2);
        }
        return ddl;
    }

    private Ddl createSourceObject(SourceObject sourceObject, boolean bl) {
        DeclarativePlSql declarativePlSql;
        String string;
        String string2;
        String string3 = this.getSchemaDotName(sourceObject);
        Ddl ddl = new Ddl();
        if (sourceObject instanceof ObjectType) {
            this.createIncompleteType(bl, string3, ddl);
        }
        if (ModelUtil.hasLength((String)(string2 = sourceObject.getSource()))) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                this.addPrompt(stringBuffer, CREATE_OR_REPLACE, "TYPE SPEC", string3);
                stringBuffer.append(CREATE_OR_REPLACE).append(SP);
            } else {
                this.addPrompt(stringBuffer, CREATE, "TYPE SPEC", string3);
                stringBuffer.append(CREATE).append(SP);
            }
            stringBuffer.append(string2);
            stringBuffer.append(NEWLINE).append(SLASH).append(NEWLINE);
            ddl.put(SPEC, stringBuffer.toString());
        } else if (sourceObject instanceof DeclarativePlSql && (string = (declarativePlSql = (DeclarativePlSql)((Object)sourceObject)).getBody()) != null) {
            DataType dataType;
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = bl ? CREATE_OR_REPLACE : CREATE;
            this.addPrompt(stringBuffer, string4, "TYPE SPEC", string3);
            stringBuffer.append(string4).append(SP).append(sourceObject.getType()).append(SP).append(string3);
            PlSqlParameter[] plSqlParameterArray = declarativePlSql.getParameters();
            if (plSqlParameterArray != null && plSqlParameterArray.length > 0) {
                stringBuffer.append(NEWLINE).append(LPAREN);
                OracleDDLGenerator.convertParam(stringBuffer, plSqlParameterArray[0]);
                int n = 1;
                while (n < plSqlParameterArray.length) {
                    stringBuffer.append(COMMA);
                    OracleDDLGenerator.convertParam(stringBuffer, plSqlParameterArray[n]);
                    ++n;
                }
                stringBuffer.append(RPAREN);
            }
            if ((dataType = declarativePlSql.getReturnType()) != null) {
                stringBuffer.append(NEWLINE).append(RETURN).append(SP);
                stringBuffer.append(dataType.getName());
            }
            stringBuffer.append(SP).append(AS).append(NEWLINE);
            stringBuffer.append(string);
            ddl.put(SPEC, stringBuffer.toString());
        }
        return ddl;
    }

    private static void convertParam(StringBuffer stringBuffer, PlSqlParameter plSqlParameter) {
        stringBuffer.append(plSqlParameter.getName());
        PlSqlParameter.Mode mode = plSqlParameter.getMode();
        if (mode != null) {
            stringBuffer.append(SP).append((Object)mode);
        }
        DataType dataType = plSqlParameter.getDataType();
        stringBuffer.append(SP).append(dataType.getName());
        String string = plSqlParameter.getDefaultValue();
        if (ModelUtil.hasLength((String)string)) {
            stringBuffer.append(SP).append(DEFAULT).append(SP).append(string);
        }
    }

    private Ddl createSpecAndBody(SpecPlSql specPlSql, boolean bl) {
        String string = this.getSchemaDotName(specPlSql);
        Ddl ddl = this.createSourceObject(specPlSql, bl);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = specPlSql.getBodySource();
        if (ModelUtil.hasLength((String)string2)) {
            if (bl) {
                this.addPrompt(stringBuffer, CREATE_OR_REPLACE, "TYPE BODY", string);
                stringBuffer.append(CREATE_OR_REPLACE).append(SP);
            } else {
                this.addPrompt(stringBuffer, CREATE, "TYPE BODY", string);
                stringBuffer.append(CREATE).append(SP);
            }
            stringBuffer.append(string2);
            stringBuffer.append(NEWLINE).append(SLASH).append(NEWLINE);
            ddl.put(BODY, stringBuffer.toString());
        }
        return ddl;
    }

    private void createIncompleteType(boolean bl, String string, Ddl ddl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(CREATE_OR_REPLACE).append(SP);
        } else {
            stringBuffer.append(CREATE).append(SP);
        }
        stringBuffer.append(TYPE).append(SP);
        stringBuffer.append(string).append(SEMICOLON);
        stringBuffer.append(NEWLINE).append(SLASH).append(NEWLINE);
        ddl.put("INCOMPLETE", stringBuffer.toString());
    }

    private Ddl createDatabaseLink(DatabaseLink databaseLink) {
        StringBuffer stringBuffer = new StringBuffer("CREATE ");
        if (databaseLink.isShared()) {
            stringBuffer.append(SHARED).append(SP);
        }
        if (databaseLink.isPublic()) {
            stringBuffer.append(PUBLIC).append(SP);
        }
        stringBuffer.append(DATABASE).append(SP).append(LINK).append(SP).append(DQ).append(databaseLink.getName()).append(DQ);
        if (databaseLink.getUsername() != null || databaseLink.isCurrentUser()) {
            stringBuffer.append(SP).append(CONNECT).append(SP).append(TO).append(SP);
            if (databaseLink.isCurrentUser()) {
                stringBuffer.append(CURRENT_USER);
            } else {
                stringBuffer.append(databaseLink.getUsername()).append(SP).append(IDENTIFIED).append(SP).append(BY).append(SP).append(databaseLink.getPassword());
            }
        }
        stringBuffer.append(this.getAuthentification(databaseLink));
        if (ModelUtil.hasLength((String)databaseLink.getHost())) {
            stringBuffer.append(SP).append(USING).append(SP).append("'" + databaseLink.getHost() + "'");
        }
        Ddl ddl = new Ddl();
        ddl.put("DATABASELINK", stringBuffer.toString());
        return ddl;
    }

    private String getAuthentification(DatabaseLink databaseLink) {
        StringBuffer stringBuffer = new StringBuffer();
        if (databaseLink.isShared()) {
            stringBuffer.append(SP).append(AUTHENTICATED).append(SP).append(BY).append(SP).append(databaseLink.getAuthentificationUser()).append(SP).append(IDENTIFIED).append(SP).append(BY).append(SP).append(databaseLink.getAuthentificationPassword());
        }
        return stringBuffer.toString();
    }

    protected final class MaterializedViewDDLHelper {
        private MaterializedView _mview;

        public MaterializedViewDDLHelper(MaterializedView materializedView) {
            if (materializedView == null) {
                throw new IllegalStateException("Null materialized view passed into MaterializedViewDDLHelper class");
            }
            this._mview = materializedView;
        }

        public final String getUsingIndexDDL(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(OracleDDLGenerator.USING).append(OracleDDLGenerator.SP);
            if (this._mview.isUseNoIndex()) {
                if (!bl) {
                    stringBuffer.append(OracleDDLGenerator.NO).append(OracleDDLGenerator.SP);
                    stringBuffer.append(OracleDDLGenerator.INDEX).append(OracleDDLGenerator.NEWLINE);
                }
            } else {
                stringBuffer.append(OracleDDLGenerator.INDEX).append(OracleDDLGenerator.SP);
                if (!bl) {
                    stringBuffer.append(this.getTablespaceDDL());
                    stringBuffer.append(this.getIndexPercentFreeDDL());
                    stringBuffer.append(this.getIndexExtentDDL());
                }
                stringBuffer.append(this.getIndexInitTransDDL());
                stringBuffer.append(OracleDDLGenerator.NEWLINE);
            }
            return stringBuffer.toString();
        }

        public final String getRefreshDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getRefreshMode() == 3) {
                stringBuffer.append(OracleDDLGenerator.NEVER_REFRESH).append(OracleDDLGenerator.NEWLINE);
            } else {
                stringBuffer.append(OracleDDLGenerator.REFRESH).append(OracleDDLGenerator.SP);
                stringBuffer.append(this.getDemandCommitDDL());
                stringBuffer.append(this.getStartWithDDL());
                stringBuffer.append(this.getIntervalDDL());
                stringBuffer.append(this.getRefreshMethodDDL());
                stringBuffer.append(this.getPKRowIdDDL());
                stringBuffer.append(this.getUsingDDL());
                stringBuffer.append(OracleDDLGenerator.NEWLINE);
            }
            return stringBuffer.toString();
        }

        public final String getCacheDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.isCache()) {
                stringBuffer.append(OracleDDLGenerator.CACHE).append(OracleDDLGenerator.SP);
            } else {
                stringBuffer.append(OracleDDLGenerator.NOCACHE).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getParallelDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this._mview.getParallel();
            if (n > 0) {
                stringBuffer.append(OracleDDLGenerator.PARALLEL).append(OracleDDLGenerator.SP);
                stringBuffer.append(n).append(OracleDDLGenerator.SP);
            } else {
                stringBuffer.append(OracleDDLGenerator.NOPARALLEL).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getTablespaceDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (ModelUtil.hasLength((String)this._mview.getTablespace())) {
                stringBuffer.append(OracleDDLGenerator.TABLESPACE).append(OracleDDLGenerator.SP);
                stringBuffer.append(this._mview.getTablespace()).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getIndexPercentFreeDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getIndexPercentFree() >= 0) {
                stringBuffer.append(OracleDDLGenerator.PCTFREE).append(OracleDDLGenerator.SP);
                stringBuffer.append(this._mview.getIndexPercentFree()).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getIndexInitTransDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getIndexInitTrans() >= 1) {
                stringBuffer.append(OracleDDLGenerator.INITRANS).append(OracleDDLGenerator.SP);
                stringBuffer.append(this._mview.getIndexInitTrans()).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getIndexExtentDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getIndexMinExtent() >= 1 || this._mview.getIndexMaxExtent() >= 1) {
                stringBuffer.append(OracleDDLGenerator.STORAGE).append(OracleDDLGenerator.LPAREN);
                if (this._mview.getIndexMinExtent() > 1) {
                    stringBuffer.append(OracleDDLGenerator.MINEXTENTS).append(OracleDDLGenerator.SP);
                    stringBuffer.append(this._mview.getIndexMinExtent()).append(OracleDDLGenerator.SP);
                }
                if (this._mview.getIndexMaxExtent() > 1) {
                    stringBuffer.append(OracleDDLGenerator.MAXEXTENTS).append(OracleDDLGenerator.SP);
                    stringBuffer.append(this._mview.getIndexMaxExtent()).append(OracleDDLGenerator.SP);
                }
                stringBuffer.append(OracleDDLGenerator.RPAREN).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getDemandCommitDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getRefreshMode() == 1) {
                stringBuffer.append(OracleDDLGenerator.ON).append(OracleDDLGenerator.SP).append(OracleDDLGenerator.COMMIT).append(OracleDDLGenerator.SP);
            } else if (this._mview.getRefreshMode() == 0) {
                stringBuffer.append(OracleDDLGenerator.ON).append(OracleDDLGenerator.SP).append(OracleDDLGenerator.DEMAND).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getStartWithDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getRefreshMode() == 2 && ModelUtil.hasLength((String)this._mview.getNextRefresh())) {
                stringBuffer.append(OracleDDLGenerator.START).append(OracleDDLGenerator.SP).append(OracleDDLGenerator.WITH).append(OracleDDLGenerator.SP);
                stringBuffer.append(this._mview.getNextRefresh()).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getIntervalDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getRefreshMode() == 2 && ModelUtil.hasLength((String)this._mview.getInterval())) {
                stringBuffer.append(OracleDDLGenerator.NEXT).append(OracleDDLGenerator.SP).append(this._mview.getInterval()).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getRefreshMethodDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getRefreshMethod() == 2) {
                stringBuffer.append(OracleDDLGenerator.FAST).append(OracleDDLGenerator.SP);
            } else if (this._mview.getRefreshMethod() == 0) {
                stringBuffer.append(OracleDDLGenerator.COMPLETE).append(OracleDDLGenerator.SP);
            } else if (this._mview.getRefreshMethod() == 1) {
                stringBuffer.append(OracleDDLGenerator.FORCE).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getPKRowIdDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._mview.getKeyType() == 1) {
                stringBuffer.append(OracleDDLGenerator.NEWLINE).append(OracleDDLGenerator.WITH).append(OracleDDLGenerator.SP);
                stringBuffer.append(OracleDDLGenerator.PRIMARY).append(OracleDDLGenerator.SP).append(OracleDDLGenerator.KEY).append(OracleDDLGenerator.SP);
            } else if (this._mview.getKeyType() == 2) {
                stringBuffer.append(OracleDDLGenerator.NEWLINE).append(OracleDDLGenerator.WITH).append(OracleDDLGenerator.SP);
                stringBuffer.append(OracleDDLGenerator.ROWID).append(OracleDDLGenerator.SP);
            }
            return stringBuffer.toString();
        }

        public final String getUsingDDL() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (this._mview.getRollbackSegmentType() != 0) {
                String string = this._mview.getRollbackSegmentName();
                String string2 = this._mview.getRollbackSegmentType() == 1 ? OracleDDLGenerator.LOCAL : OracleDDLGenerator.MASTER;
                stringBuffer.append(OracleDDLGenerator.USING).append(OracleDDLGenerator.SP);
                bl = true;
                if (!ModelUtil.hasLength((String)string) || OracleDDLGenerator.DEFAULT.equals(string)) {
                    stringBuffer.append(OracleDDLGenerator.DEFAULT).append(OracleDDLGenerator.SP);
                    stringBuffer.append(string2).append(OracleDDLGenerator.SP);
                    stringBuffer.append(OracleDDLGenerator.ROLLBACK_SEGMENT).append(OracleDDLGenerator.SP);
                } else {
                    stringBuffer.append(string2).append(OracleDDLGenerator.SP);
                    stringBuffer.append(OracleDDLGenerator.ROLLBACK_SEGMENT).append(OracleDDLGenerator.SP);
                    stringBuffer.append(string).append(OracleDDLGenerator.SP);
                }
            }
            if (this._mview.isUsingTrustedConstraints() != null) {
                if (this._mview.isUsingTrustedConstraints().booleanValue()) {
                    if (!bl) {
                        stringBuffer.append(OracleDDLGenerator.USING).append(OracleDDLGenerator.SP);
                    }
                    stringBuffer.append(OracleDDLGenerator.TRUSTED).append(OracleDDLGenerator.SP);
                    stringBuffer.append(OracleDDLGenerator.CONSTRAINTS).append(OracleDDLGenerator.SP);
                } else {
                    if (!bl) {
                        stringBuffer.append(OracleDDLGenerator.USING).append(OracleDDLGenerator.SP);
                    }
                    stringBuffer.append(OracleDDLGenerator.ENFORCED).append(OracleDDLGenerator.SP);
                    stringBuffer.append(OracleDDLGenerator.CONSTRAINTS).append(OracleDDLGenerator.SP);
                }
            }
            return stringBuffer.toString();
        }
    }
}

