/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;

public class OracleDatabaseDescriptor
extends DatabaseDescriptor {
    private static final int MAX_NAME_LEN = 30;
    private static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "DUAL", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));

    public int getCasePolicy() {
        return 2;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        OracleDatabaseDescriptor.validateIdentifier(string, string2);
    }

    private static void validateIdentifier(String string, String string2) throws InvalidNameException {
        String string3 = null;
        string3 = string != null && string.equals("DATABASE LINK") ? "_$#." : "_$#";
        OracleDatabaseDescriptor.validateIdentifier(string2.trim(), '\"', 30, string3, true, RESERVED_WORDS, 2);
    }

    public static boolean isValidOracleIdentifier(String string) {
        try {
            OracleDatabaseDescriptor.validateIdentifier(null, string);
        }
        catch (InvalidNameException invalidNameException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }
}

