/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.ModelUtil;

public class OracleDatabaseFactory
extends DatabaseFactory {
    private static boolean _autocommit = true;
    private DatabaseDescriptor m_descriptor;
    private static final OracleDatabaseFactory s_instance = new OracleDatabaseFactory();
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";

    public static final OracleDatabaseFactory getInstance() {
        return s_instance;
    }

    private OracleDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new OracleLite.Registerer(), OracleLite.class);
        dataTypeRegistry.registerProvider(new OracleDatabaseImpl.Registerer(), OracleDatabaseImpl.class);
        dataTypeRegistry.registerProvider(new Oracle8.Registerer(), Oracle8.class);
        dataTypeRegistry.registerProvider(new Oracle8i.Registerer(), Oracle8i.class);
        dataTypeRegistry.registerProvider(new Oracle9i.Registerer(), Oracle9i.class);
        dataTypeRegistry.registerProvider(new Oracle9iR2.Registerer(), Oracle9iR2.class);
        dataTypeRegistry.registerProvider(new Oracle10g.Registerer(), Oracle10g.class);
        dataTypeRegistry.registerProvider(new Oracle10gR2.Registerer(), Oracle10gR2.class);
        dataTypeRegistry.registerProvider(new Oracle10gR2XE.Registerer(), Oracle10gR2XE.class);
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (OracleDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new OracleDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }

    public Database createDatabaseImpl(String string, Connection connection) {
        BaseOracleDatabase baseOracleDatabase = null;
        switch (OracleDatabaseFactory.getType(connection)) {
            case -1: {
                baseOracleDatabase = null;
                break;
            }
            case 1: {
                baseOracleDatabase = new Oracle8(string, connection);
                break;
            }
            case 2: {
                baseOracleDatabase = new Oracle8i(string, connection);
                break;
            }
            case 3: {
                baseOracleDatabase = new Oracle9i(string, connection);
                break;
            }
            case 4: {
                baseOracleDatabase = new Oracle9iR2(string, connection);
                break;
            }
            case 5: {
                baseOracleDatabase = new Oracle10g(string, connection);
                break;
            }
            case 6: {
                baseOracleDatabase = new Oracle10gR2(string, connection);
                break;
            }
            case 7: {
                baseOracleDatabase = new Oracle10gR2XE(string, connection);
                break;
            }
            case 8: {
                baseOracleDatabase = new OracleLite(string, connection);
                break;
            }
            default: {
                baseOracleDatabase = new OracleDatabaseImpl(string, connection);
            }
        }
        if (baseOracleDatabase != null) {
            this.initDB(baseOracleDatabase);
        }
        return baseOracleDatabase;
    }

    private void initDB(Database database) {
        Connection connection = database.getConnection();
        try {
            connection.setAutoCommit(_autocommit);
        }
        catch (SQLException sQLException) {
            DBUtil.getLog().trace(sQLException.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean bl) {
        _autocommit = bl;
    }

    public static boolean isDefaultAutocommit() {
        return _autocommit;
    }

    public static boolean isOracleDatabase(Connection connection) {
        int n = OracleDatabaseFactory.getType(connection);
        return n > -1 && n <= 7;
    }

    private static boolean isExpressEdition(String string) {
        return string.indexOf("Express Edition") >= 0;
    }

    private static int getType(Connection connection) {
        int n = -1;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (ModelUtil.hasLength((String)string)) {
                    if (string.startsWith("Oracle Lite") || string.startsWith("Oracle9i Lite")) {
                        n = 8;
                    } else if (string.startsWith("Personal Oracle") || string.startsWith("Oracle") && !string.startsWith("Oracle Rdb")) {
                        n = 0;
                        String string2 = databaseMetaData.getDatabaseProductVersion();
                        int[] nArray = OracleDatabaseFactory.getOracleMajorMinorVersion(string2);
                        if (nArray != null && nArray.length == 2) {
                            int n2 = nArray[0];
                            int n3 = nArray[1];
                            if (n2 < 8) {
                                n = 0;
                            } else if (n2 == 8) {
                                n = n3 >= 1 ? 2 : 1;
                            } else if (n2 == 9) {
                                n = n3 >= 2 ? 4 : 3;
                            } else if (n2 > 9) {
                                n = n3 < 2 ? 5 : (OracleDatabaseFactory.isExpressEdition(string2) ? 7 : 6);
                            }
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n;
    }

    public static int[] getOracleMajorMinorVersion(String string) {
        if (ModelUtil.hasLength((String)string)) {
            String string2;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(string);
            String string3 = string2 = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)string2)) {
                int n = 8;
                int n2 = 0;
                int n3 = string2.indexOf(46);
                if (n3 != -1) {
                    try {
                        n = Integer.parseInt(string2.substring(0, n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int n4 = n3 + 1;
                    n3 = string2.indexOf(46, n4);
                    if (n3 != -1) {
                        try {
                            n2 = Integer.parseInt(string2.substring(n4, n3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                return new int[]{n, n2};
            }
        }
        return null;
    }
}

