/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DateDataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.OracleTriggerBuilder;
import oracle.javatools.db.ora.PlSqlSourceBuilder;
import oracle.javatools.db.ora.TopLevelObjectID;
import oracle.javatools.db.validators.PackageValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.util.ModelUtil;

public class OracleDatabaseImpl
extends BaseOracleDatabase {
    private static final String PRIVS_QUERY = "SELECT PRIVILEGE FROM SESSION_PRIVS";
    private static final String PARTITIONING_QUERY = "SELECT VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'";
    private Boolean m_partitioning;
    private static String[] ENTERPRISE_QUERIES = new String[]{"SELECT STATUS FROM SYS.ALL_OBJECTS WHERE  OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ?", "SELECT OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE  OWNER = ? AND OBJECT_NAME LIKE ? AND OBJECT_TYPE = ?", "SELECT TABLE_NAME, 'TABLE' FROM SYS.ALL_INDEXES WHERE  OWNER = ? AND INDEX_NAME = ? ", "SELECT TABLE_NAME, 'TABLE' FROM SYS.ALL_TRIGGERS WHERE  OWNER = ? AND TRIGGER_NAME = ? ", "SELECT TO_DATE(TIMESTAMP, 'YYYY-MM-DD:HH24:MI:SS') FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ?"};
    private static final String QUERY_OBJECT_EXISTS = "SELECT OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ?";
    private static final String QUERY_JAVA_EXISTS = "SELECT OBJECT_NAME FROM JAVASNM, SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = SHORT(+) AND NVL(LONGNAME,OBJECT_NAME) = ? AND OBJECT_TYPE = ?";
    private static final String QUERY_MAIN_OBJECT_NAMESPACE = "SELECT OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_TYPE IN ( 'TABLE', 'VIEW', 'SEQUENCE', 'PACKAGE', 'PROCEDURE', 'FUNCTION', 'TYPE', 'SYNONYM' ) AND OBJECT_NAME LIKE ?";
    private static final String VALIDATE_MAIN_OBJECT_NAMESPACE = "SELECT OBJECT_NAME, OBJECT_TYPE FROM   SYS.ALL_OBJECTS WHERE  OWNER = ? AND    OBJECT_NAME = ? AND    OBJECT_TYPE IN ( 'TABLE', 'VIEW', 'SEQUENCE', 'PACKAGE', 'PROCEDURE', 'FUNCTION', 'TYPE', 'SYNONYM' )";
    private static final String TIMESTAMP_BY_ID = "SELECT TO_DATE(TIMESTAMP, 'YYYY-MM-DD:HH24:MI:SS') FROM SYS.ALL_OBJECTS WHERE OBJECT_ID = ?";

    OracleDatabaseImpl(Connection connection) {
        this(null, connection);
    }

    OracleDatabaseImpl(String string, Connection connection) {
        super(string, connection);
        this.setDDLGenerator(this.createDDLGenerator());
        HashSet<String> hashSet = new HashSet<String>();
        Schema schema = this.getCurrentSchema();
        schema.setProperty("USER PRIVS", hashSet);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                this.sqlTrace(PRIVS_QUERY);
                resultSet = statement.executeQuery(PRIVS_QUERY);
                while (resultSet.next()) {
                    hashSet.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {}
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getOracleDatabaseType() {
        return 0;
    }

    public String getDatabaseType() {
        return "Oracle Database";
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        if (this.m_partitioning == null) {
            this.checkPartitioning();
        }
        return this.m_partitioning;
    }

    private void checkPartitioning() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                this.sqlTrace(PARTITIONING_QUERY);
                resultSet = statement.executeQuery(PARTITIONING_QUERY);
                if (resultSet.next()) {
                    this.m_partitioning = Boolean.valueOf(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.logStackTrace(sQLException);
                this.m_partitioning = Boolean.FALSE;
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getTimestampQuery() {
        return TIMESTAMP_BY_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getExternalTimestampByID(DBObjectID dBObjectID) throws DBException {
        Long l = null;
        if (dBObjectID instanceof TopLevelObjectID) {
            Connection connection;
            TopLevelObjectID topLevelObjectID = (TopLevelObjectID)dBObjectID;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Connection connection2 = connection = this.getConnection();
            synchronized (connection2) {
                try {
                    try {
                        Timestamp timestamp;
                        String string = this.getTimestampQuery();
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setInt(1, topLevelObjectID.getID());
                        this.sqlTrace(string, new Integer[]{new Integer(topLevelObjectID.getID())});
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)) != null) {
                            l = new Long(timestamp.getTime());
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (dBObjectID instanceof BaseObjectID) {
            BaseObjectID baseObjectID = (BaseObjectID)dBObjectID;
            l = this.getExternalTimestampByName(baseObjectID.getType(), baseObjectID.getSchema(), baseObjectID.getName());
        }
        return l;
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TRIGGER", new OracleTriggerBuilder(this));
        this.registerBuilder("FUNCTION", new PlSqlSourceBuilder(this, "FUNCTION"));
        this.registerBuilder("PROCEDURE", new PlSqlSourceBuilder(this, "PROCEDURE"));
        this.registerBuilder("PACKAGE", new PlSqlSourceBuilder(this, "PACKAGE"));
    }

    protected void registerValidators() {
        super.registerValidators();
        this.registerValidator("PACKAGE", new PackageValidator(this));
        this.registerValidator("PROCEDURE", new PlSqlValidator(this));
        this.registerValidator("FUNCTION", new PlSqlValidator(this));
    }

    protected DDLGenerator createDDLGenerator() {
        return new OracleDDLGenerator(this);
    }

    protected boolean hasPrivilege(String string) {
        Set set = (Set)this.getCurrentSchema().getProperty("USER PRIVS");
        return set != null && set.contains(string);
    }

    public void close() {
        super.close();
    }

    protected DBObjectID createID(Schema schema, String string, String string2, int n) {
        if (n == 0) {
            return BaseObjectID.createObjectID(schema, string, string2, this);
        }
        return TopLevelObjectID.createObjectID(n, string2, this);
    }

    protected String getStandardQuery(String[] stringArray) {
        return "SELECT OBJECT_NAME, OBJECT_TYPE, OBJECT_ID FROM SYS.ALL_OBJECTS WHERE OWNER = ''{0}'' AND   OBJECT_NAME LIKE ''{1}'' AND   OBJECT_TYPE IN ({2}) AND   SUBOBJECT_NAME IS NULL ";
    }

    protected boolean isCustomQuery(String string, Schema schema) {
        if (string.equals("INDEX")) {
            return ModelUtil.areDifferent((Object)this.getUserName(), (Object)schema.getName());
        }
        return string.equals("TABLE") || super.isCustomQuery(string, schema);
    }

    protected String getCustomQuery(String string) {
        if (string.equals("TABLE")) {
            return "SELECT O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID FROM SYS.ALL_OBJECTS O WHERE O.OWNER = ''{0}'' AND   O.OBJECT_TYPE = ''TABLE'' AND   O.OBJECT_NAME LIKE ''{1}'' AND   O.GENERATED = ''N'' AND NOT EXISTS (SELECT 1 FROM SYS.ALL_MVIEWS WHERE MVIEW_NAME = O.OBJECT_NAME AND OWNER = O.OWNER) ";
        }
        if (string.equals("INDEX")) {
            return " SELECT INDEX_NAME, ''INDEX'', null FROM SYS.ALL_INDEXES  WHERE OWNER = ''{0}'' AND INDEX_NAME LIKE ''{1}'' ";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SchemaObject createByIDImpl(DBObjectID dBObjectID) throws DBException {
        AbstractSchemaObject abstractSchemaObject = null;
        if (dBObjectID instanceof TopLevelObjectID) {
            TopLevelObjectID topLevelObjectID = (TopLevelObjectID)dBObjectID;
            String string = topLevelObjectID.getType();
            DBObjectBuilder dBObjectBuilder = this.getBuilderForType(string);
            if (dBObjectBuilder != null) {
                Connection connection;
                String string2 = this.getIDQuery(string);
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                Connection connection2 = connection = this.getConnection();
                synchronized (connection2) {
                    try {
                        try {
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setInt(1, topLevelObjectID.getID());
                            this.sqlTrace(string2, new Object[]{new Integer(topLevelObjectID.getID())});
                            resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                Schema schema = this.getSchema(resultSet.getString(1));
                                String string3 = resultSet.getString(2);
                                abstractSchemaObject = (AbstractSchemaObject)dBObjectBuilder.createObject(string3, schema, dBObjectID);
                                if ("SYNONYM".equals(string)) {
                                    DBObjectID dBObjectID2 = this.createSynonymRefID(this.getSchema(resultSet.getString(3)), resultSet.getString(4), resultSet.getString(5), resultSet.getInt(6));
                                    ((Synonym)abstractSchemaObject).setReference(dBObjectID2);
                                } else {
                                    abstractSchemaObject.setID(dBObjectID);
                                    this.markForLazyInit(abstractSchemaObject);
                                }
                                this.cacheObject(abstractSchemaObject);
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new DBException(sQLException);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        } else {
            abstractSchemaObject = (AbstractSchemaObject)super.createByIDImpl(dBObjectID);
        }
        return abstractSchemaObject;
    }

    protected DBObjectID createSynonymRefID(Schema schema, String string, String string2, int n) {
        if (n == 0) {
            return new NameBasedRefID(schema, string);
        }
        return this.createID(schema, string, string2, n);
    }

    protected String getIDQuery(String string) {
        return "SYNONYM".equals(string) ? "SELECT S.OWNER, S.SYNONYM_NAME, O2.OWNER, O2.OBJECT_NAME, O2.OBJECT_TYPE, O2.OBJECT_ID FROM SYS.ALL_OBJECTS O, SYS.ALL_OBJECTS O2, SYS.ALL_SYNONYMS S WHERE O.OBJECT_ID = ? AND S.OWNER = O.OWNER AND S.SYNONYM_NAME = O.OBJECT_NAME AND S.TABLE_OWNER = O2.OWNER AND S.TABLE_NAME = O2.OBJECT_NAME AND O2.OBJECT_TYPE IN ( 'PACKAGE', 'FUNCTION', 'PROCEDURE', 'TABLE', 'VIEW', 'TYPE' )" : "SELECT OWNER, OBJECT_NAME, NULL, NULL, NULL, -1 FROM SYS.ALL_OBJECTS WHERE OBJECT_ID = ?";
    }

    protected PreparedStatement getStatement(Connection connection, int n, String string, String string2) throws SQLException {
        return this.getStatement(connection, ENTERPRISE_QUERIES[n], string, string2, null);
    }

    protected PreparedStatement getStatement(Connection connection, int n, String string, String string2, String string3) throws SQLException {
        return this.getStatement(connection, ENTERPRISE_QUERIES[n], string, string2, string3);
    }

    protected PreparedStatement getQueryExistsStatement(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = string3.equals("JAVA SOURCE") || string3.equals("JAVA CLASS") || string3.equals("JAVA RESOURCE") ? QUERY_JAVA_EXISTS : QUERY_OBJECT_EXISTS;
        this.sqlTrace(string4, new Object[]{string, string2, string3});
        return this.getStatement(connection, string4, string, string2, string3);
    }

    protected PreparedStatement getQueryMainNamespaceStatement(Connection connection, String string, String string2) throws SQLException {
        return this.getStatement(connection, QUERY_MAIN_OBJECT_NAMESPACE, string, string2);
    }

    protected PreparedStatement getValidateMainNamespaceStatement(Connection connection, String string, String string2) throws SQLException {
        return this.getStatement(connection, VALIDATE_MAIN_OBJECT_NAMESPACE, string, string2);
    }

    private PreparedStatement getStatement(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        if (string4 != null) {
            preparedStatement.setString(3, string4.toUpperCase());
        }
        this.sqlTrace(string, new Object[]{string2, string3, string4});
        return preparedStatement;
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            NumericDataType.MinMaxValue minMaxValue = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);
            NumericDataType.MinMaxValue minMaxValue2 = new NumericDataType.MinMaxValue("-99999999999999999999999999999999999999", "99999999999999999999999999999999999999", 0);
            OracleNumberDataType oracleNumberDataType = new OracleNumberDataType(1);
            NumericDataType numericDataType = new NumericDataType(1, "FLOAT", "FLOAT[(<precision>)]", 1L, 126, new Long(126), false, null, minMaxValue);
            CharacterDataType characterDataType = new CharacterDataType(1, "VARCHAR2", "VARCHAR2(<size>)", 1L, 4000L, 4000L, true, null);
            CharacterDataType characterDataType2 = new CharacterDataType(1, "CHAR", "CHAR[(<size>)]", 1L, 2000L, 1L, false, null);
            CharacterDataType characterDataType3 = new CharacterDataType(1, "LONG", 1L, Integer.MAX_VALUE);
            BinaryDataType binaryDataType = new BinaryDataType(1, "RAW", "RAW(<size>)", 1L, 2000L, 2000L, true, null);
            BinaryDataType binaryDataType2 = new BinaryDataType(1, "LONG RAW", 1L, Integer.MAX_VALUE);
            PredefinedDataType predefinedDataType = new PredefinedDataType(1, "ROWID");
            DateDataType dateDataType = new DateDataType(1, "DATE");
            dataTypeRegistry.registerDataType(characterDataType2, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dataTypeRegistry.registerDataType(dateDataType, OracleDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dataTypeRegistry.registerDataType(numericDataType, OracleDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(characterDataType3, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dataTypeRegistry.registerDataType(binaryDataType2, OracleDatabaseImpl.class);
            dataTypeRegistry.registerDataType(oracleNumberDataType, OracleDatabaseImpl.class, JdbcDatabase.ANSI_NUMERIC);
            dataTypeRegistry.registerDataType(binaryDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerDataType(predefinedDataType, OracleDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dataTypeRegistry.registerDataType(characterDataType, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dataTypeRegistry.registerSynonym("CHARACTER", (DataType)characterDataType2, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHAR VARYING", (DataType)characterDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHARACTER VARYING", (DataType)characterDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("LONG VARCHAR", (DataType)characterDataType3, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("VARCHAR", (DataType)characterDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("DEC", (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("DECIMAL", (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NUMERIC", (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            NumericDataType numericDataType2 = new NumericDataType(1, "INT", minMaxValue2);
            NumericDataType numericDataType3 = new NumericDataType(1, "INTEGER", minMaxValue2);
            NumericDataType numericDataType4 = new NumericDataType(1, "SMALLINT", minMaxValue2);
            NumericDataType numericDataType5 = new NumericDataType(1, "REAL", minMaxValue);
            NumericDataType numericDataType6 = new NumericDataType(1, "DOUBLE PRECISION", minMaxValue);
            dataTypeRegistry.registerSynonym(numericDataType2, (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym(numericDataType3, (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym(numericDataType4, (DataType)oracleNumberDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym(numericDataType5, (DataType)numericDataType, OracleDatabaseImpl.class);
            dataTypeRegistry.registerSynonym(numericDataType6, (DataType)numericDataType, OracleDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

