/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class OracleExternalTableProperties
implements Copyable {
    public static final String KEY = "OracleExternalTableProperties";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_LOADER = "ORACLE_LOADER";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_DATAPUMP = "ORACLE_DATAPUMP";
    public static final String REJECT_LIMIT_UNLIMITED = "UNLIMITED";
    private AccessType _accessParameterType;
    private DBObjectID _defaultDirectory;
    private String _accessDriverType;
    private Object _accessParameters;
    private String _rejectLimit;
    private ProjectColumn _projectColumn;
    private List<LocationSpecifier> _locationSpecifiers;

    void $init$() {
        this._accessParameterType = AccessType.BLOB;
        this._projectColumn = ProjectColumn.ALL;
        this._locationSpecifiers = new ArrayList<LocationSpecifier>();
    }

    public OracleExternalTableProperties() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        OracleExternalTableProperties oracleExternalTableProperties = object != null ? (OracleExternalTableProperties)object : new OracleExternalTableProperties();
        this.copyToImpl(oracleExternalTableProperties);
        return oracleExternalTableProperties;
    }

    public boolean equals(Object object) {
        return object instanceof OracleExternalTableProperties && this.equalsImpl((OracleExternalTableProperties)object);
    }

    public void setDefaultDirectory(DBObjectID dBObjectID) {
        this._defaultDirectory = dBObjectID;
    }

    public DBObjectID getDefaultDirectory() {
        return this._defaultDirectory;
    }

    public void setLocationSpecifiers(LocationSpecifier[] locationSpecifierArray) {
        this._locationSpecifiers.clear();
        int n = 0;
        while (n < locationSpecifierArray.length) {
            this._locationSpecifiers.add(locationSpecifierArray[n]);
            ++n;
        }
    }

    public LocationSpecifier[] getLocationSpecifiers() {
        return this._locationSpecifiers.toArray(new LocationSpecifier[this._locationSpecifiers.size()]);
    }

    public void addLocationSpecifier(LocationSpecifier locationSpecifier) {
        this._locationSpecifiers.add(locationSpecifier);
    }

    public void addLocationSpecifier(DBObjectID dBObjectID, String string) {
        this._locationSpecifiers.add(new LocationSpecifier(dBObjectID, string));
    }

    public void addLocationSpecifier(String string) {
        this._locationSpecifiers.add(new LocationSpecifier(string));
    }

    public void removeLocationSpecifier(LocationSpecifier locationSpecifier) {
        this._locationSpecifiers.remove(locationSpecifier);
    }

    public void removeAllLocationSpecifiers() {
        this._locationSpecifiers.clear();
    }

    public void setAccessDriverType(String string) {
        this._accessDriverType = string;
    }

    public String getAccessDriverType() {
        return this._accessDriverType;
    }

    public void setAccessParameterType(AccessType accessType) {
        this._accessParameterType = accessType;
    }

    public AccessType getAccessParameterType() {
        return this._accessParameterType;
    }

    public void setAccessParameters(Object object) {
        this._accessParameters = object;
    }

    public Object getAccessParameters() {
        return this._accessParameters;
    }

    public void setRejectLimit(String string) {
        this._rejectLimit = string;
    }

    public String getRejectLimit() {
        return this._rejectLimit;
    }

    public void setProjectColumn(ProjectColumn projectColumn) {
        this._projectColumn = projectColumn;
    }

    public ProjectColumn getProjectColumn() {
        return this._projectColumn;
    }

    public void validateDefaultDirectory(Table table) throws ValidationException {
        Directory directory = null;
        try {
            directory = this._defaultDirectory != null ? (Directory)this._defaultDirectory.resolveID() : null;
        }
        catch (DBException dBException) {
            throw new ValidationException((DBObject)table, dBException.getMessage());
        }
        if (directory == null) {
            throw new ValidationException((DBObject)table, DBArb.getString(188));
        }
    }

    public void validateLocationSpecifiers(Table table) throws ValidationException {
        if (this._locationSpecifiers.size() == 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(187));
        }
    }

    public void validateAccessDriverType(Table table) throws ValidationException {
        if (this._accessDriverType != null && !this._accessDriverType.equals(ACCESS_DRIVER_TYPE_ORACLE_LOADER) && !this._accessDriverType.equals(ACCESS_DRIVER_TYPE_ORACLE_DATAPUMP)) {
            throw new ValidationException((DBObject)table, DBArb.getString(181));
        }
    }

    public void validateAccessParameterType(Table table) throws ValidationException {
        if (this._accessParameterType != AccessType.BLOB && this._accessParameterType != AccessType.CLOB) {
            throw new ValidationException((DBObject)table, DBArb.getString(182));
        }
    }

    public void validateAccessParameters(Table table) throws ValidationException {
        if (this._accessParameters != null) {
            if (this._accessParameters instanceof OpaqueFormatSpec) {
                ((OpaqueFormatSpec)this._accessParameters).validate(table);
            } else if (this._accessParameters instanceof SQLQuery) {
                // empty if block
            }
        }
    }

    public void validateRejectLimit(Table table) throws ValidationException {
        if (this._rejectLimit != null && !this._rejectLimit.equalsIgnoreCase(REJECT_LIMIT_UNLIMITED)) {
            try {
                Integer n = new Integer(this._rejectLimit);
                if (n == null || n < 0) {
                    throw new ValidationException((DBObject)table, DBArb.getString(183));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidationException((DBObject)table, DBArb.getString(183));
            }
        }
    }

    public void validateProjectColumn(Table table) throws ValidationException {
        if (this._projectColumn != null && this._projectColumn != ProjectColumn.ALL && this._projectColumn != ProjectColumn.REFERENCED) {
            throw new ValidationException((DBObject)table, DBArb.getString(184));
        }
    }

    public void validate(Table table) throws ValidationException {
        boolean bl;
        boolean bl2 = table.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
        boolean bl3 = bl = table.getProperty("NESTED TABLE") == Boolean.TRUE;
        if (bl2 || bl) {
            throw new ValidationException((DBObject)table, DBArb.format(169, "EXTERNAL TABLE", bl2 ? "PARTITIONED TABLE" : "NESTED TABLE"));
        }
        if (table.getConstraints().length != 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(185));
        }
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(columnArray[n].getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null && (dataType instanceof ComplexType || dataType.getName().startsWith("LONG"))) {
                throw new ValidationException((DBObject)table, DBArb.getString(186));
            }
            ++n;
        }
        this.validateDefaultDirectory(table);
        this.validateLocationSpecifiers(table);
        this.validateAccessParameterType(table);
        this.validateAccessParameters(table);
        this.validateAccessDriverType(table);
        this.validateRejectLimit(table);
        this.validateProjectColumn(table);
    }

    protected void copyToImpl(OracleExternalTableProperties oracleExternalTableProperties) {
        oracleExternalTableProperties._accessDriverType = this._accessDriverType;
        oracleExternalTableProperties._accessParameterType = this._accessParameterType;
        oracleExternalTableProperties._accessParameters = this._accessParameters;
        oracleExternalTableProperties._rejectLimit = this._rejectLimit;
        oracleExternalTableProperties._defaultDirectory = this._defaultDirectory;
        ModelUtil.deepCopy(this._locationSpecifiers, oracleExternalTableProperties._locationSpecifiers);
    }

    protected boolean equalsImpl(OracleExternalTableProperties oracleExternalTableProperties) {
        return ModelUtil.areEqual((Object)this._accessDriverType, (Object)oracleExternalTableProperties._accessDriverType) && ModelUtil.areEqual((Object)((Object)this._accessParameterType), (Object)((Object)oracleExternalTableProperties._accessParameterType)) && ModelUtil.areEqual((Object)this._accessParameters, (Object)oracleExternalTableProperties._accessParameters) && ModelUtil.areEqual((Object)this._rejectLimit, (Object)oracleExternalTableProperties._rejectLimit) && ModelUtil.areEqual((Object)this._defaultDirectory, (Object)oracleExternalTableProperties._defaultDirectory) && ModelUtil.areEqual(this._locationSpecifiers, oracleExternalTableProperties._locationSpecifiers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AccessType
    extends Enum {
        private static final /* synthetic */ AccessType[] $v;
        public static final /* enum */ AccessType BLOB;
        public static final /* enum */ AccessType CLOB;

        public static AccessType valueOf(String string) {
            return Enum.valueOf(AccessType.class, string);
        }

        public static final AccessType[] values() {
            return (AccessType[])$v.clone();
        }

        static {
            AccessType[] accessTypeArray = new AccessType[2];
            accessTypeArray[1] = CLOB = new AccessType();
            accessTypeArray[0] = BLOB = new AccessType();
            $v = accessTypeArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProjectColumn
    extends Enum {
        private static final /* synthetic */ ProjectColumn[] $v;
        public static final /* enum */ ProjectColumn ALL;
        public static final /* enum */ ProjectColumn REFERENCED;

        public static ProjectColumn valueOf(String string) {
            return Enum.valueOf(ProjectColumn.class, string);
        }

        public static final ProjectColumn[] values() {
            return (ProjectColumn[])$v.clone();
        }

        static {
            ProjectColumn[] projectColumnArray = new ProjectColumn[2];
            projectColumnArray[1] = REFERENCED = new ProjectColumn();
            projectColumnArray[0] = ALL = new ProjectColumn();
            $v = projectColumnArray;
        }
    }

    public static class LocationSpecifier
    implements Copyable {
        private DBObjectID _directory;
        private String _specifier;

        public LocationSpecifier() {
        }

        public LocationSpecifier(String string) {
            this._directory = null;
            this._specifier = string;
        }

        public LocationSpecifier(DBObjectID dBObjectID, String string) {
            this._directory = dBObjectID;
            this._specifier = string;
        }

        public Object copyTo(Object object) {
            LocationSpecifier locationSpecifier = object != null ? (LocationSpecifier)object : new LocationSpecifier();
            this.copyToImpl(locationSpecifier);
            return locationSpecifier;
        }

        protected void copyToImpl(LocationSpecifier locationSpecifier) {
            locationSpecifier._specifier = this._specifier;
            locationSpecifier._directory = this._directory;
        }

        public boolean equals(Object object) {
            return object instanceof LocationSpecifier && this.equalsImpl((LocationSpecifier)object);
        }

        protected boolean equalsImpl(LocationSpecifier locationSpecifier) {
            return ModelUtil.areEqual((Object)this._specifier, (Object)locationSpecifier._specifier) && ModelUtil.areEqual((Object)this._directory, (Object)locationSpecifier._directory);
        }

        public void setDirectory(DBObjectID dBObjectID) {
            this._directory = dBObjectID;
        }

        public DBObjectID getDirectory() {
            return this._directory;
        }

        public void setSpecifier(String string) {
            this._specifier = string;
        }

        public String getSpecifier() {
            return this._specifier;
        }
    }
}

