/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIndexProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleIndexBuilder
extends OracleDBObjectBuilder {
    private static String NORMAL;
    private static String DOMAIN;
    private static String CTXSYS;
    private static String CONTEXT;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = OracleIndexBuilder.class.desiredAssertionStatus() ^ true;
        NORMAL = "NORMAL";
        DOMAIN = "DOMAIN";
        CTXSYS = "CTXSYS";
        CONTEXT = "CONTEXT";
    }

    public OracleIndexBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "INDEX");
    }

    @Override
    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Index index = new Index(string, schema);
        index.setID(dBObjectID);
        return index;
    }

    protected boolean canBuildMultipleObjects() {
        return true;
    }

    @Override
    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Index index = (Index)schemaObject;
        SchemaObject schemaObject2 = this.getParent(index);
        if (schemaObject2 == null) {
            this.fillInLonelyIndex(index);
        } else if (schemaObject2 instanceof Table) {
            OracleTableBuilder oracleTableBuilder = (OracleTableBuilder)this.getDatabase().getBuilderForType("TABLE");
            oracleTableBuilder.buildObjectComponent((Table)schemaObject2, "INDEX");
        }
    }

    private SchemaObject getParent(Index index) throws DBException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper("SELECT TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ? ", index.getSchema(), index);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    BaseOracleDatabase baseOracleDatabase = this.getDatabase();
                    Schema schema = baseOracleDatabase.getSchema(string2);
                    SchemaObject schemaObject = baseOracleDatabase.getObject(string3, schema, string);
                    queryWrapper.close();
                    return schemaObject;
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
        return null;
    }

    private void fillInLonelyIndex(Index index) {
    }

    protected void fillInIndexes(SchemaObject schemaObject) throws DBException {
        HashMap<String, Index> hashMap = new HashMap<String, Index>();
        this.fillInBaseDefinitionsForTable(schemaObject, hashMap);
        if (hashMap.size() > 0) {
            this.fillInExpressionsForTable(schemaObject, hashMap);
            if (schemaObject instanceof Table) {
                Collection<Index> collection = hashMap.values();
                this.removeSystemIndexes((Table)schemaObject, collection);
                ((Table)schemaObject).setIndexes(collection.toArray(new Index[collection.size()]));
            }
        }
    }

    private void fillInBaseDefinitionsForTable(SchemaObject schemaObject, Map<String, Index> map) throws DBException {
        Schema schema = schemaObject.getSchema();
        String string = schema == null || schema.getName().equals(this.getDatabase().getUserName()) ? " SELECT i.INDEX_NAME, i.OWNER, (select object_id from all_objects where object_name = i.index_name and owner = i.owner) OBJECT_ID, i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME  FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?" : " SELECT i.INDEX_NAME, i.OWNER, null, i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME  FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? ";
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(string, schemaObject.getSchema(), schemaObject.getType(), schemaObject);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    Schema schema2 = this.getDatabase().getSchema(string3);
                    Index index = (Index)this.getDatabase().findObject("INDEX", schema2, string2);
                    if (index == null) {
                        int n = resultSet.getInt(3);
                        DBObjectID dBObjectID = this.getDatabase().createID(schema2, string2, "INDEX", n);
                        index = (Index)this.createObject(string2, schema2, dBObjectID);
                        this.getDatabase().cacheObject(index);
                    }
                    if (index == null) continue;
                    this.markAsBuilt(index);
                    String string4 = resultSet.getString(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6);
                    String string7 = resultSet.getString(7);
                    this.setIndexType(index, string4, string5, string6, string7);
                    if (schemaObject instanceof Table) {
                        index.setTable((Table)schemaObject);
                    }
                    map.put(string2, index);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    private void fillInExpressionsForTable(SchemaObject schemaObject, Map<String, Index> map) throws DBException {
        Object[] objectArray = new Object[]{schemaObject.getSchema(), schemaObject};
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(this.getIndexColumnQuery(), objectArray);
        try {
            try {
                Map<String, Map<Long, String>> map2 = null;
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    Constraint constraint;
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    Long l = new Long(resultSet.getInt(3));
                    String string3 = resultSet.getString(4);
                    Index index = map.get(string);
                    if (index == null) continue;
                    if (schemaObject instanceof Relation && (constraint = ((Relation)schemaObject).getConstraint(index.getName())) instanceof ColumnConstraint) {
                        Column[] columnArray = ((ColumnConstraint)constraint).getColumns();
                        IndexObject[] indexObjectArray = new IndexObject[columnArray.length];
                        int n = 0;
                        while (n < columnArray.length) {
                            indexObjectArray[n] = new IndexObject();
                            ColumnUsage columnUsage = new ColumnUsage(columnArray[n].getID());
                            indexObjectArray[n].setExpression(columnUsage);
                            ++n;
                        }
                        index.setColumnExpressions(indexObjectArray);
                        index = null;
                    }
                    if (index == null || !(schemaObject instanceof Relation)) continue;
                    SQLFragment sQLFragment = null;
                    if (resultSet.getInt(5) == 1) {
                        if (map2 == null) {
                            map2 = this.getIndexExpressionsForTable(schemaObject);
                        }
                        Map map3 = (Map)map2.get(string);
                        if (!($assertionsDisabled || map3 != null && map3.containsKey(l))) {
                            throw new AssertionError((Object)"Missing column expression");
                        }
                        sQLFragment = OracleIndexBuilder.createExpression((String)map3.get(l), (Relation)schemaObject);
                    } else {
                        sQLFragment = OracleIndexBuilder.createExpression(string2, (Relation)schemaObject);
                    }
                    IndexObject indexObject = new IndexObject(sQLFragment, string3);
                    index.addColumnExpression(indexObject);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    private Map<String, Map<Long, String>> getIndexExpressionsForTable(SchemaObject schemaObject) throws DBException {
        HashMap<String, Map<Long, String>> hashMap = new HashMap<String, Map<Long, String>>();
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper("SELECT index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ", schemaObject.getSchema(), schemaObject);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    Long l = new Long(resultSet.getInt(2));
                    String string2 = resultSet.getString(3);
                    HashMap<Long, String> hashMap2 = (HashMap<Long, String>)hashMap.get(string);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<Long, String>();
                        hashMap.put(string, hashMap2);
                    }
                    hashMap2.put(l, string2);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
        return hashMap;
    }

    public static SQLFragment createExpression(String string, Relation relation) {
        Column column = relation.getColumn(string);
        if (column != null && column.getID() != null) {
            return new ColumnUsage(column.getID());
        }
        return new SimpleSQLFragment(string);
    }

    private String getIndexColumnQuery() {
        int n = this.getDatabase().getOracleDatabaseType();
        return n == 8 ? "SELECT INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION" : "SELECT c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    }

    private void setIndexType(Index index, String string, String string2, String string3, String string4) {
        if ("BITMAP".equals(string)) {
            index.setIndexType(3);
        } else if ("UNIQUE".equals(string)) {
            index.setIndexType(2);
        } else if (string2 != null && string2.contains(NORMAL)) {
            index.setIndexType(1);
        } else if (DOMAIN.equals(string2)) {
            index.setIndexType(4);
            if (string3.equals(CTXSYS) && string4.equals(CONTEXT)) {
                OracleIndexProperties oracleIndexProperties = new OracleIndexProperties();
                index.setProperty("OracleIndexProperties", oracleIndexProperties);
                oracleIndexProperties.setIndexDomainType(1);
            }
        }
    }

    private void removeSystemIndexes(Relation relation, Collection<Index> collection) throws DBException {
        Iterator<Index> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Index index = iterator.next();
            Constraint constraint = relation.getConstraint(index.getName());
            if (constraint != null) {
                iterator.remove();
                continue;
            }
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            boolean bl = false;
            int n = 0;
            while (n < indexObjectArray.length && !bl) {
                String string;
                String string2 = string = indexObjectArray[n].getExpression() != null ? indexObjectArray[n].getExpression().getSQLText() : null;
                if (string != null) {
                    try {
                        PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(string, 2);
                        ParserUtils.checkErrors(plsqlRoot, string);
                        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
                        if (!$assertionsDisabled && plsqlNodeArray.length != 1) {
                            throw new AssertionError((Object)"Invalid expression parse");
                        }
                        Collection collection2 = ParserUtils.getColumnNames((SqlExpression)plsqlNodeArray[0]);
                        for (String string3 : collection2) {
                            if (!string3.startsWith("SYS_NC")) continue;
                            iterator.remove();
                            bl = true;
                            break;
                        }
                    }
                    catch (SQLQueryException sQLQueryException) {
                        throw new DBException((DBObject)index, DBArb.format(85, new Object[]{index.getName(), string}));
                    }
                }
                ++n;
            }
        }
    }
}

