/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class OracleIndexOrganizedTableProperties
implements Copyable {
    public static final String KEY = "OracleIndexOrganizedTableProperties";
    private Integer _pctThreshold;
    private boolean _mapped;
    private Integer _keyCompression;
    private DBObjectID _includeColumn;
    private boolean _overflowable;
    private OracleStorageProperties _overflowProperties;

    void $init$() {
        this._mapped = false;
        this._overflowable = false;
    }

    public OracleIndexOrganizedTableProperties() {
        this.$init$();
    }

    public OracleIndexOrganizedTableProperties(Integer n, boolean bl, Integer n2, DBObjectID dBObjectID, boolean bl2, OracleStorageProperties oracleStorageProperties) {
        this.$init$();
        this._pctThreshold = n;
        this._mapped = bl;
        this._keyCompression = n2;
        this._includeColumn = dBObjectID;
        this._overflowable = bl2;
        this._overflowProperties = oracleStorageProperties;
    }

    public Object copyTo(Object object) {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = object != null ? (OracleIndexOrganizedTableProperties)object : new OracleIndexOrganizedTableProperties();
        this.copyToImpl(oracleIndexOrganizedTableProperties);
        return oracleIndexOrganizedTableProperties;
    }

    protected void copyToImpl(OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) {
        oracleIndexOrganizedTableProperties._pctThreshold = this._pctThreshold;
        oracleIndexOrganizedTableProperties._mapped = this._mapped;
        oracleIndexOrganizedTableProperties._keyCompression = this._keyCompression;
        oracleIndexOrganizedTableProperties._overflowable = this._overflowable;
        oracleIndexOrganizedTableProperties._includeColumn = this._includeColumn;
        oracleIndexOrganizedTableProperties._overflowProperties = this._overflowProperties == null ? null : (OracleStorageProperties)this._overflowProperties.copyTo(null);
    }

    public boolean equals(Object object) {
        return object instanceof OracleIndexOrganizedTableProperties && this.equalsImpl((OracleIndexOrganizedTableProperties)object);
    }

    protected boolean equalsImpl(OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) {
        return ModelUtil.areEqual((Object)this._pctThreshold, (Object)oracleIndexOrganizedTableProperties._pctThreshold) && ModelUtil.areEqual((Object)this._mapped, (Object)oracleIndexOrganizedTableProperties._mapped) && ModelUtil.areEqual((Object)this._keyCompression, (Object)oracleIndexOrganizedTableProperties._keyCompression) && ModelUtil.areEqual((Object)this._includeColumn, (Object)oracleIndexOrganizedTableProperties._includeColumn) && ModelUtil.areEqual((Object)this._overflowable, (Object)oracleIndexOrganizedTableProperties._overflowable) && ModelUtil.areEqual((Object)this._overflowProperties, (Object)oracleIndexOrganizedTableProperties._overflowProperties);
    }

    public void setPctThreshold(Integer n) {
        this._pctThreshold = n;
    }

    public Integer getPctThreshold() {
        return this._pctThreshold;
    }

    public void setMapped(boolean bl) {
        this._mapped = bl;
    }

    public boolean isMapped() {
        return this._mapped;
    }

    public void setKeyCompression(Integer n) {
        this._keyCompression = n;
    }

    public Integer getKeyCompression() {
        return this._keyCompression;
    }

    public void setIncludeColumn(DBObjectID dBObjectID) {
        this._includeColumn = dBObjectID;
    }

    public DBObjectID getIncludeColumn() {
        return this._includeColumn;
    }

    public void setOverflowable(boolean bl) {
        this._overflowable = bl;
    }

    public boolean isOverflowable() {
        return this._overflowable;
    }

    public void setOverflowProperties(OracleStorageProperties oracleStorageProperties) {
        this._overflowProperties = oracleStorageProperties;
    }

    public OracleStorageProperties getOverflowProperties() {
        return this._overflowProperties;
    }

    public void validatePctThreshold(Table table) throws ValidationException {
        if (this._pctThreshold != null && (this._pctThreshold < 1 || this._pctThreshold > 50)) {
            throw new ValidationException((DBObject)table, DBArb.getString(170));
        }
    }

    public void validateKeyCompression(Table table) throws ValidationException {
        if (this._keyCompression != null) {
            Constraint[] constraintArray;
            Constraint[] constraintArray2 = constraintArray = table == null ? null : table.getConstraints();
            if (constraintArray == null || constraintArray.length < 1) {
                throw new ValidationException((DBObject)table, DBArb.getString(171));
            }
            Integer n = null;
            int n2 = 0;
            while (n2 < constraintArray.length) {
                if (constraintArray[n2].getConstraintType().equals("PKConstraint")) {
                    PKConstraint pKConstraint = (PKConstraint)constraintArray[n2];
                    n = new Integer(pKConstraint.getColumns().length);
                    break;
                }
                ++n2;
            }
            if (this._keyCompression < 0 || n == null || this._keyCompression.compareTo(n) >= 0) {
                throw new ValidationException((DBObject)table, DBArb.getString(172));
            }
        }
    }

    public void validateIncludeColumn(Table table) throws ValidationException {
        if (this._includeColumn != null) {
            Constraint[] constraintArray;
            if (!this.isOverflowable()) {
                throw new ValidationException((DBObject)table, DBArb.getString(173));
            }
            Column column = null;
            Column[] columnArray = table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column column2 = columnArray[n];
                DBObjectID dBObjectID = column2.getID();
                if (dBObjectID.equals(this._includeColumn, false)) {
                    column = column2;
                    break;
                }
                ++n;
            }
            if (column == null) {
                throw new ValidationException((DBObject)table, DBArb.getString(174));
            }
            Constraint[] constraintArray2 = constraintArray = table == null ? null : table.getConstraints();
            if (constraintArray != null && constraintArray.length > 0) {
                int n2 = 0;
                while (n2 < constraintArray.length) {
                    if (constraintArray[n2].getConstraintType().equals("PKConstraint")) {
                        PKConstraint pKConstraint = (PKConstraint)constraintArray[n2];
                        Column[] columnArray2 = pKConstraint.getColumns();
                        if (columnArray2.length <= 0 || column.getName().equals(columnArray2[columnArray2.length - 1].getName())) break;
                        int n3 = 0;
                        while (n3 < columnArray2.length - 1) {
                            if (column.getName().equals(columnArray2[n3].getName())) {
                                throw new ValidationException((DBObject)table, DBArb.getString(174));
                            }
                            ++n3;
                        }
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    public void validateOverflowProperties(Table table) throws ValidationException {
        if (this._overflowProperties != null) {
            this._overflowProperties.validate(table);
        }
    }

    public void validate(Table table) throws ValidationException {
        this.validatePctThreshold(table);
        this.validateKeyCompression(table);
        this.validateIncludeColumn(table);
        this.validateOverflowProperties(table);
    }
}

