/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.ora.OracleIndexProperties;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.IndexValidator;

public class OracleIndexValidator
extends IndexValidator {
    private static final HashSet INVALID_INDEX_DATATYPES = new HashSet<String>(Arrays.asList("LONG", "LONG RAW", "LOB", "BLOB", "CLOB", "NCLOB", "BFILE", "REF"));
    private static final HashSet VALID_TEXT_INDEX_DATATYPES = new HashSet<String>(Arrays.asList(OracleTypesArb.getString(0), OracleTypesArb.getString(6), "BLOB", "BFILE"));

    public OracleIndexValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        super.validateNameInUse(dBObject);
        Table table = (Table)dBObject.getParent();
        Constraint[] constraintArray = table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraintArray[n] instanceof UniqueConstraint && dBObject.getName().equals(constraintArray[n].getName())) {
                throw new NameInUseException(dBObject.getName(), table.getName(), table.getType());
            }
            ++n;
        }
        this.getProvider().validateUniqueName("CONSTRAINT", table.getSchema(), dBObject.getName());
    }

    protected void validateIndexDefinition(Index index) throws ValidationException {
        OracleIndexProperties oracleIndexProperties;
        super.validateIndexDefinition(index);
        if (index.getIndexType() == 4 && (oracleIndexProperties = (OracleIndexProperties)index.getProperty("OracleIndexProperties")) != null && 1 == oracleIndexProperties.getIndexDomainType()) {
            this.checkTextIndex(index);
        }
        boolean bl = false;
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        if (bl && indexObjectArray.length > 30) {
            throw new ValidationException((DBObject)index, DBArb.getString(83));
        }
        if (indexObjectArray.length > 32) {
            throw new ValidationException((DBObject)index, DBArb.getString(82));
        }
    }

    protected void validateColumnType(Index index, Column column) throws ValidationException {
        if (index.getIndexType() != 4) {
            super.validateColumnType(index, column);
            boolean bl = true;
            String string = "";
            try {
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                DataType dataType = DataTypeHelper.getDataType(dataTypeUsage);
                string = dataType.getName();
                if (dataType instanceof PredefinedDataTypeUsage || INVALID_INDEX_DATATYPES.contains(string)) {
                    bl = false;
                }
            }
            catch (DBException dBException) {
                bl = false;
            }
            if (!bl) {
                throw new ValidationException((DBObject)column, DBArb.format(88, index.getName(), column.getName(), string));
            }
        }
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        boolean bl = false;
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Table table = index.getTable();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < indexObjectArray.length) {
            SQLFragment sQLFragment = indexObjectArray[n].getExpression();
            String string = this.getProvider().getInternalName(sQLFragment.getSQLText());
            if (table.getColumn(string) != null && (bl || indexObjectArray[n].getOrder() != "DESC")) {
                if (hashSet.contains(string)) {
                    throw new ValidationException((DBObject)index, DBArb.getString(87));
                }
                hashSet.add(string);
            }
            this.validateColumnExpression(index, sQLFragment);
            ++n;
        }
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        super.checkDefinitionIsUnique(index);
    }

    protected void checkTextIndex(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Table table = index.getTable();
        HashSet hashSet = new HashSet();
        if (indexObjectArray.length != 1) {
            throw new ValidationException((DBObject)index, DBArb.getString(89));
        }
        SQLFragment sQLFragment = indexObjectArray[0].getExpression();
        String string = this.getProvider().getInternalName(sQLFragment.getSQLText());
        Column column = table.getColumn(string);
        if (column == null) {
            throw new ValidationException((DBObject)index, DBArb.format(90, index, string));
        }
        String string2 = "";
        boolean bl = false;
        try {
            DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
            DataType dataType = DataTypeHelper.getDataType(dataTypeUsage);
            string2 = dataType.getName();
            if (dataType instanceof CharacterDataType || VALID_TEXT_INDEX_DATATYPES.contains(string2)) {
                bl = true;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!bl) {
            throw new ValidationException((DBObject)index, DBArb.format(91, index.getName(), string, string2));
        }
    }
}

