/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleLiteObjectID;

public class OracleLite
extends BaseOracleDatabase {
    public static final String ORACLE_LITE_DATABASE_TYPE = "Oracle Lite";
    private static String[] OLITE_SCHEMA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM"};
    private static String[] OLITE_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM", "INDEX"};
    private static String NO_ROWS_QUERY = "select null from dual where dummy <> 'X'";
    private static String[] OLITE_QUERIES = new String[]{"SELECT STATUS FROM SYS.ALL_<type>S WHERE <owner> = ? AND <type>_NAME = ?", "SELECT <type>_NAME FROM SYS.ALL_<type>S WHERE  <owner> = ? AND <type>_NAME LIKE ?", "SELECT TABLE_NAME, 'TABLE' FROM SYS.ALL_INDEXES WHERE  <owner> = ? AND INDEX_NAME = ?", "SELECT TABLE_NAME, 'TABLE' FROM SYS.ALL_TRIGGERS WHERE  <owner> = ? AND TRIGGER_NAME = ?", "SELECT TO_DATE(TIMESTAMP, 'YYYY-MM-DD:HH24:MI:SS') FROM SYS.ALL_<type>S WHERE <owner> = ? AND <type>_NAME = ?"};
    private static final String QUERY_OBJECT_EXISTS = "SELECT <type>_NAME FROM SYS.ALL_<type>S WHERE  <owner> = ? AND <type>_NAME = ?";
    private static final String QUERY_MAIN_OBJECT_NAMESPACE = "SELECT <type>_NAME FROM SYS.ALL_<type>S WHERE  <owner> = ? AND <type>_NAME LIKE ? ";
    private static final String VALIDATE_MAIN_OBJECT_NAMESPACE = "SELECT <type>_NAME, '<type>' FROM SYS.ALL_<type>S WHERE  <owner> = ? AND <type>_NAME = ? ";
    private static final String OBJECT_QUERY = "SELECT <type>_NAME, ''<type>'', NULL FROM SYS.ALL_<type>S WHERE <owner> = ''{0}'' AND <type>_NAME LIKE ''{1}''";
    private static final String ID_QUERY = "SELECT <owner>, <type>_NAME, NULL, NULL, NULL FROM SYS.ALL_<type>S WHERE  <owner> = ''{0}'' AND <type>_NAME = ''{1}''";
    private static final String SYNONYM_ID_QUERY = "SELECT S.OWNER, S.SYNONYM_NAME, S.TABLE_OWNER, S.TABLE_NAME, ''TABLE'' FROM SYS.ALL_TABLES T, SYS.ALL_SYNONYMS S WHERE S.OWNER = ''{0}'' AND S.SYNONYM_NAME LIKE ''{1}'' AND   S.TABLE_OWNER = T.OWNER AND S.TABLE_NAME = T.TABLE_NAME UNION SELECT S.OWNER, S.SYNONYM_NAME, S.TABLE_OWNER, S.TABLE_NAME, ''VIEW'' FROM SYS.ALL_VIEWS V, SYS.ALL_SYNONYMS S WHERE S.OWNER = ''{0}'' AND S.SYNONYM_NAME LIKE ''{1}'' AND   S.TABLE_OWNER = V.OWNER AND S.TABLE_NAME = V.VIEW_NAME";

    OracleLite(Connection connection) {
        this(null, connection);
    }

    OracleLite(String string, Connection connection) {
        super(string, connection);
    }

    public int getOracleDatabaseType() {
        return 8;
    }

    public String getDatabaseType() {
        return ORACLE_LITE_DATABASE_TYPE;
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        return false;
    }

    protected Schema createSchema(Connection connection) {
        try {
            Schema schema = this.createSchema(connection.getMetaData().getUserName());
            return schema;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected DBObjectID createID(Schema schema, String string, String string2, int n) {
        return OracleLiteObjectID.createObjectID(schema, string, string2, this);
    }

    protected String getStandardQuery(String[] stringArray) {
        return this.buildQuery(OBJECT_QUERY, stringArray);
    }

    protected String getCustomQuery(String string) {
        return null;
    }

    public Long getExternalTimestampByID(DBObjectID dBObjectID) throws DBException {
        return dBObjectID instanceof OracleLiteObjectID ? this.getExternalTimestampByName(((OracleLiteObjectID)dBObjectID).getType(), ((OracleLiteObjectID)dBObjectID).getSchema(), ((OracleLiteObjectID)dBObjectID).getName()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SchemaObject createByIDImpl(DBObjectID dBObjectID) throws DBException {
        OracleLiteObjectID oracleLiteObjectID;
        String string;
        DBObjectBuilder dBObjectBuilder;
        AbstractSchemaObject abstractSchemaObject = null;
        if (dBObjectID instanceof OracleLiteObjectID && (dBObjectBuilder = this.getBuilderForType(string = (oracleLiteObjectID = (OracleLiteObjectID)dBObjectID).getType())) != null) {
            Connection connection;
            Schema schema = oracleLiteObjectID.getSchema();
            String string2 = oracleLiteObjectID.getName();
            String string3 = MessageFormat.format(OracleLite.getIDQuery(string), OracleLite.convertObject(schema), string2);
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection2 = connection = this.getConnection();
            synchronized (connection2) {
                try {
                    try {
                        statement = connection.createStatement();
                        this.sqlTrace(string3);
                        resultSet = statement.executeQuery(string3);
                        if (resultSet.next()) {
                            abstractSchemaObject = (AbstractSchemaObject)dBObjectBuilder.createObject(string2, schema, dBObjectID);
                            if ("SYNONYM".equals(string)) {
                                DBObjectID dBObjectID2 = this.createID(this.getSchema(resultSet.getString(3)), resultSet.getString(4), resultSet.getString(5), -1);
                                ((Synonym)abstractSchemaObject).setReference(dBObjectID2);
                            } else {
                                abstractSchemaObject.setID(dBObjectID);
                                this.markForLazyInit(abstractSchemaObject);
                            }
                            this.cacheObject(abstractSchemaObject);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return abstractSchemaObject;
    }

    protected PreparedStatement getQueryExistsStatement(Connection connection, String string, String string2, String string3) throws SQLException {
        return this.getStatement(connection, QUERY_OBJECT_EXISTS, string, string2, string3);
    }

    protected PreparedStatement getQueryMainNamespaceStatement(Connection connection, String string, String string2) throws SQLException {
        String string3 = this.buildQuery(QUERY_MAIN_OBJECT_NAMESPACE, OLITE_SCHEMA_OBJECT_TYPES);
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string2);
        preparedStatement.setString(5, string);
        preparedStatement.setString(6, string2);
        preparedStatement.setString(7, string);
        preparedStatement.setString(8, string2);
        this.sqlTrace(string3, new Object[]{string, string2, string, string2, string, string2, string, string2});
        return preparedStatement;
    }

    protected PreparedStatement getValidateMainNamespaceStatement(Connection connection, String string, String string2) throws SQLException {
        String string3 = this.buildQuery(VALIDATE_MAIN_OBJECT_NAMESPACE, OLITE_SCHEMA_OBJECT_TYPES);
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string2);
        preparedStatement.setString(5, string);
        preparedStatement.setString(6, string2);
        preparedStatement.setString(7, string);
        preparedStatement.setString(8, string2);
        this.sqlTrace(string3, new Object[]{string, string2, string, string2, string, string2, string, string2});
        return preparedStatement;
    }

    protected PreparedStatement getStatement(Connection connection, int n, String string, String string2) throws SQLException {
        return this.getStatement(connection, OLITE_QUERIES[n], string, string2, "");
    }

    protected PreparedStatement getStatement(Connection connection, int n, String string, String string2, String string3) throws SQLException {
        return this.getStatement(connection, OLITE_QUERIES[n], string, string2, string3);
    }

    private PreparedStatement getStatement(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        if (this.isOLiteType(string4)) {
            String string5 = OracleLite.convertQuery(string, string4);
            PreparedStatement preparedStatement = connection.prepareStatement(string5);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            this.sqlTrace(string5, new Object[]{string2, string3});
            return preparedStatement;
        }
        this.sqlTrace(NO_ROWS_QUERY);
        return connection.prepareStatement(NO_ROWS_QUERY);
    }

    private String buildQuery(String string, String[] stringArray) {
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            if (this.isOLiteType(stringArray[n])) {
                string2 = string2 + (string2.length() > 0 ? " UNION " : "") + OracleLite.convertQuery(string, stringArray[n]);
            }
            ++n;
        }
        return string2;
    }

    private boolean isOLiteType(String string) {
        int n = 0;
        while (n < OLITE_OBJECT_TYPES.length) {
            if (OLITE_OBJECT_TYPES[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String getIDQuery(String string) {
        return "SYNONYM".equals(string) ? SYNONYM_ID_QUERY : OracleLite.convertQuery(ID_QUERY, string);
    }

    private static String convertQuery(String string, String string2) {
        return string.replaceAll("<type>", string2).replaceAll("<owner>", string2.equals("SEQUENCE") ? "SEQUENCE_OWNER" : "OWNER");
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            NumericDataType numericDataType = new NumericDataType(65535, "BIGINT", NumericDataType.MIN_MAX_BIGINT);
            NumericDataType numericDataType2 = new NumericDataType(65535, "INTEGER", NumericDataType.MIN_MAX_INT);
            NumericDataType numericDataType3 = new NumericDataType(65535, "SMALLINT", NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType numericDataType4 = new NumericDataType(65535, "TINYINT", NumericDataType.MIN_MAX_SIGNED_TINYINT);
            NumericDataType numericDataType5 = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 0L, 38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType numericDataType6 = new NumericDataType(65535, "NUMERIC", "NUMERIC[(<precision>[, <scale>])]", 0L, 38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType numericDataType7 = new NumericDataType(65535, "NUMBER", "NUMBER[(<precision>[, <scale>])]", 0L, 38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType numericDataType8 = new NumericDataType(65535, "DOUBLE", new NumericDataType.MinMaxValue("1.0E-308", "1.0E+308", 2));
            NumericDataType numericDataType9 = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, 53, null, false, null, new NumericDataType.MinMaxValue("1.0E-308", "1.0E+308", 2));
            NumericDataType numericDataType10 = new NumericDataType(65535, "REAL", new NumericDataType.MinMaxValue("1.0E-38", "1.0E+38", 2));
            dataTypeRegistry.registerDataType(numericDataType, OracleLite.class, JdbcDatabase.ANSI_BIGINT);
            dataTypeRegistry.registerDataType(numericDataType2, OracleLite.class, JdbcDatabase.ANSI_INTEGER);
            dataTypeRegistry.registerDataType(numericDataType3, OracleLite.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType4, OracleLite.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType5, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType6, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType7, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType8, OracleLite.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dataTypeRegistry.registerDataType(numericDataType9, OracleLite.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(numericDataType10, OracleLite.class, JdbcDatabase.ANSI_REAL);
            dataTypeRegistry.registerSynonym("DEC", (DataType)numericDataType5, OracleLite.class);
            dataTypeRegistry.registerSynonym("INT", (DataType)numericDataType2, OracleLite.class);
            dataTypeRegistry.registerSynonym("DOUBLE PRECISION", (DataType)numericDataType8, OracleLite.class);
            CharacterDataType characterDataType = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 4096L, 1L, false, null);
            CharacterDataType characterDataType2 = new CharacterDataType(65535, "LONG", 1L, 2000000000L);
            CharacterDataType characterDataType3 = new CharacterDataType(65535, "VARCHAR", "VARCHAR(<size>)", 1L, 4096L, 4096L, true, null);
            CharacterDataType characterDataType4 = new CharacterDataType(65535, "VARCHAR2", "VARCHAR2(<size>)", 1L, 4096L, 4096L, true, null);
            CharacterDataType characterDataType5 = new CharacterDataType(65535, "LONG VARCHAR", "LONG VARCHAR[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            CharacterDataType characterDataType6 = new CharacterDataType(1, "CLOB", 1L, 2000000000L);
            dataTypeRegistry.registerDataType(characterDataType, OracleLite.class, JdbcDatabase.ANSI_CHAR);
            dataTypeRegistry.registerDataType(characterDataType2, OracleLite.class, JdbcDatabase.ANSI_CLOB);
            dataTypeRegistry.registerDataType(characterDataType6, OracleLite.class, JdbcDatabase.ANSI_CLOB);
            dataTypeRegistry.registerDataType(characterDataType3, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dataTypeRegistry.registerDataType(characterDataType4, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dataTypeRegistry.registerDataType(characterDataType5, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dataTypeRegistry.registerSynonym("CHARACTER", (DataType)characterDataType, OracleLite.class);
            DataTypeAttribute dataTypeAttribute = new DataTypeAttribute("precision", 96, 0L, BaseOracleDatabase.LONG_6, BaseOracleDatabase.LONG_6, false);
            PredefinedDataType predefinedDataType = new PredefinedDataType(65535, "DATE");
            PredefinedDataType predefinedDataType2 = new PredefinedDataType(65535, "TIME", "TIME[(<precision>)]", new DataTypeAttribute[]{dataTypeAttribute});
            PredefinedDataType predefinedDataType3 = new PredefinedDataType(65535, "TIMESTAMP", "TIMESTAMP[(<precision>)]", new DataTypeAttribute[]{dataTypeAttribute});
            dataTypeRegistry.registerDataType(predefinedDataType, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            dataTypeRegistry.registerDataType(predefinedDataType2, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            dataTypeRegistry.registerDataType(predefinedDataType3, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            BinaryDataType binaryDataType = new BinaryDataType(1, "BINARY", "BINARY[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType binaryDataType2 = new BinaryDataType(1, "VARBINARY", "VARBINARY[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType binaryDataType3 = new BinaryDataType(1, "RAW", "RAW[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType binaryDataType4 = new BinaryDataType(1, "LONG RAW", "LONG RAW[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            BinaryDataType binaryDataType5 = new BinaryDataType(1, "LONG VARBINARY", "LONG VARBINARY[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            BinaryDataType binaryDataType6 = new BinaryDataType(1, "BLOB", 1L, 2000000000L);
            BinaryDataType binaryDataType7 = new BinaryDataType(1, "ROWID");
            BinaryDataType binaryDataType8 = new BinaryDataType(1, "BIT");
            dataTypeRegistry.registerDataType(binaryDataType, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType2, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType3, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType4, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType5, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType6, OracleLite.class, JdbcDatabase.ANSI_BLOB);
            dataTypeRegistry.registerDataType(binaryDataType7, OracleLite.class);
            dataTypeRegistry.registerDataType(binaryDataType8, OracleLite.class, JdbcDatabase.ANSI_BIT);
        }

        Registerer() {
        }
    }
}

