/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.ModelUtil;

public class OracleLiteObjectID
extends AbstractDBObjectID {
    private Schema _schema;
    private String _name;
    private String _type;
    private OracleLite _db;
    private OracleLiteObjectID _parent;
    private String _label;
    static final /* synthetic */ boolean $assertionsDisabled;

    static OracleLiteObjectID createObjectID(Schema schema, String string, String string2, OracleLite oracleLite) {
        return new OracleLiteObjectID(schema, string, string2, oracleLite, null);
    }

    static OracleLiteObjectID createObjectID(Schema schema, String string, String string2, OracleLite oracleLite, OracleLiteObjectID oracleLiteObjectID) {
        return new OracleLiteObjectID(schema, string, string2, oracleLite, oracleLiteObjectID);
    }

    static {
        $assertionsDisabled = OracleLiteObjectID.class.desiredAssertionStatus() ^ true;
    }

    private OracleLiteObjectID(Schema schema, String string, String string2, OracleLite oracleLite, OracleLiteObjectID oracleLiteObjectID) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && schema == null && oracleLiteObjectID == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && oracleLite == null) {
            throw new AssertionError();
        }
        this._schema = schema;
        this._name = string;
        this._db = oracleLite;
        this.setType(string2);
        this.setParent(oracleLiteObjectID);
    }

    public synchronized String toString() {
        if (this._label == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._type).append('(');
            String string = AbstractDBObjectProvider.convertObject(this._schema);
            if (ModelUtil.hasLength((String)string)) {
                stringBuffer.append(string).append('.');
            }
            stringBuffer.append(this._name).append(')');
            this._label = stringBuffer.toString();
        }
        return this._label;
    }

    public DBObject resolveID() throws DBException {
        if (this.getParent() != null) {
            return this.resolveFromParent();
        }
        if (this._db == null) {
            throw new DBException(null, "ID has not been given a database to resolve with");
        }
        return this._db.findByID(this);
    }

    Schema getSchema() {
        return this._schema;
    }

    String getName() {
        return this._name;
    }

    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        return dBObjectID instanceof OracleLiteObjectID && this.equalsImpl((OracleLiteObjectID)dBObjectID);
    }

    private boolean equalsImpl(OracleLiteObjectID oracleLiteObjectID) {
        return ModelUtil.areEqual((Object)this.getType(), (Object)oracleLiteObjectID.getType()) && ModelUtil.areEqual((Object)this._schema, (Object)oracleLiteObjectID._schema) && ModelUtil.areEqual((Object)this._name, (Object)oracleLiteObjectID._name);
    }
}

