/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class OracleNumberDataType
extends NumericDataType {
    private static final Long LONG_1 = new Long(1L);
    private static final Long LONG_38 = new Long(38);
    private static final Long LONG__84 = new Long(-84);
    private static final Long LONG_127 = new Long(127);
    private static DataTypeAttribute PRECISION = new DataTypeAttribute("precision", 93, null, null, true, false);
    private static DataTypeAttribute SCALE = new DataTypeAttribute("scale", 94, -84, LONG_127, new Long(0L), false);
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);

    public OracleNumberDataType() {
    }

    public OracleNumberDataType(int n) {
        super(n, "NUMBER", "NUMBER[(<precision>[, <scale>])]", new DataTypeAttribute[]{PRECISION, SCALE}, MIN_MAX_FLOAT);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        OracleNumberDataType oracleNumberDataType = dBObject != null ? (OracleNumberDataType)dBObject : new OracleNumberDataType();
        this.copyToImpl(oracleNumberDataType, bl);
        return oracleNumberDataType;
    }

    protected void copyToImpl(OracleNumberDataType oracleNumberDataType, boolean bl) {
        super.copyToImpl(oracleNumberDataType, bl);
    }

    public boolean equals(Object object) {
        return object instanceof OracleNumberDataType && this.equalsImpl((OracleNumberDataType)object);
    }

    protected boolean equalsImpl(OracleNumberDataType oracleNumberDataType) {
        return super.equalsImpl(oracleNumberDataType);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        Long l;
        String string = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        if (ModelUtil.hasLength((String)string) && !string.trim().equals("*")) {
            int n = 0;
            try {
                n = Long.valueOf(string).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.getString(125));
            }
            if (n < 1) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(121, DataTypeHelper.getNameFromLabel(93), LONG_1));
            }
            if (n > 38) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(122, DataTypeHelper.getNameFromLabel(93), LONG_38));
            }
        }
        if ((l = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"))) != null) {
            if (l.compareTo(LONG__84) < 0) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(121, DBArb.getString(94), LONG__84));
            }
            if (l.compareTo(LONG_127) > 0) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(122, DBArb.getString(94), LONG_127));
            }
        }
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        String string = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        Long l = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"));
        PredefinedDataTypeUsage predefinedDataTypeUsage = new PredefinedDataTypeUsage();
        dataTypeUsage.copyTo(predefinedDataTypeUsage);
        if (string != null) {
            if (string.trim().equals("*")) {
                if (l != null) {
                    predefinedDataTypeUsage.putAttributeValue("precision", LONG_38);
                } else {
                    predefinedDataTypeUsage.deleteAttributeValue("precision");
                }
            }
        } else if (l != null) {
            predefinedDataTypeUsage.putAttributeValue("precision", LONG_38);
        }
        super.validateDefaultValue(object, predefinedDataTypeUsage, dBObject);
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        String string = this.getName();
        String string2 = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        Long l = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"));
        if (string2 != null) {
            string = string + '(' + string2 + (l == null ? "" : ", " + l) + ')';
        } else if (l != null) {
            string = string + "(*, " + l + ')';
        }
        return string;
    }
}

