/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.PlSqlSourceBuilder;

public class OracleObjectTypeBuilder
extends PlSqlSourceBuilder {
    private static final String ORACLE8_TYPE_QUERY = "select TYPECODE from ALL_TYPES where OWNER = ? and TYPE_NAME = ? ";
    private static final int TQ_SELECT_TYPECODE = 1;
    private static final int TQ_WHERE_SCHEMA_POSITION = 1;
    private static final int TQ_WHERE_NAME_POSITION = 2;

    public OracleObjectTypeBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
        if (!"TYPE".equals(string)) {
            throw new IllegalArgumentException("Illegal object type: " + string);
        }
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        super.fillInObject(schemaObject);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                ObjectType objectType = (ObjectType)schemaObject;
                Connection connection = this.getConnection();
                String string = AbstractDBObjectProvider.convertObject(objectType.getSchema());
                String string2 = schemaObject.getName();
                statement = connection.prepareStatement(ORACLE8_TYPE_QUERY);
                statement.setString(1, string);
                statement.setString(2, string2);
                this.sqlTrace(ORACLE8_TYPE_QUERY, new Object[]{string, string2});
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    OracleObjectTypeBuilder._updateType(objectType, resultSet);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void _updateType(ObjectType objectType, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString(1);
        objectType.setTypeCode(string);
    }
}

