/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.ChildLevelObjectID;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLiteObjectID;
import oracle.javatools.db.ora.TopLevelObjectID;
import oracle.javatools.util.ModelUtil;

public abstract class OracleRelationBuilder
extends OracleDBObjectBuilder {
    private static final String COLUMN_QUERY = "SELECT C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS , decode(CHAR_USED, 'C', 'CHAR', null) FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT WHERE C.OWNER = ? AND C.TABLE_NAME = ? AND C.OWNER = CMT.OWNER AND C.TABLE_NAME = CMT.TABLE_NAME AND C.COLUMN_NAME = CMT.COLUMN_NAME ORDER BY COLUMN_ID";
    private static final String ORACLE8i_COLUMN_QUERY = "SELECT C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS , null FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT WHERE C.OWNER = ? AND C.TABLE_NAME = ? AND C.OWNER = CMT.OWNER AND C.TABLE_NAME = CMT.TABLE_NAME AND C.COLUMN_NAME = CMT.COLUMN_NAME ORDER BY COLUMN_ID";
    private static final String ORACLE8_COLUMN_QUERY = "SELECT C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, DEFAULT_LENGTH, NULL, DATA_DEFAULT, COMMENTS , null FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT WHERE C.OWNER = ? AND C.TABLE_NAME = ? AND C.OWNER = CMT.OWNER AND C.TABLE_NAME = CMT.TABLE_NAME AND C.COLUMN_NAME = CMT.COLUMN_NAME ORDER BY COLUMN_ID";
    private static final String ORACLE7_COLUMN_QUERY = "SELECT C.COLUMN_NAME, DATA_TYPE, NULL, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, DEFAULT_LENGTH, NULL, DATA_DEFAULT, COMMENTS , NULL FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT WHERE C.OWNER = ? AND C.TABLE_NAME = ? AND C.OWNER = CMT.OWNER AND C.TABLE_NAME = CMT.TABLE_NAME AND C.COLUMN_NAME = CMT.COLUMN_NAME ORDER BY COLUMN_ID";
    private static final String OLITE_COLUMN_QUERY = "SELECT C.COLUMN_NAME, DATA_TYPE, NULL, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, DEFAULT_LENGTH, NULL, DATA_DEFAULT, COMMENTS , NULL FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT WHERE C.OWNER = ? AND C.TABLE_NAME = ? AND C.OWNER = CMT.OWNER(+) AND C.TABLE_NAME = CMT.TABLE_NAME(+) AND C.COLUMN_NAME = CMT.COLUMN_NAME(+) ORDER BY COLUMN_ID";
    private static final String ENTERPRISE_CONSTRAINT_QUERY = "SELECT  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION,         A.R_OWNER, A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED,         B.COLUMN_NAME,         ( SELECT D.CONSTRAINT_TYPE           FROM SYS.ALL_CONSTRAINTS D           WHERE D.OWNER = A.R_OWNER           AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME) ref_constraint_type,        ( SELECT BB.OBJECT_ID          FROM SYS.ALL_CONSTRAINTS AA             , SYS.ALL_OBJECTS     BB          WHERE AA.OWNER = A.R_OWNER           AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME          AND   AA.OWNER = BB.OWNER           AND   AA.TABLE_NAME = BB.OBJECT_NAME          AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW')     ) ref_relation_object_id,        ( SELECT BB.OBJECT_TYPE          FROM SYS.ALL_CONSTRAINTS AA             , SYS.ALL_OBJECTS     BB          WHERE AA.OWNER = A.R_OWNER           AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME          AND   AA.OWNER = BB.OWNER           AND   AA.TABLE_NAME = BB.OBJECT_NAME          AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW')     ) ref_relation_type,        ( SELECT AA.TABLE_NAME          FROM SYS.ALL_CONSTRAINTS AA             , SYS.ALL_OBJECTS     BB          WHERE AA.OWNER = A.R_OWNER           AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME          AND   AA.OWNER = BB.OWNER           AND   AA.TABLE_NAME = BB.OBJECT_NAME          AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW')     ) ref_relation_name FROM SYS.ALL_CONSTRAINTS  A,      SYS.ALL_CONS_COLUMNS B WHERE A.OWNER           = ? AND   A.TABLE_NAME      = ? AND   A.OWNER           = B.OWNER AND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME ORDER BY B.POSITION ";
    private static final String OLITE_CONSTRAINT_QUERY = "SELECT  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION,         A.R_OWNER, A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME',         B.COLUMN_NAME,          ( SELECT D.CONSTRAINT_TYPE            FROM SYS.ALL_CONSTRAINTS D            WHERE D.OWNER = A.R_OWNER            AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME  ) ref_constraint_type,         null                                               ref_relation_object_id,         ( SELECT 'TABLE'           FROM SYS.ALL_CONSTRAINTS AA              , SYS.ALL_TABLES      BB           WHERE AA.OWNER = A.R_OWNER            AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME           AND   AA.OWNER = BB.OWNER            AND   AA.TABLE_NAME = BB.TABLE_NAME          UNION           SELECT 'VIEW'           FROM SYS.ALL_CONSTRAINTS AA              , SYS.ALL_VIEWS       BB           WHERE AA.OWNER = A.R_OWNER            AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME           AND   AA.OWNER = BB.OWNER            AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_type,            ( SELECT AA.TABLE_NAME           FROM SYS.ALL_CONSTRAINTS AA              , SYS.ALL_TABLES     BB           WHERE AA.OWNER = A.R_OWNER            AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME           AND   AA.OWNER = BB.OWNER            AND   AA.TABLE_NAME = BB.TABLE_NAME          UNION           SELECT AA.TABLE_NAME           FROM SYS.ALL_CONSTRAINTS AA              , SYS.ALL_VIEWS       BB           WHERE AA.OWNER = A.R_OWNER            AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME           AND   AA.OWNER = BB.OWNER            AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_name  FROM SYS.ALL_CONSTRAINTS  A,       SYS.ALL_CONS_COLUMNS B  WHERE A.OWNER           = ?  AND   A.TABLE_NAME      = ?  AND   A.OWNER           = B.OWNER  AND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  ORDER BY B.POSITION ";
    private static final String ORACLE7_CONSTRAINT_QUERY = "SELECT A.CONSTRAINT_NAME, CONSTRAINT_TYPE, SEARCH_CONDITION, R_OWNER, R_CONSTRAINT_NAME, DELETE_RULE, STATUS, 'GENERATED NAME', COLUMN_NAME FROM SYS.ALL_CONSTRAINTS A, SYS.ALL_CONS_COLUMNS B WHERE A.OWNER = ? AND A.TABLE_NAME = ? AND A.OWNER = B.OWNER AND A.CONSTRAINT_NAME = B.CONSTRAINT_NAME ORDER BY POSITION";
    private static final String COMMENT_QUERY = "SELECT COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?";
    private static final String ORACLE8i_NOT_NULL_COND = "\"{0}\" IS NOT NULL";
    private static final String ORACLE7_NOT_NULL_COND = "{0} IS NOT NULL";
    private static final char PK_TYPE = 'P';
    private static final char FK_TYPE = 'R';
    private static final char UNIQUE_TYPE = 'U';
    private static final char CHECK_TYPE = 'C';

    protected OracleRelationBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Relation relation = (Relation)schemaObject;
        if (this.needsBuilding(relation, "Comment")) {
            this.fillInComment(relation);
        }
        if (this.needsBuilding(relation, "COLUMN")) {
            this.fillInColumns(relation);
        }
        if (this.needsBuilding(relation, "CONSTRAINT")) {
            this.fillInConstraints(relation);
        }
    }

    protected void fillInComment(Relation relation) throws DBException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(COMMENT_QUERY, relation.getSchema(), relation, this.getObjectType());
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    relation.setProperty("Comment", resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    protected void fillInColumns(Relation relation) throws DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        int n = baseOracleDatabase.getOracleDatabaseType();
        String string = OracleRelationBuilder.getColumnQuery(n);
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(string, relation.getSchema(), relation);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    Column column = new Column(string2);
                    relation.addColumn(column);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    if (!resultSet.wasNull()) {
                        string3 = string4 + "." + string3;
                    }
                    column.setNotNull(resultSet.getString(7).equals("N"));
                    String string5 = resultSet.getString(10);
                    if (string5 != null) {
                        string5 = string5.trim();
                    }
                    column.setDefault(string5);
                    String string6 = resultSet.getString(11);
                    column.setProperty("Comment", string6);
                    if (n == 8) {
                        column.setID(OracleLiteObjectID.createObjectID(relation.getSchema(), column.getName(), column.getType(), (OracleLite)baseOracleDatabase, (OracleLiteObjectID)relation.getID()));
                    } else {
                        column.setID(ChildLevelObjectID.createObjectID((TopLevelObjectID)relation.getID(), column.getName(), column.getType()));
                    }
                    if (string3.indexOf(46) >= 0) {
                        DataType dataType = null;
                        try {
                            int n2 = string3.indexOf(46);
                            String string7 = string3.substring(0, n2);
                            String string8 = string3.substring(n2 + 1, string3.length());
                            dataType = (ObjectType)baseOracleDatabase.getObject("TYPE", new Schema(string7), string8);
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                        if (dataType == null) {
                            dataType = baseOracleDatabase.getDataType(string3);
                        }
                        column.setDataTypeUsage(dataType.createDefaultUsage());
                        continue;
                    }
                    DataType dataType = baseOracleDatabase.getDataType(string3);
                    if (dataType == null) continue;
                    long l = resultSet.getLong(5);
                    Long l2 = resultSet.wasNull() ? null : new Long(l);
                    l = resultSet.wasNull() ? resultSet.getLong(9) : l;
                    l = resultSet.wasNull() ? resultSet.getLong(4) : l;
                    Long l3 = resultSet.wasNull() ? null : new Long(l);
                    Long l4 = new Long(resultSet.getLong(6));
                    l4 = resultSet.wasNull() ? null : l4;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("name", string3);
                    hashMap.put("size", DataTypeHelper.getAttributeValue(l3, dataType, "size"));
                    hashMap.put("precision", DataTypeHelper.getAttributeValue(l2, dataType, "precision"));
                    hashMap.put("scale", DataTypeHelper.getAttributeValue(l4, dataType, "scale"));
                    hashMap.put("unit", resultSet.getString(12));
                    column.setDataTypeUsage(dataType.createUsage(hashMap));
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    private void fillInConstraints(Relation relation) throws DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = OracleRelationBuilder.getConstraintQuery(baseOracleDatabase.getOracleDatabaseType());
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(string, relation.getSchema(), relation);
        try {
            try {
                HashMap<String, ConstraintData> hashMap = new HashMap<String, ConstraintData>();
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    String string2;
                    String string3 = resultSet.getString(1);
                    ConstraintData constraintData = (ConstraintData)hashMap.get(string3);
                    if (constraintData == null) {
                        constraintData = new ConstraintData(string3, resultSet);
                        hashMap.put(string3, constraintData);
                    }
                    if ((string2 = resultSet.getString(9)).startsWith("SYS_NC")) {
                        ConstraintData.wa$_ignore(constraintData, true);
                        continue;
                    }
                    if (resultSet.wasNull()) continue;
                    ConstraintData.mav$_addColumn(constraintData, string2);
                }
                ArrayList<Constraint> arrayList = new ArrayList<Constraint>(hashMap.size());
                for (ConstraintData constraintData : hashMap.values()) {
                    Constraint constraint;
                    if (ConstraintData.ra$_ignore(constraintData) || (constraint = ConstraintData.mav$_createConstraint(constraintData, relation)) == null) continue;
                    arrayList.add(constraint);
                }
                relation.setConstraints(arrayList.toArray(new Constraint[arrayList.size()]));
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    private static int _translateDeleteAction(String string) {
        int n = 0;
        if ("CASCADE".equals(string)) {
            n = 1;
        } else if ("SET NULL".equals(string)) {
            n = 2;
        }
        return n;
    }

    private static String getColumnQuery(int n) {
        String string = null;
        switch (n) {
            case 8: {
                string = OLITE_COLUMN_QUERY;
                break;
            }
            case 0: {
                string = ORACLE7_COLUMN_QUERY;
                break;
            }
            case 1: {
                string = ORACLE8_COLUMN_QUERY;
                break;
            }
            case 2: {
                string = ORACLE8i_COLUMN_QUERY;
                break;
            }
            default: {
                string = COLUMN_QUERY;
            }
        }
        return string;
    }

    private static String getConstraintQuery(int n) {
        return n == 8 ? OLITE_CONSTRAINT_QUERY : ENTERPRISE_CONSTRAINT_QUERY;
    }

    private static String getNotNullText(int n) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 8: {
                string = ORACLE7_NOT_NULL_COND;
                break;
            }
            default: {
                string = ORACLE8i_NOT_NULL_COND;
            }
        }
        return string;
    }

    protected void fillInObjectComponent(SchemaObject schemaObject, String string) throws DBException {
        Relation relation = (Relation)schemaObject;
        if (string.equals("COLUMN")) {
            this.fillInColumns(relation);
        } else if (string.equals("CONSTRAINT")) {
            this.ensureComponent(relation, "COLUMN");
            this.fillInConstraints(relation);
        } else if (string.equals("Comment")) {
            this.fillInComment(relation);
        } else {
            super.fillInObjectComponent(schemaObject, string);
        }
    }

    static String maS$getNotNullText(int n) {
        return OracleRelationBuilder.getNotNullText(n);
    }

    static int maS$_translateDeleteAction(String string) {
        return OracleRelationBuilder._translateDeleteAction(string);
    }

    private class ConstraintData {
        private String _cName;
        private char _cType;
        private String _cond;
        private String _rSchemaName;
        private String _rConstraintName;
        private String _rConstraintType;
        private String _rRelationType;
        private String _rRelationName;
        private int _rRelationObjectID;
        private int _dRule;
        private boolean _status;
        private boolean _generated;
        private List _cols;
        private boolean _ignore;

        void $init$() {
            this._cols = new ArrayList();
            this._ignore = false;
        }

        ConstraintData(String string, ResultSet resultSet) throws SQLException {
            this.$init$();
            this._cName = string;
            String string2 = resultSet.getString(2);
            this._cType = ModelUtil.hasLength((String)string2) ? string2.charAt(0) : (char)'\u0000';
            switch (this._cType) {
                case 'C': {
                    this._cond = resultSet.getString(3);
                    break;
                }
                case 'P': 
                case 'U': {
                    break;
                }
                case 'R': {
                    this._rSchemaName = resultSet.getString(4);
                    this._rConstraintName = resultSet.getString(5);
                    this._rConstraintType = resultSet.getString(10);
                    this._rRelationObjectID = resultSet.getInt(11);
                    this._rRelationType = resultSet.getString(12);
                    this._rRelationName = resultSet.getString(13);
                    this._dRule = OracleRelationBuilder.maS$_translateDeleteAction(resultSet.getString(6));
                    break;
                }
                default: {
                    this._cType = '\u0000';
                }
            }
            String string3 = resultSet.getString(7);
            this._status = "ENABLED".equals(string3);
            String string4 = resultSet.getString(8);
            this._generated = "GENERATED NAME".equals(string4);
        }

        private void _addColumn(String string) {
            this._cols.add(string);
        }

        private Constraint _createConstraint(Relation relation) throws SQLException, DBException {
            Constraint constraint = null;
            switch (this._cType) {
                case 'C': {
                    constraint = this._createCheckConstraint(relation);
                    break;
                }
                case 'P': 
                case 'U': {
                    constraint = this._createUniqueConstraint(relation);
                    break;
                }
                case 'R': {
                    constraint = this._createFK(relation);
                    break;
                }
                default: {
                    constraint = null;
                }
            }
            if (constraint != null) {
                BaseOracleDatabase baseOracleDatabase = OracleRelationBuilder.this.getDatabase();
                if (baseOracleDatabase.getOracleDatabaseType() == 8) {
                    constraint.setID(OracleLiteObjectID.createObjectID(relation.getSchema(), constraint.getName(), constraint.getType(), (OracleLite)baseOracleDatabase, (OracleLiteObjectID)relation.getID()));
                } else {
                    constraint.setID(ChildLevelObjectID.createObjectID((TopLevelObjectID)relation.getID(), constraint.getName(), constraint.getType()));
                }
                constraint.setEnabled(this._status);
            }
            return constraint;
        }

        private CheckConstraint _createCheckConstraint(Relation relation) {
            String string;
            Column column;
            if (this._cond == null) {
                return null;
            }
            this._cond = this._cond.trim();
            if (this._generated && this._cols.size() == 1 && (column = relation.getColumn(string = (String)this._cols.get(0))) != null && column.isNotNull() && MessageFormat.format(OracleRelationBuilder.maS$getNotNullText(OracleRelationBuilder.this.getDatabase().getOracleDatabaseType()), string).equals(this._cond)) {
                return null;
            }
            CheckConstraint checkConstraint = new CheckConstraint();
            checkConstraint.setName(this._cName);
            checkConstraint.setCheckCondition(this._cond);
            return checkConstraint;
        }

        private Column[] _getConstraintColumns(Relation relation) {
            String[] stringArray = this._cols.toArray(new String[this._cols.size()]);
            int n = 0;
            Column[] columnArray = new Column[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                Column column = relation.getColumn(stringArray[n2]);
                if (column != null) {
                    columnArray[n++] = column;
                }
                ++n2;
            }
            if (n < columnArray.length) {
                Column[] columnArray2 = columnArray;
                columnArray = new Column[n];
                System.arraycopy(columnArray2, 0, columnArray, 0, n);
            }
            return columnArray;
        }

        private UniqueConstraint _createUniqueConstraint(Relation relation) {
            UniqueConstraint uniqueConstraint = this._cType == 'P' ? new PKConstraint() : new UniqueConstraint();
            uniqueConstraint.setName(this._cName);
            uniqueConstraint.setColumns(this._getConstraintColumns(relation));
            return uniqueConstraint;
        }

        private FKConstraint _createFK(Relation relation) throws SQLException, DBException {
            FKConstraint fKConstraint = new FKConstraint();
            fKConstraint.setName(this._cName);
            fKConstraint.setColumns(this._getConstraintColumns(relation));
            fKConstraint.setDeleteMode(this._dRule);
            BaseOracleDatabase baseOracleDatabase = OracleRelationBuilder.this.getDatabase();
            if (this._rSchemaName != null && this._rRelationName != null && this._rRelationType != null) {
                Schema schema = baseOracleDatabase.getSchema(this._rSchemaName);
                DBObjectID dBObjectID = baseOracleDatabase.createID(schema, this._rRelationName, this._rRelationType, this._rRelationObjectID);
                DBObjectID dBObjectID2 = null;
                if (baseOracleDatabase.getOracleDatabaseType() == 8) {
                    if (dBObjectID instanceof OracleLiteObjectID) {
                        dBObjectID2 = OracleLiteObjectID.createObjectID(schema, this._rConstraintName, "CONSTRAINT", (OracleLite)baseOracleDatabase, (OracleLiteObjectID)dBObjectID);
                    }
                } else if (dBObjectID instanceof TopLevelObjectID) {
                    dBObjectID2 = ChildLevelObjectID.createObjectID((TopLevelObjectID)dBObjectID, this._rConstraintName, "CONSTRAINT");
                }
                fKConstraint.setReferenceID(dBObjectID2);
            }
            return fKConstraint;
        }

        static void wa$_ignore(ConstraintData constraintData, boolean bl) {
            constraintData._ignore = bl;
        }

        static void mav$_addColumn(ConstraintData constraintData, String string) {
            constraintData._addColumn(string);
        }

        static boolean ra$_ignore(ConstraintData constraintData) {
            return constraintData._ignore;
        }

        static Constraint mav$_createConstraint(ConstraintData constraintData, Relation relation) {
            return constraintData._createConstraint(relation);
        }
    }
}

