/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.OracleFunctions;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.data.SqlOperators;
import oracle.javatools.parser.plsql.symtab.SqlAjndef;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlFrodef;
import oracle.javatools.parser.plsql.symtab.SqlGbydef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlOrddef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.symtab.SqlTypdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.util.ModelUtil;

public final class OracleSQLQueryBuilder
extends AbstractSQLQueryBuilder
implements SQLQueryBuilder {
    private static OracleFunctions s_funcs;
    private OracleSQLQueryBuilder m_parentBuilder;
    private NonDeclarativeSQLQuery m_semiDecQuery;

    public OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, DeclarativeSQLQuery declarativeSQLQuery) throws SQLQueryException {
        super(declarativeSQLQuery, dBObjectProvider, schema);
    }

    public OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, SQLQuery sQLQuery) throws SQLQueryException {
        super(dBObjectProvider, schema);
        if (sQLQuery instanceof DeclarativeSQLQuery) {
            this.m_query = (DeclarativeSQLQuery)sQLQuery;
            this.validateQuery();
            this.loadQuery();
        } else {
            this.buildQuery(sQLQuery == null ? "" : sQLQuery.getSQLText());
        }
    }

    public OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, String string) throws SQLQueryException {
        this(dBObjectProvider, schema, string, true);
    }

    OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, String string, boolean bl) throws SQLQueryException {
        super(dBObjectProvider, schema);
        if (bl) {
            this.buildQuery(string);
        } else {
            this.m_semiDecQuery = new NonDeclarativeSQLQuery(string);
        }
    }

    private OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, SqlQbcdef sqlQbcdef, OracleSQLQueryBuilder oracleSQLQueryBuilder) throws SQLQueryException {
        super(dBObjectProvider, schema);
        this.m_parentBuilder = oracleSQLQueryBuilder;
        this.buildQuery(sqlQbcdef, this.m_parentBuilder.getSQLQuery());
    }

    void buildQuery() throws SQLQueryException {
        if (this.m_semiDecQuery != null) {
            this.buildQuery(this.m_semiDecQuery.getSQLText());
        }
    }

    SQLQuery getSemiDeclarativeSQLQuery() {
        return this.m_semiDecQuery;
    }

    private void buildQuery(String string) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        if (ModelUtil.hasLength((String)string)) {
            PlsqlRoot plsqlRoot = OracleSQLQueryBuilder.parseQueryString(string, 0);
            OracleSQLQueryBuilder.checkErrors(plsqlRoot, string);
            PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
            SqlQbcdef sqlQbcdef = null;
            int n = 0;
            while (n < plsqlNodeArray.length) {
                byte by = ((SqlExpression)plsqlNodeArray[n]).getOperandType();
                if (by == 5) {
                    sqlQbcdef = (SqlQbcdef)plsqlNodeArray[n];
                }
                ++n;
            }
            this.buildQuery(sqlQbcdef, null);
        }
    }

    private void buildQuery(SqlQbcdef sqlQbcdef, SQLQuery sQLQuery) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        this.m_query.setParent(sQLQuery == null ? (DBObject)this.m_defaultSchema : sQLQuery);
        if (sqlQbcdef != null) {
            SqlFrodef[] sqlFrodefArray = sqlQbcdef.qbcfro;
            if (sqlFrodefArray == null) {
                SqlOpndef[] sqlOpndefArray = (SqlOpndef[])sqlQbcdef.getOperands();
                short s = sqlQbcdef.getOperatorType();
                throw new SQLQueryException(DBArb.getString(22));
            }
            SQLQueryException sQLQueryException = null;
            int n = 0;
            while (n < sqlFrodefArray.length) {
                try {
                    FromObject fromObject = this.createFrom(sqlFrodefArray[n]);
                    this.addFromObject(fromObject);
                }
                catch (SQLQueryException sQLQueryException2) {
                    if (sQLQueryException == null) {
                        sQLQueryException = sQLQueryException2;
                    }
                    sQLQueryException.setNextException(sQLQueryException2);
                }
                ++n;
            }
            if (sQLQueryException != null) {
                throw sQLQueryException;
            }
            try {
                SqlOrddef[] sqlOrddefArray;
                SqlGbydef sqlGbydef;
                SqlSeldef[] sqlSeldefArray = sqlQbcdef.qbcsel;
                int n2 = 0;
                while (n2 < sqlSeldefArray.length) {
                    String string = sqlSeldefArray[n2].getSelnam();
                    SqlOpndef sqlOpndef = sqlSeldefArray[n2].getSelopn();
                    SQLFragment sQLFragment = this.createFragment(sqlOpndef);
                    boolean bl = sqlSeldefArray[n2].hasAs();
                    SelectObject selectObject = new SelectObject(sQLFragment, string, bl);
                    this.addSelectObject(selectObject);
                    ++n2;
                }
                SqlOptdef sqlOptdef = sqlQbcdef.qbcwhr;
                if (sqlOptdef != null) {
                    WhereObject whereObject = this.createWhere(sqlOptdef);
                    this.setWhereObject(whereObject);
                }
                if ((sqlGbydef = sqlQbcdef.qbcgbh) != null) {
                    GroupByObject groupByObject = this.createGroupBy(sqlGbydef, (SqlOpndef)sqlQbcdef.qbchav);
                    this.setGroupByObject(groupByObject);
                }
                if ((sqlOrddefArray = sqlQbcdef.qbcord) != null) {
                    int n3 = 0;
                    while (n3 < sqlOrddefArray.length) {
                        String string = sqlOrddefArray[n3].getOrderByAscSource();
                        String string2 = sqlOrddefArray[n3].getOrderByNullsLastSource();
                        SqlOpndef sqlOpndef = sqlOrddefArray[n3].getOrderByTerm();
                        SQLFragment sQLFragment = this.createFragment(sqlOpndef);
                        OrderByObject orderByObject = new OrderByObject(sQLFragment, string, string2);
                        this.addOrderByObject(orderByObject);
                        ++n3;
                    }
                }
            }
            catch (SQLQueryException sQLQueryException3) {
                if (this.m_semiDecQuery != null) {
                    this.m_semiDecQuery.setFromObjects(this.m_query.getFromObjects());
                    this.m_semiDecQuery.setSelectObjects(this.m_query.getSelectObjects());
                }
                throw sQLQueryException3;
            }
        }
    }

    private void checkLength(String string) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)string)) {
            throw new SQLQueryException(DBArb.getString(19));
        }
    }

    private FromObject createFrom(SqlFrodef sqlFrodef) throws SQLQueryException {
        FromObject fromObject = null;
        SqlOpndef sqlOpndef = sqlFrodef.getSubQuery();
        if (sqlOpndef == null) {
            fromObject = new FromObject();
            SqlAjndef sqlAjndef = sqlFrodef.getAnsiJoin();
            if (sqlAjndef == null) {
                fromObject.setAlias(sqlFrodef.getTableAlias());
                String string = sqlFrodef.getSchemaName();
                String string2 = sqlFrodef.getTableName();
                if (ModelUtil.hasLength((String)string2) && string2.equalsIgnoreCase("DUAL")) {
                    fromObject.setExpression(new SimpleSQLFragment(string2));
                } else {
                    if (ModelUtil.hasLength((String)sqlFrodef.networkAccess)) {
                        throw new SQLQueryException(DBArb.format(28, string2, sqlFrodef.networkAccess));
                    }
                    DBObjectUsage dBObjectUsage = this.createRelationUsage(string, string2);
                    if (dBObjectUsage == null) {
                        throw new SQLQueryException(DBArb.format(29, string2));
                    }
                    fromObject.setExpression(dBObjectUsage);
                }
            } else {
                JoinObject joinObject = new JoinObject();
                fromObject.setExpression(joinObject);
                int n = sqlAjndef.getJoinType();
                String string = null;
                switch (n) {
                    case 4: {
                        string = "FULL";
                        break;
                    }
                    case 2: {
                        string = "LEFT";
                        break;
                    }
                    case 3: {
                        string = "RIGHT";
                        break;
                    }
                    case 5: {
                        string = "CROSS";
                        break;
                    }
                    default: {
                        string = "INNER";
                    }
                }
                joinObject.setJoinType(string);
                boolean bl = sqlAjndef.getNaturalJoin();
                joinObject.setNatural(bl);
                SqlFrodef sqlFrodef2 = sqlAjndef.getJoinLeftTable();
                FromObject fromObject2 = this.createFrom(sqlFrodef2);
                joinObject.setLeftExpression(fromObject2);
                SqlFrodef sqlFrodef3 = sqlAjndef.getJoinRightTable();
                FromObject fromObject3 = this.createFrom(sqlFrodef3);
                joinObject.setRightExpression(fromObject3);
                if (!string.equals("CROSS") && !bl) {
                    SqlOpndef sqlOpndef2 = sqlAjndef.getJoinOnClause();
                    if (sqlOpndef2 != null && sqlOpndef2 instanceof SqlOptdef) {
                        WhereObject whereObject = this.createWhere((SqlOptdef)sqlOpndef2, fromObject);
                        if (whereObject != null) {
                            OnJoinCondition onJoinCondition = (OnJoinCondition)whereObject.copyTo(new OnJoinCondition());
                            joinObject.setCondition(onJoinCondition);
                        }
                    } else {
                        SqlColdef[] sqlColdefArray = sqlAjndef.getJoinColumns();
                        if (sqlColdefArray != null) {
                            UsingJoinCondition usingJoinCondition = new UsingJoinCondition();
                            joinObject.setCondition(usingJoinCondition);
                            int n2 = 0;
                            while (n2 < sqlColdefArray.length) {
                                String string3 = sqlColdefArray[n2].getColumnBaseName();
                                FromObjectUsage fromObjectUsage = this.findColumnInFromObjects(string3, new FromObject[]{fromObject2, fromObject3}, true, true);
                                if (fromObjectUsage != null) {
                                    usingJoinCondition.addColumn(fromObjectUsage);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
        } else {
            OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, (SqlQbcdef)sqlOpndef, this);
            DeclarativeSQLQuery declarativeSQLQuery = oracleSQLQueryBuilder.getSQLQuery();
            if (declarativeSQLQuery == null) {
                throw new SQLQueryException(DBArb.getString(30));
            }
            fromObject = new FromObject(declarativeSQLQuery, sqlFrodef.getTableAlias());
        }
        return fromObject;
    }

    private WhereObject createWhere(SqlOptdef sqlOptdef) throws SQLQueryException {
        return this.createWhere(sqlOptdef, null);
    }

    private WhereObject createWhere(SqlOptdef sqlOptdef, SQLFragment sQLFragment) throws SQLQueryException {
        WhereObject whereObject = null;
        short s = sqlOptdef.getOperatorType();
        SqlExpression[] sqlExpressionArray = sqlOptdef.getOperands();
        SQLFragment[] sQLFragmentArray = new SQLFragment[sqlExpressionArray.length];
        int n = 0;
        while (n < sqlExpressionArray.length) {
            sQLFragmentArray[n] = this.createFragment((SqlOpndef)sqlExpressionArray[n], sQLFragment, null);
            ++n;
        }
        whereObject = WhereObject.isWhereOperator(s) ? new WhereObject(sQLFragmentArray, s) : new WhereObject(this.createFragment((SqlOpndef)sqlOptdef, sQLFragment, null));
        return whereObject;
    }

    private GroupByObject createGroupBy(SqlGbydef sqlGbydef, SqlOpndef sqlOpndef) throws SQLQueryException {
        GroupByObject groupByObject = null;
        int n = sqlGbydef.getGroupByListType();
        if (n == 0) {
            SqlOpndef[] sqlOpndefArray = sqlGbydef.getGroupBySetTerms();
            FromObjectUsage[] fromObjectUsageArray = new FromObjectUsage[sqlOpndefArray.length];
            int n2 = 0;
            while (n2 < sqlOpndefArray.length) {
                if (!(sqlOpndefArray[n2] instanceof SqlColdef)) {
                    throw new SQLQueryException(DBArb.getString(31));
                }
                fromObjectUsageArray[n2] = this.createColumnUsage((SqlColdef)sqlOpndefArray[n2]);
                ++n2;
            }
            groupByObject = new GroupByObject(fromObjectUsageArray);
            if (sqlOpndef != null && sqlOpndef instanceof SqlOptdef) {
                WhereObject whereObject = this.createWhere((SqlOptdef)sqlOpndef);
                groupByObject.setHaving(whereObject);
            }
        }
        return groupByObject;
    }

    private FromObjectUsage createColumnUsage(SqlColdef sqlColdef) throws SQLQueryException {
        return this.createColumnUsage(sqlColdef, null);
    }

    private FromObjectUsage createColumnUsage(SqlColdef sqlColdef, SQLFragment sQLFragment) throws SQLQueryException {
        String string;
        String string2;
        String string3;
        FromObjectUsage fromObjectUsage = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = sqlColdef.getColumnUserName();
        if (ModelUtil.hasLength((String)string4)) {
            arrayList.add(string4);
        }
        if (ModelUtil.hasLength((String)(string3 = sqlColdef.getColumnTableName()))) {
            arrayList.add(string3);
        }
        if ((string2 = sqlColdef.getColumnBaseName()) == null) {
            String[] stringArray = sqlColdef.getColumnAndAttributes();
            if (stringArray != null) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
        } else if (ModelUtil.hasLength((String)string2)) {
            arrayList.add(string2);
        }
        FromObject fromObject = sQLFragment instanceof FromObject ? (FromObject)sQLFragment : null;
        FromObject fromObject2 = null;
        String string5 = null;
        if (arrayList.size() > 1) {
            string5 = (String)arrayList.remove(0);
            fromObject2 = this.findFromObject(string5, fromObject);
            if (fromObject2 == null && arrayList.size() > 0 && (fromObject2 = this.findFromObject(string5 = string5 + "." + (String)arrayList.get(0), fromObject)) != null) {
                arrayList.remove(0);
            }
            if (fromObject2 == null) {
                throw new SQLQueryException(DBArb.format(32, string5));
            }
        }
        if ((string = (String)arrayList.remove(0)).charAt(0) != '\"') {
            string = string.toUpperCase();
        }
        if (string.equals("*")) {
            fromObjectUsage = new ColumnKeywordUsage(string, fromObject2);
        } else if (fromObject2 == null) {
            fromObjectUsage = this.findColumnInFromObjects(string);
            if (fromObjectUsage == null) {
                throw new SQLQueryException(DBArb.format(33, string));
            }
        } else {
            SQLFragment sQLFragment2 = fromObject2.getExpression();
            if (sQLFragment2 instanceof RelationUsage) {
                fromObjectUsage = this.findColumnInRelation(string, (RelationUsage)sQLFragment2);
                if (fromObjectUsage == null) {
                    throw new SQLQueryException(DBArb.format(34, string, string5));
                }
            } else if (sQLFragment2 instanceof SQLQuery) {
                fromObjectUsage = this.findColumnInSubQuery(string, (SQLQuery)sQLFragment2);
                if (fromObjectUsage == null) {
                    throw new SQLQueryException(DBArb.format(36, string));
                }
            } else if (sQLFragment2 instanceof SynonymUsage) {
                SchemaObject schemaObject = ((SynonymUsage)sQLFragment2).getReferencedObject();
                if (schemaObject instanceof Relation) {
                    fromObjectUsage = this.findColumnInRelation(string, (Relation)schemaObject);
                }
                if (fromObjectUsage == null) {
                    throw new SQLQueryException(DBArb.format(35, string, string5));
                }
                fromObjectUsage.setFromObject(fromObject2);
            } else {
                throw new SQLQueryException(DBArb.format(37, string5));
            }
        }
        if (fromObjectUsage instanceof ColumnUsage) {
            if (arrayList.size() > 0) {
                ((ColumnUsage)fromObjectUsage).setAttributes(arrayList.toArray(new String[arrayList.size()]));
            }
            if (sqlColdef.colOuterJoin) {
                ((ColumnUsage)fromObjectUsage).setOuterJoin(true);
            }
        }
        return fromObjectUsage;
    }

    private FromObject findFromObject(String string, FromObject fromObject) {
        FromObject fromObject2 = this.getFromObject(string, fromObject);
        if (fromObject2 == null) {
            OracleSQLQueryBuilder oracleSQLQueryBuilder = this.m_parentBuilder;
            while (oracleSQLQueryBuilder != null && fromObject2 == null) {
                fromObject2 = oracleSQLQueryBuilder.getFromObject(string);
                oracleSQLQueryBuilder = oracleSQLQueryBuilder.m_parentBuilder;
            }
        }
        return fromObject2;
    }

    private SQLFragment[] createFragments(SqlExpression[] sqlExpressionArray, SQLFragment sQLFragment, Object object) throws SQLQueryException {
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        int n = 0;
        while (n < sqlExpressionArray.length) {
            if (sqlExpressionArray[n] != null) {
                arrayList.add(this.createFragment((SqlOpndef)sqlExpressionArray[n], sQLFragment, object));
            }
            ++n;
        }
        return arrayList.toArray(new SQLFragment[arrayList.size()]);
    }

    private SQLFragment createFragment(SqlOpndef sqlOpndef) throws SQLQueryException {
        return this.createFragment(sqlOpndef, null, null);
    }

    private SQLFragment createFragment(SqlOpndef sqlOpndef, SQLFragment sQLFragment, Object object) throws SQLQueryException {
        SQLFragment sQLFragment2 = null;
        byte by = sqlOpndef.getOperandType();
        switch (by) {
            case 12: {
                sQLFragment2 = this.createFragment(((SqlSeldef)sqlOpndef).getSelopn(), sQLFragment, object);
                break;
            }
            case 1: {
                if (object != null && object.equals("MAKE_REF")) {
                    try {
                        sQLFragment2 = this.createColumnUsage((SqlColdef)sqlOpndef, sQLFragment);
                    }
                    catch (SQLQueryException sQLQueryException) {
                        String string = ((SqlColdef)sqlOpndef).getColumnBaseName();
                        String string2 = ((SqlColdef)sqlOpndef).getColumnTableName();
                        sQLFragment2 = this.createRelationUsage(string2, string);
                        if (sQLFragment2 != null) break;
                        String string3 = string;
                        if (ModelUtil.hasLength((String)string2)) {
                            string3 = string2 + "." + string3;
                        }
                        sQLFragment2 = new SimpleSQLFragment(string3);
                    }
                    break;
                }
                sQLFragment2 = this.createColumnUsage((SqlColdef)sqlOpndef, sQLFragment);
                break;
            }
            case 2: {
                SqlOptdef sqlOptdef = (SqlOptdef)sqlOpndef;
                short s = sqlOptdef.getOperatorType();
                if (WhereObject.isWhereOperator(s)) {
                    sQLFragment2 = this.createWhere((SqlOptdef)sqlOpndef, sQLFragment);
                    break;
                }
                if (ArithmeticOperation.isArithmeticOperation(s)) {
                    sQLFragment2 = new ArithmeticOperation(s, this.createFragments(sqlOptdef.getOperands(), sQLFragment, object));
                    break;
                }
                if (Comparison.isComparator(s)) {
                    SQLFragment[] sQLFragmentArray = this.createFragments(sqlOptdef.getOperands(), sQLFragment, object);
                    sQLFragment2 = new Comparison(sQLFragmentArray[0], s, sQLFragmentArray.length > 1 ? sQLFragmentArray[1] : null);
                    break;
                }
                if (SetOperation.isSetOperator(s)) {
                    SQLFragment[] sQLFragmentArray = this.createFragments(sqlOptdef.getOperands(), sQLFragment, object);
                    sQLFragment2 = new SetOperation(s, sQLFragmentArray);
                    break;
                }
                if (s == 371 || s == 385) {
                    SQLFragment[] sQLFragmentArray = this.createFragments(sqlOptdef.getOperands(), sQLFragment, object);
                    int n = 0;
                    SQLFragment sQLFragment3 = null;
                    if (s == 385) {
                        sQLFragment3 = sQLFragmentArray[n++];
                    }
                    SQLFragment sQLFragment4 = null;
                    if ((sQLFragmentArray.length - n) % 2 != 0) {
                        sQLFragment4 = sQLFragmentArray[sQLFragmentArray.length - 1];
                    }
                    int n2 = sQLFragmentArray.length - (sQLFragment4 == null ? 0 : 1);
                    CaseStatement.WhenThen[] whenThenArray = new CaseStatement.WhenThen[(n2 - n) / 2];
                    int n3 = 0;
                    while (n3 < whenThenArray.length) {
                        whenThenArray[n3] = new CaseStatement.WhenThen(sQLFragmentArray[n++], sQLFragmentArray[n++]);
                        ++n3;
                    }
                    sQLFragment2 = new CaseStatement(sQLFragment3, whenThenArray, sQLFragment4);
                    break;
                }
                String string = SqlOperators.OPT_words[s - 1];
                if (string == null) {
                    throw new SQLQueryException(DBArb.format(38, string));
                }
                SqlExpression[] sqlExpressionArray = sqlOptdef.getOperands();
                int n = 0;
                if (string.equals("plsfun") && sqlExpressionArray.length > 0) {
                    string = sqlExpressionArray[0].getColumnBaseName();
                    n = 1;
                }
                string = string.toUpperCase();
                ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
                int n4 = n;
                while (n4 < sqlExpressionArray.length) {
                    if (sqlExpressionArray[n4] != null) {
                        SQLFragment sQLFragment5 = this.createFragment((SqlOpndef)sqlExpressionArray[n4], sQLFragment, string);
                        arrayList.add(sQLFragment5);
                    }
                    ++n4;
                }
                SQLFragment[] sQLFragmentArray = arrayList.toArray(new SQLFragment[arrayList.size()]);
                sQLFragment2 = this.getOracleFunctions().createFunction(string, sQLFragmentArray, sqlOptdef.getSource());
                if (sQLFragment2 != null) break;
                throw new SQLQueryException(DBArb.format(38, string));
            }
            case 3: {
                SqlStrdef sqlStrdef = (SqlStrdef)sqlOpndef;
                byte by2 = sqlStrdef.getStringType();
                String string = sqlStrdef.getStringText();
                sQLFragment2 = new SimpleSQLFragment(string);
                break;
            }
            case 11: {
                SqlTypdef sqlTypdef = (SqlTypdef)sqlOpndef;
                String string = sqlTypdef.getTypName();
                sQLFragment2 = new SimpleSQLFragment(string);
                break;
            }
            case 5: {
                OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, (SqlQbcdef)sqlOpndef, this);
                DeclarativeSQLQuery declarativeSQLQuery = oracleSQLQueryBuilder.getSQLQuery();
                if (declarativeSQLQuery == null) {
                    throw new SQLQueryException(DBArb.getString(30));
                }
                sQLFragment2 = declarativeSQLQuery;
            }
        }
        return sQLFragment2;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_provider = this.m_provider;
    }

    public SQLFragment parseFromExpression(String string) throws SQLQueryException {
        this.checkLength(string);
        int n = string.indexOf(".");
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            DBObject dBObject = this.m_query.getParent();
            if (dBObject instanceof SchemaObject) {
                string2 = ((SchemaObject)dBObject).getSchema().getName();
            }
            string3 = string;
        }
        DBObjectUsage dBObjectUsage = this.createRelationUsage(string2, string3);
        if (dBObjectUsage == null) {
            throw new SQLQueryException(DBArb.format(29, string));
        }
        return dBObjectUsage;
    }

    public SQLFragment parseSelectExpression(String string) throws SQLQueryException {
        this.checkLength(string);
        PlsqlRoot plsqlRoot = OracleSQLQueryBuilder.parseQueryString(string, 3);
        OracleSQLQueryBuilder.checkErrors(plsqlRoot, string);
        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
        if (plsqlNodeArray != null && plsqlNodeArray.length > 0) {
            return this.createFragment((SqlOpndef)plsqlNodeArray[0]);
        }
        throw new SQLQueryException(DBArb.getString(39));
    }

    public SQLFragment parseWhereExpression(String string) throws SQLQueryException {
        this.checkLength(string);
        PlsqlRoot plsqlRoot = OracleSQLQueryBuilder.parseQueryString(string, 1);
        OracleSQLQueryBuilder.checkErrors(plsqlRoot, string);
        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
        if (plsqlNodeArray != null && plsqlNodeArray.length > 0) {
            return this.createFragment((SqlOpndef)plsqlNodeArray[0]);
        }
        throw new SQLQueryException(DBArb.getString(39));
    }

    public OnJoinCondition parseOnExpression(String string, JoinObject joinObject) throws SQLQueryException {
        this.checkLength(string);
        PlsqlRoot plsqlRoot = OracleSQLQueryBuilder.parseQueryString(string, 1);
        OracleSQLQueryBuilder.checkErrors(plsqlRoot, string);
        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
        if (plsqlNodeArray != null && plsqlNodeArray.length > 0) {
            SQLFragment sQLFragment = this.createFragment((SqlOpndef)plsqlNodeArray[0], joinObject, null);
            if (sQLFragment instanceof WhereObject) {
                return (OnJoinCondition)sQLFragment.copyTo(new OnJoinCondition());
            }
            return new OnJoinCondition(sQLFragment);
        }
        throw new SQLQueryException(DBArb.getString(39));
    }

    private DBObjectUsage createRelationUsage(String string, String string2) {
        if (!ModelUtil.hasLength((String)string2)) {
            return null;
        }
        AbstractSchemaObjectUsage abstractSchemaObjectUsage = null;
        if (this.m_provider != null) {
            string = string == null ? null : this.m_provider.getInternalName(string);
            string2 = this.m_provider.getInternalName(string2);
            try {
                Schema schema = null;
                schema = ModelUtil.hasLength((String)string) ? this.m_provider.getSchema(string) : this.m_defaultSchema;
                if (schema != null) {
                    SchemaObject schemaObject = this.m_provider.getObject("TABLE", schema, string2);
                    if (schemaObject == null) {
                        schemaObject = this.m_provider.getObject("VIEW", schema, string2);
                    }
                    if (schemaObject == null) {
                        DBObjectID dBObjectID;
                        schemaObject = this.m_provider.getObject("SYNONYM", schema, string2);
                        if (schemaObject != null && (dBObjectID = schemaObject.getID()) != null) {
                            abstractSchemaObjectUsage = new SynonymUsage(dBObjectID);
                            abstractSchemaObjectUsage.setProvider(this.m_provider);
                        }
                    } else {
                        DBObjectID dBObjectID = schemaObject.getID();
                        if (dBObjectID != null) {
                            abstractSchemaObjectUsage = new RelationUsage(dBObjectID);
                            abstractSchemaObjectUsage.setProvider(this.m_provider);
                        }
                    }
                }
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
        }
        return abstractSchemaObjectUsage;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public FunctionDefinition[] getBuiltInFunctions() {
        Collection collection = this.getOracleFunctions().getAllFunctions();
        return collection.toArray(new FunctionDefinition[collection.size()]);
    }

    private OracleFunctions getOracleFunctions() {
        if (s_funcs == null) {
            s_funcs = new OracleFunctions();
        }
        return s_funcs;
    }

    private static PlsqlRoot parseQueryString(String string, int n) throws SQLQueryException {
        try {
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
            parsingOptions.inputType = 16;
            SqlDriver sqlDriver = new SqlDriver();
            sqlDriver.setTextBuffer(readTextBuffer);
            PlsqlRoot plsqlRoot = sqlDriver.qcpidrv(n);
            return plsqlRoot;
        }
        catch (Exception exception) {
            DBUtil.logStackTrace(exception);
            throw new SQLQueryException(DBArb.format(21, exception.getMessage()));
        }
    }

    private static void checkErrors(PlsqlRoot plsqlRoot, String string) throws SQLQueryException {
        PlsqlError[] plsqlErrorArray = plsqlRoot.getErrors();
        if (plsqlErrorArray != null && plsqlErrorArray.length > 0) {
            throw new SQLParseException(plsqlErrorArray, string);
        }
    }

    public static void checkSQLForErrors(String string) throws SQLQueryException {
        PlsqlRoot plsqlRoot = OracleSQLQueryBuilder.parseQueryString(string, 0);
        OracleSQLQueryBuilder.checkErrors(plsqlRoot, string);
    }

    protected FromObjectUsage findColumnInRelation(String string, Relation relation) throws SQLQueryException {
        if (string.equalsIgnoreCase(this.getOracleFunctions().ROWID)) {
            ColumnKeywordUsage columnKeywordUsage = new ColumnKeywordUsage();
            columnKeywordUsage.setColumnName(string);
            return columnKeywordUsage;
        }
        return super.findColumnInRelation(string, relation);
    }
}

