/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class OracleSequenceBuilder
extends OracleDBObjectBuilder {
    OracleSequenceBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "SEQUENCE");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Sequence sequence = new Sequence(string, schema);
        sequence.setID(dBObjectID);
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Connection connection;
        Sequence sequence = (Sequence)schemaObject;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    String string = this.getNameQuery();
                    String string2 = AbstractDBObjectProvider.convertObject(schemaObject.getSchema());
                    String string3 = schemaObject.getName();
                    statement = connection.prepareStatement(string);
                    statement.setString(1, string2);
                    statement.setString(2, string3);
                    this.sqlTrace(string, new Object[]{string2, string3});
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                        BigDecimal bigDecimal2 = resultSet.getBigDecimal(2);
                        BigDecimal bigDecimal3 = resultSet.getBigDecimal(3);
                        String string4 = resultSet.getString(4);
                        String string5 = resultSet.getString(5);
                        BigDecimal bigDecimal4 = resultSet.getBigDecimal(6);
                        BigDecimal bigDecimal5 = resultSet.getBigDecimal(7);
                        this._createSequence(sequence, bigDecimal, bigDecimal2, bigDecimal3, string4, string5, bigDecimal4, bigDecimal5);
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void _createSequence(Sequence sequence, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string, String string2, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        BigInteger bigInteger = bigDecimal == null ? null : bigDecimal.toBigInteger();
        BigInteger bigInteger2 = bigDecimal2 == null ? null : bigDecimal2.toBigInteger();
        BigInteger bigInteger3 = bigDecimal3 == null ? null : bigDecimal3.toBigInteger();
        BigInteger bigInteger4 = bigDecimal5 == null ? null : bigDecimal5.toBigInteger();
        BigInteger bigInteger5 = null;
        if (bigDecimal4.intValue() == 0) {
            sequence.setCacheFlag(false);
        } else {
            sequence.setCacheFlag(true);
            bigInteger5 = bigDecimal4.toBigInteger();
        }
        sequence.setMinValue(bigInteger);
        sequence.setMaxValue(bigInteger2);
        sequence.setIncrementBy(bigInteger3);
        sequence.setCycleFlag("Y".equalsIgnoreCase(string));
        sequence.setOrderFlag("Y".equalsIgnoreCase(string2));
        sequence.setCacheSize(bigInteger5);
        sequence.setLastNumber(bigInteger4);
    }

    private String getNameQuery() {
        return this.getDatabase().getOracleDatabaseType() == 8 ? "SELECT MIN_VALUE, MAX_VALUE, INCREMENT_BY, NULL, NULL, NULL, NULL FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?" : "SELECT MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ? ";
    }
}

