/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class OracleStorageProperties
implements Copyable {
    public static final String KEY = "OracleStorageProperties";
    public static final int BUFFER_DEFAULT = 0;
    public static final int BUFFER_KEEP = 1;
    public static final int BUFFER_RECYCLE = 2;
    private String _tablespace;
    private Integer _pctFree;
    private Integer _pctUsed;
    private Integer _initrans;
    private Integer _maxtrans;
    private Integer _initialExtent;
    private Integer _nextExtent;
    private Integer _minExtent;
    private Integer _maxExtent;
    private Integer _pctIncrease;
    private Boolean _logging;
    private Integer _freelists;
    private Integer _freelistGroups;
    private int _bufferMode;
    private static Integer n0 = new Integer(0);
    private static Integer n1 = new Integer(1);
    private static Integer n99 = new Integer(99);
    private static Integer n255 = new Integer(255);

    void $init$() {
        this._bufferMode = 0;
    }

    public OracleStorageProperties() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        OracleStorageProperties oracleStorageProperties = object != null ? (OracleStorageProperties)object : new OracleStorageProperties();
        this.copyToImpl(oracleStorageProperties);
        return oracleStorageProperties;
    }

    protected void copyToImpl(OracleStorageProperties oracleStorageProperties) {
        oracleStorageProperties._tablespace = this._tablespace;
        oracleStorageProperties._pctFree = this._pctFree;
        oracleStorageProperties._pctUsed = this._pctUsed;
        oracleStorageProperties._initrans = this._initrans;
        oracleStorageProperties._maxtrans = this._maxtrans;
        oracleStorageProperties._initialExtent = this._initialExtent;
        oracleStorageProperties._nextExtent = this._nextExtent;
        oracleStorageProperties._minExtent = this._minExtent;
        oracleStorageProperties._maxExtent = this._maxExtent;
        oracleStorageProperties._pctIncrease = this._pctIncrease;
        oracleStorageProperties._logging = this._logging;
        oracleStorageProperties._freelists = this._freelists;
        oracleStorageProperties._freelistGroups = this._freelistGroups;
        oracleStorageProperties._bufferMode = this._bufferMode;
    }

    public boolean equals(Object object) {
        return object instanceof OracleStorageProperties && this.equalsImpl((OracleStorageProperties)object);
    }

    protected boolean equalsImpl(OracleStorageProperties oracleStorageProperties) {
        return ModelUtil.areEqual((Object)this._tablespace, (Object)oracleStorageProperties._tablespace) && ModelUtil.areEqual((Object)this._pctFree, (Object)oracleStorageProperties._pctFree) && ModelUtil.areEqual((Object)this._pctUsed, (Object)oracleStorageProperties._pctUsed) && ModelUtil.areEqual((Object)this._initrans, (Object)oracleStorageProperties._initrans) && ModelUtil.areEqual((Object)this._maxtrans, (Object)oracleStorageProperties._maxtrans) && ModelUtil.areEqual((Object)this._initialExtent, (Object)oracleStorageProperties._initialExtent) && ModelUtil.areEqual((Object)this._nextExtent, (Object)oracleStorageProperties._nextExtent) && ModelUtil.areEqual((Object)this._minExtent, (Object)oracleStorageProperties._minExtent) && ModelUtil.areEqual((Object)this._maxExtent, (Object)oracleStorageProperties._maxExtent) && ModelUtil.areEqual((Object)this._pctIncrease, (Object)oracleStorageProperties._pctIncrease) && ModelUtil.areEqual((Object)this._logging, (Object)oracleStorageProperties._logging) && ModelUtil.areEqual((Object)this._freelists, (Object)oracleStorageProperties._freelists) && ModelUtil.areEqual((Object)this._freelistGroups, (Object)oracleStorageProperties._freelistGroups) && this._bufferMode == oracleStorageProperties._bufferMode;
    }

    public void setTablespace(String string) {
        this._tablespace = string;
    }

    public String getTablespace() {
        return this._tablespace;
    }

    public void setPercentFree(Integer n) {
        this._pctFree = n;
    }

    public Integer getPercentFree() {
        return this._pctFree;
    }

    public void setPercentUsed(Integer n) {
        this._pctUsed = n;
    }

    public Integer getPercentUsed() {
        return this._pctUsed;
    }

    public void setInitrans(Integer n) {
        this._initrans = n;
    }

    public Integer getInitrans() {
        return this._initrans;
    }

    public void setMaxtrans(Integer n) {
        this._maxtrans = n;
    }

    public Integer getMaxtrans() {
        return this._maxtrans;
    }

    public void setInitialExtent(Integer n) {
        this._initialExtent = n;
    }

    public Integer getInitialExtent() {
        return this._initialExtent;
    }

    public void setNextExtent(Integer n) {
        this._nextExtent = n;
    }

    public Integer getNextExtent() {
        return this._nextExtent;
    }

    public void setMinExtent(Integer n) {
        this._minExtent = n;
    }

    public Integer getMinExtent() {
        return this._minExtent;
    }

    public void setMaxExtent(Integer n) {
        this._maxExtent = n;
    }

    public Integer getMaxExtent() {
        return this._maxExtent;
    }

    public void setPercentIncrease(Integer n) {
        this._pctIncrease = n;
    }

    public Integer getPercentIncrease() {
        return this._pctIncrease;
    }

    public void setLogging(Boolean bl) {
        this._logging = bl;
    }

    public Boolean getLogging() {
        return this._logging;
    }

    public void setFreelists(Integer n) {
        this._freelists = n;
    }

    public Integer getFreelists() {
        return this._freelists;
    }

    public void setFreelistGroups(Integer n) {
        this._freelistGroups = n;
    }

    public Integer getFreelistGroups() {
        return this._freelistGroups;
    }

    public void setBufferMode(int n) {
        this._bufferMode = n;
    }

    public int getBufferMode() {
        return this._bufferMode;
    }

    public void validatePercentFree(DBObject dBObject) throws ValidationException {
        if (this._pctFree != null && (this._pctFree < 0 || this._pctFree > 99)) {
            throw new ValidationException(dBObject, DBArb.format(176, "PCTFREE", n0, n99));
        }
        this.validateSumOfPctFreeAndPctUsed(dBObject);
    }

    public void validatePercentUsed(DBObject dBObject) throws ValidationException {
        if (this._pctUsed != null && (this._pctUsed < 0 || this._pctUsed > 99)) {
            throw new ValidationException(dBObject, DBArb.format(176, "PCTUSED", n0, n99));
        }
        this.validateSumOfPctFreeAndPctUsed(dBObject);
    }

    public void validateInitrans(DBObject dBObject) throws ValidationException {
        if (this._initrans != null && (this._initrans < 1 || this._initrans > 255)) {
            throw new ValidationException(dBObject, DBArb.format(176, "INITRANS", n1, n255));
        }
    }

    public void validateMaxtrans(DBObject dBObject) throws ValidationException {
        if (this._maxtrans != null && (this._maxtrans < 1 || this._maxtrans > 255)) {
            throw new ValidationException(dBObject, DBArb.format(176, "MAXTRANS", n1, n255));
        }
    }

    public void validateInitialExtent(DBObject dBObject) throws ValidationException {
        if (this._initialExtent != null && this._initialExtent < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "INITIAL", n1));
        }
    }

    public void validateNextExtent(DBObject dBObject) throws ValidationException {
        if (this._nextExtent != null && this._nextExtent < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "NEXT", n1));
        }
    }

    public void validateMinExtent(DBObject dBObject) throws ValidationException {
        if (this._minExtent != null && this._minExtent < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "MINEXTENT", n1));
        }
    }

    public void validateMaxExtent(DBObject dBObject) throws ValidationException {
        if (this._maxExtent != null && this._maxExtent < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "MAXEXTENT", n1));
        }
    }

    public void validatePercentIncrease(DBObject dBObject) throws ValidationException {
        if (this._pctIncrease != null && this._pctIncrease < 0) {
            throw new ValidationException(dBObject, DBArb.format(177, "PCTINCREASE", n0));
        }
    }

    public void validateFreelistGroups(DBObject dBObject) throws ValidationException {
        if (this._freelistGroups != null && this._freelistGroups < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "FREELIST_GROUPS", n1));
        }
    }

    public void validateFreelists(DBObject dBObject) throws ValidationException {
        if (this._freelists != null && this._freelists < 1) {
            throw new ValidationException(dBObject, DBArb.format(177, "FREELISTS", n1));
        }
    }

    public void validateBufferMode(DBObject dBObject) throws ValidationException {
        if (this._bufferMode < 0 || this._bufferMode > 2) {
            throw new ValidationException(dBObject, DBArb.getString(175));
        }
    }

    public void validate(DBObject dBObject) throws ValidationException {
        this.validatePercentFree(dBObject);
        this.validatePercentUsed(dBObject);
        this.validateInitrans(dBObject);
        this.validateMaxtrans(dBObject);
        this.validateInitialExtent(dBObject);
        this.validateNextExtent(dBObject);
        this.validateMinExtent(dBObject);
        this.validateMaxExtent(dBObject);
        this.validatePercentIncrease(dBObject);
        this.validateFreelistGroups(dBObject);
        this.validateFreelists(dBObject);
        this.validateBufferMode(dBObject);
    }

    private void validateSumOfPctFreeAndPctUsed(DBObject dBObject) throws ValidationException {
        if (this._pctFree != null && this._pctUsed != null && this._pctFree + this._pctUsed > 100) {
            throw new ValidationException(dBObject, DBArb.getString(178));
        }
    }

    private static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }
}

