/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.ModelUtil;

class OracleSynonymBuilder
extends OracleDBObjectBuilder {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final String REFERENCED_OBJECT_QUERY = "SELECT S.TABLE_OWNER, S.TABLE_NAME, REF.OBJECT_TYPE, REF.OBJECT_ID,        S.DB_LINK  FROM  SYS.ALL_OBJECTS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.OBJECT_NAME";
    private static final String OLITE_REFERENCED_OBJECT_QUERY = "SELECT S.TABLE_OWNER, S.TABLE_NAME, 'TABLE', NULL, S.DB_LINK  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION SELECT S.TABLE_OWNER, S.TABLE_NAME, 'VIEW', NULL, S.DB_LINK  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME";
    private static final String REFERENCED_OBJECT_NAME_AND_TYPE_QUERY = "SELECT S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK  FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ";

    OracleSynonymBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "SYNONYM");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Synonym synonym = new Synonym(string, schema, null);
        synonym.setID(dBObjectID);
        synonym.setPublic(ModelUtil.areEqual((Object)this.getDatabase().getPublicSchema(), (Object)schema));
        return synonym;
    }

    static {
        $assertionsDisabled = OracleSynonymBuilder.class.desiredAssertionStatus() ^ true;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        if (!($assertionsDisabled || schemaObject != null && schemaObject instanceof Synonym)) {
            throw new AssertionError();
        }
        Synonym synonym = (Synonym)schemaObject;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                BaseOracleDatabase baseOracleDatabase = this.getDatabase();
                Connection connection = this.getConnection();
                String string = baseOracleDatabase instanceof OracleLite ? OLITE_REFERENCED_OBJECT_QUERY : REFERENCED_OBJECT_QUERY;
                String string2 = AbstractDBObjectProvider.convertObject(synonym.getSchema());
                String string3 = AbstractDBObjectProvider.convertObject(synonym);
                statement = connection.prepareStatement(string);
                statement.setString(1, string2);
                statement.setString(2, string3);
                if (baseOracleDatabase instanceof OracleLite) {
                    statement.setString(3, string2);
                    statement.setString(4, string3);
                    this.sqlTrace(string, new Object[]{string2, string3, string2, string3});
                } else {
                    this.sqlTrace(string, new Object[]{string2, string3});
                }
                resultSet = statement.executeQuery();
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                int n = 0;
                if (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    string5 = resultSet.getString(2);
                    string7 = resultSet.getString(3);
                    n = resultSet.getInt(4);
                    string6 = resultSet.getString(5);
                } else {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String string8 = AbstractDBObjectProvider.convertObject(synonym.getSchema());
                    String string9 = AbstractDBObjectProvider.convertObject(synonym);
                    statement = connection.prepareStatement(REFERENCED_OBJECT_NAME_AND_TYPE_QUERY);
                    statement.setString(1, string8);
                    statement.setString(2, string9);
                    this.sqlTrace(REFERENCED_OBJECT_NAME_AND_TYPE_QUERY, new Object[]{string8, string9});
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        string4 = resultSet.getString(1);
                        string5 = resultSet.getString(2);
                        string6 = resultSet.getString(3);
                    }
                }
                Schema schema = string4 == null ? null : baseOracleDatabase.getSchema(string4);
                DBObjectID dBObjectID = n == 0 ? new NameBasedRefID(schema, string5, string6) : baseOracleDatabase.createID(schema, string5, string7, n);
                synonym.setReference(dBObjectID);
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

