/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.ChildLevelObjectID;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

class OracleTableBuilder
extends OracleRelationBuilder {
    private static final String TABLE_QUERY = "SELECT TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\nINITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\nFREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, TEMPORARY, DURATION,\nIOT_TYPE, PARTITIONED, NESTED\nFROM SYS.{0} WHERE OWNER = ? AND TABLE_NAME = ?";
    private static final String ORACLE8_TABLE_QUERY = "SELECT TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\nINITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\nFREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, 'N' TEMPORARY, NULL DURATION,\nIOT_TYPE, PARTITIONED, NESTED\nFROM SYS.ALL_TABLES WHERE OWNER = ? AND TABLE_NAME = ?";
    private static final String ORACLE7_TABLE_QUERY = "SELECT TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\nINITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\nFREELISTS, FREELIST_GROUPS, NULL LOGGING, NULL BUFFER_POOL, 'N' TEMPORARY, NULL DURATION,\nNULL IOT_TYPE, NULL PARTITIONED, 'NO' NESTED\nFROM SYS.ALL_TABLES WHERE OWNER = ? AND TABLE_NAME = ?";
    private static final String OLITE_TABLE_QUERY = "SELECT TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\nINITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\nNULL FREELISTS, NULL FREELIST_GROUPS, NULL LOGGING, NULL BUFFER_POOL, 'N' TEMPORARY, NULL DURATION,\nNULL IOT_TYPE, NULL PARTITIONED, 'NO' NESTED\nFROM SYS.ALL_TABLES WHERE OWNER = ? AND TABLE_NAME = ?";
    private static final String EXTERNAL_TABLE_QUERY = "select TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    private static final String ORACLE9i_EXTERNAL_TABLE_QUERY = "select TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    private static final String EXTERNAL_LOCATIONS_QUERY = "select LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n";
    private static String IOT_INDEX_QUERY;
    private static String IOT_MAPPING_AND_OVERFLOW_QUERY;
    private static final String REFS_COLLECTION = "select 1\nfrom all_tab_columns c\nwhere c.owner=?\nand   c.table_name=?\nand exists ( select 1 from all_types t\n             where  t.owner = c.owner\n             and    t.type_name = c.data_type\n             and    t.typecode like '%COLLECTION' )";
    private static final String TABLE_PARTITION_TYPE_QUERY = "select apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   all_part_tables apt, all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\norder by apkc.column_position";
    private static final String TABLE_PARTITION_QUERY = "select TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE\nfrom   all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position";
    private static final String TABLE_LOB_PARTITION_QUERY = "select COLUMN_NAME, PARTITION_NAME, LOB_PARTITION_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME";
    private static final String TABLE_SUBPARTITION_COLUMNS_QUERY = "select COLUMN_NAME\nfrom   ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION";
    private static final String TABLE_SUBPARTITION_TEMPLATES_QUERY = "select SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   ALL_SUBPARTITION_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION";
    private static final String TABLE_LOB_TEMPLATES_QUERY = "select distinct SUBPARTITION_NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME\nfrom   ALL_LOB_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME";
    private static final String TABLE_PARTITION_LEVEL_SUBPARTITION_QUERY = "select PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION";
    private static final String TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY = "select s.subpartition_name, s.lob_subpartition_name,\n       s.column_name, s.tablespace_name\nfrom all_lob_subpartitions  s\nwhere s.table_owner = ?\nand   s.table_name  = ?\norder by s.subpartition_name";
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = OracleTableBuilder.class.desiredAssertionStatus() ^ true;
        IOT_INDEX_QUERY = "select PCT_THRESHOLD, PREFIX_LENGTH, INCLUDE_COLUMN\nfrom   ALL_INDEXES\nwhere  OWNER = ?\nand    INDEX_NAME = ?";
        IOT_MAPPING_AND_OVERFLOW_QUERY = "select TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, IOT_TYPE\nfrom   ALL_TABLES\nwhere  OWNER = ?\nand    IOT_NAME = ?\nand    IOT_TYPE like 'IOT_%'";
    }

    protected OracleTableBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "TABLE");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Table table = new Table(string, schema);
        table.setID(dBObjectID);
        return table;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        super.fillInObject(schemaObject);
        Table table = (Table)schemaObject;
        if (this.needsBuilding(table, "INDEX")) {
            this.fillInIndexes(table);
        }
        if (this.needsBuilding(table, "BASE")) {
            this._buildProperties(table);
        }
    }

    private void fillInIndexes(Table table) throws DBException {
        OracleIndexBuilder oracleIndexBuilder = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        oracleIndexBuilder.fillInIndexes(table);
    }

    private void _buildProperties(Table table) throws DBException {
        String string;
        int n = this.getDatabase().getOracleDatabaseType();
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(OracleTableBuilder.getTableQuery(n), table.getSchema(), table);
        boolean bl = true;
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    bl = false;
                    this._updateTable(table, resultSet);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
        if (bl && (string = OracleTableBuilder.getObjectTableQuery(n)) != null) {
            OracleDBObjectBuilder.QueryWrapper queryWrapper2 = new OracleDBObjectBuilder.QueryWrapper(string, table.getSchema(), table);
            try {
                try {
                    ResultSet resultSet = queryWrapper2.executeQuery();
                    if (resultSet.next()) {
                        table.setProperty("OBJECT TABLE", Boolean.TRUE);
                        this._updateTable(table, resultSet);
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                queryWrapper2.close();
            }
        }
    }

    private void _updateTable(Table table, ResultSet resultSet) throws SQLException, DBException {
        boolean bl = "YES".equals(resultSet.getString(19));
        boolean bl2 = "YES".equals(resultSet.getString(18));
        table.setProperty("NESTED TABLE", null);
        table.setProperty("PARTITIONED TABLE", null);
        if (bl) {
            table.setProperty("NESTED TABLE", Boolean.TRUE);
        }
        Table.TableType tableType = Table.TableType.NORMAL;
        if ("IOT".equals(resultSet.getString(17))) {
            tableType = Table.TableType.INDEX_ORGANIZED;
            table.setProperty("OracleIndexOrganizedTableProperties", this._getIotProperties(table));
            if (!bl2) {
                OracleStorageProperties oracleStorageProperties = this._getSegmentAttributeProperties(resultSet);
                oracleStorageProperties.setPercentUsed(null);
                table.setProperty("OracleStorageProperties", oracleStorageProperties);
            }
        } else {
            OracleExternalTableProperties oracleExternalTableProperties;
            if ("Y".equals(resultSet.getString(15))) {
                String string = resultSet.getString(16);
                if ("SYS$SESSION".equals(string)) {
                    tableType = Table.TableType.SESSION_TEMP;
                } else if ("SYS$TRANSACTION".equals(string)) {
                    tableType = Table.TableType.TRANSACTION_TEMP;
                }
            }
            OracleExternalTableProperties oracleExternalTableProperties2 = oracleExternalTableProperties = tableType == Table.TableType.NORMAL && !bl ? this._getExternalTableProperties(table) : null;
            if (oracleExternalTableProperties != null) {
                tableType = Table.TableType.EXTERNAL;
                table.setProperty("OracleExternalTableProperties", oracleExternalTableProperties);
            } else if (!bl2) {
                table.setProperty("OracleStorageProperties", this._getSegmentAttributeProperties(resultSet));
            }
        }
        table.setProperty("TableType", (Object)tableType);
        if (bl2 && tableType != Table.TableType.EXTERNAL) {
            table.setProperty("PARTITIONED TABLE", Boolean.TRUE);
            table.setProperty("OracleTablePartitions", this._getOracleTablePartitions(table));
        }
    }

    private OracleStorageProperties _getStorageProperties(ResultSet resultSet) throws SQLException {
        OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
        int n = resultSet.getInt("INITIAL_EXTENT");
        Integer n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setInitialExtent(n2);
        n = resultSet.getInt("NEXT_EXTENT");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setNextExtent(n2);
        n = resultSet.getInt("MIN_EXTENTS");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setMinExtent(n2);
        n = resultSet.getInt("MAX_EXTENTS");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setMaxExtent(n2);
        n = resultSet.getInt("PCT_INCREASE");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setPercentIncrease(n2);
        n = resultSet.getInt("FREELISTS");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setFreelists(n2);
        n = resultSet.getInt("FREELIST_GROUPS");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setFreelistGroups(n2);
        String string = resultSet.getString("BUFFER_POOL");
        oracleStorageProperties.setBufferMode("KEEP".equals(string) ? 1 : ("RECYCLE".equals(string) ? 2 : 0));
        return oracleStorageProperties;
    }

    private OracleStorageProperties _getSegmentAttributeProperties(ResultSet resultSet) throws SQLException {
        OracleStorageProperties oracleStorageProperties = this._getStorageProperties(resultSet);
        int n = resultSet.getInt("PCT_FREE");
        Integer n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setPercentFree(n2);
        n = resultSet.getInt("PCT_USED");
        n2 = resultSet.wasNull() ? null : new Integer(n);
        oracleStorageProperties.setPercentUsed(n2);
        n = resultSet.getInt("INI_TRANS");
        n2 = resultSet.wasNull() || n == 0 ? null : new Integer(n);
        oracleStorageProperties.setInitrans(n2);
        n = resultSet.getInt("MAX_TRANS");
        n2 = resultSet.wasNull() || n == 0 ? null : new Integer(n);
        oracleStorageProperties.setMaxtrans(n2);
        oracleStorageProperties.setTablespace(resultSet.getString("TABLESPACE_NAME"));
        String string = resultSet.getString("LOGGING");
        if (!resultSet.wasNull() && string != null) {
            oracleStorageProperties.setLogging("YES".equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE);
        }
        return oracleStorageProperties;
    }

    private OracleTablePartitions _getOracleTablePartitions(Table table) throws SQLException {
        OracleTablePartitions oracleTablePartitions;
        block13: {
            oracleTablePartitions = null;
            OracleTablePartitions oracleTablePartitions2 = null;
            OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_PARTITION_TYPE_QUERY, table.getSchema(), table);
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    Column column;
                    if (oracleTablePartitions == null) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        if ("HASH".equals(string) || "LIST".equals(string) || "RANGE".equals(string)) {
                            oracleTablePartitions = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf(string), OracleTablePartitions.ObjectType.PARTITION);
                            DBObjectID dBObjectID = ChildLevelObjectID.createObjectID(table.getID(), null, oracleTablePartitions.getType());
                            oracleTablePartitions.setID(dBObjectID);
                            if ("HASH".equals(string2) || "LIST".equals(string2)) {
                                oracleTablePartitions2 = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf(string2), OracleTablePartitions.ObjectType.SUBPARTITION);
                                dBObjectID = ChildLevelObjectID.createObjectID(oracleTablePartitions.getID(), null, oracleTablePartitions2.getType());
                                oracleTablePartitions2.setID(dBObjectID);
                                oracleTablePartitions.setSubpartitionModel(oracleTablePartitions2);
                            }
                        }
                    }
                    if (oracleTablePartitions == null || (column = table.getColumn(resultSet.getString(3))) == null) continue;
                    oracleTablePartitions.addPartitionColumn(column.getID());
                }
                if (oracleTablePartitions == null) break block13;
                Map map = this._getPartitionLOBs(table);
                Map map2 = null;
                if (oracleTablePartitions2 != null) {
                    map2 = this._getPartitionLevelSubpartitions(table, oracleTablePartitions2.getPartitionType());
                }
                OracleDBObjectBuilder.QueryWrapper queryWrapper2 = new OracleDBObjectBuilder.QueryWrapper(TABLE_PARTITION_QUERY, table.getSchema(), table);
                try {
                    ResultSet resultSet2 = queryWrapper2.executeQuery();
                    while (resultSet2.next()) {
                        TablePartition tablePartition = oracleTablePartitions.createPartition(resultSet2.getString("PARTITION_NAME"));
                        DBObjectID dBObjectID = ChildLevelObjectID.createObjectID(oracleTablePartitions.getID(), tablePartition.getName(), tablePartition.getType());
                        tablePartition.setID(dBObjectID);
                        this._initialisePartition(tablePartition, resultSet2, map, map2);
                    }
                }
                finally {
                    queryWrapper2.close();
                }
                if (oracleTablePartitions2 != null) {
                    this._getSubpartitionColumns(table, oracleTablePartitions2);
                    this._getSubpartitionTemplates(table, oracleTablePartitions2);
                }
            }
            finally {
                queryWrapper.close();
            }
        }
        return oracleTablePartitions;
    }

    private Map _getPartitionLOBs(Table table) throws SQLException {
        HashMap hashMap = new HashMap();
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_LOB_PARTITION_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            ArrayList<LOBDescriptor> arrayList = null;
            while (resultSet.next()) {
                String string = resultSet.getString("PARTITION_NAME");
                if (!hashMap.containsKey(string)) {
                    arrayList = new ArrayList<LOBDescriptor>();
                    hashMap.put(string, arrayList);
                }
                LOBDescriptor lOBDescriptor = new LOBDescriptor();
                arrayList.add(lOBDescriptor);
                lOBDescriptor.addColumn(table.getColumn(resultSet.getString("COLUMN_NAME")).getID());
                lOBDescriptor.setChunk(resultSet.getInt("CHUNK"));
                lOBDescriptor.setLOBSegName(resultSet.getString("LOB_PARTITION_NAME"));
                lOBDescriptor.setPctVersion(resultSet.getInt("PCTVERSION"));
                lOBDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(resultSet.getString("IN_ROW")));
                String string2 = resultSet.getString("CACHE");
                if (!resultSet.wasNull() && string2 != null) {
                    lOBDescriptor.setCache(string2.equals("YES") ? "CACHE" : (string2.equals("NO") ? "NOCACHE" : (string2.equals("CACHEREADS") ? "CACHE READS" : null)));
                }
                OracleStorageProperties oracleStorageProperties = this._getStorageProperties(resultSet);
                lOBDescriptor.setStorage(oracleStorageProperties);
                oracleStorageProperties.setTablespace(resultSet.getString("TABLESPACE_NAME"));
                String string3 = resultSet.getString("LOGGING");
                if (resultSet.wasNull() || string3 == null) continue;
                oracleStorageProperties.setLogging("YES".equalsIgnoreCase(string3) ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        finally {
            queryWrapper.close();
        }
        return hashMap;
    }

    private void _initialisePartition(TablePartition tablePartition, ResultSet resultSet, Map map, Map map2) throws SQLException {
        if (tablePartition != null && tablePartition.getPartitionType() != null) {
            if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                this._initialiseHashPartition(tablePartition, resultSet, map);
            } else {
                OracleTablePartitions oracleTablePartitions;
                tablePartition.setValues(resultSet.getString("HIGH_VALUE"));
                String string = resultSet.getString("COMPRESSION");
                if ("ENABLED".equals(string)) {
                    tablePartition.setCompression("COMPRESS");
                } else if ("DISABLED".equals(string)) {
                    tablePartition.setCompression("NOCOMPRESS");
                }
                tablePartition.setSegmentAttributes(this._getSegmentAttributeProperties(resultSet));
                if (map != null && map.containsKey(tablePartition.getName())) {
                    List list = (List)map.get(tablePartition.getName());
                    tablePartition.setLOBDescriptors(list.toArray(new LOBDescriptor[list.size()]));
                }
                if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE && map2 != null && map2.containsKey(tablePartition.getName()) && (oracleTablePartitions = (OracleTablePartitions)map2.get(tablePartition.getName())) != null) {
                    DBObjectID dBObjectID = ChildLevelObjectID.createObjectID(tablePartition.getID(), null, oracleTablePartitions.getType());
                    oracleTablePartitions.setID(dBObjectID);
                    TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
                    int n = 0;
                    while (n < tablePartitionArray.length) {
                        TablePartition tablePartition2 = tablePartitionArray[n];
                        DBObjectID dBObjectID2 = ChildLevelObjectID.createObjectID(dBObjectID, tablePartition2.getName(), tablePartition2.getType());
                        tablePartition2.setID(dBObjectID2);
                        ++n;
                    }
                    tablePartition.setPartitionLevelSubpartitions(oracleTablePartitions);
                }
            }
        } else if (!($assertionsDisabled || tablePartition != null && tablePartition.getPartitionType() != null)) {
            throw new AssertionError();
        }
    }

    private void _initialiseHashPartition(TablePartition tablePartition, ResultSet resultSet, Map map) throws SQLException {
        this._addTablespace(tablePartition, resultSet.getString("TABLESPACE_NAME"));
        if (map != null && map.containsKey(tablePartition.getName())) {
            List list = (List)map.get(tablePartition.getName());
            int n = 0;
            while (n < list.size()) {
                LOBDescriptor lOBDescriptor = new LOBDescriptor();
                tablePartition.addLOBDescriptor(lOBDescriptor);
                LOBDescriptor lOBDescriptor2 = (LOBDescriptor)list.get(n);
                lOBDescriptor.setColumns(lOBDescriptor2.getColumns());
                lOBDescriptor.setLOBSegName(lOBDescriptor2.getLOBSegName());
                if (lOBDescriptor2.getStorage() != null && ModelUtil.hasLength((String)lOBDescriptor2.getStorage().getTablespace())) {
                    this._addTablespace(lOBDescriptor, lOBDescriptor2.getStorage().getTablespace());
                }
                ++n;
            }
        }
    }

    private void _getSubpartitionColumns(Table table, OracleTablePartitions oracleTablePartitions) throws SQLException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_SUBPARTITION_COLUMNS_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            while (resultSet.next()) {
                Column column = table.getColumn(resultSet.getString(1));
                if (column == null) continue;
                oracleTablePartitions.addPartitionColumn(column.getID());
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    private void _getSubpartitionTemplates(Table table, OracleTablePartitions oracleTablePartitions) throws SQLException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_SUBPARTITION_TEMPLATES_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            while (resultSet.next()) {
                String string;
                oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
                String string2 = resultSet.getString("SUBPARTITION_NAME");
                TablePartition tablePartition = oracleTablePartitions.createPartition(string2);
                DBObjectID dBObjectID = ChildLevelObjectID.createObjectID(oracleTablePartitions.getID(), string2, tablePartition.getType());
                tablePartition.setID(dBObjectID);
                String string3 = resultSet.getString("HIGH_BOUND");
                if (string3 != null && !resultSet.wasNull()) {
                    tablePartition.setValues(string3);
                }
                if ((string = resultSet.getString("TABLESPACE_NAME")) == null || resultSet.wasNull()) continue;
                this._addTablespace(tablePartition, string);
            }
            this._getSubpartitionLOBTemplates(table, oracleTablePartitions.getPartitions());
        }
        finally {
            queryWrapper.close();
        }
    }

    private void _getSubpartitionLOBTemplates(Table table, TablePartition[] tablePartitionArray) throws SQLException {
        if (tablePartitionArray.length > 0) {
            OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_LOB_TEMPLATES_QUERY, table.getSchema(), table);
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                while (resultSet.next()) {
                    TablePartition tablePartition = this._findSubpartitionTemplate(resultSet.getString("SUBPARTITION_NAME"), tablePartitionArray);
                    if (!$assertionsDisabled && tablePartition == null) {
                        throw new AssertionError();
                    }
                    if (tablePartition == null) continue;
                    LOBDescriptor lOBDescriptor = new LOBDescriptor();
                    tablePartition.addLOBDescriptor(lOBDescriptor);
                    lOBDescriptor.addColumn(table.getColumn(resultSet.getString("LOB_COL_NAME")).getID());
                    lOBDescriptor.setLOBSegName(resultSet.getString("LOB_SEGMENT_NAME"));
                    String string = resultSet.getString("TABLESPACE_NAME");
                    if (string == null || resultSet.wasNull()) continue;
                    this._addTablespace(lOBDescriptor, string);
                }
            }
            finally {
                queryWrapper.close();
            }
        }
    }

    private TablePartition _findSubpartitionTemplate(String string, TablePartition[] tablePartitionArray) {
        int n = 0;
        while (n < tablePartitionArray.length) {
            if (tablePartitionArray[n].getName().equals(string)) {
                return tablePartitionArray[n];
            }
            ++n;
        }
        return null;
    }

    private Map _getPartitionLevelSubpartitions(Table table, OracleTablePartitions.PartitionType partitionType) throws SQLException {
        HashMap<String, OracleTablePartitions> hashMap = new HashMap<String, OracleTablePartitions>();
        OracleTablePartitions oracleTablePartitions = null;
        Map map = this._getPartitionLevelSubpartitionLOBs(table);
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_PARTITION_LEVEL_SUBPARTITION_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString("PARTITION_NAME");
                if (!hashMap.containsKey(string)) {
                    oracleTablePartitions = new OracleTablePartitions(partitionType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                    hashMap.put(string, oracleTablePartitions);
                }
                String string2 = resultSet.getString("SUBPARTITION_NAME");
                TablePartition tablePartition = oracleTablePartitions.createPartition(string2);
                tablePartition.setValues(resultSet.getString("HIGH_VALUE"));
                String string3 = resultSet.getString("TABLESPACE_NAME");
                if (string3 != null && !resultSet.wasNull()) {
                    this._addTablespace(tablePartition, string3);
                }
                if (map == null || !map.containsKey(string2)) continue;
                List list = (List)map.get(string2);
                tablePartition.setLOBDescriptors(list.toArray(new LOBDescriptor[list.size()]));
            }
        }
        finally {
            queryWrapper.close();
        }
        return hashMap;
    }

    private Map _getPartitionLevelSubpartitionLOBs(Table table) throws SQLException {
        HashMap hashMap = new HashMap();
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            ArrayList<LOBDescriptor> arrayList = null;
            while (resultSet.next()) {
                String string = resultSet.getString("SUBPARTITION_NAME");
                if (!hashMap.containsKey(string)) {
                    arrayList = new ArrayList<LOBDescriptor>();
                    hashMap.put(string, arrayList);
                }
                LOBDescriptor lOBDescriptor = new LOBDescriptor();
                arrayList.add(lOBDescriptor);
                lOBDescriptor.addColumn(table.getColumn(resultSet.getString("COLUMN_NAME")).getID());
                lOBDescriptor.setLOBSegName(resultSet.getString("LOB_SUBPARTITION_NAME"));
                this._addTablespace(lOBDescriptor, resultSet.getString("TABLESPACE_NAME"));
            }
        }
        finally {
            queryWrapper.close();
        }
        return hashMap;
    }

    private void _addTablespace(TablePartition tablePartition, String string) {
        OracleStorageProperties oracleStorageProperties = this._getSegmentAttributes(tablePartition);
        oracleStorageProperties.setTablespace(string);
    }

    private void _addTablespace(LOBDescriptor lOBDescriptor, String string) {
        OracleStorageProperties oracleStorageProperties = lOBDescriptor.getStorage();
        if (oracleStorageProperties == null) {
            oracleStorageProperties = new OracleStorageProperties();
            lOBDescriptor.setStorage(oracleStorageProperties);
        }
        oracleStorageProperties.setTablespace(string);
    }

    private OracleStorageProperties _getSegmentAttributes(TablePartition tablePartition) {
        OracleStorageProperties oracleStorageProperties = tablePartition.getSegmentAttributes();
        if (oracleStorageProperties == null) {
            oracleStorageProperties = new OracleStorageProperties();
            tablePartition.setSegmentAttributes(oracleStorageProperties);
        }
        return oracleStorageProperties;
    }

    private OracleIndexOrganizedTableProperties _getIotProperties(Table table) throws SQLException {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = new OracleIndexOrganizedTableProperties();
        Constraint[] constraintArray = table.getConstraints();
        PKConstraint pKConstraint = null;
        if (constraintArray != null) {
            int n = 0;
            while (n < constraintArray.length) {
                if (constraintArray[n].getConstraintType().equals("PKConstraint")) {
                    pKConstraint = (PKConstraint)constraintArray[n];
                    break;
                }
                ++n;
            }
        }
        if (pKConstraint != null) {
            OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(IOT_INDEX_QUERY, table.getSchema(), pKConstraint);
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    oracleIndexOrganizedTableProperties.setPctThreshold(resultSet.wasNull() ? null : new Integer(n));
                    int n2 = resultSet.getInt(2);
                    oracleIndexOrganizedTableProperties.setKeyCompression(resultSet.wasNull() ? null : new Integer(n2));
                    int n3 = resultSet.getInt(3);
                    AbstractDBObject abstractDBObject = null;
                    if (!resultSet.wasNull()) {
                        Column[] columnArray = table.getColumns();
                        AbstractDBObject abstractDBObject2 = abstractDBObject = n3 > 0 && n3 <= columnArray.length ? columnArray[n3 - 1] : null;
                    }
                    if (abstractDBObject != null) {
                        oracleIndexOrganizedTableProperties.setIncludeColumn(abstractDBObject.getID());
                    }
                }
            }
            finally {
                queryWrapper.close();
            }
        }
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(IOT_MAPPING_AND_OVERFLOW_QUERY, table.getSchema(), table);
        try {
            ResultSet resultSet = queryWrapper.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getString(15).equals("IOT_OVERFLOW")) {
                    oracleIndexOrganizedTableProperties.setOverflowable(true);
                    oracleIndexOrganizedTableProperties.setOverflowProperties(this._getSegmentAttributeProperties(resultSet));
                    continue;
                }
                oracleIndexOrganizedTableProperties.setMapped(true);
            }
        }
        finally {
            queryWrapper.close();
        }
        return oracleIndexOrganizedTableProperties;
    }

    private OracleExternalTableProperties _getExternalTableProperties(Table table) throws SQLException, DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        int n = baseOracleDatabase.getOracleDatabaseType();
        OracleExternalTableProperties oracleExternalTableProperties = null;
        String string = OracleTableBuilder.getExternalTableQuery(n);
        if (string != null) {
            OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(string, table.getSchema(), table);
            try {
                try {
                    ResultSet resultSet = queryWrapper.executeQuery();
                    if (resultSet.next()) {
                        oracleExternalTableProperties = new OracleExternalTableProperties();
                        oracleExternalTableProperties.setAccessDriverType(resultSet.getString(1));
                        oracleExternalTableProperties.setRejectLimit(resultSet.getString(2));
                        oracleExternalTableProperties.setAccessParameterType(OracleExternalTableProperties.AccessType.valueOf(resultSet.getString(3)));
                        oracleExternalTableProperties.setAccessParameters(resultSet.getString(4));
                        String string2 = resultSet.getString(5);
                        if (string2 != null && !string2.equals("null")) {
                            oracleExternalTableProperties.setProjectColumn(OracleExternalTableProperties.ProjectColumn.valueOf(string2));
                        }
                        Directory directory = this.getDirectory(resultSet.getString(6), resultSet.getString(7));
                        oracleExternalTableProperties.setDefaultDirectory(directory.getID());
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                queryWrapper.close();
            }
            if (oracleExternalTableProperties != null) {
                OracleDBObjectBuilder.QueryWrapper queryWrapper2 = new OracleDBObjectBuilder.QueryWrapper(EXTERNAL_LOCATIONS_QUERY, table.getSchema(), table);
                try {
                    try {
                        ResultSet resultSet = queryWrapper2.executeQuery();
                        while (resultSet.next()) {
                            Directory directory = this.getDirectory(resultSet.getString(2), resultSet.getString(3));
                            oracleExternalTableProperties.addLocationSpecifier(directory.getID(), resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    queryWrapper2.close();
                }
            }
        }
        return oracleExternalTableProperties;
    }

    private Directory getDirectory(String string, String string2) throws DBException {
        if (ModelUtil.hasLength((String)string2)) {
            BaseOracleDatabase baseOracleDatabase = this.getDatabase();
            Schema schema = baseOracleDatabase.getSchema(string);
            return (Directory)baseOracleDatabase.getObject("DIRECTORY", schema, string2);
        }
        return null;
    }

    private static String getExternalTableQuery(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return null;
            }
            case 3: 
            case 4: {
                return ORACLE9i_EXTERNAL_TABLE_QUERY;
            }
        }
        return EXTERNAL_TABLE_QUERY;
    }

    private static String getTableQuery(int n) {
        String string = null;
        switch (n) {
            case 8: {
                string = OLITE_TABLE_QUERY;
                break;
            }
            case 0: {
                string = ORACLE7_TABLE_QUERY;
                break;
            }
            case 1: {
                string = ORACLE8_TABLE_QUERY;
                break;
            }
            default: {
                string = MessageFormat.format(TABLE_QUERY, "ALL_TABLES");
            }
        }
        return string;
    }

    private static String getObjectTableQuery(int n) {
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 8: {
                string = null;
                break;
            }
            default: {
                string = MessageFormat.format(TABLE_QUERY, "ALL_OBJECT_TABLES");
            }
        }
        return string;
    }

    protected void fillInObjectComponent(SchemaObject schemaObject, String string) throws DBException {
        Table table = (Table)schemaObject;
        if (string.equals("INDEX")) {
            this.ensureComponent(table, "COLUMN");
            this.ensureComponent(table, "CONSTRAINT");
            this.fillInIndexes(table);
        } else if (string.equals("BASE")) {
            this._buildProperties(table);
        } else {
            super.fillInObjectComponent(schemaObject, string);
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

