/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablePartitions
extends AbstractDBObject {
    public static final String KEY = "OracleTablePartitions";
    public static final String TYPE = "PARTITION MODEL";
    private PartitionType _partitionType;
    private ObjectType _objectType;
    private List<DBObjectID> _partitionColumns;
    private List<TablePartition> _partitions;
    private Integer _hashQuantity;
    private List<String> _hashQuantityTablespaces;
    private OracleTablePartitions _subpartitionModel;

    public OracleTablePartitions() {
        this.$init$();
    }

    public OracleTablePartitions(PartitionType partitionType, ObjectType objectType) {
        this.$init$();
        this._partitionType = partitionType;
        this._objectType = objectType;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DBObject getParent() {
        return null;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        collection.addAll(this._partitionColumns);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String[] stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("PARTITION", stringArray)) {
            collection.addAll(this._partitions);
        }
        if (this._subpartitionModel != null && this.includesType(TYPE, stringArray)) {
            collection.add(this._subpartitionModel);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        boolean bl = super.replaceReferenceIDs(map);
        int n = 0;
        while (n < this._partitionColumns.size()) {
            DBObjectID dBObjectID = this._partitionColumns.get(n);
            if (map.containsKey(dBObjectID)) {
                this._partitionColumns.set(n, map.get(dBObjectID));
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void setPartitionType(PartitionType partitionType) {
        this._partitionType = partitionType;
    }

    public PartitionType getPartitionType() {
        return this._partitionType;
    }

    public void setObjectType(ObjectType objectType) {
        this._objectType = objectType;
    }

    public ObjectType getObjectType() {
        return this._objectType;
    }

    public void setSubpartitionModel(OracleTablePartitions oracleTablePartitions) {
        this._subpartitionModel = oracleTablePartitions;
    }

    public OracleTablePartitions getSubpartitionModel() {
        return this._subpartitionModel;
    }

    public void setPartitionColumns(DBObjectID[] dBObjectIDArray) {
        this._partitionColumns.removeAll(this._partitionColumns);
        if (dBObjectIDArray != null) {
            int n = 0;
            while (n < dBObjectIDArray.length) {
                this.addPartitionColumn(dBObjectIDArray[n]);
                ++n;
            }
        }
    }

    public DBObjectID[] getPartitionColumns() {
        return this._partitionColumns.toArray(new DBObjectID[this._partitionColumns.size()]);
    }

    public void addPartitionColumn(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this._partitionColumns.add(dBObjectID);
        }
    }

    public void addPartitionColumn(DBObjectID dBObjectID, int n) {
        if (dBObjectID != null) {
            this._partitionColumns.add(n, dBObjectID);
        }
    }

    public void removePartitionColumn(DBObjectID dBObjectID) {
        this._partitionColumns.remove(dBObjectID);
    }

    public void removePartitionColumnAt(int n) {
        this._partitionColumns.remove(n);
    }

    public void setHashQuantity(Integer n) {
        this._hashQuantity = n;
    }

    public Integer getHashQuantity() {
        return this._hashQuantity;
    }

    public void setHashQuantityTablespaces(String[] stringArray) {
        this._hashQuantityTablespaces.removeAll(this._hashQuantityTablespaces);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addHashQuantityTablespace(stringArray[n]);
                ++n;
            }
        }
    }

    public void addHashQuantityTablespace(String string) {
        if (string != null) {
            this._hashQuantityTablespaces.add(string);
        }
    }

    public void removeHashQuantityTablespace(String string) {
        this._hashQuantityTablespaces.remove(string);
    }

    public String[] getHashQuantityTablespaces() {
        return this._hashQuantityTablespaces.toArray(new String[this._hashQuantityTablespaces.size()]);
    }

    public void setPartitions(TablePartition[] tablePartitionArray) {
        this._partitions.removeAll(this._partitions);
        if (tablePartitionArray != null) {
            int n = 0;
            while (n < tablePartitionArray.length) {
                this._partitions.add(tablePartitionArray[n]);
                ++n;
            }
        }
    }

    public TablePartition[] getPartitions() {
        return this._partitions.toArray(new TablePartition[this._partitions.size()]);
    }

    public void addPartition(TablePartition tablePartition) {
        if (tablePartition != null) {
            this._partitions.add(tablePartition);
        }
    }

    public void removePartition(TablePartition tablePartition) {
        this._partitions.remove(tablePartition);
    }

    public TablePartition createPartition(String string) {
        TablePartition tablePartition = new TablePartition(string, this._partitionType, this._objectType);
        this.addPartition(tablePartition);
        return tablePartition;
    }

    public void validate(Table table) throws ValidationException {
        this.validateColumns(table);
        this.validatePartitions(table);
        this.validateSubpartitionModel(table);
    }

    public void validateColumns(Table table) throws ValidationException {
        this._validateTypes(table);
        if (this._objectType == ObjectType.PARTITION_LEVEL_SUBPARTITION && this._partitionColumns.size() > 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(219));
        }
        if (this._partitionType == PartitionType.LIST) {
            if (this._partitionColumns.size() != 1 || this._partitionColumns.size() == 1 && LOBDescriptor.isLOBColumn(this._partitionColumns.get(0))) {
                throw new ValidationException((DBObject)table, DBArb.getString(197));
            }
        } else {
            if (this._partitionColumns.size() < 1) {
                throw new ValidationException((DBObject)table, DBArb.getString(191));
            }
            if (this._partitionType == PartitionType.HASH && this._partitionColumns.size() > 16) {
                throw new ValidationException((DBObject)table, DBArb.getString(199));
            }
        }
    }

    public void validateHashQuantity(Table table) throws ValidationException {
        this._validateTypes(table);
        if (this._partitionType == PartitionType.HASH) {
            if ((this._objectType == ObjectType.PARTITION || this._objectType == ObjectType.SUBPARTITION_TEMPLATE || this._objectType == ObjectType.PARTITION_LEVEL_SUBPARTITION) && (this._partitions.size() == 0 && this._hashQuantity == null || this._partitions.size() != 0 && this._hashQuantity != null)) {
                throw new ValidationException((DBObject)table, DBArb.getString(201));
            }
        } else if (this._hashQuantity != null || this._hashQuantityTablespaces.size() != 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(193));
        }
        if (this._hashQuantity == null && this._hashQuantityTablespaces.size() != 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(202));
        }
    }

    public void validatePartitions(Table table) throws ValidationException {
        this.validateHashQuantity(table);
        if (this._partitionType != PartitionType.HASH && this._objectType == ObjectType.PARTITION && this._partitions.size() < 1) {
            throw new ValidationException((DBObject)table, DBArb.format(192, (Object)this._partitionType));
        }
        if (this._partitionType == PartitionType.LIST && (this._objectType == ObjectType.SUBPARTITION_TEMPLATE || this._objectType == ObjectType.PARTITION_LEVEL_SUBPARTITION) && this._partitions.size() < 1) {
            throw new ValidationException((DBObject)table, DBArb.getString(218));
        }
        int n = 0;
        while (n < this._partitions.size()) {
            if (this._partitions.get(n).getPartitionType() != this._partitionType) {
                throw new ValidationException((DBObject)table, DBArb.format(194, (Object)this._partitionType));
            }
            this._partitions.get(n).validate(table);
            ++n;
        }
    }

    public void validateSubpartitionModel(Table table) throws ValidationException {
        if (this._subpartitionModel != null) {
            this._validateTypes(table);
            if (this._partitionType == PartitionType.RANGE && this._objectType == ObjectType.PARTITION) {
                this._subpartitionModel.validate(table);
            } else {
                throw new ValidationException((DBObject)table, DBArb.format(195, (Object)this._partitionType));
            }
        }
    }

    private void _validateTypes(Table table) throws ValidationException {
        if (this._partitionType == null) {
            throw new ValidationException((DBObject)table, DBArb.getString(189));
        }
        if (this._objectType == null) {
            throw new ValidationException((DBObject)table, DBArb.getString(190));
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        OracleTablePartitions oracleTablePartitions = dBObject != null ? (OracleTablePartitions)dBObject : new OracleTablePartitions();
        this.copyToImpl(oracleTablePartitions, bl);
        return oracleTablePartitions;
    }

    public boolean equals(Object object) {
        return object instanceof OracleTablePartitions && this.equalsImpl((OracleTablePartitions)object);
    }

    protected void copyToImpl(OracleTablePartitions oracleTablePartitions, boolean bl) {
        super.copyToImpl(oracleTablePartitions, bl);
        oracleTablePartitions._partitionType = this._partitionType;
        oracleTablePartitions._objectType = this._objectType;
        oracleTablePartitions._hashQuantity = this._hashQuantity;
        oracleTablePartitions._subpartitionModel = this._subpartitionModel == null ? null : (OracleTablePartitions)this._subpartitionModel.copyTo(null, oracleTablePartitions, bl);
        ModelUtil.deepCopy(this._hashQuantityTablespaces, oracleTablePartitions._hashQuantityTablespaces);
        oracleTablePartitions._partitionColumns.clear();
        oracleTablePartitions._partitionColumns.addAll(this._partitionColumns);
        oracleTablePartitions._partitions.clear();
        for (TablePartition tablePartition : this._partitions) {
            oracleTablePartitions._partitions.add((TablePartition)tablePartition.copyTo(null, oracleTablePartitions, bl));
        }
    }

    protected boolean equalsImpl(OracleTablePartitions oracleTablePartitions) {
        return ModelUtil.areEqual((Object)((Object)this._partitionType), (Object)((Object)oracleTablePartitions._partitionType)) && ModelUtil.areEqual((Object)((Object)this._objectType), (Object)((Object)oracleTablePartitions._objectType)) && ModelUtil.areEqual((Object)this._hashQuantity, (Object)oracleTablePartitions._hashQuantity) && ModelUtil.areEqual(this._hashQuantityTablespaces, oracleTablePartitions._hashQuantityTablespaces) && ModelUtil.areEqual(this._partitionColumns, oracleTablePartitions._partitionColumns) && ModelUtil.areEqual(this._partitions, oracleTablePartitions._partitions) && ModelUtil.areEqual((Object)this._subpartitionModel, (Object)oracleTablePartitions._subpartitionModel);
    }

    void $init$() {
        this._partitionColumns = new ArrayList<DBObjectID>();
        this._partitions = new ArrayList<TablePartition>();
        this._hashQuantityTablespaces = new ArrayList<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionType
    extends Enum {
        private static final /* synthetic */ PartitionType[] $v;
        public static final /* enum */ PartitionType RANGE;
        public static final /* enum */ PartitionType HASH;
        public static final /* enum */ PartitionType LIST;

        public static PartitionType valueOf(String string) {
            return Enum.valueOf(PartitionType.class, string);
        }

        public static final PartitionType[] values() {
            return (PartitionType[])$v.clone();
        }

        static {
            PartitionType[] partitionTypeArray = new PartitionType[3];
            partitionTypeArray[2] = LIST = new PartitionType();
            partitionTypeArray[1] = HASH = new PartitionType();
            partitionTypeArray[0] = RANGE = new PartitionType();
            $v = partitionTypeArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectType
    extends Enum {
        private static final /* synthetic */ ObjectType[] $v;
        public static final /* enum */ ObjectType PARTITION;
        public static final /* enum */ ObjectType SUBPARTITION;
        public static final /* enum */ ObjectType SUBPARTITION_TEMPLATE;
        public static final /* enum */ ObjectType PARTITION_LEVEL_SUBPARTITION;

        public static ObjectType valueOf(String string) {
            return Enum.valueOf(ObjectType.class, string);
        }

        public static final ObjectType[] values() {
            return (ObjectType[])$v.clone();
        }

        static {
            ObjectType[] objectTypeArray = new ObjectType[4];
            objectTypeArray[3] = PARTITION_LEVEL_SUBPARTITION = new ObjectType();
            objectTypeArray[2] = SUBPARTITION_TEMPLATE = new ObjectType();
            objectTypeArray[1] = SUBPARTITION = new ObjectType();
            objectTypeArray[0] = PARTITION = new ObjectType();
            $v = objectTypeArray;
        }
    }
}

