/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.validators.TableValidator;

public class OracleTableValidator
extends TableValidator {
    public OracleTableValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateColumns(Relation relation, Relation relation2) throws ValidationException {
        super.validateColumns(relation, relation2);
        boolean bl = false;
        Column[] columnArray = relation2.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            DBObject dBObject = null;
            try {
                dBObject = DataTypeHelper.getDataType(columnArray[n].getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dBObject.getName().equals("LONG") || dBObject.getName().equals("LONG RAW")) {
                if (bl) {
                    throw new ValidationException((DBObject)relation2, DBArb.getString(151), DBArb.getString(152));
                }
                bl = true;
            }
            ++n;
        }
    }

    protected boolean enforceConstraintsUniqueInSchema() {
        return true;
    }

    public void validateProperties(Table table, Table table2) throws ValidationException {
        block7: {
            OracleTablePartitions oracleTablePartitions;
            super.validateProperties(table, table2);
            Table.TableType tableType = (Table.TableType)((Object)table2.getProperty("TableType"));
            if (tableType == Table.TableType.INDEX_ORGANIZED) {
                OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table2.getProperty("OracleIndexOrganizedTableProperties");
                if (oracleIndexOrganizedTableProperties != null) {
                    oracleIndexOrganizedTableProperties.validate(table2);
                }
            } else if (tableType == Table.TableType.EXTERNAL) {
                OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)table2.getProperty("OracleExternalTableProperties");
                if (oracleExternalTableProperties != null) {
                    oracleExternalTableProperties.validate(table2);
                } else {
                    throw new ValidationException((DBObject)(table2 != null ? table2 : table), DBArb.getString(180));
                }
            }
            OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)table2.getProperty("OracleStorageProperties");
            if (oracleStorageProperties != null) {
                oracleStorageProperties.validate(table2);
            }
            if (table2.getProperty("PARTITIONED TABLE") != Boolean.TRUE || (oracleTablePartitions = (OracleTablePartitions)table2.getProperty("OracleTablePartitions")) == null) break block7;
            oracleTablePartitions.validate(table2);
        }
    }
}

